/*
 * Decompiled with CFR 0.152.
 */
package GeneralUI;

import GeneralUI.Component;
import GeneralUI.DrawText;
import GeneralUI.DropDownBox;
import GeneralUI.JPlatformCanvas;
import GeneralUI.JTextField;
import GeneralUI.ScreenPointerDefinition;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class CanvasForm {
    private String title = null;
    public static final byte SCROLL_UP = 1;
    public static final byte SCROLL_DOWN = 2;
    protected static final byte CANVAS_SCROLL_STEP = 30;
    public int focusedIndex = -1;
    protected int bodyOffset = 0;
    protected boolean adjustFocus = false;
    protected int paintAreaHeight;
    private Vector components = null;
    private int formHeight = 0;
    private int formWidth = 0;
    private byte formXPosition = 0;
    private byte formYPosition = 0;
    private byte iVerticleOffset = 0;
    protected JPlatformCanvas canvas;

    public CanvasForm(String title) {
        this.title = title;
        this.components = new Vector();
        this.canvas = JPlatformCanvas.getInstance();
        int startx = 10;
        this.setFormDimenssion((byte)10, (byte)(JPlatformCanvas.TITLE_BAR_HEIGHT + JPlatformCanvas.SOFT_KEYBAR_HEIGHT), JPlatformCanvas.SCREEN_WIDTH, JPlatformCanvas.SCREEN_HEIGHT);
        this.iVerticleOffset = (byte)(DrawText.getHeight() >> 1);
    }

    public void wrapItem(Component item) {
        this.components.addElement(item);
        this.components.trimToSize();
        if (item instanceof JTextField || item instanceof DropDownBox) {
            item.setDimenssion(JPlatformCanvas.SCREEN_WIDTH - 20, (DrawText.getHeight() << 1) - 5);
        }
        if (item.focusable && this.focusedIndex == -1) {
            item.requestFocus();
            this.focusedIndex = this.size() - 1;
        }
    }

    public void deleteItem(Component item) {
        if (this.components.contains(item)) {
            if (item.isFocusOwner()) {
                --this.focusedIndex;
                this.changeFocus(this.focusedIndex);
            }
            this.components.removeElement(item);
            this.components.trimToSize();
        }
    }

    public void deleteItem(int index) {
        if (index >= 0 && index < this.size()) {
            this.deleteItem((Component)this.components.elementAt(index));
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setFormDimenssion(byte formStartX, byte formStartY, int newWidth, int newHeight) {
        this.formXPosition = formStartX;
        this.formYPosition = formStartY;
        this.formWidth = newWidth;
        this.formHeight = newHeight;
    }

    public int getFormX() {
        return this.formXPosition;
    }

    public int getFormY() {
        return this.formYPosition;
    }

    public int getFormWidth() {
        return this.formWidth;
    }

    public int getFormHeight() {
        return this.formHeight;
    }

    public int size() {
        int size = 0;
        if (this.components != null) {
            size = this.components.size();
        }
        return size;
    }

    public void paint(Graphics g) {
        Component currentComponent = null;
        int currentOffset = 0;
        int popAt = -1;
        int cSize = this.size();
        int BODY_AREA_BOTTOM = this.getFormHeight() - JPlatformCanvas.SOFT_KEYBAR_HEIGHT - 5;
        int iYOffset = this.getFormY();
        if (cSize > 0) {
            this.recalcAdjustment();
            for (int index = 0; index < cSize; ++index) {
                currentComponent = (Component)this.components.elementAt(index);
                int height = currentComponent.getHeight() + currentComponent.getLabelHeight();
                this.paintAreaHeight = this.getFormHeight() - iYOffset - JPlatformCanvas.SOFT_KEYBAR_HEIGHT - 5;
                int paintPos = currentComponent.screenY = iYOffset + currentOffset - this.bodyOffset;
                currentComponent.screenX = this.getFormX();
                currentComponent.isVisible = paintPos + height > iYOffset && paintPos < BODY_AREA_BOTTOM;
                boolean bl = currentComponent.isCompletelyVisible = currentComponent.isVisible && paintPos + height <= BODY_AREA_BOTTOM && paintPos >= iYOffset;
                if (currentComponent.isVisible) {
                    currentComponent.drawComponent(g);
                }
                currentOffset += height + this.iVerticleOffset;
                if (currentComponent.drawPopUp) {
                    popAt = index;
                }
                if (!JPlatformCanvas.getInstance().hasPointerEvents() || !currentComponent.isCompletelyVisible) continue;
                ScreenPointerDefinition.setPointer(JPlatformCanvas.getInstance().getTitle(), currentComponent.getLabel(), currentComponent.screenX, currentComponent.screenY, currentComponent.screenX + currentComponent.getWidth(), currentComponent.screenY + currentComponent.getHeight());
            }
            if (popAt != -1) {
                currentComponent = (DropDownBox)this.components.elementAt(popAt);
                currentComponent.drawListWindow(g);
            }
        }
    }

    private void recalcAdjustment() {
        if (this.adjustFocus) {
            Component currentComponent = null;
            int BODY_AREA_BOTTOM = this.getFormHeight() - JPlatformCanvas.SOFT_KEYBAR_HEIGHT - 5;
            int iYOffset = JPlatformCanvas.TITLE_BAR_HEIGHT + (JPlatformCanvas.SOFT_KEYBAR_HEIGHT << 1);
            if (this.focusedIndex >= 0 && this.focusedIndex < this.size()) {
                boolean isFocusedCompletelyVisible;
                int fY = -this.bodyOffset + iYOffset;
                for (int index = 0; index < this.focusedIndex; ++index) {
                    currentComponent = (Component)this.components.elementAt(index);
                    fY += currentComponent.getHeight() + currentComponent.getLabelHeight() + this.iVerticleOffset;
                }
                int fH = ((Component)this.components.elementAt(this.focusedIndex)).getHeight() + ((Component)this.components.elementAt(this.focusedIndex)).getLabelHeight();
                int fYH = fY + fH;
                boolean bl = isFocusedCompletelyVisible = fYH > iYOffset && fY < BODY_AREA_BOTTOM && fYH <= BODY_AREA_BOTTOM && fY >= iYOffset;
                if (!isFocusedCompletelyVisible) {
                    if (fY < iYOffset) {
                        this.bodyOffset -= iYOffset - fY;
                    } else if (fYH >= BODY_AREA_BOTTOM) {
                        this.bodyOffset += fYH - BODY_AREA_BOTTOM;
                    }
                }
            }
            this.adjustFocus = false;
        }
    }

    public void restoreForm() {
        this.bodyOffset = 0;
        this.changeFocus(0);
        this.canvas.refreshDisplay();
    }

    public static void drawTriangle(Graphics g, int tipX, int tipY, int maxHeight, int direction, int color) {
        int yIncrement = 1;
        if (direction == 2) {
            yIncrement = -1;
        }
        if (color != -1) {
            g.setColor(color);
        }
        for (int height = 0; height < maxHeight; ++height) {
            g.drawLine(tipX, tipY, tipX + (height << 1), tipY);
            --tipX;
            tipY += yIncrement;
        }
    }

    protected void paintScroller(Graphics g) {
        int scrollDirections = this.getScrollDirections();
        int arrowMaxHeight = (JPlatformCanvas.SOFT_KEYBAR_HEIGHT >> 1) - 1;
        if ((scrollDirections & 1) > 0) {
            CanvasForm.drawTriangle(g, this.getFormWidth() >> 1, this.getFormHeight() - JPlatformCanvas.SOFT_KEYBAR_HEIGHT + 1, arrowMaxHeight, 1, 0);
        }
        if ((scrollDirections & 2) > 0) {
            CanvasForm.drawTriangle(g, this.getFormWidth() >> 1, this.getFormHeight() - 1, arrowMaxHeight, 2, 0);
        }
    }

    protected int getComponentsHeight() {
        int height = 0;
        Component c = null;
        int cSize = this.size();
        for (int i = 0; i < cSize; ++i) {
            c = (Component)this.components.elementAt(i);
            height += c.getHeight() + c.getLabelHeight() + this.iVerticleOffset;
        }
        return height - this.iVerticleOffset;
    }

    protected boolean scrollUp() {
        if ((this.getScrollDirections() & 1) > 0) {
            this.bodyOffset -= this.bodyOffset > 30 ? 30 : this.bodyOffset;
            return true;
        }
        return false;
    }

    protected boolean scrollDown() {
        if ((this.getScrollDirections() & 2) > 0) {
            int x = this.getComponentsHeight() - this.paintAreaHeight - this.bodyOffset;
            this.bodyOffset += 30 - (x >= 30 ? 0 : 30 - x);
            return true;
        }
        return false;
    }

    public Component getCurrentComponent() {
        return this.focusedIndex >= 0 && this.focusedIndex < this.size() ? (Component)this.components.elementAt(this.focusedIndex) : null;
    }

    protected int getNextFocusable() {
        int nRes = -1;
        Component c = null;
        if (this.focusedIndex == this.size()) {
            return nRes;
        }
        for (int i = this.focusedIndex + 1; i < this.size(); ++i) {
            c = (Component)this.components.elementAt(i);
            if (!c.focusable) continue;
            nRes = i;
            break;
        }
        c = null;
        return nRes;
    }

    protected int getPreviousFocusable() {
        int nRes = -1;
        if (this.focusedIndex == 0) {
            return nRes;
        }
        Component c = null;
        for (int i = this.focusedIndex - 1; i >= 0; --i) {
            c = (Component)this.components.elementAt(i);
            if (!c.focusable) continue;
            nRes = i;
            break;
        }
        c = null;
        return nRes;
    }

    protected int getFirstFocusable() {
        int nRes = -1;
        Component c = null;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            c = (Component)this.components.elementAt(i);
            if (!c.focusable) continue;
            nRes = i;
            break;
        }
        c = null;
        return nRes;
    }

    public int getLastFocusable() {
        int nRes = -1;
        Component c = null;
        for (int i = this.size() - 1; i >= 0; --i) {
            c = (Component)this.components.elementAt(i);
            if (!c.focusable) continue;
            nRes = i;
            break;
        }
        c = null;
        return nRes;
    }

    public void changeFocus(int newIndex) {
        if (this.size() > 0 && newIndex != this.focusedIndex) {
            Component c;
            if (this.focusedIndex >= 0 && this.focusedIndex < this.size()) {
                c = (Component)this.components.elementAt(this.focusedIndex);
                c.releaseFocus();
            }
            this.focusedIndex = newIndex;
            c = (Component)this.components.elementAt(this.focusedIndex);
            c.requestFocus();
            this.refocus();
        }
    }

    public void refocus() {
        this.adjustFocus = true;
    }

    protected int getScrollDirections() {
        int directions = 0;
        if (this.bodyOffset > 0) {
            directions |= 1;
        }
        if (this.bodyOffset + this.paintAreaHeight < this.getComponentsHeight()) {
            directions |= 2;
        }
        return directions;
    }

    public void keyPressed(int keyCode) {
        Component focusedComponent = this.getCurrentComponent();
        if (!this.canvas.isDrawList() && focusedComponent != null && focusedComponent.keyPressed(keyCode)) {
            focusedComponent = null;
            return;
        }
        int n = -1;
        switch (keyCode) {
            case -1: 
            case 221: {
                if (focusedComponent != null && focusedComponent.drawPopUp) {
                    focusedComponent.scrolUp();
                    focusedComponent = null;
                    break;
                }
                n = this.getPreviousFocusable();
                if (n != -1) {
                    this.changeFocus(n);
                    break;
                }
                this.scrollUp();
                break;
            }
            case -2: 
            case 222: {
                if (focusedComponent != null && focusedComponent.drawPopUp) {
                    focusedComponent.scrolDn();
                    focusedComponent = null;
                    break;
                }
                n = this.getNextFocusable();
                if (n != -1) {
                    this.changeFocus(n);
                    break;
                }
                this.scrollDown();
                break;
            }
            default: {
                JPlatformCanvas.getInstance().processSoftKeys(keyCode);
            }
        }
    }

    public void pointerPressed(String componentLabel, int x, int y) {
        if (this.canvas.isDrawList()) {
            return;
        }
        Component currentComponent = this.getCurrentComponent();
        if (currentComponent != null && currentComponent.drawPopUp) {
            currentComponent.pointerPressed(x, y);
            currentComponent = null;
            return;
        }
        if (componentLabel.equals("FOOTER")) {
            int n = -1;
            n = this.getNextFocusable();
            if (n != -1) {
                this.changeFocus(n);
            } else {
                this.scrollDown();
            }
        } else if (componentLabel.equals("HEADER")) {
            int n = -1;
            n = this.getPreviousFocusable();
            if (n != -1) {
                this.changeFocus(n);
            } else {
                this.scrollUp();
            }
        } else {
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                Component clickedComponent = (Component)this.components.elementAt(i);
                if (!clickedComponent.getLabel().equals(componentLabel)) continue;
                this.changeFocus(i);
                clickedComponent.pointerPressed(x, y);
                clickedComponent = null;
                break;
            }
        }
    }
}

