/*
 * Decompiled with CFR 0.152.
 */
package GeneralUI;

import GeneralUI.JPlatformCanvas;
import common.AppConstants;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class DrawText {
    public static final byte LEFT = 0;
    public static final byte CENTER = 1;
    public static final byte RIGHT = 2;
    private static final byte SPACE = 2;
    private static final byte fontSpacing = 1;
    private static final byte NO_OF_STRIPS = 2;
    public static final byte BLACK_BOLD = 0;
    public static final byte BLACK_NORMAL = 1;
    private static Image[] fontStrip = null;
    private static byte currentStrip = 0;
    private static short[][] fontStart;
    private static byte[][] fontWidth;
    private static final char[] fontChars;

    public static void drawText(String text, Graphics g, int x, int y) {
        DrawText.drawText(text, g, x, y, JPlatformCanvas.SCREEN_WIDTH, 0);
    }

    public static void drawText(String text, Graphics g, int x, int y, int endX) {
        DrawText.drawText(text, g, x, y, endX, 1);
    }

    public static void drawText(String text, Graphics g, int x, int y, int endX, int orient) {
        DrawText.drawText(text, g, x, y, endX, orient, 0, 0, JPlatformCanvas.SCREEN_WIDTH, JPlatformCanvas.SCREEN_HEIGHT);
    }

    public static void drawText(String text, Graphics g, int x, int y, int endX, int orient, int clipX, int clipY, int clipWidth, int clipHeight) {
        DrawText.loadStrip();
        if (text == null) {
            return;
        }
        int tmpX = orient == 0 ? x : (orient == 1 ? endX + x - DrawText.getWidth(text) >> 1 : endX - x - DrawText.getWidth(text));
        int length = text.length();
        int currentStripLength = fontChars.length;
        block0: for (int i = length; i > 0; --i) {
            char tmp = text.charAt(length - i);
            for (int j = currentStripLength; j > 0; --j) {
                if (tmp == ' ') {
                    tmpX += 3;
                    continue block0;
                }
                if (tmp != fontChars[currentStripLength - j]) continue;
                g.setClip(tmpX, y, (int)fontWidth[DrawText.getCurrentStrip()][currentStripLength - j], fontStrip[DrawText.getCurrentStrip()].getHeight());
                g.drawImage(fontStrip[DrawText.getCurrentStrip()], tmpX - fontStart[DrawText.getCurrentStrip()][currentStripLength - j], y, 20);
                tmpX += fontWidth[DrawText.getCurrentStrip()][currentStripLength - j] + 1;
                continue block0;
            }
        }
        g.setClip(clipX, clipY, clipWidth, clipHeight);
    }

    public static int getWidth(String text) {
        DrawText.loadStrip();
        int tmpX = 0;
        int length = text.length();
        int currentStripLength = fontChars.length;
        block0: for (int i = length; i > 0; --i) {
            char tmp = text.charAt(length - i);
            for (int j = currentStripLength; j > 0; --j) {
                if (tmp == ' ') {
                    tmpX += 3;
                    continue block0;
                }
                if (tmp != fontChars[currentStripLength - j]) continue;
                tmpX += fontWidth[DrawText.getCurrentStrip()][currentStripLength - j] + 1;
                continue block0;
            }
        }
        return tmpX;
    }

    public static int getHeight() {
        DrawText.loadStrip();
        return fontStrip[DrawText.getCurrentStrip()].getHeight();
    }

    private static void loadStrip() {
        if (fontStrip == null) {
            fontStrip = new Image[2];
            try {
                DrawText.fontStrip[0] = Image.createImage((String)("/arial-bold" + AppConstants.iFont + ".png"));
                DrawText.fontStrip[1] = Image.createImage((String)("/arial-regular" + AppConstants.iFont + ".png"));
                switch (AppConstants.iFont) {
                    case 0: {
                        fontStart = new short[][]{{1, 12, 21, 31, 40, 48, 56, 66, 75, 79, 87, 96, 104, 115, 124, 134, 143, 153, 163, 172, 182, 191, 202, 217, 226, 236, 245, 253, 261, 269, 277, 285, 292, 300, 308, 312, 318, 326, 330, 342, 350, 358, 366, 374, 380, 388, 394, 402, 411, 424, 432, 441, 448, 456, 462, 470, 478, 486, 494, 502, 510, 518, 526, 530, 534, 538, 545, 553, 561, 565, 569, 578, 584, 590, 598, 607, 616, 621, 626, 631, 638, 648, 656, 666, 673, 681, 696, 705, 709, 712, 719}, {1, 12, 21, 30, 39, 48, 56, 66, 75, 78, 85, 95, 103, 114, 123, 133, 142, 152, 161, 170, 179, 188, 198, 214, 223, 231, 240, 247, 254, 261, 268, 275, 281, 288, 295, 298, 303, 310, 313, 324, 331, 338, 345, 352, 357, 364, 369, 376, 383, 394, 401, 408, 415, 423, 428, 436, 444, 452, 460, 468, 476, 484, 492, 495, 498, 501, 506, 514, 522, 525, 527, 534, 540, 546, 555, 564, 573, 578, 583, 588, 595, 605, 612, 624, 631, 641, 655, 664, 667, 670, 676}};
                        fontWidth = new byte[][]{{9, 7, 8, 7, 6, 6, 8, 7, 2, 6, 7, 6, 9, 7, 8, 7, 8, 8, 7, 8, 7, 9, 13, 7, 8, 7, 6, 6, 6, 6, 6, 5, 6, 6, 2, 4, 6, 2, 10, 6, 6, 6, 6, 4, 6, 4, 6, 7, 11, 6, 7, 5, 6, 4, 6, 6, 6, 6, 6, 6, 6, 6, 2, 2, 2, 5, 6, 6, 2, 2, 7, 4, 4, 6, 7, 7, 3, 3, 3, 5, 8, 6, 8, 5, 6, 13, 7, 2, 3, 4, 4}, {9, 7, 7, 7, 7, 6, 8, 7, 1, 5, 8, 6, 9, 7, 8, 7, 8, 7, 7, 7, 7, 9, 13, 7, 7, 7, 5, 5, 5, 5, 5, 4, 5, 5, 1, 3, 5, 1, 9, 5, 5, 5, 5, 3, 5, 3, 5, 5, 9, 5, 5, 5, 6, 3, 6, 6, 6, 6, 6, 6, 6, 6, 1, 1, 1, 3, 6, 6, 1, 1, 5, 4, 4, 7, 7, 7, 3, 3, 3, 5, 8, 5, 10, 5, 8, 12, 7, 1, 2, 3, 3}};
                        AppConstants.FONT_CONTENT = Font.getFont((int)0, (int)0, (int)8);
                        AppConstants.FONT_HEADING = Font.getFont((int)0, (int)1, (int)8);
                        break;
                    }
                    case 1: {
                        fontStart = new short[][]{{3, 14, 25, 37, 49, 60, 69, 82, 94, 98, 107, 119, 129, 143, 154, 167, 178, 191, 202, 213, 224, 235, 244, 259, 270, 280, 289, 298, 308, 317, 326, 335, 342, 352, 361, 365, 372, 380, 385, 398, 408, 417, 427, 437, 444, 451, 458, 468, 477, 490, 498, 507, 515, 524, 532, 541, 550, 558, 567, 576, 585, 593, 603, 608, 613, 622, 629, 639, 649, 654, 658, 668, 675, 680, 690, 699, 709, 714, 721, 727, 735, 746, 755, 771, 781, 791, 807, 817, 821, 825, 833}, {1, 12, 22, 34, 46, 57, 66, 78, 89, 92, 100, 111, 120, 132, 142, 155, 166, 179, 190, 200, 211, 221, 230, 248, 258, 269, 277, 286, 295, 304, 312, 320, 326, 335, 343, 346, 352, 359, 363, 377, 386, 394, 403, 412, 418, 424, 431, 439, 447, 458, 466, 475, 484, 493, 501, 510, 518, 527, 536, 545, 554, 562, 571, 576, 581, 586, 592, 602, 612, 617, 621, 629, 636, 642, 652, 660, 669, 676, 682, 689, 697, 706, 712, 726, 738, 748, 764, 775, 780, 784, 790}};
                        fontWidth = new byte[][]{{9, 9, 9, 9, 8, 7, 10, 9, 2, 7, 9, 7, 11, 9, 10, 8, 10, 9, 8, 8, 9, 9, 13, 8, 8, 8, 7, 7, 6, 7, 7, 6, 7, 7, 2, 4, 6, 2, 10, 7, 7, 7, 7, 5, 6, 5, 7, 7, 11, 6, 7, 6, 7, 5, 7, 7, 7, 7, 7, 7, 7, 7, 2, 2, 2, 6, 7, 7, 2, 2, 8, 4, 4, 8, 8, 8, 4, 4, 4, 5, 10, 8, 12, 7, 7, 14, 8, 2, 4, 5, 5}, {9, 9, 9, 9, 8, 7, 9, 8, 1, 6, 8, 7, 9, 8, 10, 8, 10, 9, 8, 9, 8, 9, 16, 9, 9, 8, 6, 6, 6, 6, 6, 4, 6, 6, 1, 3, 6, 1, 11, 6, 6, 6, 6, 4, 6, 4, 7, 7, 11, 7, 7, 6, 6, 3, 6, 6, 6, 6, 6, 6, 6, 6, 1, 1, 1, 3, 7, 7, 1, 1, 6, 4, 4, 7, 7, 8, 4, 3, 3, 5, 9, 5, 11, 7, 8, 14, 8, 1, 2, 4, 4}};
                        AppConstants.FONT_CONTENT = Font.getFont((int)0, (int)0, (int)0);
                        AppConstants.FONT_HEADING = Font.getFont((int)0, (int)1, (int)0);
                        break;
                    }
                    case 2: {
                        fontStart = new short[][]{{1, 16, 30, 44, 58, 70, 82, 97, 110, 116, 128, 141, 154, 170, 184, 198, 211, 225, 239, 252, 265, 278, 292, 311, 324, 336, 348, 359, 371, 382, 394, 405, 413, 425, 437, 442, 450, 461, 467, 485, 497, 509, 521, 533, 540, 550, 558, 570, 581, 598, 609, 622, 632, 643, 653, 664, 674, 686, 696, 708, 719, 730, 742, 750, 756, 764, 774, 786, 798, 804, 809, 821, 829, 837, 849, 860, 873, 880, 886, 896, 905, 917, 930, 948, 961, 977, 995, 1008, 1011, 1018, 1028}, {1, 14, 26, 41, 55, 66, 79, 94, 108, 113, 123, 136, 147, 162, 177, 191, 204, 219, 233, 246, 259, 272, 284, 302, 314, 327, 339, 350, 361, 371, 382, 392, 399, 410, 420, 426, 432, 443, 448, 463, 474, 485, 496, 506, 513, 522, 529, 539, 551, 566, 576, 586, 596, 608, 617, 628, 638, 650, 661, 672, 683, 693, 705, 711, 720, 726, 733, 744, 758, 764, 769, 778, 788, 795, 807, 817, 829, 836, 844, 852, 861, 873, 883, 902, 915, 930, 953, 967, 972, 975, 985}};
                        fontWidth = new byte[][]{{13, 11, 11, 12, 9, 9, 12, 11, 4, 10, 11, 11, 14, 11, 12, 10, 12, 12, 11, 11, 11, 13, 17, 10, 11, 9, 9, 9, 8, 9, 9, 7, 9, 10, 3, 6, 9, 4, 16, 10, 9, 10, 9, 6, 8, 6, 10, 9, 15, 9, 11, 8, 9, 8, 9, 8, 10, 8, 10, 9, 9, 10, 6, 4, 6, 8, 10, 10, 3, 3, 10, 6, 6, 10, 9, 11, 5, 4, 7, 6, 12, 10, 15, 10, 12, 16, 11, 3, 6, 7, 7}, {11, 10, 13, 12, 10, 9, 12, 12, 3, 8, 11, 8, 13, 12, 12, 11, 13, 12, 10, 10, 12, 11, 17, 10, 12, 10, 9, 9, 8, 8, 8, 5, 9, 8, 4, 4, 9, 3, 13, 9, 9, 9, 8, 5, 7, 5, 8, 10, 13, 8, 9, 8, 9, 7, 9, 8, 10, 9, 9, 9, 8, 10, 4, 7, 4, 5, 10, 11, 4, 3, 7, 8, 6, 10, 9, 11, 5, 6, 6, 6, 11, 7, 14, 10, 12, 18, 12, 3, 3, 6, 6}};
                        AppConstants.FONT_CONTENT = Font.getFont((int)0, (int)0, (int)16);
                        AppConstants.FONT_HEADING = Font.getFont((int)0, (int)1, (int)16);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void resetFontStrip() {
        fontStrip = null;
        DrawText.loadStrip();
    }

    private static int getCurrentStrip() {
        return currentStrip;
    }

    public static void setCurrentStrip(int aCurrentStrip) {
        DrawText.loadStrip();
        currentStrip = (byte)aCurrentStrip;
    }

    public static void setStrip(int strip) {
        DrawText.loadStrip();
        DrawText.setCurrentStrip(strip);
    }

    public static int getcharWidth(char ch) {
        DrawText.loadStrip();
        int tmpX = 0;
        int currentStripLength = fontChars.length;
        char tmp = ch;
        for (int j = currentStripLength; j > 0; --j) {
            if (tmp == ' ') {
                tmpX += 3;
                break;
            }
            if (tmp != fontChars[currentStripLength - j]) continue;
            tmpX += fontWidth[DrawText.getCurrentStrip()][currentStripLength - j] + 1;
            break;
        }
        return tmpX;
    }

    static {
        fontChars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '\'', '\"', '<', '>', '.', ',', '?', '/', '\\', '+', '=', '_', '-', ')', '(', '*', '&', '^', '%', '$', '#', '@', '~', '!', '`', '[', ']'};
    }
}

