/*
 * Decompiled with CFR 0.152.
 */
package GeneralUI;

import GeneralUI.DrawText;
import GeneralUI.JPlatformCanvas;
import GeneralUI.ScreenPointerDefinition;
import common.AppConstants;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import market.iWinRefresh;

public class JList {
    private String[] sItems = null;
    private boolean[] bSelectedIndex = null;
    private String title = null;
    private int currentSelect = 0;
    private int currentStart = 0;
    private int currentEnd = 0;
    private byte MAXDISPLAYABLEITEMS = 0;
    private int startX;
    private int startY;
    private byte displacing;
    private byte iFontHeight = (byte)10;
    private int count = 0;
    private int maxx = 0;
    private int maxy = 0;
    private boolean isListTypeChoiceGroup = false;
    public static final byte EXCLUSIVE = 0;
    public static final byte IMPLICIT = 1;
    public static final byte MULTIPLE = 2;
    private byte iChoiceGroupListType = 1;
    private Image choiceImg = null;
    private int choiceImageWidth = -1;
    private String Label = null;
    private int iOldSelectedIndex = -1;
    private int iOrientation = -1;

    public JList(String title) {
        this.setTitle(title);
        this.Label = null;
        int iDefaultCapacity = 5;
        this.sItems = new String[5];
        this.bSelectedIndex = new boolean[5];
        this.iFontHeight = (byte)DrawText.getHeight();
        this.maxx = JPlatformCanvas.SCREEN_WIDTH;
        this.maxy = JPlatformCanvas.SCREEN_HEIGHT;
        this.startY = JPlatformCanvas.TITLE_BAR_HEIGHT + this.iFontHeight;
        this.startX = this.maxx / 25;
        this.displacing = (byte)(this.maxy / (this.iFontHeight * 3));
        this.init();
    }

    private void init() {
        this.MAXDISPLAYABLEITEMS = (byte)((this.maxy - this.startY - JPlatformCanvas.SOFT_KEYBAR_HEIGHT) / (this.iFontHeight + this.displacing));
        this.adjustMenu();
        this.setTextOrientation(0);
    }

    public void setLabel(String newLabel) {
        this.Label = newLabel;
        this.setMenuStartXY(this.startX, JPlatformCanvas.TITLE_BAR_HEIGHT + 3 * this.iFontHeight / 2);
    }

    public String getLabel() {
        return this.Label;
    }

    public void setTextOrientation(int newOrientation) {
        this.iOrientation = newOrientation;
    }

    public int getTextOrientation() {
        return this.iOrientation;
    }

    public void paint(Graphics g) {
        DrawText.setCurrentStrip(0);
        if (this.count <= 0) {
            DrawText.drawText("No Data", g, (this.maxx - DrawText.getWidth(this.title)) / 2 + 1, this.startY, this.maxx, this.iOrientation);
            return;
        }
        if (this.getLabel() != null) {
            DrawText.drawText(this.getLabel(), g, 5, JPlatformCanvas.TITLE_BAR_HEIGHT + 1, this.maxx, this.iOrientation);
        }
        int j = 0;
        int iSelectorXPosition = this.startX - 2;
        int iSelectorYPosition = this.startY;
        int iSelectorHeight = 3 * this.iFontHeight / 2;
        int iClipAreaWidth = 2;
        int choiceIconWidth = 5;
        for (int i = this.currentStart; i <= this.currentEnd; ++i) {
            if (this.currentSelect == i) {
                g.setColor(9613776);
                g.fillRect(iSelectorXPosition, iSelectorYPosition + j * (this.iFontHeight + this.displacing) - this.iFontHeight / 2, this.maxx - iSelectorXPosition * 2, iSelectorHeight);
                g.setColor(0);
                g.drawRect(iSelectorXPosition, iSelectorYPosition + j * (this.iFontHeight + this.displacing) - this.iFontHeight / 2, this.maxx - iSelectorXPosition * 2, iSelectorHeight);
                g.drawImage(JPlatformCanvas.getInstance().getSelecteorLogoImg(), iSelectorXPosition + this.maxx - (iSelectorXPosition + 1) * 2, iSelectorYPosition + j * (this.iFontHeight + this.displacing) - this.iFontHeight / 4, 24);
            }
            if (this.isListTypeChoiceGroup) {
                g.setClip(this.startX, this.startY + j * (this.iFontHeight + this.displacing) - 1, this.choiceImageWidth / 8 + 2, iSelectorHeight);
                switch (this.iChoiceGroupListType) {
                    case 0: 
                    case 2: {
                        if (this.choiceImg == null) break;
                        g.drawImage(this.choiceImg, this.startX - (this.choiceImageWidth / 8 + 2) * (this.bSelectedIndex[i] ? 1 : 0), this.startY + j * (this.iFontHeight + this.displacing) + 1, 20);
                    }
                }
                g.setClip(0, 0, this.maxx, this.maxy);
                choiceIconWidth = this.choiceImageWidth / 8;
            }
            DrawText.drawText(this.getString(i), g, this.startX + choiceIconWidth + 4, this.startY + (j * (this.iFontHeight + this.displacing) - 1), this.maxx, this.iOrientation);
            if (JPlatformCanvas.getInstance().hasPointerEvents()) {
                ScreenPointerDefinition.setPointer(this.getTitle(), this.getString(i), iSelectorXPosition, this.startY + j * (this.iFontHeight + this.displacing) - this.iFontHeight / 2, this.maxx - iSelectorXPosition, this.startY + j * (this.iFontHeight + this.displacing) - this.iFontHeight / 2 + iSelectorHeight);
            }
            ++j;
        }
    }

    public void append(String item, Image img) {
        this.append(item);
    }

    public void append(String item) {
        this.checkCapacity();
        this.sItems[this.count] = item;
        if (this.isListTypeChoiceGroup) {
            this.bSelectedIndex[this.count] = false;
        }
        ++this.count;
        if (this.currentEnd - this.currentStart < this.MAXDISPLAYABLEITEMS - 1 && this.currentEnd < this.count - 1) {
            ++this.currentEnd;
        }
    }

    private void checkCapacity() {
        int increaseCapacity = 5;
        int length = this.sItems.length;
        if (this.count >= length) {
            String[] tmp = new String[length + 5];
            System.arraycopy(this.sItems, 0, tmp, 0, this.sItems.length);
            this.sItems = tmp;
            tmp = null;
            if (this.isListTypeChoiceGroup) {
                boolean[] tmp_bool = new boolean[length + 5];
                System.arraycopy(this.bSelectedIndex, 0, tmp_bool, 0, this.bSelectedIndex.length);
                this.bSelectedIndex = tmp_bool;
                tmp_bool = null;
            }
        }
    }

    public void delete(int i) {
        if (i < this.count && this.count > 0) {
            for (int j = i; j < this.count - 1; ++j) {
                this.sItems[j] = this.sItems[j + 1];
                if (!this.isListTypeChoiceGroup) continue;
                this.bSelectedIndex[j] = this.bSelectedIndex[j + 1];
            }
            this.sItems[this.count - 1] = null;
            if (this.isListTypeChoiceGroup) {
                this.bSelectedIndex[this.count - 1] = false;
            }
            --this.count;
            if (this.currentSelect >= this.count && this.currentSelect != 0 && this.currentEnd == this.currentSelect) {
                --this.currentSelect;
            }
            this.adjustMenu();
        }
    }

    public void deleteAll() {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.delete(i);
        }
    }

    private void adjustMenu() {
        if (this.currentSelect < this.currentStart) {
            this.currentStart = this.currentSelect;
            this.currentEnd = this.currentStart + this.MAXDISPLAYABLEITEMS - 1;
        } else if (this.currentSelect > this.currentEnd) {
            this.currentEnd = this.currentSelect;
            this.currentStart = this.currentEnd - this.MAXDISPLAYABLEITEMS + 1;
        } else if (this.currentEnd - this.currentStart < this.MAXDISPLAYABLEITEMS - 1) {
            --this.currentStart;
        }
        if (this.currentEnd >= this.count) {
            this.currentEnd = this.count - 1;
        }
        if (this.currentStart < 0) {
            this.currentStart = 0;
        }
    }

    public void paintScroller(Graphics g) {
        if (this.currentSelect >= this.MAXDISPLAYABLEITEMS | this.currentStart > 0) {
            JPlatformCanvas.drawUpArrow(g);
        }
        if (this.size() > this.MAXDISPLAYABLEITEMS & this.currentSelect < this.size() - 1) {
            JPlatformCanvas.drawDownArrow(g);
        }
    }

    public boolean isPointerSelected(String lsSection) {
        for (int i = 0; i <= this.size(); ++i) {
            if (!lsSection.equals(this.sItems[i])) continue;
            if (i == this.currentSelect) {
                this.adjustMenu();
                return true;
            }
            this.currentSelect = i;
            return false;
        }
        return false;
    }

    public void pointerPressed(String fsSection, int x, int y) {
        if (fsSection.equals("HEADER")) {
            this.scrolUp();
        } else if (fsSection.equals("FOOTER")) {
            this.scrolDown();
        } else if (this.isPointerSelected(fsSection)) {
            if (this.isListTypeChoiceGroup) {
                this.handleChoiceGroup();
            }
            if (JPlatformCanvas.getInstance().leftSoftKey != null && JPlatformCanvas.getInstance().leftSoftKey.getLabel().equals("Select")) {
                JPlatformCanvas.getInstance().leftSoftKey.performAction();
            }
        }
    }

    private void scrolUp() {
        if (this.count > 0) {
            this.currentSelect = ((this.currentSelect - 1) % this.count + this.count) % this.count;
            this.adjustMenu();
        }
    }

    private void scrolDown() {
        if (this.count > 0) {
            this.currentSelect = (this.currentSelect + 1) % this.count;
            this.adjustMenu();
        }
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case -1: 
            case 221: {
                this.scrolUp();
                break;
            }
            case -2: 
            case 222: {
                this.scrolDown();
                break;
            }
            case 225: {
                if (this.isListTypeChoiceGroup) {
                    this.handleChoiceGroup();
                    break;
                }
            }
            default: {
                JPlatformCanvas.getInstance().processSoftKeys(keyCode);
            }
        }
    }

    private void handleChoiceGroup() {
        switch (this.iChoiceGroupListType) {
            case 2: {
                this.bSelectedIndex[this.getSelectedIndex()] = !this.bSelectedIndex[this.getSelectedIndex()];
                break;
            }
            case 0: {
                this.bSelectedIndex[this.getSelectedIndex()] = true;
                if (this.getSelectedIndex() == this.iOldSelectedIndex) break;
                if (this.iOldSelectedIndex != -1) {
                    this.bSelectedIndex[this.getSelectedIndex()] = this.bSelectedIndex[this.iOldSelectedIndex];
                    this.bSelectedIndex[this.iOldSelectedIndex] = false;
                }
                this.iOldSelectedIndex = this.getSelectedIndex();
            }
        }
    }

    public void unSelectIndex() {
        this.handleChoiceGroup();
    }

    public void setChoiceType(byte newType) {
        try {
            if (this.choiceImg == null) {
                this.choiceImg = Image.createImage((String)"/iconStrip.png");
                this.choiceImageWidth = this.choiceImg.getWidth();
            }
            this.isListTypeChoiceGroup = true;
            this.iChoiceGroupListType = newType;
            if (this.iChoiceGroupListType == 0) {
                this.bSelectedIndex[0] = true;
            }
        }
        catch (Exception e) {
            iWinRefresh.displayAlert("Error", "JList : " + e, AppConstants.iAlertDisplayTime);
        }
    }

    public void setTitle(String str) {
        this.title = str;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSelectedIndex() {
        return this.currentSelect;
    }

    public void setSelectedIndex(int i) {
        this.currentSelect = i;
    }

    public int size() {
        return this.count;
    }

    public void setMenuStartXY(int x, int y) {
        this.startX = x;
        this.startY = y;
        this.init();
    }

    public void setScreenWidthHeight(int x, int y) {
        this.maxx = x;
        this.maxy = y;
        this.init();
    }

    public void setMenuSpacing(byte value) {
        this.displacing = value;
    }

    public String getString(int index) {
        return this.sItems[index];
    }

    public boolean isSelected(int index) {
        return index >= 0 && index < this.size() ? this.bSelectedIndex[index] : false;
    }

    public int getSelectedCount() {
        int selectedCount = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.isSelected(i)) continue;
            ++selectedCount;
        }
        return selectedCount;
    }
}

