/*
 * Decompiled with CFR 0.152.
 */
package GeneralUI;

import GeneralUI.Component;
import GeneralUI.DrawText;
import GeneralUI.JPlatformCanvas;
import javax.microedition.lcdui.Graphics;

public class JStringItem
extends Component {
    private int lineCount;
    private int startLine;
    private int strHeight;
    private int fontid = 0;
    public static final int FONT_HEADING = 0;
    public static final int FONT_NORMAL = 1;
    private String[] lineStr = new String[]{null, null, null, null, null};
    private String text;

    public JStringItem() {
        this(null, null, 1);
    }

    public JStringItem(String Label) {
        this(Label, null, 1);
    }

    public JStringItem(String Label, String text) {
        this(Label, text, 1);
    }

    public JStringItem(String Label, String text, int font_type) {
        this.Label = Label;
        if (text != null && text.length() > 0) {
            this.setText(text, font_type);
        }
    }

    public void drawComponent(Graphics g) {
        if (this.lineCount == 0) {
            return;
        }
        int currentY = this.screenY;
        this.screenX -= 5;
        this.strHeight = DrawText.getHeight() + 2;
        if (this.Label != null && this.Label.length() > 0) {
            DrawText.setCurrentStrip(0);
            DrawText.drawText(this.Label, g, this.screenX, currentY, JPlatformCanvas.SCREEN_WIDTH, 0);
            currentY += this.strHeight;
        }
        this.setFont(this.fontid);
        int i = 0;
        for (i = this.startLine; i < this.lineCount && currentY + this.strHeight < JPlatformCanvas.SCREEN_HEIGHT; ++i) {
            DrawText.drawText(this.lineStr[i], g, this.screenX, currentY, JPlatformCanvas.SCREEN_WIDTH, 0);
            currentY += this.strHeight;
        }
    }

    public void setFont(int id) {
        switch (id) {
            case 0: {
                this.fontid = 0;
                break;
            }
            case 1: {
                this.fontid = 1;
            }
        }
        DrawText.setCurrentStrip(this.fontid);
    }

    public void setText(String msg, int font_type) {
        this.text = msg;
        this.setFont(font_type);
        this.HEIGHT = DrawText.getHeight() + 2;
        int counter = 0;
        int tempWidth = 0;
        int curWidth = 0;
        this.startLine = 0;
        this.lineCount = 0;
        this.lineStr[this.lineCount] = "";
        this.text = this.text + " ";
        char[] strData = this.text.toCharArray();
        int length = strData.length;
        for (int i = 0; i < length; ++i) {
            tempWidth += DrawText.getcharWidth(strData[i]);
            if (strData[i] == '\n' || strData[i] == '\r') {
                this.lineStr[this.lineCount] = this.lineStr[this.lineCount] + new String(strData, counter, i - counter);
                ++this.lineCount;
                this.checkLength(this.lineCount);
                this.lineStr[this.lineCount] = "";
                curWidth = 0;
                tempWidth = 0;
                counter = i + 1;
                continue;
            }
            if (strData[i] == ' ') {
                this.lineStr[this.lineCount] = this.lineStr[this.lineCount] + new String(strData, counter, i - counter) + " ";
                tempWidth = 0;
                curWidth = DrawText.getWidth(this.lineStr[this.lineCount]);
                counter = i + 1;
                continue;
            }
            if (tempWidth + curWidth <= JPlatformCanvas.SCREEN_WIDTH - 10) continue;
            ++this.lineCount;
            this.checkLength(this.lineCount);
            this.lineStr[this.lineCount] = new String(strData, counter, i - counter);
            tempWidth = DrawText.getcharWidth(strData[i]);
            curWidth = DrawText.getWidth(this.lineStr[this.lineCount]);
            counter = i;
        }
        ++this.lineCount;
        this.checkLength(this.lineCount);
        this.HEIGHT *= this.lineCount;
    }

    private void checkLength(int lineCount) {
        int length = this.lineStr.length;
        if (lineCount == length) {
            String[] temp = new String[length + 5];
            System.arraycopy(this.lineStr, 0, temp, 0, length);
            this.lineStr = null;
            this.lineStr = temp;
            Object var3_3 = null;
        }
    }

    public String getText() {
        return this.text;
    }
}

