/*
 * Decompiled with CFR 0.152.
 */
package GeneralUI;

import GeneralUI.Component;
import GeneralUI.DrawText;
import GeneralUI.JPlatformCanvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;
import market.iWinRefresh;

public class JTextField
extends Component
implements CommandListener {
    private int iTextBoxCapacity = 0;
    private int iTextContentType = 0;
    private TextBox javaTextBox = null;
    private final Command Ok = new Command("Ok", 4, 1);
    private StringBuffer sTextContent = null;
    private byte previousScreenId = (byte)-1;
    private boolean isUpperCase = false;

    public JTextField(String sLabel, String aText, int iCapacity, int iTYPE) {
        this.setLabel(sLabel);
        this.sTextContent = new StringBuffer(aText);
        this.iTextContentType = iTYPE;
        this.iTextBoxCapacity = iCapacity;
        this.focusable = true;
        this.isUpperCase = false;
    }

    public void drawComponent(Graphics g) {
        int textlength;
        int xposition = 4;
        int yposition = this.getHeight() / 2;
        this.screenY += this.getLabelHeight();
        this.paintBackground(g, this.screenX, this.getWidth(), this.getHeight());
        g.setColor(0);
        g.drawRect(this.screenX, this.screenY, this.getWidth(), this.getHeight());
        DrawText.setCurrentStrip(0);
        int n = textlength = this.getLabel() != null ? this.getLabel().length() : 0;
        if (textlength > 0) {
            DrawText.drawText(this.getLabel(), g, this.screenX, this.screenY - this.getLabelHeight() - 2);
        }
        DrawText.setCurrentStrip(1);
        int n2 = textlength = this.sTextContent != null ? this.sTextContent.toString().length() : 0;
        if (textlength > 0) {
            int j;
            if (DrawText.getWidth(this.sTextContent.toString()) > this.getWidth() - 4) {
                int width = 0;
                for (j = 0; j < textlength; ++j) {
                    if ((width += DrawText.getcharWidth(this.sTextContent.toString().charAt(j))) <= this.getWidth() - 4) continue;
                    textlength = j;
                    break;
                }
            }
            if (this.iTextContentType == 65536) {
                StringBuffer passChar = new StringBuffer();
                for (j = 0; j < textlength; ++j) {
                    passChar.append("*");
                }
                DrawText.drawText(passChar.toString(), g, this.screenX + 4, this.screenY + yposition - DrawText.getHeight() / 2);
                passChar = null;
            } else {
                DrawText.drawText(this.sTextContent.toString().substring(0, textlength), g, this.screenX + 4, this.screenY + yposition - DrawText.getHeight() / 2);
            }
        }
    }

    public boolean keyPressed(int keyCode) {
        if (keyCode == 225 || keyCode >= 49 & keyCode <= 57 || keyCode >= 201 & keyCode <= 212 || keyCode == 225) {
            this.showTextBox();
            return true;
        }
        return false;
    }

    public boolean pointerPressed(int x, int y) {
        this.showTextBox();
        return false;
    }

    private void showTextBox() {
        this.javaTextBox = null;
        if (this.javaTextBox == null) {
            this.javaTextBox = new TextBox(this.getLabel(), this.getText(), this.iTextBoxCapacity, this.iTextContentType);
            this.javaTextBox.addCommand(this.Ok);
            this.javaTextBox.setCommandListener((CommandListener)this);
        }
        this.previousScreenId = JPlatformCanvas.getInstance().getScreenID();
        iWinRefresh.display.setCurrent((Displayable)this.javaTextBox);
    }

    public void commandAction(Command command, Displayable d) {
        if (command == this.Ok) {
            if (this.sTextContent != null) {
                this.sTextContent.delete(0, this.sTextContent.length());
                String contentText = this.isUpperCase ? this.javaTextBox.getString().toUpperCase() : this.javaTextBox.getString();
                this.sTextContent.append(contentText);
                Object var3_3 = null;
            }
            JPlatformCanvas.getInstance().setScreenID(this.previousScreenId);
        }
    }

    public void toUpperCase() {
        this.isUpperCase = true;
    }

    public void clearText() {
        if (this.sTextContent == null) {
            return;
        }
        this.sTextContent.delete(0, this.sTextContent.length());
    }

    public String getText() {
        return this.sTextContent.toString();
    }

    public void setText(String text) {
        int len = this.sTextContent.length();
        if (len > 0) {
            this.sTextContent.delete(0, len);
        }
        this.sTextContent.append(text);
    }

    public void setContentType(int ipContentType) {
        this.iTextContentType = ipContentType;
    }
}

