/*
 * Decompiled with CFR 0.152.
 */
package chart;

import GeneralUI.JPlatformCanvas;
import GeneralUI.ScreenPointerDefinition;
import GeneralUI.SoftKey;
import chart.Indicators;
import chart.Plotter;
import chart.Studies;
import chart.Tick;
import common.AppConstants;
import common.JCommandListener;
import common.Utilities;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import market.iWinRefresh;

public class ChartCanvas
implements JCommandListener {
    public static String strchartTime = "1";
    private String[] strButtons = new String[]{"<<", ">>", "+", "-", "Rst", "3M"};
    private final String[] strChartType = new String[]{"1", "5", "10", "15", "30", "1H", "4H", "1W", "1M", "3M", "6M", "1Y"};
    private final int m_nButtonsLen = this.strButtons.length;
    private final int m_nChartTypeLen = this.strChartType.length;
    private String m_strSegmentId;
    private String m_strInstrumentID;
    private String m_strKey;
    private Plotter m_objMainChart;
    private Indicators m_objIndicator;
    private Studies m_objStudies;
    private Vector m_objData;
    private Vector m_objOriginalData;
    public int iIndex = 0;
    private int m_nButtonIndex = 0;
    private int m_nStartIndex = 0;
    private int m_nEndIndex = 0;
    private int m_nChartTime = 0;
    private int m_nChartTimeIndex = 0;
    private boolean bIndicatorFlag = false;
    private boolean bStudiesFlag = false;
    private boolean bOHLCFlag = false;
    private boolean bDropDownFlag = false;
    private boolean bIsReload = false;
    private boolean bIsReDraw = false;
    private int SCREEN_WIDTH;
    private int SCREEN_HEIGHT;
    private int CHART_START_XCordinate = 0;
    private int CHART_START_YCordinate = 0;
    public static int CHART_ACTION_KEYS = 14;
    private int m_nPx = 1;
    private int m_nMinWidthOfEachScrip = 1;
    private int m_nMaxWidthOfEachScrip = 12;
    private byte INTRADAY_CHART = 0;
    private byte ONE_MONTH_CHART = 1;
    private byte THREE_MONTH_CHART = (byte)2;
    private byte SIX_MONTH_CHART = (byte)3;
    private byte ONE_YEAR_CHART = (byte)4;
    private final int CHART_START_DIFFERENCE;
    private final byte EXTRA_XAXIS_LENGTH = (byte)32;
    private final byte LEFT_EXTRA_XAXIS_LENGTH = (byte)5;
    private final byte NO_OF_UNITS_FOR_XAxis = (byte)4;
    private final byte NO_OF_UNITS_FOR_YAxis = (byte)3;
    private final byte m_nIncreasePxBy;
    private Font f = AppConstants.FONT_HEADING;
    private JPlatformCanvas canvas = JPlatformCanvas.getInstance();
    private int count = 12;
    private int selectedIndex;
    private int currentStart = 0;
    private int currentEnd = 0;
    private int f_nChartTime;
    private int MAXDISPLAYABLEITEMS;
    String m_TotalTick = "";
    int tempi;

    public ChartCanvas() {
        this.CHART_START_DIFFERENCE = 15;
        this.m_nIncreasePxBy = 1;
        this.m_objMainChart = new Plotter();
        this.m_objIndicator = new Indicators();
        this.m_objStudies = new Studies();
        this.SCREEN_WIDTH = JPlatformCanvas.SCREEN_WIDTH;
        this.SCREEN_HEIGHT = JPlatformCanvas.SCREEN_HEIGHT - JPlatformCanvas.SOFT_KEYBAR_HEIGHT - JPlatformCanvas.TITLE_BAR_HEIGHT;
        this.CHART_START_YCordinate = JPlatformCanvas.TITLE_BAR_HEIGHT + 3;
        int iTotalWidth = this.SCREEN_WIDTH;
        if (JPlatformCanvas.SCREEN_HEIGHT < JPlatformCanvas.SCREEN_WIDTH) {
            iTotalWidth = JPlatformCanvas.SCREEN_HEIGHT + (JPlatformCanvas.SCREEN_WIDTH - JPlatformCanvas.SCREEN_HEIGHT) / 2;
        }
        if ((CHART_ACTION_KEYS = iTotalWidth / (this.m_nButtonsLen * 2) - 1) > 30) {
            CHART_ACTION_KEYS = 30;
        }
        this.f = CHART_ACTION_KEYS < 18 ? Font.getFont((int)0, (int)0, (int)8) : (CHART_ACTION_KEYS < 24 ? Font.getFont((int)0, (int)0, (int)0) : Font.getFont((int)0, (int)1, (int)8));
    }

    public void LoadChart(String f_strSegmentId, String f_strInstId, String f_strKey, int f_nChartTime, String f_strTickData) {
        this.m_strSegmentId = f_strSegmentId;
        this.m_strInstrumentID = f_strInstId;
        this.m_strKey = f_strKey;
        this.m_nChartTime = f_nChartTime;
        this.m_nChartTimeIndex = f_nChartTime;
        this.strButtons[this.m_nButtonsLen - 1] = this.strChartType[this.m_nChartTimeIndex];
        this.bDropDownFlag = false;
        this.bOHLCFlag = false;
        this.bStudiesFlag = false;
        this.bIndicatorFlag = false;
        this.m_nPx = 1;
        this.m_nMinWidthOfEachScrip = 1;
        this.m_nMaxWidthOfEachScrip = 12;
        this.clearOriginalVector();
        this.clearDisplayVector();
        this.m_objOriginalData = this.getHistory(f_strTickData);
        this.showStudies(4, 2);
        this.setDisplayVector();
        this.refresh();
        this.canvas.refreshDisplay();
    }

    public void ReLoadChart(String f_strSegmentId, String f_strInstId, String f_strKey, int f_nChartTime, String f_strTickData) {
        Utilities.printLog(f_strTickData);
        this.m_strSegmentId = f_strSegmentId;
        this.m_strKey = f_strKey;
        this.m_nChartTime = f_nChartTime;
        this.m_nChartTimeIndex = f_nChartTime;
        this.strButtons[this.m_nButtonsLen - 1] = this.strChartType[this.m_nChartTimeIndex];
        this.bDropDownFlag = false;
        this.bStudiesFlag = false;
        this.bIndicatorFlag = false;
        this.m_nPx = 1;
        this.m_nMinWidthOfEachScrip = 1;
        this.m_nMaxWidthOfEachScrip = 12;
        this.clearOriginalVector();
        this.clearDisplayVector();
        if (f_nChartTime == 0) {
            this.m_TotalTick = this.m_TotalTick + "#" + f_strTickData;
            this.m_objOriginalData = this.getHistory(this.m_TotalTick);
            this.setDisplayVector();
            this.refresh();
            this.canvas.refreshDisplay();
        }
    }

    private void setDisplayVector() {
        this.clearDisplayVector();
        int l_nWidth = this.m_objMainChart.m_nWidth - this.m_nPx;
        int iOriginalSize = this.m_objOriginalData.size();
        int l_nNoOfScrips = l_nWidth / this.m_nPx;
        l_nNoOfScrips = this.resetWidthOfEachTick(l_nWidth, l_nNoOfScrips, iOriginalSize);
        this.m_nStartIndex = iOriginalSize - l_nNoOfScrips;
        this.m_nEndIndex = iOriginalSize - 1;
        int i = this.m_nStartIndex;
        int j = 0;
        while (i < iOriginalSize) {
            this.m_objData.insertElementAt(this.m_objOriginalData.elementAt(i), j);
            ++i;
            ++j;
        }
        this.iIndex = this.m_objData.size() - 1;
    }

    private int resetWidthOfEachTick(int f_nWidth, int f_nNoOfScrip, int f_nOriginalSize) {
        while (f_nNoOfScrip > f_nOriginalSize) {
            ++this.m_nMinWidthOfEachScrip;
            f_nNoOfScrip = --f_nWidth / this.m_nMinWidthOfEachScrip;
            this.m_nPx = this.m_nMinWidthOfEachScrip;
            if (this.m_nMinWidthOfEachScrip < this.m_nMaxWidthOfEachScrip) continue;
            this.m_nPx = this.m_nMinWidthOfEachScrip = this.m_nMaxWidthOfEachScrip;
            if (f_nNoOfScrip <= f_nOriginalSize) break;
            f_nNoOfScrip = f_nOriginalSize;
            break;
        }
        return f_nNoOfScrip;
    }

    public void draw(Graphics g) {
        if (this.canvas.hasPointerEvents()) {
            ScreenPointerDefinition.setPointer(this.canvas.getTitle(), "Main Chart", 0, JPlatformCanvas.TITLE_BAR_HEIGHT, this.SCREEN_WIDTH - 32 - 5, this.SCREEN_HEIGHT + JPlatformCanvas.TITLE_BAR_HEIGHT - CHART_ACTION_KEYS);
            ScreenPointerDefinition.setPointer(this.canvas.getTitle(), "Action Keys", 0, this.SCREEN_HEIGHT + JPlatformCanvas.TITLE_BAR_HEIGHT - CHART_ACTION_KEYS, this.SCREEN_WIDTH, this.SCREEN_HEIGHT + JPlatformCanvas.TITLE_BAR_HEIGHT);
            if (this.bDropDownFlag) {
                ScreenPointerDefinition.setPointer(this.canvas.getTitle(), "Drop Down", (CHART_ACTION_KEYS + 1) * 2 * (this.m_nButtonsLen - 1), this.SCREEN_HEIGHT + JPlatformCanvas.TITLE_BAR_HEIGHT - CHART_ACTION_KEYS * 4, (CHART_ACTION_KEYS + 1) * 2 * this.m_nButtonsLen, this.SCREEN_HEIGHT + JPlatformCanvas.TITLE_BAR_HEIGHT - CHART_ACTION_KEYS);
            }
        }
        g.setColor(255, 255, 255);
        g.fillRect(0, 0, this.SCREEN_WIDTH, this.SCREEN_HEIGHT);
        this.m_objMainChart.paintPlotter(g, this.iIndex);
        if (this.bStudiesFlag) {
            this.m_objStudies.paintStudies(g, this.m_nStartIndex, this.iIndex);
        }
        if (this.bIndicatorFlag) {
            this.m_objIndicator.paintIndicator(g, this.f, this.m_nStartIndex, this.iIndex);
        }
        this.drawActionKeys(g);
        if (this.bOHLCFlag) {
            this.drawOHLC(g);
        }
        this.bIsReDraw = true;
        AppConstants.IsRedraw = true;
    }

    public void reDraw(Graphics g) {
        if (this.canvas.hasPointerEvents()) {
            ScreenPointerDefinition.setPointer(this.canvas.getTitle(), "Main Chart", 0, JPlatformCanvas.TITLE_BAR_HEIGHT, this.SCREEN_WIDTH - 32 - 5, this.SCREEN_HEIGHT + JPlatformCanvas.TITLE_BAR_HEIGHT - CHART_ACTION_KEYS);
            ScreenPointerDefinition.setPointer(this.canvas.getTitle(), "Action Keys", 0, this.SCREEN_HEIGHT + JPlatformCanvas.TITLE_BAR_HEIGHT - CHART_ACTION_KEYS, this.SCREEN_WIDTH, this.SCREEN_HEIGHT + JPlatformCanvas.TITLE_BAR_HEIGHT);
            if (this.bDropDownFlag) {
                ScreenPointerDefinition.setPointer(this.canvas.getTitle(), "Drop Down", (CHART_ACTION_KEYS + 1) * 2 * (this.m_nButtonsLen - 1), this.SCREEN_HEIGHT + JPlatformCanvas.TITLE_BAR_HEIGHT - CHART_ACTION_KEYS * 4, (CHART_ACTION_KEYS + 1) * 2 * this.m_nButtonsLen, this.SCREEN_HEIGHT + JPlatformCanvas.TITLE_BAR_HEIGHT - CHART_ACTION_KEYS);
            }
        }
        g.setColor(255, 255, 255);
        g.fillRect(0, (int)JPlatformCanvas.TITLE_BAR_HEIGHT, this.SCREEN_WIDTH, this.SCREEN_HEIGHT - JPlatformCanvas.TITLE_BAR_HEIGHT - CHART_ACTION_KEYS);
        this.m_objMainChart.paintPlotter(g, this.iIndex);
        if (this.bStudiesFlag) {
            this.m_objStudies.paintStudies(g, this.m_nStartIndex, this.iIndex);
        }
        if (this.bIndicatorFlag) {
            this.m_objIndicator.paintIndicator(g, this.f, this.m_nStartIndex, this.iIndex);
        }
        if (this.bOHLCFlag) {
            this.drawOHLC(g);
        }
    }

    private void writeOnOHLC(Graphics g) {
        int iImageWidth = this.f.stringWidth("VOL : 00000000") + 10;
        int x = (this.SCREEN_WIDTH - iImageWidth >> 1) + 5;
        int xIncrementCounter = 0;
        int iStartPoint = JPlatformCanvas.TITLE_BAR_HEIGHT + 1;
        int iFontHeight = this.f.getHeight();
        int l_nSegmentId = Integer.parseInt(this.m_strSegmentId);
        int l_nDivisionFactor = ((Tick)this.m_objData.elementAt((int)this.iIndex)).m_nDivisionFactor;
        String l_strOpen = Utilities.ConvertToDecimal(((Tick)this.m_objData.elementAt((int)this.iIndex)).m_nOpen, l_nDivisionFactor, l_nSegmentId);
        String l_strHigh = Utilities.ConvertToDecimal(((Tick)this.m_objData.elementAt((int)this.iIndex)).m_nHigh, l_nDivisionFactor, l_nSegmentId);
        String l_strLow = Utilities.ConvertToDecimal(((Tick)this.m_objData.elementAt((int)this.iIndex)).m_nLow, l_nDivisionFactor, l_nSegmentId);
        String l_strLTP = Utilities.ConvertToDecimal(((Tick)this.m_objData.elementAt((int)this.iIndex)).m_nLTP, l_nDivisionFactor, l_nSegmentId);
        int nVolume = ((Tick)this.m_objData.elementAt((int)this.iIndex)).m_nVolume;
        String strDate = ((Tick)this.m_objData.elementAt((int)this.iIndex)).m_strDate;
        int n = xIncrementCounter++;
        g.drawString(strDate, this.SCREEN_WIDTH >> 1, iStartPoint + iFontHeight * n, 0x10 | 1);
        int n2 = xIncrementCounter++;
        g.drawString("O  : " + l_strOpen, x, iStartPoint + iFontHeight * n2, 0x10 | 4);
        int n3 = xIncrementCounter++;
        g.drawString("H  : " + l_strHigh, x, iStartPoint + iFontHeight * n3, 0x10 | 4);
        int n4 = xIncrementCounter++;
        g.drawString("L  : " + l_strLow, x, iStartPoint + iFontHeight * n4, 0x10 | 4);
        int n5 = xIncrementCounter++;
        g.drawString("C  : " + l_strLTP, x, iStartPoint + iFontHeight * n5, 0x10 | 4);
        int n6 = xIncrementCounter++;
        g.drawString("V  : " + nVolume, x, iStartPoint + iFontHeight * n6, 0x10 | 4);
    }

    private void drawOHLC(Graphics g) {
        int iNoOfLines = 6;
        int iImageWidth = this.f.stringWidth("VOL : 00000000") + 10;
        int iStartPoint = JPlatformCanvas.TITLE_BAR_HEIGHT + 1;
        if (this.bIndicatorFlag && this.m_objIndicator.getIndicatorType() != 1) {
            iImageWidth = this.f.stringWidth("ST[9.9,99] : 000000") + 10;
            ++iNoOfLines;
        }
        if (this.bStudiesFlag && this.m_objStudies.getStudiesType() == 0) {
            iImageWidth = this.f.stringWidth("MACD[99,99,99] : 000000") + 10;
            iNoOfLines += 2;
        } else if (this.bStudiesFlag && this.m_objStudies.getStudiesType() != 10) {
            iImageWidth = this.f.stringWidth("EO[99,99] : 000000") + 10;
            ++iNoOfLines;
        }
        int iFontHeight = this.f.getHeight();
        int l_nSegmentId = Integer.parseInt(this.m_strSegmentId);
        int l_nDivisionFactor = ((Tick)this.m_objData.elementAt((int)this.iIndex)).m_nDivisionFactor;
        String l_strOpen = Utilities.ConvertToDecimal(((Tick)this.m_objData.elementAt((int)this.iIndex)).m_nOpen, l_nDivisionFactor, l_nSegmentId);
        String l_strHigh = Utilities.ConvertToDecimal(((Tick)this.m_objData.elementAt((int)this.iIndex)).m_nHigh, l_nDivisionFactor, l_nSegmentId);
        String l_strLow = Utilities.ConvertToDecimal(((Tick)this.m_objData.elementAt((int)this.iIndex)).m_nLow, l_nDivisionFactor, l_nSegmentId);
        String l_strLTP = Utilities.ConvertToDecimal(((Tick)this.m_objData.elementAt((int)this.iIndex)).m_nLTP, l_nDivisionFactor, l_nSegmentId);
        int nVolume = ((Tick)this.m_objData.elementAt((int)this.iIndex)).m_nVolume;
        String strDate = ((Tick)this.m_objData.elementAt((int)this.iIndex)).m_strDate;
        Image img = this.getTransparentBackground(iImageWidth, iFontHeight * iNoOfLines, 0, 160);
        g.drawImage(img, this.SCREEN_WIDTH >> 1, iStartPoint, 0x10 | 1);
        g.setFont(this.f);
        g.setColor(0xFFFFFF);
        int x = (this.SCREEN_WIDTH - iImageWidth >> 1) + 5;
        int xIncrementCounter = 0;
        int n = xIncrementCounter++;
        g.drawString(strDate, this.SCREEN_WIDTH >> 1, iStartPoint + iFontHeight * n, 0x10 | 1);
        int n2 = xIncrementCounter++;
        g.drawString("O  : " + l_strOpen, x, iStartPoint + iFontHeight * n2, 0x10 | 4);
        int n3 = xIncrementCounter++;
        g.drawString("H  : " + l_strHigh, x, iStartPoint + iFontHeight * n3, 0x10 | 4);
        int n4 = xIncrementCounter++;
        g.drawString("L  : " + l_strLow, x, iStartPoint + iFontHeight * n4, 0x10 | 4);
        int n5 = xIncrementCounter++;
        g.drawString("C  : " + l_strLTP, x, iStartPoint + iFontHeight * n5, 0x10 | 4);
        if (nVolume <= 0) {
            int n6 = xIncrementCounter++;
            g.drawString("V  : ", x, iStartPoint + iFontHeight * n6, 0x10 | 4);
        } else {
            int n7 = xIncrementCounter++;
            g.drawString("V  : " + nVolume, x, iStartPoint + iFontHeight * n7, 0x10 | 4);
        }
        if (this.bIndicatorFlag && this.m_objIndicator.getIndicatorType() != 1) {
            if (this.m_objIndicator.getIndicatorType() == 0) {
                int n8 = xIncrementCounter++;
                g.drawString("MA[" + this.m_objIndicator.getPeriod() + "] : " + this.m_objIndicator.getAverageLTP(this.iIndex + this.m_nStartIndex, l_nDivisionFactor), x, iStartPoint + iFontHeight * n8, 0x10 | 4);
            }
            if (this.m_objIndicator.getIndicatorType() == 2) {
                int n9 = xIncrementCounter++;
                g.drawString("ST[" + this.m_objIndicator.getMultiplier() + "," + this.m_objIndicator.getPeriod() + "] : " + this.m_objIndicator.getAverageLTP(this.iIndex + this.m_nStartIndex, l_nDivisionFactor), x, iStartPoint + iFontHeight * n9, 0x10 | 4);
            }
        }
        if (this.bStudiesFlag) {
            if (this.m_objStudies.getStudiesType() == 0) {
                int n10 = xIncrementCounter++;
                g.drawString("MACD[" + this.m_objStudies.getShortPeriod() + "," + this.m_objStudies.getLongPeriod() + "," + this.m_objStudies.getPeriod() + "]: " + this.m_objStudies.getStudyValue(this.iIndex + this.m_nStartIndex, l_nDivisionFactor), x, iStartPoint + iFontHeight * n10, 0x10 | 4);
                int n11 = xIncrementCounter++;
                g.drawString("Sig,His : " + this.m_objStudies.getSignalValue(this.iIndex + this.m_nStartIndex, l_nDivisionFactor) + ", " + this.m_objStudies.getHistogramValue(this.iIndex + this.m_nStartIndex, l_nDivisionFactor), x, iStartPoint + iFontHeight * n11, 0x10 | 4);
            } else if (this.m_objStudies.getStudiesType() == 1) {
                int n12 = xIncrementCounter++;
                g.drawString("EO[" + this.m_objStudies.getShortPeriod() + "," + this.m_objStudies.getLongPeriod() + "]: " + this.m_objStudies.getStudyValue(this.iIndex + this.m_nStartIndex, l_nDivisionFactor), x, iStartPoint + iFontHeight * n12, 0x10 | 4);
            } else if (this.m_objStudies.getStudiesType() == 4) {
                int n13 = xIncrementCounter++;
                g.drawString("StdD[" + this.m_objStudies.getPeriod() + "]: " + this.m_objStudies.getStudyValue(this.iIndex + this.m_nStartIndex, l_nDivisionFactor), x, iStartPoint + iFontHeight * n13, 0x10 | 4);
            } else if (this.m_objStudies.getStudiesType() == 2) {
                int n14 = xIncrementCounter++;
                g.drawString("AbsD[" + this.m_objStudies.getPeriod() + "]: " + this.m_objStudies.getStudyValue(this.iIndex + this.m_nStartIndex, l_nDivisionFactor), x, iStartPoint + iFontHeight * n14, 0x10 | 4);
            } else if (this.m_objStudies.getStudiesType() == 3) {
                int n15 = xIncrementCounter++;
                g.drawString("RSI[" + this.m_objStudies.getPeriod() + "]: " + this.m_objStudies.getStudyValue(this.iIndex + this.m_nStartIndex, l_nDivisionFactor), x, iStartPoint + iFontHeight * n15, 0x10 | 4);
            }
        }
    }

    private Image getTransparentBackground(int f_width, int f_height, int f_nRGB, int f_nTransparency) {
        int width = f_width;
        int height = f_height;
        Image im = Image.createImage((int)width, (int)height);
        int[] irgbData = new int[width * height];
        im.getRGB(irgbData, 0, width, 0, 0, width, height);
        int l_nTransparency = f_nTransparency << 24;
        int l_nRBG = f_nRGB;
        for (int i = 0; i < irgbData.length; ++i) {
            irgbData[i] = l_nTransparency + l_nRBG;
        }
        im = Image.createRGBImage((int[])irgbData, (int)width, (int)height, (boolean)true);
        return im;
    }

    private void drawActionKeys(Graphics g) {
        block17: {
            int i;
            int DropHeight;
            block18: {
                Font tempFont = Font.getFont((int)0, (int)0, (int)8);
                if (this.m_objOriginalData != null && this.m_objOriginalData.size() > 0) {
                    String strStartDate = ((Tick)this.m_objOriginalData.elementAt((int)0)).m_strDate;
                    int spaceindex = strStartDate.indexOf(" ");
                    if (spaceindex > 0) {
                        strStartDate = strStartDate.substring(0, spaceindex);
                    }
                    String strEndDate = ((Tick)this.m_objOriginalData.elementAt((int)(this.m_objOriginalData.size() - 1))).m_strDate;
                    spaceindex = strEndDate.indexOf(" ");
                    if (spaceindex > 0) {
                        strEndDate = strEndDate.substring(0, spaceindex);
                    }
                    g.setColor(0);
                    g.setFont(tempFont);
                    g.drawString(strStartDate + " - " + strEndDate, this.m_objMainChart.m_nWidth / 2, this.CHART_START_YCordinate - 2, 0x10 | 1);
                }
                for (int i2 = 0; i2 < this.m_nButtonsLen; ++i2) {
                    if (i2 == this.m_nButtonsLen - 1) {
                        g.setColor(255, 255, 255);
                    } else {
                        g.setColor(128, 128, 128);
                    }
                    g.fillRect(i2 * CHART_ACTION_KEYS * 2 + i2 * 2 + 1, this.SCREEN_HEIGHT + this.CHART_START_YCordinate - CHART_ACTION_KEYS, CHART_ACTION_KEYS * 2 - 1, CHART_ACTION_KEYS - 1);
                    if (i2 == this.m_nButtonIndex) {
                        g.setColor(15971078);
                    } else {
                        g.setColor(0, 0, 0);
                    }
                    g.drawRect(i2 * CHART_ACTION_KEYS * 2 + i2 * 2, this.SCREEN_HEIGHT + this.CHART_START_YCordinate - CHART_ACTION_KEYS - 1, CHART_ACTION_KEYS * 2, CHART_ACTION_KEYS);
                    g.setColor(0, 0, 0);
                    if (i2 == this.m_nButtonsLen - 1) {
                        if (this.canvas.hasPointerEvents()) {
                            g.drawString(this.strChartType[this.selectedIndex], i2 * CHART_ACTION_KEYS * 2 + i2 * 2 + CHART_ACTION_KEYS, this.SCREEN_HEIGHT + this.CHART_START_YCordinate - CHART_ACTION_KEYS, 0x10 | 1);
                            continue;
                        }
                        g.drawString(this.strChartType[Integer.parseInt(strchartTime)], i2 * CHART_ACTION_KEYS * 2 + i2 * 2 + CHART_ACTION_KEYS, this.SCREEN_HEIGHT + this.CHART_START_YCordinate - CHART_ACTION_KEYS, 0x10 | 1);
                        continue;
                    }
                    g.drawString(this.strButtons[i2], i2 * CHART_ACTION_KEYS * 2 + i2 * 2 + CHART_ACTION_KEYS, this.SCREEN_HEIGHT + this.CHART_START_YCordinate - CHART_ACTION_KEYS, 0x10 | 1);
                }
                if (!this.bDropDownFlag) break block17;
                if (!this.canvas.hasPointerEvents()) break block18;
                DropHeight = 3 * CHART_ACTION_KEYS;
                g.setColor(255, 255, 255);
                g.fillRect(5 * CHART_ACTION_KEYS * 2 + 10, this.SCREEN_HEIGHT + this.CHART_START_YCordinate - CHART_ACTION_KEYS - 1 - DropHeight, CHART_ACTION_KEYS * 2, DropHeight);
                g.setColor(0, 0, 0);
                g.drawRect(5 * CHART_ACTION_KEYS * 2 + 10, this.SCREEN_HEIGHT + this.CHART_START_YCordinate - CHART_ACTION_KEYS - 1 - DropHeight, CHART_ACTION_KEYS * 2, DropHeight);
                this.currentEnd = this.currentStart + 3;
                i = this.currentStart;
                int j = 0;
                while (i < this.currentEnd) {
                    if (i == this.selectedIndex) {
                        g.setColor(0xCCCC99);
                        g.fillRect(5 * CHART_ACTION_KEYS * 2 + 10 + 1, this.SCREEN_HEIGHT + this.CHART_START_YCordinate - CHART_ACTION_KEYS * (j + 2), CHART_ACTION_KEYS * 2 - 1, CHART_ACTION_KEYS - 1);
                    }
                    g.setColor(0, 0, 0);
                    g.drawString(this.strChartType[i], 5 * CHART_ACTION_KEYS * 2 + 10 + CHART_ACTION_KEYS, this.SCREEN_HEIGHT + this.CHART_START_YCordinate - CHART_ACTION_KEYS * (j + 2), 0x10 | 1);
                    ++i;
                    ++j;
                }
                break block17;
            }
            DropHeight = 3 * CHART_ACTION_KEYS;
            g.setColor(255, 255, 255);
            g.fillRect(5 * CHART_ACTION_KEYS * 2 + 10, this.SCREEN_HEIGHT + this.CHART_START_YCordinate - CHART_ACTION_KEYS - 1 - DropHeight, CHART_ACTION_KEYS * 2, DropHeight);
            g.setColor(0, 0, 0);
            g.drawRect(5 * CHART_ACTION_KEYS * 2 + 10, this.SCREEN_HEIGHT + this.CHART_START_YCordinate - CHART_ACTION_KEYS - 1 - DropHeight, CHART_ACTION_KEYS * 2, DropHeight);
            if (this.m_nChartTimeIndex <= 2) {
                for (i = 0; i < 3; ++i) {
                    if (i == this.m_nChartTimeIndex) {
                        g.setColor(0xCCCC99);
                        g.fillRect(5 * CHART_ACTION_KEYS * 2 + 10 + 1, this.SCREEN_HEIGHT + this.CHART_START_YCordinate - CHART_ACTION_KEYS * (i + 2), CHART_ACTION_KEYS * 2 - 1, CHART_ACTION_KEYS - 1);
                    }
                    g.setColor(0, 0, 0);
                    g.drawString(this.strChartType[i], 5 * CHART_ACTION_KEYS * 2 + 10 + CHART_ACTION_KEYS, this.SCREEN_HEIGHT + this.CHART_START_YCordinate - CHART_ACTION_KEYS * (i + 2), 0x10 | 1);
                }
            }
            if (this.m_nChartTimeIndex <= 2) break block17;
            i = this.m_nChartTimeIndex - 2;
            int j = 0;
            while (i < this.m_nChartTimeIndex + 1) {
                if (i == this.m_nChartTimeIndex) {
                    g.setColor(0xCCCC99);
                    g.fillRect(5 * CHART_ACTION_KEYS * 2 + 10 + 1, this.SCREEN_HEIGHT + this.CHART_START_YCordinate - CHART_ACTION_KEYS * (j + 2), CHART_ACTION_KEYS * 2 - 1, CHART_ACTION_KEYS - 1);
                }
                g.setColor(0, 0, 0);
                g.drawString(this.strChartType[i], 5 * CHART_ACTION_KEYS * 2 + 10 + CHART_ACTION_KEYS, this.SCREEN_HEIGHT + this.CHART_START_YCordinate - CHART_ACTION_KEYS * (j + 2), 0x10 | 1);
                ++i;
                ++j;
            }
        }
    }

    public void keyPressed(int ipKeyCode) {
        block14: {
            block13: {
                if (!this.bDropDownFlag) break block13;
                switch (ipKeyCode) {
                    case 53: 
                    case 205: 
                    case 225: {
                        if (this.m_nChartTimeIndex < 0) {
                            this.m_nChartTimeIndex = this.m_nChartTime;
                            this.bDropDownFlag = !this.bDropDownFlag;
                            break;
                        }
                        this.bDropDownFlag = !this.bDropDownFlag;
                        this.ChartRequest(this.m_nChartTimeIndex);
                        break;
                    }
                    case 50: 
                    case 202: 
                    case 221: {
                        if (this.m_nChartTimeIndex < this.strChartType.length - 1) {
                            ++this.m_nChartTimeIndex;
                            break;
                        }
                        break block14;
                    }
                    case 52: 
                    case 204: 
                    case 222: {
                        if (this.m_nChartTimeIndex >= 0) {
                            --this.m_nChartTimeIndex;
                            break;
                        }
                        break block14;
                    }
                    default: {
                        this.canvas.processSoftKeys(ipKeyCode);
                        break;
                    }
                }
                break block14;
            }
            switch (ipKeyCode) {
                case 53: 
                case 205: 
                case 225: {
                    this.indexAction(this.m_nButtonIndex);
                    break;
                }
                case 52: 
                case 204: 
                case 223: {
                    if (this.m_nButtonIndex <= 0) break;
                    --this.m_nButtonIndex;
                    break;
                }
                case 54: 
                case 206: 
                case 224: {
                    if (this.m_nButtonIndex >= this.m_nButtonsLen - 1) break;
                    ++this.m_nButtonIndex;
                    break;
                }
                default: {
                    this.canvas.processSoftKeys(ipKeyCode);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void pointerPressed(String f_strSection, int iX, int iY) {
        block14: {
            block12: {
                block16: {
                    block15: {
                        block13: {
                            if (!this.bDropDownFlag) break block12;
                            if (!f_strSection.equals("Action Keys")) break block13;
                            iButtonWidth = (ChartCanvas.CHART_ACTION_KEYS + 1) * 2;
                            if (iX / iButtonWidth >= 5) {
                                this.m_nButtonIndex = 5;
                                this.m_nChartTimeIndex = this.m_nChartTime;
                                if (iX >= 5 * ChartCanvas.CHART_ACTION_KEYS * 2 + 10 + 1 && iX <= 5 * ChartCanvas.CHART_ACTION_KEYS * 2 + 10 + 1 + (ChartCanvas.CHART_ACTION_KEYS * 2 - 1)) {
                                    if (iY >= this.SCREEN_HEIGHT - ChartCanvas.CHART_ACTION_KEYS + JPlatformCanvas.TITLE_BAR_HEIGHT) {
                                        if (iY <= this.SCREEN_HEIGHT - ChartCanvas.CHART_ACTION_KEYS + JPlatformCanvas.TITLE_BAR_HEIGHT + ChartCanvas.CHART_ACTION_KEYS) {
                                            this.ChartRequest(this.selectedIndex);
                                        }
                                    }
                                }
                                this.bDropDownFlag = this.bDropDownFlag == false;
                            }
                            break block14;
                        }
                        if (!f_strSection.equals("Main Chart") || iY >= this.SCREEN_HEIGHT + this.CHART_START_YCordinate - ChartCanvas.CHART_ACTION_KEYS * (this.m_nChartTypeLen + 1) - 1 && (iX >= (ChartCanvas.CHART_ACTION_KEYS + 1) * 2 * (this.m_nButtonsLen - 1) || iY < this.SCREEN_HEIGHT + this.CHART_START_YCordinate - ChartCanvas.CHART_ACTION_KEYS * (this.m_nChartTypeLen + 1) - 1 || iY >= this.SCREEN_HEIGHT + this.CHART_START_YCordinate - 1) && (iX <= (ChartCanvas.CHART_ACTION_KEYS + 1) * 2 * this.m_nButtonsLen || iY < this.SCREEN_HEIGHT + this.CHART_START_YCordinate - ChartCanvas.CHART_ACTION_KEYS * (this.m_nChartTypeLen + 1) - 1 || iY >= this.SCREEN_HEIGHT + this.CHART_START_YCordinate - 1)) break block15;
                        this.iIndex = iX / this.m_nPx;
                        break block14;
                    }
                    this.m_nChartTimeIndex = (this.SCREEN_HEIGHT + this.CHART_START_YCordinate + JPlatformCanvas.TITLE_BAR_HEIGHT - iY - 1) / ChartCanvas.CHART_ACTION_KEYS;
                    this.m_nChartTimeIndex -= 2;
                    DropHeight = 3 * ChartCanvas.CHART_ACTION_KEYS;
                    if (iX < (ChartCanvas.CHART_ACTION_KEYS + 1) * 2 * (this.m_nButtonsLen - 1) || iX > (ChartCanvas.CHART_ACTION_KEYS + 1) * 2 * this.m_nButtonsLen) break block16;
                    if (iY < this.SCREEN_HEIGHT + JPlatformCanvas.TITLE_BAR_HEIGHT - ChartCanvas.CHART_ACTION_KEYS - DropHeight / 2) ** GOTO lbl-1000
                    if (iY <= this.SCREEN_HEIGHT + JPlatformCanvas.TITLE_BAR_HEIGHT - ChartCanvas.CHART_ACTION_KEYS) {
                        this.scrolDncharttime();
                    } else if (iY >= this.SCREEN_HEIGHT + JPlatformCanvas.TITLE_BAR_HEIGHT - ChartCanvas.CHART_ACTION_KEYS * 4) {
                        if (iY <= this.SCREEN_HEIGHT + JPlatformCanvas.TITLE_BAR_HEIGHT - ChartCanvas.CHART_ACTION_KEYS - DropHeight / 2) {
                            this.scrolUpcharttime();
                        }
                    }
                }
                this.bDropDownFlag = true;
                this.m_nChartTimeIndex = this.m_nChartTime;
                break block14;
            }
            if (f_strSection.equals("Main Chart")) {
                this.iIndex = iX / this.m_nPx;
            } else if (f_strSection.equals("Action Keys")) {
                iButtonWidth = (ChartCanvas.CHART_ACTION_KEYS + 1) * 2;
                this.m_nButtonIndex = iX / iButtonWidth;
                this.indexAction(this.m_nButtonIndex);
            }
        }
        if (this.iIndex > this.m_objData.size() - 1) {
            this.iIndex = this.m_objData.size() - 1;
        }
    }

    public void scrolDncharttime() {
        if (this.count > 0) {
            this.selectedIndex = ((this.selectedIndex - 1) % this.count + this.count) % this.count;
            this.adjustchartListItems();
        }
    }

    public void scrolUpcharttime() {
        if (this.count > 0) {
            this.selectedIndex = (this.selectedIndex + 1) % this.count;
            this.adjustchartListItems();
        }
    }

    private void adjustchartListItems() {
        if (this.selectedIndex < this.currentStart) {
            this.currentStart = this.selectedIndex;
            this.currentEnd = this.currentStart + 3 - 1;
        } else if (this.selectedIndex >= this.currentEnd) {
            this.currentEnd = this.selectedIndex;
            this.currentStart = this.currentEnd - 3 + 1;
        } else if (this.currentEnd - this.currentStart < 2) {
            --this.currentStart;
        }
        if (this.currentEnd >= this.count) {
            this.currentEnd = this.count - 1;
        }
        if (this.currentStart < 0) {
            this.currentStart = 0;
        }
    }

    private void indexAction(int f_nButtonIndex) {
        switch (f_nButtonIndex) {
            case 0: {
                this.shiftScrollerLeft();
                break;
            }
            case 1: {
                this.shiftScrollerRight();
                break;
            }
            case 2: {
                this.zoomIn();
                break;
            }
            case 3: {
                this.zoomOut();
                break;
            }
            case 4: {
                this.reset();
                break;
            }
            case 5: {
                this.bDropDownFlag = !this.bDropDownFlag;
            }
        }
    }

    public void pointerReleased(int iX, int iY) {
    }

    public void pointerDragged(int iX, int iY) {
    }

    private void zoomIn() {
        if (this.m_nPx >= this.m_nMaxWidthOfEachScrip) {
            return;
        }
        ++this.m_nPx;
        this.setDisplayVector();
        this.refresh();
    }

    private void zoomOut() {
        if (this.m_nPx <= this.m_nMinWidthOfEachScrip) {
            this.m_nPx = this.m_nMinWidthOfEachScrip;
            return;
        }
        --this.m_nPx;
        this.setDisplayVector();
        this.refresh();
    }

    private void reset() {
        if (this.m_nPx == this.m_nMinWidthOfEachScrip) {
            return;
        }
        this.m_nPx = this.m_nMinWidthOfEachScrip;
        this.setDisplayVector();
        this.refresh();
    }

    private void shiftScrollerRight() {
        if (this.moveForward()) {
            ++this.m_nStartIndex;
            ++this.m_nEndIndex;
            this.m_objData.removeElementAt(0);
            this.m_objData.insertElementAt(this.m_objOriginalData.elementAt(this.m_nEndIndex), this.m_objData.size());
            this.refresh();
        }
    }

    private boolean moveForward() {
        if (this.iIndex < this.m_objData.size() - 1) {
            ++this.iIndex;
            return false;
        }
        if (this.m_nEndIndex < this.m_objOriginalData.size() - 1) {
            this.iIndex = this.m_objData.size() - 1;
            return true;
        }
        return false;
    }

    private void shiftScrollerLeft() {
        if (this.moveBackward()) {
            --this.m_nStartIndex;
            --this.m_nEndIndex;
            this.m_objData.removeElementAt(this.m_objData.size() - 1);
            this.m_objData.insertElementAt(this.m_objOriginalData.elementAt(this.m_nStartIndex), 0);
            this.refresh();
        }
    }

    private boolean moveBackward() {
        if (this.iIndex > 0) {
            --this.iIndex;
            return false;
        }
        if (this.m_nStartIndex > 0) {
            this.iIndex = 0;
            return true;
        }
        return false;
    }

    private void showStudies(int f_nMainChartType, int f_nStudiesYAxis) {
        int l_nChartWidth = this.SCREEN_WIDTH - 32 - 5;
        if (this.bStudiesFlag) {
            this.m_objMainChart.setInitialValues(f_nMainChartType, 1, this.CHART_START_XCordinate, this.CHART_START_YCordinate, l_nChartWidth, this.SCREEN_HEIGHT * 2 / 3 - 15 - CHART_ACTION_KEYS, 4, 4);
            this.m_objIndicator.setInitialValues(this.CHART_START_XCordinate, this.CHART_START_YCordinate, l_nChartWidth, this.SCREEN_HEIGHT * 2 / 3 - 15 - CHART_ACTION_KEYS);
            this.m_objStudies.setInitialValues(f_nStudiesYAxis, this.CHART_START_XCordinate, this.CHART_START_YCordinate + this.m_objMainChart.m_nHeight + 15, l_nChartWidth, this.SCREEN_HEIGHT / 3 - CHART_ACTION_KEYS, 4, 3);
        } else {
            this.m_objMainChart.setInitialValues(f_nMainChartType, 1, this.CHART_START_XCordinate, this.CHART_START_YCordinate, l_nChartWidth, this.SCREEN_HEIGHT - 15 - CHART_ACTION_KEYS, 4, 4);
            this.m_objIndicator.setInitialValues(this.CHART_START_XCordinate, this.CHART_START_YCordinate, l_nChartWidth, this.SCREEN_HEIGHT - 15 - CHART_ACTION_KEYS);
        }
    }

    private void refresh() {
        this.m_objMainChart.setIntradayFlag(true);
        this.m_objMainChart.getDataToPlot(this.m_objData, true, this.m_nPx);
        if (this.bStudiesFlag) {
            if (this.m_objStudies.getStudiesType() == 0) {
                this.m_objStudies.getDataToPlotMACD(this.m_objData, this.m_nStartIndex, this.m_nEndIndex, this.m_nPx);
            } else {
                this.m_objStudies.getDataToPlot(this.m_objData, this.m_nStartIndex, this.m_nEndIndex, this.m_nPx);
            }
        }
        if (this.bIndicatorFlag) {
            this.m_objIndicator.getDataToPlot(this.m_objMainChart.m_nMax, this.m_objMainChart.m_nMin, this.m_nStartIndex, this.m_nEndIndex, this.m_nPx);
        }
    }

    public boolean jcommandAction(SoftKey softKey, Displayable d) {
        if (softKey.getLabel().equals("Select")) {
            String strCommand = this.canvas.getCommandName();
            if (strCommand.equals("Volume Chart")) {
                this.bStudiesFlag = !this.bStudiesFlag;
                this.m_objStudies.setStudiesType(10);
                this.showStudies(this.m_objMainChart.m_nTypeOfChart, 2);
                this.m_objStudies.prepareStudiesData(this.m_objOriginalData);
                this.refresh();
            } else if (strCommand.equals("OHLC")) {
                this.bOHLCFlag = !this.bOHLCFlag;
            } else if (strCommand.equals("Studies")) {
                iWinRefresh.getInstance().showform.showSelectionWindow(strCommand);
            } else if (strCommand.equals("Indicators")) {
                iWinRefresh.getInstance().showform.showSelectionWindow(strCommand);
            } else if (strCommand.equals("Candle Stick")) {
                if (this.m_objMainChart.m_nTypeOfChart == 4) {
                    return true;
                }
                this.m_objMainChart.m_nTypeOfChart = 4;
            } else if (strCommand.equals("Bar Chart")) {
                if (this.m_objMainChart.m_nTypeOfChart == 3) {
                    return true;
                }
                this.m_objMainChart.m_nTypeOfChart = 3;
            } else if (strCommand.equals("Mountain Chart")) {
                if (this.m_objMainChart.m_nTypeOfChart == 5) {
                    return true;
                }
                this.m_objMainChart.m_nTypeOfChart = 5;
            }
            this.canvas.refreshDisplay();
        } else if (softKey.getLabel().equals("Back")) {
            AppConstants.FirstTime = false;
            AppConstants.IsRedraw = false;
            this.bIsReDraw = false;
            this.clearOriginalVector();
            iWinRefresh.getInstance().backForm(5);
        }
        return true;
    }

    private void ChartRequest(int f_nChartTime) {
        if (this.m_nChartTime == f_nChartTime) {
            return;
        }
        iWinRefresh.getInstance().showProgressBar();
        AppConstants.iCurrentPage = (byte)34;
        switch (f_nChartTime) {
            case 4: {
                f_nChartTime = 30;
                break;
            }
            case 5: {
                f_nChartTime = 12;
                break;
            }
            case 6: {
                f_nChartTime = 48;
                break;
            }
            case 7: {
                f_nChartTime = 9;
                break;
            }
            case 8: {
                f_nChartTime = 4;
                break;
            }
            case 9: {
                f_nChartTime = 5;
                break;
            }
            case 10: {
                f_nChartTime = 6;
                break;
            }
            case 11: {
                f_nChartTime = 7;
            }
        }
        AppConstants.sendrequest.sendInteractiveChartRequest(this.m_strSegmentId, this.m_strInstrumentID, this.m_strKey, f_nChartTime);
    }

    private void clearOriginalVector() {
        if (this.m_objOriginalData != null) {
            this.m_objOriginalData.removeAllElements();
            this.m_objOriginalData = null;
        }
        this.m_objOriginalData = new Vector();
    }

    private void clearDisplayVector() {
        if (this.m_objData != null) {
            this.m_objData.removeAllElements();
            this.m_objData = null;
        }
        this.m_objData = new Vector();
    }

    private Vector getHistory(String f_strData) {
        int iDivisionFactor = 0;
        Vector<Tick> l_objQuoteVector = new Vector<Tick>();
        String[] l_objLineTokens = Utilities.split(f_strData, "#");
        int l_nNoOfRecords = l_objLineTokens.length;
        for (int i = 0; i < l_nNoOfRecords; ++i) {
            try {
                String m_strDataLine = l_objLineTokens[i];
                if (m_strDataLine.startsWith("~") || m_strDataLine.indexOf("~") == -1) continue;
                String[] stringtokenizer = Utilities.split(m_strDataLine, "~");
                String strLTP = stringtokenizer[1].trim();
                int iDotIndex = strLTP.indexOf(".");
                if (iDotIndex > 0 && iDivisionFactor == 0) {
                    String strDecimalString = strLTP.substring(iDotIndex + 1);
                    iDivisionFactor = strDecimalString.length();
                }
                int l_nTime = Integer.parseInt(stringtokenizer[0].trim());
                int l_nLTP = Utilities.convertToWholeNumber(stringtokenizer[1].trim(), iDivisionFactor);
                int l_nOpen = Utilities.convertToWholeNumber(stringtokenizer[2].trim(), iDivisionFactor);
                int l_nHigh = Utilities.convertToWholeNumber(stringtokenizer[3].trim(), iDivisionFactor);
                int l_nLow = Utilities.convertToWholeNumber(stringtokenizer[4].trim(), iDivisionFactor);
                int l_nPreviousClose = Utilities.convertToWholeNumber(stringtokenizer[5].trim(), iDivisionFactor);
                int l_nVolume = Integer.parseInt(stringtokenizer[6].trim());
                String l_strDate = stringtokenizer[7].trim();
                if (l_nOpen == 0 || l_nHigh == 0 || l_nLow == 0) continue;
                Tick l_objTick = new Tick(l_nTime, l_nLTP, l_nOpen, l_nHigh, l_nLow, l_nPreviousClose, l_nVolume, l_nVolume, l_strDate, iDivisionFactor);
                l_objQuoteVector.addElement(l_objTick);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return l_objQuoteVector;
    }

    public int getIndicatorPeriod() {
        int l_nPeriod = this.m_objIndicator.getPeriod();
        return l_nPeriod;
    }

    public int getStudiesShortPeriod() {
        int l_nShortPeriod = this.m_objStudies.getShortPeriod();
        return l_nShortPeriod;
    }

    public int getStudiesLongPeriod() {
        int l_nLongPeriod = this.m_objStudies.getLongPeriod();
        return l_nLongPeriod;
    }

    public int getStudiesPeriod() {
        int l_nPeriod = this.m_objStudies.getPeriod();
        return l_nPeriod;
    }

    public boolean getIsRedraw() {
        return this.bIsReDraw;
    }

    public void setIndicatorValues(boolean f_bIndicatorFlag, int f_nPeriod, int f_nIndicatorType, int f_nFormulaIndex, String f_strMultiplier) {
        this.bIndicatorFlag = f_bIndicatorFlag;
        this.m_objIndicator.setIndicatorType(f_nIndicatorType);
        this.m_objIndicator.setPeriod(f_nPeriod);
        this.m_objIndicator.setFormulaIndex(f_nFormulaIndex);
        this.m_objIndicator.setMultiplier(f_strMultiplier);
        this.m_objIndicator.prepareIndicatorData(this.m_objOriginalData);
        this.refresh();
    }

    public void setStudiesValues(boolean bStudyFlag, int f_nMACDSignalPeriod, int f_nShortPeriod, int f_nLongPeriod, int f_nStudyType) {
        this.bStudiesFlag = bStudyFlag;
        this.m_objStudies.setStudiesType(f_nStudyType);
        this.m_objStudies.setShortPeriod(f_nShortPeriod);
        this.m_objStudies.setLongPeriod(f_nLongPeriod);
        this.m_objStudies.setPeriod(f_nMACDSignalPeriod);
        this.showStudies(this.m_objMainChart.m_nTypeOfChart, 1);
        this.m_objStudies.prepareStudiesData(this.m_objOriginalData);
        this.refresh();
    }
}

