/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.CXAxis;
import chart.CYAxis;
import chart.ChartGenerator;
import chart.DataToPlotted;
import chart.Tick;
import common.Utilities;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Plotter {
    private ChartGenerator m_objChartGenerator = new ChartGenerator();
    private CYAxis m_objYAxis = new CYAxis();
    private CXAxis m_objXAxis = new CXAxis();
    private Vector m_objIntraDayTicks;
    private int m_nPx = 0;
    private int m_nStartIndex = 0;
    private int m_nEndIndex = 0;
    private int m_nYAxisData;
    private int m_nXCordinate;
    private int m_nYcordinate;
    private int m_nUnitsForX;
    private int m_nUnitsForY;
    private String m_strStartDate;
    private String m_strEndDate;
    public int m_nTypeOfChart = 0;
    public int m_nMax = 0;
    public int m_nMin = 0;
    public int m_nHeight = 0;
    public int m_nWidth = 0;
    private boolean m_bIntraDayFlag = true;

    public void setInitialValues(int f_nTypeOfChart, int f_nYAxisData, int f_nXCordinate, int f_nYCordinate, int f_nWidth, int f_nHeight, int f_nNoOfUnitsForX, int f_nNoOfUnitsForY) {
        this.m_objYAxis.setInitialvalue(f_nXCordinate, f_nYCordinate, f_nWidth, f_nHeight);
        this.m_objXAxis.setInitialValue(f_nXCordinate, f_nYCordinate, f_nWidth, f_nHeight);
        this.m_nTypeOfChart = f_nTypeOfChart;
        this.m_nYAxisData = f_nYAxisData;
        this.m_nXCordinate = f_nXCordinate;
        this.m_nYcordinate = f_nYCordinate;
        this.m_nWidth = f_nWidth;
        this.m_nHeight = f_nHeight;
        this.m_nUnitsForX = f_nNoOfUnitsForX;
        this.m_nUnitsForY = f_nNoOfUnitsForY;
    }

    public synchronized void setIntradayFlag(boolean f_bIntraDayFlag) {
        this.m_bIntraDayFlag = f_bIntraDayFlag;
    }

    public void TypeOfChart(int f_nTypeOfChart) {
        this.m_nTypeOfChart = f_nTypeOfChart;
    }

    public synchronized void getDataToPlot(Vector f_objData, boolean f_bUpdate, int f_nPx) {
        try {
            this.ClearPlotter();
            if (f_objData.size() <= 0) {
                return;
            }
            this.m_nPx = f_nPx;
            this.m_nStartIndex = 0;
            this.m_nEndIndex = f_objData.size();
            this.m_nMax = 0;
            this.m_nMin = 0;
            int m_nXPoint = 0;
            int m_nYPoint = 0;
            int l_nDivisionFactor = ((Tick)f_objData.elementAt((int)this.m_nStartIndex)).m_nDivisionFactor;
            int l_nDivisionValue = Utilities.convertToWholeNumber(Integer.toString(1), l_nDivisionFactor);
            switch (this.m_nTypeOfChart) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    if (this.m_nYAxisData == 2) {
                        this.m_nMax = ((Tick)f_objData.elementAt((int)this.m_nStartIndex)).m_nVolume;
                        this.m_nMin = ((Tick)f_objData.elementAt((int)this.m_nStartIndex)).m_nVolume;
                        for (int i = this.m_nStartIndex + 1; i < this.m_nEndIndex; ++i) {
                            int l_nHighVolume = ((Tick)f_objData.elementAt((int)i)).m_nVolume;
                            int l_nLowVolume = ((Tick)f_objData.elementAt((int)i)).m_nVolume;
                            if (l_nHighVolume > this.m_nMax) {
                                this.m_nMax = l_nHighVolume;
                            }
                            if (l_nLowVolume >= this.m_nMin) continue;
                            this.m_nMin = l_nLowVolume;
                        }
                        int l_nDiffential = (this.m_nMax - this.m_nMin) / 100;
                        this.m_nMax += l_nDiffential;
                        this.m_nMin -= l_nDiffential;
                        this.m_strStartDate = ((Tick)f_objData.elementAt((int)this.m_nStartIndex)).m_strDate;
                        this.m_strEndDate = ((Tick)f_objData.elementAt((int)(this.m_nEndIndex - 1))).m_strDate;
                        m_nXPoint = 0;
                        for (int i = this.m_nStartIndex; i < this.m_nEndIndex; ++i) {
                            float l_fLTPY = ((Tick)f_objData.elementAt((int)i)).m_nLTP - this.m_nMin;
                            m_nYPoint = (int)Math.abs((float)this.m_nHeight * l_fLTPY / (float)(this.m_nMax - this.m_nMin));
                            DataToPlotted l_objDataToPlotted = new DataToPlotted((Tick)f_objData.elementAt(i), m_nXPoint += this.m_nPx, m_nYPoint);
                            this.m_objIntraDayTicks.addElement(l_objDataToPlotted);
                        }
                    } else if (this.m_nYAxisData == 1) {
                        int i;
                        this.m_nMax = ((Tick)f_objData.elementAt((int)this.m_nStartIndex)).m_nHigh;
                        this.m_nMin = ((Tick)f_objData.elementAt((int)this.m_nStartIndex)).m_nLow;
                        for (i = this.m_nStartIndex + 1; i < this.m_nEndIndex; ++i) {
                            int l_nHigh = ((Tick)f_objData.elementAt((int)i)).m_nHigh;
                            int l_nLow = ((Tick)f_objData.elementAt((int)i)).m_nLow;
                            if (l_nHigh > this.m_nMax) {
                                this.m_nMax = l_nHigh;
                            }
                            if (l_nLow >= this.m_nMin) continue;
                            this.m_nMin = l_nLow;
                        }
                        this.m_nMax += 2 * l_nDivisionValue;
                        this.m_nMin -= 2 * l_nDivisionValue;
                        this.m_strStartDate = ((Tick)f_objData.elementAt((int)this.m_nStartIndex)).m_strDate;
                        this.m_strEndDate = ((Tick)f_objData.elementAt((int)(this.m_nEndIndex - 1))).m_strDate;
                        m_nXPoint = 0;
                        for (i = this.m_nStartIndex; i < this.m_nEndIndex; ++i) {
                            float l_fLTPY = ((Tick)f_objData.elementAt((int)i)).m_nLTP - this.m_nMin;
                            m_nYPoint = (int)Math.abs((float)this.m_nHeight * l_fLTPY / (float)(this.m_nMax - this.m_nMin));
                            DataToPlotted l_objDataToPlotted = new DataToPlotted((Tick)f_objData.elementAt(i), m_nXPoint += this.m_nPx, m_nYPoint);
                            this.m_objIntraDayTicks.addElement(l_objDataToPlotted);
                        }
                    }
                    this.m_objYAxis.AssignValues(this.m_nMin, this.m_nMax, this.m_nUnitsForY, l_nDivisionFactor);
                    this.m_objXAxis.AssignValues(this.m_strStartDate, this.m_strEndDate, this.m_nUnitsForX);
                }
            }
            this.m_nStartIndex = 0;
            this.m_nEndIndex = this.m_objIntraDayTicks.size();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void ClearPlotter() {
        if (this.m_objIntraDayTicks != null) {
            this.m_objIntraDayTicks.removeAllElements();
            this.m_objIntraDayTicks = null;
        }
        this.m_objIntraDayTicks = new Vector();
    }

    public void paintPlotter(Graphics g, int f_nIndex) {
        if (this.m_objIntraDayTicks == null || this.m_objIntraDayTicks.size() == 0) {
            g.setColor(0);
            g.drawString("Data not available", this.m_nWidth / 2, this.m_nYcordinate + this.m_nHeight / 2, 0x10 | 1);
            return;
        }
        this.m_objXAxis.paintXAxis(g);
        this.m_objYAxis.paintYAxis(g, this.m_nTypeOfChart);
        this.drawSelector(g, f_nIndex);
        switch (this.m_nTypeOfChart) {
            case 4: {
                this.m_objChartGenerator.CandleStickChartGenretor(g, this.m_objIntraDayTicks, this.m_nWidth + this.m_nXCordinate, this.m_nHeight + this.m_nYcordinate, this.m_nStartIndex, this.m_nEndIndex, this.m_nPx, this.m_nHeight, this.m_nMin, this.m_nMax);
                break;
            }
            case 3: {
                this.m_objChartGenerator.BarChartGenerator(g, this.m_objIntraDayTicks, this.m_nWidth + this.m_nXCordinate, this.m_nHeight + this.m_nYcordinate, this.m_nStartIndex, this.m_nEndIndex, this.m_nPx, this.m_nHeight, this.m_nMin, this.m_nMax);
                break;
            }
            case 5: {
                this.m_objChartGenerator.MountainChartGenerator(g, this.m_objIntraDayTicks, this.m_nWidth + this.m_nXCordinate, this.m_nHeight + this.m_nYcordinate, this.m_nStartIndex, this.m_nEndIndex);
            }
        }
    }

    private void drawSelector(Graphics g, int f_nIndex) {
        int xPoint = ((DataToPlotted)this.m_objIntraDayTicks.elementAt((int)f_nIndex)).m_nXPoint;
        int yPoint = ((DataToPlotted)this.m_objIntraDayTicks.elementAt((int)f_nIndex)).m_nYPoint;
        yPoint = this.m_nHeight - yPoint;
        g.setColor(0, 0, 0);
        g.drawLine(this.m_nXCordinate, yPoint + this.m_nYcordinate, this.m_nWidth + this.m_nXCordinate, yPoint + this.m_nYcordinate);
        g.drawLine(xPoint, this.m_nYcordinate + 1, xPoint, this.m_nHeight + this.m_nYcordinate);
    }
}

