/*
 * Decompiled with CFR 0.152.
 */
package common;

import GeneralUI.JList;
import GeneralUI.JPlatformCanvas;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.DynamicExchange;
import common.JCommandListener;
import common.Utilities;
import javax.microedition.lcdui.Displayable;
import market.iWinRefresh;

public class CommonList
extends JList
implements JCommandListener {
    private int iPage = 0;

    public CommonList(String strpFormName) {
        super(strpFormName);
    }

    public void setData(int ipPage) {
        this.iPage = ipPage;
    }

    public boolean jcommandAction(SoftKey c, Displayable d) {
        try {
            iWinRefresh iwinapp = iWinRefresh.getInstance();
            int iIndex = this.getSelectedIndex();
            String strFormName = this.getTitle();
            if (c.getLabel().equals("Select")) {
                if (strFormName.equals("Select Exchange")) {
                    String strExchangeName = this.getString(iIndex);
                    DynamicExchange temp = AppConstants.dynamicList.getExchange(strExchangeName, "0", "0", "0", "0");
                    int iSegment = temp.iSegmentId;
                    AppConstants.strSearchString = strExchangeName;
                    iWinRefresh.iPreviousForm = 20;
                    iwinapp.showProgressBar();
                    AppConstants.sendrequest.sendIndexRequest(iSegment);
                    return true;
                }
                if (strFormName.equals("Mutual Fund")) {
                    AppConstants.iListIndex = iIndex;
                    AppConstants.strRequestString = "/MutualFund.aspx";
                    iWinRefresh.iPreviousForm = 16;
                    if (iIndex == 0 || iIndex == 2) {
                        iwinapp.showform.showMutualFundDetails();
                    } else {
                        iwinapp.showProgressBar();
                        AppConstants.sendrequest.sendIPOMutualFundRequest(iIndex, 1, "", "");
                    }
                    return true;
                }
                if (strFormName.equals("IPO")) {
                    iWinRefresh.iPreviousForm = 17;
                    AppConstants.iListIndex = iIndex;
                    iwinapp.showProgressBar();
                    AppConstants.strRequestString = "/IPO.aspx";
                    AppConstants.sendrequest.sendIPOMutualFundRequest(iIndex, 1, "", "");
                    return true;
                }
                if (strFormName.equals("Profile")) {
                    if (JPlatformCanvas.getInstance().getCommandName().equals("MarketWatch")) {
                        if (this.size() == 0) {
                            return false;
                        }
                        AppConstants.SELECT_PROFILE_INDEX = (byte)AppConstants.profilelist.getIdFromName(this.getString(iIndex));
                        AppConstants.sendrequest.sendMarketWatchRequestRealtime();
                    } else if (JPlatformCanvas.getInstance().getCommandName().equals("New Profile")) {
                        if (this.size() >= 5) {
                            iWinRefresh.displayAlert("MVMG", "Max. Profile limit reached.", AppConstants.iAlertDisplayTime);
                            return false;
                        }
                        AppConstants.SELECT_PROFILE_INDEX = -1;
                        iWinRefresh.iFirstForm = 7;
                        iWinRefresh.iPreviousForm = 7;
                        iwinapp.showform.showAddProfile();
                    } else if (JPlatformCanvas.getInstance().getCommandName().equals("Modify Profile")) {
                        if (this.size() == 0) {
                            return false;
                        }
                        AppConstants.STR_PROFILE_NAME = this.getString(iIndex);
                        AppConstants.SELECT_PROFILE_INDEX = AppConstants.profilelist.getIdFromName(AppConstants.STR_PROFILE_NAME);
                        iWinRefresh.iFirstForm = 7;
                        iWinRefresh.iPreviousForm = 7;
                        iWinRefresh.getInstance().showform.showModifyProfile();
                    } else if (JPlatformCanvas.getInstance().getCommandName().equals("Remove Profile")) {
                        if (this.size() == 0) {
                            return false;
                        }
                        int f_nProfileId = AppConstants.profilelist.getIdFromName(this.getString(iIndex));
                        AppConstants.SELECT_PROFILE_INDEX = (byte)f_nProfileId;
                        if (AppConstants.DEFUALT_PROFILE_INDEX == f_nProfileId) {
                            iWinRefresh.displayAlert("MVMG", "Default Profile Cannot be removed", AppConstants.iAlertDisplayTime);
                        } else {
                            iWinRefresh.getInstance().showform.showCommonForm("Remove Profile", "", "", "", "", "", "");
                        }
                    } else if (JPlatformCanvas.getInstance().getCommandName().equals("Set Default")) {
                        if (this.size() == 0) {
                            return false;
                        }
                        int f_nProfileId = AppConstants.profilelist.getIdFromName(this.getString(iIndex));
                        iwinapp.showProgressBar();
                        AppConstants.sendrequest.sendDefaultProfileRequest(f_nProfileId, "MARKETWATCH");
                    } else {
                        iwinapp.showform.showMainMenu();
                    }
                    return true;
                }
                if (strFormName.equals("Market Info")) {
                    AppConstants.iListIndex = iIndex;
                    iWinRefresh.iPreviousForm = 20;
                    iWinRefresh.iFirstForm = 20;
                    AppConstants.strScrollCanvasHeading = this.getString(iIndex);
                    if (iIndex == this.size() - 1) {
                        iwinapp.showform.showWorldIndices();
                    } else if (iIndex == this.size() - 2) {
                        AppConstants.strSearchString = "NSE";
                        iwinapp.showProgressBar();
                        AppConstants.sendrequest.sendBSE30Request("/NIFTY50.aspx");
                    } else if (iIndex == this.size() - 3) {
                        AppConstants.strSearchString = "BSE";
                        iwinapp.showProgressBar();
                        AppConstants.sendrequest.sendBSE30Request("/BSE30.aspx");
                    } else if (iIndex == this.size() - 4) {
                        iwinapp.showform.showSelectExchangeList();
                    } else {
                        iwinapp.showform.showSelectInstrument(1);
                    }
                    return true;
                }
                if (strFormName.equals("World Indices")) {
                    AppConstants.strSearchString = this.getString(iIndex);
                    AppConstants.iMarketSegmentId = iIndex;
                    iWinRefresh.iPreviousForm = 31;
                    iWinRefresh.iFirstForm = 31;
                    iwinapp.showProgressBar();
                    AppConstants.sendrequest.sendWorldIndicesRequest(iIndex + 1, 1);
                } else {
                    if (strFormName.equals("Tools")) {
                        iWinRefresh.iPreviousForm = 28;
                        AppConstants.iListIndex = iIndex;
                        switch (iIndex) {
                            case 0: {
                                iwinapp.showform.showAlerts();
                                break;
                            }
                            case 1: {
                                if ((AppConstants.bMCXIndex || AppConstants.bNCDEXIndex) && (AppConstants.bCOMEX || AppConstants.bINTLSPOT) && AppConstants.bTPCONTRIBUTOR) {
                                    if (AppConstants.parityStore.getKeys().length == 0) {
                                        iwinapp.showProgressBar();
                                        AppConstants.sendrequest.sendParityCalcRequest();
                                        break;
                                    }
                                    iwinapp.showform.showParityCalc();
                                    break;
                                }
                                iWinRefresh.displayAlert("MVMG", "You dont have the privilege.", AppConstants.iAlertDisplayTime);
                                break;
                            }
                            case 2: {
                                iwinapp.showProgressBar();
                                AppConstants.IsAddOrRemove = "";
                                AppConstants.sendrequest.sendNewPortfolioRequest();
                                break;
                            }
                            case 3: {
                                iwinapp.showform.showSettings(0);
                            }
                        }
                        return true;
                    }
                    if (strFormName.equals("Alerts")) {
                        iWinRefresh.iPreviousForm = 19;
                        AppConstants.iListIndex = iIndex;
                        if (iIndex == 0) {
                            AppConstants.bCommonCanvasThread = true;
                            iwinapp.showform.showModifyAlerts();
                        } else if (iIndex == 1) {
                            AppConstants.bCommonCanvasThread = true;
                            iwinapp.showform.showAlertsHistory();
                        }
                        return true;
                    }
                }
            } else if (c.getLabel().equals("Back")) {
                if (strFormName.equals("Select Exchange")) {
                    iWinRefresh.getInstance().backForm(iWinRefresh.iPreviousForm);
                } else if (strFormName.equals("IPO") || strFormName.equals("Profile") || strFormName.equals("Tools") || strFormName.equals("Mutual Fund") || strFormName.equals("Market Info") || strFormName.equals("PMS")) {
                    iwinapp.showform.showMainMenu();
                } else if (strFormName.equals("Alerts")) {
                    iwinapp.showform.showTools();
                } else if (strFormName.equals("World Indices")) {
                    iwinapp.showform.showMarketInfoHeading();
                }
                return true;
            }
        }
        catch (Exception e) {
            Utilities.printLog("CommonList " + e.toString());
        }
        return false;
    }
}

