/*
 * Decompiled with CFR 0.152.
 */
package connection;

import common.AppConstants;
import common.Utilities;
import common.iWinDB;
import connection.CByteArray;
import connection.CServerConnector;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Date;
import market.iWinRefresh;
import structures.CInfofeedACEFAOTouchline;
import structures.CInfofeedDGCXFNOTouchline;
import structures.CInfofeedMCXSXDervTouchline;
import structures.CInfofeedMCXSXEQIndices;
import structures.CInfofeedMCXSXEQTouchline;
import structures.CMsgHeader;
import structures.InfoFeedBSEEQIndicesInfo;
import structures.InfoFeedBSEEQMultipleIndex;
import structures.InfoFeedBSEEQTouchline;
import structures.InfoFeedCOMEXNYMEXTouchline;
import structures.InfoFeedDSGBTouchline;
import structures.InfoFeedINTLSPOT_FOREXTouchline;
import structures.InfoFeedLMETouchline;
import structures.InfoFeedMCXIndex;
import structures.InfoFeedMCXTouchline;
import structures.InfoFeedNCDEXFAOSPOTTouchline;
import structures.InfoFeedNSEEQIndex;
import structures.InfoFeedNSEEQTouchline;
import structures.InfoFeedNSEFAOTouchline;
import structures.InfoFeedNSEWDMTouchline;
import structures.InfoFeedTPContributorsSPOTTouchline;
import structures.InfofeedNCXFAOTouchline;
import structures.LBSSBSLogonRequest;
import structures.LBSSBSLogonResponse;

public class CInfoFeedMain
implements Runnable {
    public CServerConnector m_objServerConnector = null;
    private final byte BESTFIVE_BUYSELL = (byte)5;
    private final byte TOUCHLINE_BUYSELL;
    private final byte LLF_INDICATOR = (byte)7;
    private Thread t = null;

    public CInfoFeedMain() {
        this.TOUCHLINE_BUYSELL = 1;
        this.m_objServerConnector = new CServerConnector();
    }

    public void init(final String strpLoginId, final String strpPassword, final String strpNewPassword) {
        new Thread(new Runnable(){

            public void run() {
                CInfoFeedMain.this.LogOnToServer("lbs.marketviewmobile.com", 7778, strpLoginId.toUpperCase(), strpPassword, strpNewPassword);
            }
        }).start();
    }

    private void LogOnToServer(String f_strServerIP, int f_nServerPort, String f_strUserId, String f_strPassword, String f_strNewPassword) {
        int l_nRecieveMessageStatus = -1;
        CByteArray l_objDeCompressedData = new CByteArray();
        byte[] l_btMessageHeader = new byte[34];
        CMsgHeader l_objInfoFeedMsgHeader = new CMsgHeader();
        LBSSBSLogonRequest l_objLoginRequest = new LBSSBSLogonRequest();
        LBSSBSLogonResponse l_objLogonResponse = new LBSSBSLogonResponse();
        try {
            if (-1 == this.m_objServerConnector.ConnectToServer(f_strServerIP.trim(), f_nServerPort, f_strUserId, f_strPassword)) {
                this.ResetConnection();
                return;
            }
            if (-1 == l_objLoginRequest.UpdateSBSRequest(f_strUserId, f_strPassword, f_strNewPassword, "3.8")) {
                AppConstants.strRequestString = "Update request failed.";
                this.ResetConnection();
                return;
            }
            if (-1 == this.m_objServerConnector.SendMessage(l_objLoginRequest.ToByteArraySBS())) {
                AppConstants.strRequestString = "Message Write Error";
                this.ResetConnection();
                return;
            }
            Date l_objLogonResponseWaitInitialTime = new Date();
            while (true) {
                if (new Date().getTime() - l_objLogonResponseWaitInitialTime.getTime() >= 120000L) {
                    AppConstants.strRequestString = "Connection timeout";
                    this.ResetConnection();
                    return;
                }
                l_nRecieveMessageStatus = this.m_objServerConnector.RecieveMessage(l_objDeCompressedData);
                if (1 != l_nRecieveMessageStatus) break;
                Thread.sleep(100L);
            }
            if (-1 == l_nRecieveMessageStatus) {
                AppConstants.strRequestString = "Message not received";
                this.ResetConnection();
                return;
            }
            ByteArrayInputStream l_objByteArrayInputStream = new ByteArrayInputStream(l_objDeCompressedData.get());
            DataInputStream l_objDataInputStream = new DataInputStream(l_objByteArrayInputStream);
            System.arraycopy(l_objDeCompressedData.get(), 0, l_btMessageHeader, 0, 34);
            l_objByteArrayInputStream = new ByteArrayInputStream(l_btMessageHeader);
            l_objDataInputStream = new DataInputStream(l_objByteArrayInputStream);
            if (-1 == l_objInfoFeedMsgHeader.Update(l_objDataInputStream)) {
                AppConstants.strRequestString = "Invalid header.";
                this.ResetConnection();
                return;
            }
            if (l_objInfoFeedMsgHeader != null) {
                if (l_objInfoFeedMsgHeader.m_nMsgCode == 10001) {
                    l_objByteArrayInputStream = new ByteArrayInputStream(l_objDeCompressedData.get());
                    l_objDataInputStream = new DataInputStream(l_objByteArrayInputStream);
                    l_objLogonResponse.UpdateSBS(l_objDataInputStream);
                    if (l_objLogonResponse.m_nErrorCode != 0) {
                        AppConstants.strRequestString = new String(l_objLogonResponse.m_btReplyText).trim();
                        this.ResetConnection();
                        return;
                    }
                    if (AppConstants.bRememberPassword) {
                        if (!f_strNewPassword.equals("")) {
                            AppConstants.strPassword = f_strNewPassword;
                        }
                        this.saveUserSettings(AppConstants.strUserId, AppConstants.strPassword, "Y", AppConstants.strWebServer, AppConstants.strBrokerId, AppConstants.iOrientation, AppConstants.iFont);
                    } else {
                        this.saveUserSettings("", "", "Y", AppConstants.strWebServer, AppConstants.strBrokerId, AppConstants.iOrientation, AppConstants.iFont);
                    }
                    iWinRefresh.getInstance().progress.setProgress("Fetching Data", 2);
                    AppConstants.sendrequest.sendLoginRequest(f_strUserId.toUpperCase().trim(), f_strPassword);
                    return;
                }
                AppConstants.strRequestString = "Invalid message code";
                this.ResetConnection();
                return;
            }
            AppConstants.strRequestString = "Header not retrieved";
            this.ResetConnection();
            return;
        }
        catch (Exception ex) {
            AppConstants.strRequestString = "Logon failed. Try after some time";
            this.ResetConnection();
            return;
        }
    }

    public void ResetConnection() {
        try {
            iWinRefresh.getInstance().showform.showLogin();
            this.m_objServerConnector.ResetConnection();
            this.m_objServerConnector = null;
            if (this.m_objServerConnector == null) {
                this.m_objServerConnector = new CServerConnector();
            }
            Thread.sleep(500L);
            iWinRefresh.displayAlert("MVMG", AppConstants.strRequestString, 6000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ResetCInfoFeedMain() {
        this.m_objServerConnector = null;
        this.t = null;
        AppConstants.bLoggedIn = false;
    }

    public void saveUserSettings(String strUserId, String strPassword, String strSavePassword, String strWebServer, String strBrokerId, int ipOrientation, int ipFont) {
        try {
            iWinDB dbUser = new iWinDB("MVMUser");
            String[][] straUser = new String[][]{{"0", strUserId}, {"1", strPassword}, {"2", strSavePassword}, {"3", strWebServer}, {"4", strBrokerId}, {"5", Integer.toString(ipOrientation)}, {"6", Integer.toString(ipFont)}};
            dbUser.saveRecordStore(straUser);
            dbUser.close();
        }
        catch (Exception e) {
            Utilities.printLog("saveSettings " + e.toString());
        }
    }

    protected void startThread() {
        this.t = new Thread(this);
        this.t.start();
    }

    public void run() {
        while (AppConstants.bLoggedIn) {
            try {
                this.ReadAndProcessData();
                Thread.sleep(10L);
            }
            catch (Exception e) {
                Utilities.printLog("run " + e.toString());
            }
        }
    }

    private void ReadAndProcessData() {
        if (-1 == this.m_objServerConnector.CheckAndSendKeepAlive()) {
            AppConstants.strRequestString = "Keep Alive Error";
            this.ResetConnection();
            return;
        }
        CByteArray l_objDeCompressedData = new CByteArray();
        if (0 != this.m_objServerConnector.RecieveMessage(l_objDeCompressedData)) {
            return;
        }
        byte[] l_btTempArray = l_objDeCompressedData.get();
        byte l_nValue = l_btTempArray[0];
        int l_nFirstValue = l_nValue >> 4;
        int l_nSecondValue = l_nValue - (l_nFirstValue << 4);
        ByteArrayInputStream l_objByteArrayInputStream = new ByteArrayInputStream(l_btTempArray);
        DataInputStream l_objDataInputStream = new DataInputStream(l_objByteArrayInputStream);
        try {
            this.processDataForMarketWatch(l_objDataInputStream, l_nFirstValue, l_nSecondValue);
            l_objDataInputStream.close();
            l_objDataInputStream = null;
        }
        catch (Exception e) {
            Utilities.printLog("Feed Data " + e.toString());
        }
    }

    private void processDataForMarketWatch(DataInputStream f_objDataInputStream, int f_nLLFindicator, int f_nValue) {
        short INFOFEED_STATUS = 0;
        CMsgHeader l_objMsgHeader = new CMsgHeader();
        INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objMsgHeader.Update(f_objDataInputStream, f_nValue) : l_objMsgHeader.Update(f_objDataInputStream);
        switch (l_objMsgHeader.m_nSegmentId) {
            case 4: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 102: {
                                InfoFeedNSEEQTouchline l_objNSEEQTouchline = new InfoFeedNSEEQTouchline();
                                l_objNSEEQTouchline.UpdateLLF(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 104: {
                                InfoFeedNSEEQIndex l_objNSEEQMultipleIndicesBcast = new InfoFeedNSEEQIndex();
                                l_objNSEEQMultipleIndicesBcast.UpdateLLF(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                    case 2: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 202: {
                                InfoFeedNSEFAOTouchline l_objNSEFAOTouchline = new InfoFeedNSEFAOTouchline();
                                l_objNSEFAOTouchline.UpdateLLF(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 204: {
                                InfoFeedNSEFAOTouchline l_objNSEFAOOpenInterestInfo = new InfoFeedNSEFAOTouchline();
                                l_objNSEFAOOpenInterestInfo.UpdateLLFOpenInterest(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                    case 4: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 302: {
                                InfoFeedNSEWDMTouchline l_objNSEWDMTouchline = new InfoFeedNSEWDMTouchline();
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objNSEWDMTouchline.UpdateLLF(l_objMsgHeader, f_objDataInputStream) : l_objNSEWDMTouchline.Update(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 3: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 1: {
                                InfoFeedBSEEQTouchline l_objBSETouchline = new InfoFeedBSEEQTouchline(1);
                                l_objBSETouchline.UpdateLLFTouchline(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 5000: {
                                InfoFeedBSEEQTouchline l_objBSEBestfive = new InfoFeedBSEEQTouchline(5);
                                l_objBSEBestfive.UpdateLLFBestFive(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 1907: {
                                InfoFeedBSEEQMultipleIndex l_objBSEEQMultipleIndex = new InfoFeedBSEEQMultipleIndex();
                                l_objBSEEQMultipleIndex.Update(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 5002: {
                                InfoFeedBSEEQIndicesInfo l_objBSEEQBSEEQIndicesInfoReply = new InfoFeedBSEEQIndicesInfo();
                                l_objBSEEQBSEEQIndicesInfoReply.UpdateLLF(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 2: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 1: {
                                InfoFeedMCXTouchline l_objMCXTouchline = new InfoFeedMCXTouchline(1);
                                l_objMCXTouchline.UpdateLLFTouchline(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 209: {
                                InfoFeedMCXTouchline l_objMCXBestfive = new InfoFeedMCXTouchline(5);
                                l_objMCXBestfive.UpdateLLFBestFive(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 210: {
                                InfoFeedMCXIndex l_objMCXIndex = new InfoFeedMCXIndex();
                                l_objMCXIndex.Update(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                    case 2: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 1: {
                                InfoFeedMCXTouchline l_objMCXTouchline = new InfoFeedMCXTouchline(1);
                                l_objMCXTouchline.UpdateLLFTouchline(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 209: {
                                InfoFeedMCXTouchline l_objMCXBestfive = new InfoFeedMCXTouchline(5);
                                l_objMCXBestfive.UpdateLLFBestFive(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 210: {
                                InfoFeedMCXIndex l_objMCXIndex = new InfoFeedMCXIndex();
                                l_objMCXIndex.Update(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 9: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 303: {
                                InfoFeedNCDEXFAOSPOTTouchline l_objNCDEXFAOTouchline = new InfoFeedNCDEXFAOSPOTTouchline();
                                l_objNCDEXFAOTouchline.UpdateLLFFAOTouchline(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 305: {
                                InfoFeedNCDEXFAOSPOTTouchline l_objNCDEXFAOOpenInterestInfo = new InfoFeedNCDEXFAOSPOTTouchline();
                                l_objNCDEXFAOOpenInterestInfo.UpdateLLFOpenInterest(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                    case 2: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 306: {
                                InfoFeedNCDEXFAOSPOTTouchline l_objNCDEXSpotPrice = new InfoFeedNCDEXFAOSPOTTouchline();
                                l_objNCDEXSpotPrice.UpdateLLFSPOTTouchline(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 34: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 1: {
                                InfoFeedMCXTouchline l_objMCXSXTouchline = new InfoFeedMCXTouchline(1);
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objMCXSXTouchline.UpdateLLFTouchline(l_objMsgHeader, f_objDataInputStream) : l_objMCXSXTouchline.UpdateTouchline(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 209: {
                                InfoFeedMCXTouchline l_objMCXSXBestfive = new InfoFeedMCXTouchline(5);
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objMCXSXBestfive.UpdateLLFBestFive(l_objMsgHeader, f_objDataInputStream) : l_objMCXSXBestfive.UpdateBestFive(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                    case 2: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 3: {
                                InfoFeedMCXTouchline l_objMCXSXTouchline = new InfoFeedMCXTouchline(1);
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objMCXSXTouchline.UpdateLLFTouchline(l_objMsgHeader, f_objDataInputStream) : l_objMCXSXTouchline.UpdateTouchline(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 2: {
                                InfoFeedMCXTouchline l_objMCXSXBestfive = new InfoFeedMCXTouchline(5);
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objMCXSXBestfive.UpdateLLFBestFive(l_objMsgHeader, f_objDataInputStream) : l_objMCXSXBestfive.UpdateBestFive(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                    case 3: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 8: {
                                CInfofeedMCXSXEQTouchline l_objMCXSXEQTouchline = new CInfofeedMCXSXEQTouchline(1);
                                INFOFEED_STATUS = l_objMCXSXEQTouchline.UpdateLLFTouchline(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 7: {
                                CInfofeedMCXSXEQTouchline l_objMCXSXEQMDTouchline = new CInfofeedMCXSXEQTouchline(5);
                                INFOFEED_STATUS = l_objMCXSXEQMDTouchline.UpdateLLFBestFive(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 16: {
                                CInfofeedMCXSXEQIndices l_objMCXSXEQIndex = new CInfofeedMCXSXEQIndices();
                                INFOFEED_STATUS = l_objMCXSXEQIndex.Update(l_objMsgHeader, f_objDataInputStream);
                            }
                        }
                        return;
                    }
                    case 4: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 13: {
                                CInfofeedMCXSXDervTouchline l_objMCXSXDervTouchline = new CInfofeedMCXSXDervTouchline(1);
                                INFOFEED_STATUS = l_objMCXSXDervTouchline.UpdateLLFTouchline(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 12: {
                                CInfofeedMCXSXDervTouchline l_objMCXSXDervMDTouchline = new CInfofeedMCXSXDervTouchline(5);
                                INFOFEED_STATUS = l_objMCXSXDervMDTouchline.UpdateLLFBestFive(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 35: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: 
                    case 2: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 13: 
                            case 18: {
                                InfofeedNCXFAOTouchline l_objNSECURFAOTouchline = new InfofeedNCXFAOTouchline(1);
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objNSECURFAOTouchline.UpdateLLFTouchline(l_objMsgHeader, f_objDataInputStream) : l_objNSECURFAOTouchline.UpdateTouchline(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 3: 
                            case 14: {
                                InfofeedNCXFAOTouchline l_objNSECURFAOBestfive = new InfofeedNCXFAOTouchline(5);
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objNSECURFAOBestfive.UpdateLLFTouchline(l_objMsgHeader, f_objDataInputStream) : l_objNSECURFAOBestfive.UpdateBestFive(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 5: 
                            case 15: {
                                InfoFeedNSEFAOTouchline l_objNSECURFAOOpenInterestInfo = new InfoFeedNSEFAOTouchline();
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objNSECURFAOOpenInterestInfo.UpdateLLFOpenInterest(l_objMsgHeader, f_objDataInputStream) : l_objNSECURFAOOpenInterestInfo.UpdateNSEFAOOpenInterest(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 12: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: 
                    case 2: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 1001: {
                                InfoFeedINTLSPOT_FOREXTouchline l_objINTLFOREXTouchline = new InfoFeedINTLSPOT_FOREXTouchline();
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objINTLFOREXTouchline.UpdateLLFTouchline(l_objMsgHeader, f_objDataInputStream, 12) : l_objINTLFOREXTouchline.Update(l_objMsgHeader, f_objDataInputStream, 12);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 17: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: 
                    case 2: 
                    case 3: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 1: {
                                InfoFeedTPContributorsSPOTTouchline l_objTPContributorsFOREXTouchline = new InfoFeedTPContributorsSPOTTouchline();
                                l_objTPContributorsFOREXTouchline.Update(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 5: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 2003: {
                                InfoFeedCOMEXNYMEXTouchline l_objCOMEXTouchline = new InfoFeedCOMEXNYMEXTouchline();
                                l_objCOMEXTouchline.UpdateCOMEXLLF(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 7: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: 
                    case 2: 
                    case 3: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 4: {
                                InfoFeedLMETouchline l_objLMETouchline = new InfoFeedLMETouchline(1);
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objLMETouchline.UpdateLLF(l_objMsgHeader, f_objDataInputStream) : l_objLMETouchline.Update(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 1: {
                                InfoFeedLMETouchline l_objLMEBestfive = new InfoFeedLMETouchline(5);
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objLMEBestfive.UpdateLLF(l_objMsgHeader, f_objDataInputStream) : l_objLMEBestfive.Update(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 8: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 806: {
                                InfoFeedCOMEXNYMEXTouchline l_objNYMEXTouchline = new InfoFeedCOMEXNYMEXTouchline();
                                l_objNYMEXTouchline.UpdateCOMEXLLF(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 13: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 1: {
                                InfoFeedINTLSPOT_FOREXTouchline l_objPRECIOUSMETALTouchline = new InfoFeedINTLSPOT_FOREXTouchline();
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objPRECIOUSMETALTouchline.UpdateLLFTouchline(l_objMsgHeader, f_objDataInputStream, 13) : l_objPRECIOUSMETALTouchline.Update(l_objMsgHeader, f_objDataInputStream, 13);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 45: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 1: {
                                InfoFeedCOMEXNYMEXTouchline l_objSGXTouchline = new InfoFeedCOMEXNYMEXTouchline();
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objSGXTouchline.UpdateLLF(l_objMsgHeader, f_objDataInputStream) : l_objSGXTouchline.UpdateSGX_ICE(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 46: 
            case 48: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 1: {
                                InfoFeedCOMEXNYMEXTouchline l_objSGXTouchline = new InfoFeedCOMEXNYMEXTouchline();
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objSGXTouchline.UpdateLLF(l_objMsgHeader, f_objDataInputStream) : l_objSGXTouchline.UpdateSGX_ICE(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 49: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: 
                    case 2: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 1: {
                                InfoFeedCOMEXNYMEXTouchline l_objCMETouchline = new InfoFeedCOMEXNYMEXTouchline();
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objCMETouchline.UpdateLLF(l_objMsgHeader, f_objDataInputStream) : l_objCMETouchline.UpdateSGX_ICE(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 50: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 1: {
                                InfoFeedCOMEXNYMEXTouchline l_objBursaMalaysiaTouchline = new InfoFeedCOMEXNYMEXTouchline();
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objBursaMalaysiaTouchline.UpdateLLF(l_objMsgHeader, f_objDataInputStream) : l_objBursaMalaysiaTouchline.UpdateSGX_ICE(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 10: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 2: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 8: {
                                CInfofeedDGCXFNOTouchline l_objDGCXFNOTouchline = new CInfofeedDGCXFNOTouchline(1);
                                l_objDGCXFNOTouchline.UpdateLLFTouchline(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 7: {
                                CInfofeedDGCXFNOTouchline l_objDGCXFNOBestfive = new CInfofeedDGCXFNOTouchline(5);
                                l_objDGCXFNOBestfive.UpdateLLFBestFive(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 52: 
            case 55: 
            case 56: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 2: {
                                InfoFeedDSGBTouchline l_objDSGBTouchline = new InfoFeedDSGBTouchline(1);
                                l_objDSGBTouchline.UpdateLLFTouchline(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 1: {
                                InfoFeedDSGBTouchline l_objDSGBBestfive = new InfoFeedDSGBTouchline(5);
                                l_objDSGBBestfive.UpdateLLFBestFive(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 54: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 4: {
                                InfoFeedLMETouchline l_objLIFFETouchline = new InfoFeedLMETouchline(1);
                                l_objLIFFETouchline.UpdateLIFFELLF(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 1: {
                                InfoFeedLMETouchline l_objLIFFEBestfive = new InfoFeedLMETouchline(5);
                                l_objLIFFEBestfive.UpdateLIFFELLF(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 57: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 1: {
                                InfoFeedCOMEXNYMEXTouchline l_objSGXTouchline = new InfoFeedCOMEXNYMEXTouchline();
                                INFOFEED_STATUS = f_nLLFindicator == 7 ? l_objSGXTouchline.UpdateLLF(l_objMsgHeader, f_objDataInputStream) : l_objSGXTouchline.UpdateSGX_ICE(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
            case 60: {
                switch (l_objMsgHeader.m_nInstrumentType) {
                    case 1: {
                        switch (l_objMsgHeader.m_nMsgCode) {
                            case 101: {
                                CInfofeedACEFAOTouchline l_objACETouchline = new CInfofeedACEFAOTouchline(1);
                                l_objACETouchline.UpdateLLFTouchline(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                            case 100: {
                                CInfofeedACEFAOTouchline l_objACEBestfive = new CInfofeedACEFAOTouchline(5);
                                l_objACEBestfive.UpdateLLFBestFive(l_objMsgHeader, f_objDataInputStream);
                                return;
                            }
                        }
                        return;
                    }
                }
                return;
            }
        }
    }
}

