/*
 * Decompiled with CFR 0.152.
 */
package connection;

import JZlib.ZStream;
import common.AppConstants;
import common.Utilities;
import connection.CByteArray;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import market.iWinRefresh;
import structures.CMsgHeader;
import structures.LBSSBSLogonRequest;
import structures.LBSSBSLogonResponse;

public class CServerConnector {
    private StreamConnection m_objConnection = null;
    private OutputStream m_objOutStream;
    private InputStream m_objInStream;
    private byte[] m_btDatabuffer = null;
    private long m_lLastMessageSendTime = 0L;
    private Vector m_objMsgBtArrayQueue;
    private final int INFOFEED_DECOMPRESSION_BUFFER_SIZE;
    private final int INFOFEED_MAX_BUFFER_FILL_LIMIT;
    private final short INFOFEED_MESSAGE_STRUCTURE_LENGTH = (short)5;
    private final short INFOFEED_START_DATA_TAG_LENGTH = (short)8;
    private final short INFOFEED_END_DATA_TAG_LENGTH = (short)9;
    private final String INFOFEED_START_DATA_TAG_STRING;
    private final String INFOFEED_HTTP_TRAILER_STRING;

    public CServerConnector() {
        this.INFOFEED_DECOMPRESSION_BUFFER_SIZE = 3560;
        this.INFOFEED_MAX_BUFFER_FILL_LIMIT = 1024;
        this.INFOFEED_START_DATA_TAG_STRING = "<DATA>\r\n";
        this.INFOFEED_HTTP_TRAILER_STRING = "\r\n</DATA>";
        this.m_objMsgBtArrayQueue = new Vector();
    }

    protected short ConnectToServer(String f_strServerIP, int f_nServerPort, String f_strUserId, String f_strUserPassword) {
        try {
            DataInputStream l_objDataInputStream;
            ByteArrayInputStream l_objByteArrayInputStream;
            LBSSBSLogonRequest l_objLBSLogonRequest = new LBSSBSLogonRequest();
            LBSSBSLogonResponse l_objLBSLogonResponse = new LBSSBSLogonResponse();
            CByteArray l_objDeCompressedData = new CByteArray();
            byte[] l_btMessageHeader = new byte[34];
            CMsgHeader l_objInfoFeedMsgHeader = new CMsgHeader();
            int l_nRecieveMessageStatus = -1;
            this.m_objConnection = (StreamConnection)Connector.open((String)("socket://" + f_strServerIP + ":" + f_nServerPort));
            this.m_objOutStream = this.m_objConnection.openOutputStream();
            this.m_objInStream = this.m_objConnection.openInputStream();
            this.m_lLastMessageSendTime = System.currentTimeMillis();
            if (-1 == l_objLBSLogonRequest.UpdateLBSRequest(f_strUserId, f_strUserPassword, "3.8")) {
                AppConstants.strRequestString = "Update request failed";
                this.ResetConnection();
                return -1;
            }
            if (-1 == this.SendMessage(l_objLBSLogonRequest.ToByteArrayLBS())) {
                AppConstants.strRequestString = "Message Write Error";
                this.ResetConnection();
                return -1;
            }
            Date l_objLogonResponseWaitInitialTime = new Date();
            while (true) {
                if (new Date().getTime() - l_objLogonResponseWaitInitialTime.getTime() >= 120000L) {
                    AppConstants.strRequestString = "Connection timeout.";
                    this.ResetConnection();
                    return -1;
                }
                l_nRecieveMessageStatus = this.RecieveMessage(l_objDeCompressedData);
                if (1 == l_nRecieveMessageStatus) {
                    Thread.sleep(100L);
                    continue;
                }
                if (-1 == l_nRecieveMessageStatus) {
                    AppConstants.strRequestString = "Message not received";
                    this.ResetConnection();
                    return -1;
                }
                System.arraycopy(l_objDeCompressedData.get(), 0, l_btMessageHeader, 0, 34);
                l_objByteArrayInputStream = new ByteArrayInputStream(l_btMessageHeader);
                l_objDataInputStream = new DataInputStream(l_objByteArrayInputStream);
                if (-1 == l_objInfoFeedMsgHeader.Update(l_objDataInputStream)) {
                    AppConstants.strRequestString = "Invalid message header";
                    this.ResetConnection();
                    return -1;
                }
                if (l_objInfoFeedMsgHeader != null) break;
            }
            if (l_objInfoFeedMsgHeader.m_nMsgCode == 10043) {
                l_objByteArrayInputStream = new ByteArrayInputStream(l_objDeCompressedData.get());
                l_objDataInputStream = new DataInputStream(l_objByteArrayInputStream);
                l_objLBSLogonResponse.UpdateLBS(l_objDataInputStream);
                if (l_objLBSLogonResponse.m_nErrorCode != 0) {
                    AppConstants.strRequestString = new String(l_objLBSLogonResponse.m_btReplyText).trim();
                    this.ResetConnection();
                    return -1;
                }
            } else {
                AppConstants.strRequestString = "Invalid message code";
                this.ResetConnection();
                return -1;
            }
            f_strServerIP = Utilities.RemoveNull(l_objLBSLogonResponse.m_btServerIPAddress);
            f_nServerPort = l_objLBSLogonResponse.m_nServerPortNo;
            Utilities.printLog("IPAddress " + f_strServerIP + " Port " + f_nServerPort);
            iWinRefresh.getInstance().progress.setProgress("Logon to Server", 1);
            this.m_objConnection.close();
            this.m_objOutStream.close();
            this.m_objInStream.close();
            this.m_objConnection = null;
            this.m_objOutStream = null;
            this.m_objInStream = null;
            this.m_objConnection = (StreamConnection)Connector.open((String)("socket://" + f_strServerIP + ":" + f_nServerPort));
            this.m_objOutStream = this.m_objConnection.openOutputStream();
            this.m_objInStream = this.m_objConnection.openInputStream();
            this.m_lLastMessageSendTime = System.currentTimeMillis();
            return 0;
        }
        catch (Exception ex) {
            AppConstants.strRequestString = "Network not found. Kindly check your GPRS connection.";
            return -1;
        }
    }

    public void ResetConnection() {
        try {
            if (this.m_objConnection != null) {
                this.m_objConnection.close();
            }
            if (this.m_objOutStream != null) {
                this.m_objOutStream.close();
            }
            if (this.m_objInStream != null) {
                this.m_objInStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_objConnection = null;
        this.m_objOutStream = null;
        this.m_objInStream = null;
        this.m_btDatabuffer = null;
        this.m_lLastMessageSendTime = 0L;
        this.m_objMsgBtArrayQueue = null;
    }

    protected short CheckAndSendKeepAlive() {
        try {
            if (System.currentTimeMillis() - this.m_lLastMessageSendTime < 90000L) {
                return 0;
            }
            CMsgHeader l_objInfoFeedMsgHeader = new CMsgHeader();
            l_objInfoFeedMsgHeader.m_nSegmentId = 1;
            l_objInfoFeedMsgHeader.m_nMsgCategory = 1;
            l_objInfoFeedMsgHeader.m_nInstrumentType = 1;
            l_objInfoFeedMsgHeader.m_nMsgCode = 10007;
            l_objInfoFeedMsgHeader.m_nMsgLength = 34;
            l_objInfoFeedMsgHeader.m_nMsgTimeStamp = 0;
            if (-1 == this.SendMessage(l_objInfoFeedMsgHeader.ToByteArray())) {
                return -1;
            }
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    protected short SendMessage(byte[] f_btSendData) {
        CByteArray l_objCompressedData = new CByteArray();
        try {
            if (-1 == this.doCompression(f_btSendData, 0, 0, l_objCompressedData)) {
                return -1;
            }
            byte[] l_btSendData = new byte["<DATA>\r\n".length() + l_objCompressedData.get().length + "\r\n</DATA>".length()];
            System.arraycopy("<DATA>\r\n".getBytes(), 0, l_btSendData, 0, "<DATA>\r\n".length());
            System.arraycopy(l_objCompressedData.get(), 0, l_btSendData, "<DATA>\r\n".length(), l_objCompressedData.get().length);
            System.arraycopy("\r\n</DATA>".getBytes(), 0, l_btSendData, "<DATA>\r\n".length() + l_objCompressedData.get().length, "\r\n</DATA>".length());
            this.m_objOutStream.write(l_btSendData);
            this.m_objOutStream.flush();
            this.m_lLastMessageSendTime = System.currentTimeMillis();
            return 0;
        }
        catch (Exception ex) {
            iWinRefresh.getInstance();
            iWinRefresh.displayAlert("MVMG", "1 Disconnected from Gateway server", AppConstants.iAlertDisplayTime);
            try {
                Thread.sleep(5000L);
                iWinRefresh.getInstance().quit();
            }
            catch (Exception e) {
                // empty catch block
            }
            return -1;
        }
    }

    protected short RecieveMessage(CByteArray f_objDeCompressedData) {
        byte[] l_btTemp = null;
        byte[] l_btTempStore = null;
        int l_nStructureLength = 0;
        int l_nDataIndex = 0;
        String l_strVerifyDataTag = "";
        int l_nDataAvailableInSocketBuffer = 0;
        int l_nNoOfBytesRead = 0;
        try {
            if (this.m_objMsgBtArrayQueue != null && !this.m_objMsgBtArrayQueue.isEmpty()) {
                f_objDeCompressedData.set((byte[])this.m_objMsgBtArrayQueue.elementAt(0));
                this.m_objMsgBtArrayQueue.removeElementAt(0);
                return 0;
            }
            if ((null == this.m_btDatabuffer || this.m_btDatabuffer.length < 1024) && (l_nDataAvailableInSocketBuffer = this.m_objInStream.available()) > 0) {
                l_btTemp = new byte[l_nDataAvailableInSocketBuffer];
                l_nNoOfBytesRead = this.m_objInStream.read(l_btTemp);
                if (null != this.m_btDatabuffer && this.m_btDatabuffer.length > 0) {
                    l_btTempStore = new byte[this.m_btDatabuffer.length + l_nNoOfBytesRead];
                    System.arraycopy(this.m_btDatabuffer, 0, l_btTempStore, 0, this.m_btDatabuffer.length);
                    System.arraycopy(l_btTemp, 0, l_btTempStore, this.m_btDatabuffer.length, l_nNoOfBytesRead);
                    this.m_btDatabuffer = new byte[l_btTempStore.length];
                    System.arraycopy(l_btTempStore, 0, this.m_btDatabuffer, 0, l_btTempStore.length);
                } else {
                    this.m_btDatabuffer = new byte[l_nNoOfBytesRead];
                    System.arraycopy(l_btTemp, 0, this.m_btDatabuffer, 0, l_nNoOfBytesRead);
                }
            }
            if (null == this.m_btDatabuffer || this.m_btDatabuffer.length <= 0) {
                return 1;
            }
            l_strVerifyDataTag = new String(this.m_btDatabuffer);
            l_nDataIndex = l_strVerifyDataTag.indexOf("<DATA>\r\n");
            if (l_nDataIndex < 0) {
                return 1;
            }
            if (this.m_btDatabuffer.length < (l_nDataIndex += 8) + 5) {
                return 1;
            }
            l_nStructureLength = Integer.parseInt(new String(this.m_btDatabuffer, l_nDataIndex, 5));
            if (this.m_btDatabuffer.length < l_nDataIndex + 5 + l_nStructureLength + 9) {
                return 1;
            }
            byte[] l_btRecieveData = new byte[l_nStructureLength];
            System.arraycopy(this.m_btDatabuffer, l_nDataIndex + 5, l_btRecieveData, 0, l_nStructureLength);
            if (-1 == this.doDeCompression(l_btRecieveData, f_objDeCompressedData)) {
                this.ResetConnection();
                return -1;
            }
            byte[] l_btTempRecievedArray = f_objDeCompressedData.get();
            while (l_btTempRecievedArray != null && l_btTempRecievedArray.length > 0) {
                DataInputStream l_objDataInputStream = new DataInputStream(new ByteArrayInputStream(l_btTempRecievedArray));
                byte l_nParityByte = l_btTempRecievedArray[0];
                int l_nFirstValue = l_nParityByte >> 4;
                int l_nSecondValue = l_nParityByte - (l_nFirstValue << 4);
                int l_nMsgLength = this.getMsgLength(l_objDataInputStream, l_nFirstValue, l_nSecondValue);
                if (-1 == l_nMsgLength) {
                    this.ResetConnection();
                    return -1;
                }
                if (l_nMsgLength == 0) {
                    return 1;
                }
                if (l_nMsgLength > 65000) {
                    this.m_btDatabuffer = null;
                    return 1;
                }
                byte[] l_btTempMessage = new byte[l_nMsgLength];
                System.arraycopy(l_btTempRecievedArray, 0, l_btTempMessage, 0, l_nMsgLength);
                this.m_objMsgBtArrayQueue.addElement(l_btTempMessage);
                if (l_btTempMessage.length != l_btTempRecievedArray.length) {
                    l_btTempMessage = new byte[l_btTempRecievedArray.length - l_nMsgLength];
                    System.arraycopy(l_btTempRecievedArray, l_nMsgLength, l_btTempMessage, 0, l_btTempRecievedArray.length - l_nMsgLength);
                    l_btTempRecievedArray = l_btTempMessage;
                    continue;
                }
                l_btTempRecievedArray = null;
            }
            l_btTempStore = new byte[this.m_btDatabuffer.length - (l_nDataIndex + 5 + l_nStructureLength + 9)];
            System.arraycopy(this.m_btDatabuffer, l_nDataIndex + 5 + l_nStructureLength + 9, l_btTempStore, 0, this.m_btDatabuffer.length - (l_nDataIndex + 5 + l_nStructureLength + 9));
            this.m_btDatabuffer = new byte[l_btTempStore.length];
            System.arraycopy(l_btTempStore, 0, this.m_btDatabuffer, 0, l_btTempStore.length);
            if (this.m_objMsgBtArrayQueue == null || this.m_objMsgBtArrayQueue.isEmpty()) {
                return 1;
            }
            f_objDeCompressedData.set((byte[])this.m_objMsgBtArrayQueue.elementAt(0));
            this.m_objMsgBtArrayQueue.removeElementAt(0);
            return 0;
        }
        catch (Exception ex) {
            iWinRefresh.displayAlert("MVMG", "2 Disconnected from Gateway server", AppConstants.iAlertDisplayTime);
            try {
                Thread.sleep(5000L);
                iWinRefresh.getInstance().quit();
            }
            catch (Exception e) {
                // empty catch block
            }
            return -1;
        }
    }

    private int getMsgLength(DataInputStream f_objDataInputStream, int f_nIndicator, int f_nValue) {
        try {
            if (f_nIndicator == 7) {
                byte l_nSkipByte = f_objDataInputStream.readByte();
                return (int)Utilities.processDataType(f_objDataInputStream, f_nValue, 0);
            }
            int l_nSkipByte = f_objDataInputStream.skipBytes(30);
            return f_objDataInputStream.readInt();
        }
        catch (Exception e) {
            return -1;
        }
    }

    void CHECK_ERR(ZStream f_objZStream, int f_nerr, String f_strmsg) {
    }

    private short doCompression(byte[] f_btoutputData, int f_nInLen, int f_nOutLen, CByteArray f_objCompressedData) {
        int l_ncomprLen = 0;
        l_ncomprLen = f_btoutputData.length < 100 ? 150 : f_btoutputData.length;
        byte[] l_btcompr = new byte[l_ncomprLen];
        try {
            ZStream l_objZStream = new ZStream();
            int l_nerr = l_objZStream.deflateInit(-1);
            this.CHECK_ERR(l_objZStream, l_nerr, "deflateInit");
            l_objZStream.next_in = f_btoutputData;
            l_objZStream.next_in_index = 0;
            l_objZStream.next_out = l_btcompr;
            l_objZStream.next_out_index = 0;
            while (l_objZStream.total_in != (long)f_btoutputData.length && l_objZStream.total_out < (long)l_ncomprLen) {
                l_objZStream.avail_out = 1;
                l_objZStream.avail_in = 1;
                l_nerr = l_objZStream.deflate(0);
                this.CHECK_ERR(l_objZStream, l_nerr, "deflate");
            }
            while (true) {
                l_objZStream.avail_out = 1;
                l_nerr = l_objZStream.deflate(4);
                if (l_nerr == 1) break;
                this.CHECK_ERR(l_objZStream, l_nerr, "deflate");
            }
            l_nerr = l_objZStream.deflateEnd();
            this.CHECK_ERR(l_objZStream, l_nerr, "deflateEnd");
            boolean l_nLength = false;
            f_nInLen = (int)l_objZStream.total_in;
            f_nOutLen = (int)l_objZStream.total_out;
            byte[] l_btComprFinal = new byte[f_nOutLen];
            System.arraycopy(l_btcompr, 0, l_btComprFinal, 0, f_nOutLen);
            byte[] l_btComprwithlen = new byte[f_nOutLen + 5];
            String l_strLength = this.FormatLength(f_nOutLen);
            System.arraycopy(l_strLength.getBytes(), 0, l_btComprwithlen, 0, 5);
            System.arraycopy(l_btComprFinal, 0, l_btComprwithlen, 5, f_nOutLen);
            f_objCompressedData.set(l_btComprwithlen);
            return 0;
        }
        catch (Exception e) {
            f_nInLen = 0;
            f_nOutLen = 0;
            return -1;
        }
    }

    private short doDeCompression(byte[] f_btMessage, CByteArray f_objDeCompressedData) {
        try {
            int l_ncomprLen = f_btMessage.length;
            int l_nuncomprLen = 3560;
            byte[] compr = new byte[l_ncomprLen];
            byte[] uncompr = new byte[l_nuncomprLen];
            System.arraycopy(f_btMessage, 0, compr, 0, f_btMessage.length);
            ZStream d_stream = new ZStream();
            d_stream.next_in = compr;
            d_stream.next_in_index = 0;
            d_stream.next_out = uncompr;
            d_stream.next_out_index = 0;
            int l_nerr = d_stream.inflateInit();
            this.CHECK_ERR(d_stream, l_nerr, "inflateInit");
            while (d_stream.total_out < (long)l_nuncomprLen && d_stream.total_in < (long)l_ncomprLen) {
                d_stream.avail_out = 1;
                d_stream.avail_in = 1;
                l_nerr = d_stream.inflate(0);
                if (l_nerr == 1) break;
                this.CHECK_ERR(d_stream, l_nerr, "inflate");
            }
            l_nerr = d_stream.inflateEnd();
            this.CHECK_ERR(d_stream, l_nerr, "inflateEnd");
            long l_nTemp = d_stream.total_out;
            byte[] baDecompr = new byte[(int)d_stream.total_out];
            System.arraycopy(uncompr, 0, baDecompr, 0, baDecompr.length);
            String strDecompressed = new String(baDecompr);
            f_objDeCompressedData.set(baDecompr);
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private String FormatLength(int l_nLength) {
        String strOutput = "00000";
        String l_strLength = Integer.toString(l_nLength);
        int l_nLengthLength = l_strLength.length();
        strOutput = l_nLengthLength < 5 ? strOutput.substring(0, 5 - l_nLengthLength) + l_strLength : (l_nLengthLength == 5 ? l_strLength : l_strLength.substring(0, 5));
        return strOutput;
    }
}

