/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.CanvasForm;
import GeneralUI.DropDownBox;
import GeneralUI.JStringItem;
import GeneralUI.JTextField;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import common.TagData;
import common.Utilities;
import javax.microedition.lcdui.Displayable;
import market.iWinRefresh;

public class Alerts
extends CanvasForm
implements JCommandListener {
    private JStringItem strSymbol = new JStringItem("", "");
    private DropDownBox dpEntity = new DropDownBox("Entity");
    private DropDownBox dpOperator = new DropDownBox("Operator");
    private JTextField txtPrice = new JTextField("Price", "", 10, 5);
    private TagData newTagData;

    public Alerts(String strTitle) {
        super(strTitle);
        this.InitializeForm();
    }

    private void InitializeForm() {
        String[] strEntity = new String[]{"LTP"};
        String[] strOperator = new String[]{">", "<", "="};
        this.wrapItem(this.strSymbol);
        this.dpEntity.addItem(strEntity);
        this.wrapItem(this.dpEntity);
        this.dpOperator.addItem(strOperator);
        this.wrapItem(this.dpOperator);
        this.wrapItem(this.txtPrice);
    }

    public void setData(TagData tag, int ipOperator, String strpPrice) {
        this.newTagData = tag;
        this.strSymbol.setText(tag.strScripDesc, 0);
        this.dpOperator.setSelectedIndex(ipOperator == 11 ? 1 : (ipOperator == 12 ? 2 : 0));
        this.txtPrice.setText(strpPrice);
    }

    public boolean jcommandAction(SoftKey softKey, Displayable d) {
        String strCommand = softKey.getLabel();
        if (strCommand.equals("Ok")) {
            if (this.Validate()) {
                if (AppConstants.profilelist.getNoOfAlerts() == 5 && !AppConstants.profilelist.ifAlertExists(this.newTagData.strKeyOfData)) {
                    iWinRefresh.displayAlert("MVMG", "Max. alerts reached.", AppConstants.iAlertDisplayTime);
                    return false;
                }
                int iAlertIndex = Integer.parseInt(this.dpEntity.getSelectedIndex() + 1 + "" + this.dpOperator.getSelectedIndex());
                int iAlertPrice = Utilities.convertToWholeNumber(this.txtPrice.getText(), this.newTagData.iDivisionFactor);
                AppConstants.sendrequest.sendAddOrRemoveAlertRequest(this.newTagData.iSegmentId, this.newTagData.iInstrumentId, this.newTagData.strKeyOfData, iAlertIndex, iAlertPrice, 1);
            }
            return true;
        }
        if (strCommand.equals("Back")) {
            iWinRefresh.getInstance().backForm(iWinRefresh.iPreviousForm);
            return true;
        }
        return true;
    }

    private boolean Validate() {
        String strPrice = this.txtPrice.getText();
        if (strPrice.length() == 0) {
            iWinRefresh.displayAlert("MVMG", "Enter price", AppConstants.iAlertDisplayTime);
            return false;
        }
        if (!Utilities.isAlphaNumeric(strPrice, 1)) {
            iWinRefresh.displayAlert("MVMG", "Enter price in numeric", AppConstants.iAlertDisplayTime);
            return false;
        }
        return true;
    }
}

