/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.JPlatformCanvas;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import common.Utilities;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import market.iWinRefresh;

public class BestFive
implements JCommandListener {
    private final int iMaxNoOfRows;
    private String[] strData = new String[48];
    private int iMaxNoOfPages = 0;
    private int iCurrentIndex = 0;
    public int iMaxNoOfColumns = 0;
    private int iPriceWidth = 0;
    private final byte SEGMENTID_INDEX;
    private final byte INSTRUMENTID_INDEX;
    private final byte KEYOFDATA_INDEX = (byte)2;
    private final byte HEADING_INDEX = (byte)3;
    private final byte DIVISION_INDEX = (byte)6;
    private String[] strStoreData = new String[4];
    private JPlatformCanvas canvas = JPlatformCanvas.getInstance();
    private int iViewMode = 0;
    private int iDivision;

    public BestFive() {
        this.iMaxNoOfRows = 48;
        this.SEGMENTID_INDEX = 0;
        this.INSTRUMENTID_INDEX = 1;
        this.iPriceWidth = AppConstants.FONT_CONTENT.stringWidth("99999.9999") + 5;
    }

    public void setData(String[] strDisplayData, int[] iValue) {
        this.strStoreData = strDisplayData;
        this.iViewMode = 0;
        this.iCurrentIndex = 0;
        this.iDivision = iValue[6];
        this.iPriceWidth = AppConstants.FONT_CONTENT.stringWidth("99999.9999") + 5;
        this.iMaxNoOfColumns = (JPlatformCanvas.SCREEN_WIDTH - 4) / this.iPriceWidth;
        this.iMaxNoOfColumns = this.iMaxNoOfColumns >= 1 && this.iMaxNoOfColumns < 4 ? 2 : (this.iMaxNoOfColumns >= 4 && this.iMaxNoOfColumns < 8 ? 4 : 8);
        this.iViewMode = 0;
        this.strData = new String[48];
        for (int i = 0; i < 48; ++i) {
            this.strData[i] = " ";
        }
        this.strData[20] = "Vol";
        this.strData[22] = "Val(Cr)";
        this.strData[24] = "LTP";
        this.strData[26] = "ATP";
        this.strData[28] = "Net Chg";
        this.strData[30] = "%Chg.";
        this.strData[32] = "Open";
        this.strData[34] = "High";
        this.strData[36] = "Low";
        this.strData[38] = "Close";
        this.strData[40] = "TBQ";
        this.strData[42] = "TSQ";
        this.strData[44] = "LUT";
        this.strData[46] = "Opn Int";
    }

    public void paint(Graphics g) {
        boolean iStartX = true;
        Font fontContent = AppConstants.FONT_CONTENT;
        Font fontHeading = AppConstants.FONT_HEADING;
        int iFontHeight = AppConstants.FONT_HEADING.getHeight() + 1;
        int iHeadWidth = AppConstants.FONT_HEADING.stringWidth("Net Chg");
        int x = 1;
        int y = JPlatformCanvas.TITLE_BAR_HEIGHT;
        g.setColor(0);
        g.fillRect(0, 0, JPlatformCanvas.SCREEN_WIDTH, JPlatformCanvas.SCREEN_HEIGHT);
        g.setColor(0xFFFFFF);
        g.setFont(fontHeading);
        g.drawString(this.strStoreData[3], x + 1, y + 1, 20);
        int iMaxDisplayRows = (JPlatformCanvas.SCREEN_HEIGHT - (y += iFontHeight) - JPlatformCanvas.SOFT_KEYBAR_HEIGHT) / iFontHeight;
        int n = this.iMaxNoOfPages = this.iMaxNoOfColumns >= 4 ? 48 / (this.iMaxNoOfColumns * iMaxDisplayRows) : 38 / (this.iMaxNoOfColumns * iMaxDisplayRows);
        if (this.iMaxNoOfPages * this.iMaxNoOfColumns * iMaxDisplayRows < 48) {
            ++this.iMaxNoOfPages;
        }
        int iCurrentPageStartIndex = this.iCurrentIndex * iMaxDisplayRows * this.iMaxNoOfColumns;
        for (int i = 0; i < iMaxDisplayRows; ++i) {
            int j;
            g.setFont(AppConstants.FONT_HEADING);
            if (this.iMaxNoOfColumns == 8 && i < 6) {
                if (iCurrentPageStartIndex + i >= 0 && iCurrentPageStartIndex + i <= 4 && i < 5) {
                    g.setFont(fontContent);
                    g.setColor(13485061);
                    g.drawRect(++x, y, this.iPriceWidth + 1, fontHeading.getHeight() + 1);
                    g.setColor(4885759);
                    g.fillRect(x + 1, y + 1, this.iPriceWidth, fontHeading.getHeight());
                    g.setColor(0xFFFFFF);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * 4], x + 2, y + 1, 20);
                    x += this.iPriceWidth + 2;
                    g.setColor(13485061);
                    g.drawRect(++x, y, this.iPriceWidth + 1, fontHeading.getHeight() + 1);
                    g.setColor(4885759);
                    g.fillRect(x + 1, y + 1, this.iPriceWidth, fontHeading.getHeight());
                    g.setColor(0xFFFFFF);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * 4 + 1], x + 2, y + 1, 20);
                    x += this.iPriceWidth + 2;
                    g.setColor(13485061);
                    g.drawRect(++x, y, this.iPriceWidth + 1, fontHeading.getHeight() + 1);
                    g.setColor(0xFF5050);
                    g.fillRect(x + 1, y + 1, this.iPriceWidth, fontHeading.getHeight());
                    g.setColor(0xFFFFFF);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * 4 + 3], x + 2, y + 1, 20);
                    x += this.iPriceWidth + 2;
                    g.setColor(13485061);
                    g.drawRect(++x, y, this.iPriceWidth + 1, fontHeading.getHeight() + 1);
                    g.setColor(0xFF5050);
                    g.fillRect(x + 1, y + 1, this.iPriceWidth, fontHeading.getHeight());
                    g.setColor(0xFFFFFF);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * 4 + 2], x + 2, y + 1, 20);
                    g.setFont(fontHeading);
                    g.setColor(0xFFFFFF);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * 4 + 20], x += this.iPriceWidth + 6, y + 1, 20);
                    g.setFont(fontContent);
                    g.drawString(": ", x += iHeadWidth + 3, y + 1, 20);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * 4 + 21], x += fontContent.stringWidth(": "), y + 1, 20);
                    g.setFont(fontHeading);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * 4 + 22], x += this.iPriceWidth + 6, y + 1, 20);
                    g.setFont(fontContent);
                    g.drawString(": ", x += iHeadWidth + 3, y + 1, 20);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * 4 + 23], x += fontContent.stringWidth(": "), y + 1, 20);
                } else {
                    int iColonWidth = fontContent.stringWidth(": ");
                    g.setColor(0xFFFFFF);
                    g.setFont(fontHeading);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * 4 + 20], x, (y += 3) + 1, 20);
                    g.setFont(fontContent);
                    g.drawString(": ", (x += this.iPriceWidth + 4) - iColonWidth, y + 1, 20);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * 4 + 21], x + 2, y + 1, 20);
                    g.setFont(fontHeading);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * 4 + 22], x += this.iPriceWidth + 4, y + 1, 20);
                    g.setFont(fontContent);
                    g.drawString(": ", (x += this.iPriceWidth + 4) - iColonWidth, y + 1, 20);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * 4 + 23], x, y + 1, 20);
                    g.setFont(fontHeading);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * 4 + 24], x += this.iPriceWidth + 4, y + 1, 20);
                    g.setFont(fontContent);
                    g.drawString(": ", x += iHeadWidth + 3, y + 1, 20);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * 4 + 25], x += fontContent.stringWidth(": "), y + 1, 20);
                    g.setFont(fontHeading);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * 4 + 26], x += this.iPriceWidth + 6, y + 1, 20);
                    g.setFont(fontContent);
                    g.drawString(": ", x += iHeadWidth + 3, y + 1, 20);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * 4 + 27], x += fontContent.stringWidth(": "), y + 1, 20);
                }
                x = 1;
                y += iFontHeight;
                continue;
            }
            if (this.iMaxNoOfColumns == 4) {
                for (j = 0; j < this.iMaxNoOfColumns; ++j) {
                    if (iCurrentPageStartIndex + i * this.iMaxNoOfColumns < 20) {
                        g.setColor(13485061);
                        g.drawRect(++x, y, this.iPriceWidth + 1, fontHeading.getHeight() + 1);
                        g.setColor((iCurrentPageStartIndex + i * this.iMaxNoOfColumns + j) % 4 == 0 || (iCurrentPageStartIndex + i * this.iMaxNoOfColumns + j) % 4 == 1 ? 4885759 : 0xFF5050);
                        g.fillRect(x + 1, y + 1, this.iPriceWidth, fontHeading.getHeight());
                        g.setColor(0xFFFFFF);
                        g.setFont(fontContent);
                        g.drawString(this.strData[iCurrentPageStartIndex + i * this.iMaxNoOfColumns + j], x + 2, y + 1, 20);
                        x += this.iPriceWidth + 2;
                    } else if (iCurrentPageStartIndex + i * this.iMaxNoOfColumns + j < 48) {
                        g.setColor(0xFFFFFF);
                        g.drawString(this.strData[iCurrentPageStartIndex + i * this.iMaxNoOfColumns + j], x, y + 1, 20);
                        if ((iCurrentPageStartIndex + i * this.iMaxNoOfColumns + j) % 2 == 0) {
                            g.setFont(fontContent);
                            g.drawString(": ", x += iHeadWidth + 3, y + 1, 20);
                            x += fontContent.stringWidth(": ");
                        } else {
                            x += this.iPriceWidth + 6;
                            g.setFont(fontHeading);
                        }
                    }
                    if (iCurrentPageStartIndex + i * this.iMaxNoOfColumns + j != 19) continue;
                    y += 3;
                }
                x = 1;
                y += iFontHeight;
                continue;
            }
            for (j = 0; j < this.iMaxNoOfColumns; ++j) {
                if (iCurrentPageStartIndex + i * this.iMaxNoOfColumns < 10) {
                    switch (this.iViewMode) {
                        case 0: {
                            g.setColor(13485061);
                            g.drawRect(++x, y, this.iPriceWidth + 1, fontHeading.getHeight() + 1);
                            g.setColor((iCurrentPageStartIndex + i * this.iMaxNoOfColumns + j) % 2 == 0 ? 4885759 : 0xFF5050);
                            g.fillRect(x + 1, y + 1, this.iPriceWidth, fontHeading.getHeight());
                            g.setColor(0xFFFFFF);
                            g.setFont(fontContent);
                            g.drawString(this.strData[iCurrentPageStartIndex + i * this.iMaxNoOfColumns * 2 + j * 2 + 1], x + 2, y + 1, 20);
                            x += this.iPriceWidth + 2;
                            break;
                        }
                        case 1: {
                            g.setColor(13485061);
                            g.drawRect(++x, y, this.iPriceWidth + 1, fontHeading.getHeight() + 1);
                            g.setColor(4885759);
                            g.fillRect(x + 1, y + 1, this.iPriceWidth, fontHeading.getHeight());
                            g.setColor(0xFFFFFF);
                            g.setFont(fontContent);
                            g.drawString(this.strData[iCurrentPageStartIndex + i * this.iMaxNoOfColumns * 2 + j], x + 2, y + 1, 20);
                            x += this.iPriceWidth + 2;
                            break;
                        }
                        case 2: {
                            g.setColor(13485061);
                            g.drawRect(++x, y, this.iPriceWidth + 1, fontHeading.getHeight() + 1);
                            g.setColor(0xFF5050);
                            g.fillRect(x + 1, y + 1, this.iPriceWidth, fontHeading.getHeight());
                            g.setColor(0xFFFFFF);
                            g.setFont(fontContent);
                            g.drawString(this.strData[iCurrentPageStartIndex + i * this.iMaxNoOfColumns * 2 + j + 2], x + 2, y + 1, 20);
                            x += this.iPriceWidth + 2;
                        }
                    }
                } else if (iCurrentPageStartIndex + i * this.iMaxNoOfColumns + j < 38) {
                    g.setColor(0xFFFFFF);
                    g.drawString(this.strData[iCurrentPageStartIndex + i * this.iMaxNoOfColumns + j + 10], x, y + 1, 20);
                    if ((iCurrentPageStartIndex + i * this.iMaxNoOfColumns + j + 10) % 2 == 0) {
                        g.setFont(fontContent);
                        g.drawString(": ", x += iHeadWidth + 3, y + 1, 20);
                        x += fontContent.stringWidth(": ");
                    } else {
                        x += this.iPriceWidth + 6;
                        g.setFont(fontHeading);
                    }
                }
                if (iCurrentPageStartIndex + i * this.iMaxNoOfColumns + j + 10 != 19) continue;
                y += 3;
            }
            x = 1;
            y += iFontHeight;
        }
        this.canvas.setPageInfo("Pg: " + (this.iCurrentIndex + 1) + "/" + this.iMaxNoOfPages);
    }

    public void paintScroller(Graphics g) {
        if (this.iCurrentIndex != 0 && this.iCurrentIndex <= this.iMaxNoOfPages - 1) {
            JPlatformCanvas.drawUpArrow(g);
        }
        if (this.iCurrentIndex >= 0 && this.iCurrentIndex != this.iMaxNoOfPages - 1) {
            JPlatformCanvas.drawDownArrow(g);
        }
    }

    public void SetData(int piSegmentId, String strpKey, String[] strBestFiveData, int iLTP, int iVolume, int iOpen, int iHigh, int iLow, int iClose, int iTBQ, int iTSQ, int iLUT, int iDivisionFactor, int iATP, long iValue) {
        if (piSegmentId == Integer.parseInt(this.strStoreData[0]) && this.strStoreData[2].startsWith(strpKey)) {
            iDivisionFactor = this.iDivision;
            int iSegmentId = Integer.parseInt(this.strStoreData[0]);
            for (int i = 0; i < 20 && null != strBestFiveData[i]; ++i) {
                this.strData[i] = strBestFiveData[i];
            }
            this.strData[21] = Utilities.ToString(iVolume);
            this.strData[23] = iSegmentId == 34 ? Utilities.ConvertToDecimal(iValue, 9, iSegmentId) : (iSegmentId == 10 ? " " : Utilities.ConvertToDecimal(iValue, 4, iSegmentId));
            this.strData[25] = Utilities.ConvertToDecimal(iLTP, iDivisionFactor, iSegmentId);
            this.strData[27] = Utilities.ConvertToDecimal(iATP, iDivisionFactor, iSegmentId);
            if (iClose > iLTP) {
                this.strData[29] = "-" + Utilities.ConvertToDecimal(iClose - iLTP, iDivisionFactor, iSegmentId);
                long iDifference = (long)(iClose - iLTP) * 10000L / (long)iClose;
                this.strData[31] = iDifference < 0L ? Utilities.ConvertToDecimal(iDifference, 2, iSegmentId) : "-" + Utilities.ConvertToDecimal(iDifference, 2, iSegmentId);
            } else if (iLTP > iClose) {
                this.strData[29] = "+" + Utilities.ConvertToDecimal(iLTP - iClose, iDivisionFactor, iSegmentId);
                long iDifference = (long)(iLTP - iClose) * 10000L / (long)iClose;
                this.strData[31] = iDifference < 0L ? "+" + Utilities.ConvertToDecimal(iDifference, 2, iSegmentId).substring(1) : "+" + Utilities.ConvertToDecimal(iDifference, 2, iSegmentId);
            } else {
                this.strData[29] = "";
                this.strData[31] = "";
            }
            this.strData[33] = Utilities.ConvertToDecimal(iOpen, iDivisionFactor, iSegmentId);
            this.strData[35] = Utilities.ConvertToDecimal(iHigh, iDivisionFactor, iSegmentId);
            this.strData[37] = Utilities.ConvertToDecimal(iLow, iDivisionFactor, iSegmentId);
            this.strData[39] = Utilities.ConvertToDecimal(iClose, iDivisionFactor, iSegmentId);
            this.strData[41] = Utilities.ToString(iTBQ);
            this.strData[43] = Utilities.ToString(iTSQ);
            this.strData[45] = Utilities.GetFormattedTime(iLUT);
            this.canvas.refreshDisplay();
        }
        AppConstants.profilelist.checkAlerts(strpKey, iLTP, iLUT);
    }

    public void SetIndexData(int piSegmentId, String strpKey, int iLTP, int iClose, int iLUT, int iDivisionFactor) {
        if (piSegmentId == Integer.parseInt(this.strStoreData[0]) && this.strStoreData[2].startsWith(strpKey)) {
            iDivisionFactor = this.iDivision;
            int iSegmentId = Integer.parseInt(this.strStoreData[0]);
            this.strData[25] = Utilities.ConvertToDecimal(iLTP, iDivisionFactor, iSegmentId);
            if (iSegmentId == 3 || iSegmentId == 4) {
                if (iClose > iLTP && iClose > 0 && iLTP > 0) {
                    this.strData[29] = "-" + Utilities.ConvertToDecimal(iClose - iLTP, iDivisionFactor, iSegmentId);
                    long iDifference = (long)(iClose - iLTP) * 10000L / (long)iClose;
                    this.strData[31] = "-" + Utilities.ConvertToDecimal(iDifference, 2, iSegmentId);
                } else if (iLTP > iClose && iClose > 0 && iLTP > 0) {
                    this.strData[29] = "+" + Utilities.ConvertToDecimal(iLTP - iClose, iDivisionFactor, iSegmentId);
                    long iDifference = (long)(iLTP - iClose) * 10000L / (long)iClose;
                    this.strData[31] = "+" + Utilities.ConvertToDecimal(iDifference, 2, iSegmentId);
                } else {
                    this.strData[29] = "";
                    this.strData[31] = "";
                }
            } else {
                this.strData[29] = Utilities.ConvertToDecimal(iLTP - iClose, iDivisionFactor, iSegmentId);
                long iDifference = (long)(iLTP - iClose) * 10000L / (long)iClose;
                this.strData[31] = Utilities.ConvertToDecimal(iDifference, 2, iSegmentId);
            }
            this.strData[39] = Utilities.ConvertToDecimal(iClose, iDivisionFactor, iSegmentId);
            this.strData[45] = Utilities.GetFormattedTime(iLUT);
            this.canvas.refreshDisplay();
        }
        AppConstants.profilelist.checkAlerts(strpKey, iLTP, iLUT);
    }

    public void setOpenInt(int piSegmentId, String strpKey, int iOpenInt) {
        if (piSegmentId == Integer.parseInt(this.strStoreData[0]) && this.strStoreData[2].startsWith(strpKey)) {
            this.strData[47] = Utilities.ToString(iOpenInt);
            this.canvas.refreshDisplay();
        }
    }

    public void keyPressed(int keycode) {
        switch (keycode) {
            case -1: 
            case 50: 
            case 221: {
                --this.iCurrentIndex;
                if (this.iCurrentIndex > 0) break;
                this.iCurrentIndex = 0;
                break;
            }
            case -2: 
            case 56: 
            case 222: {
                ++this.iCurrentIndex;
                if (this.iCurrentIndex < this.iMaxNoOfPages) break;
                this.iCurrentIndex = this.iMaxNoOfPages - 1;
                break;
            }
            default: {
                JPlatformCanvas.getInstance().processSoftKeys(keycode);
            }
        }
    }

    public void pointerPressed(String fsSection, int x, int y) {
        if (fsSection.equals("FOOTER")) {
            ++this.iCurrentIndex;
            if (this.iCurrentIndex >= this.iMaxNoOfPages) {
                this.iCurrentIndex = this.iMaxNoOfPages - 1;
            }
        } else if (fsSection.equals("HEADER")) {
            --this.iCurrentIndex;
            if (this.iCurrentIndex <= 0) {
                this.iCurrentIndex = 0;
            }
        }
    }

    public int getPriceMultiplier(String strKey) {
        if (this.strStoreData[2].startsWith(strKey)) {
            return this.iDivision;
        }
        return 1;
    }

    public boolean jcommandAction(SoftKey softKey, Displayable d) {
        if (softKey.getLabel().equals("Back")) {
            AppConstants.iCurrentPage = (byte)5;
            AppConstants.sendrequest.stopTouchlineRequest(iWinRefresh.getInstance().showform.marketwatch.iCurrentIndex, 1, 1);
            AppConstants.sendrequest.startTouchlineRequest(iWinRefresh.getInstance().showform.marketwatch.iCurrentPageStartIndex, iWinRefresh.getInstance().showform.marketwatch.iMaxScriptsPerPage, 0);
            iWinRefresh.getInstance().showform.showMarketWatch();
            return true;
        }
        if (softKey.getLabel().equals("Select")) {
            String strCommandName = this.canvas.getCommandName();
            if (strCommandName.equals("Buy Depth")) {
                this.iViewMode = 1;
                this.iCurrentIndex = 0;
            } else if (strCommandName.equals("Sell Depth")) {
                this.iViewMode = 2;
                this.iCurrentIndex = 0;
            } else if (strCommandName.equals("Refresh")) {
                this.iViewMode = 0;
                this.iCurrentIndex = 0;
            }
            return true;
        }
        return false;
    }
}

