/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.JPlatformCanvas;
import GeneralUI.ScreenPointerDefinition;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import common.Utilities;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import market.iWinRefresh;

public class EconomicData
implements Runnable,
JCommandListener {
    private String[][] strData;
    private int iMaxPageNo = 0;
    private int iFontHeight = AppConstants.FONT_HEADING.getHeight() + 1;
    private Thread t;
    private int iHeadingX = 2;
    private int iCurrentPage = 0;
    private int iTotalPage = 0;
    private String title;
    private int iDataRowStartY = 0;
    private int iDataRowEndY = 0;
    private int iRowHeight = 0;
    private int iTotalLines = 1;
    private int iStartIndex = 0;
    private int iEndIndex = 0;
    private int iCurrentSelect = 0;
    private int count = 0;
    private int MAXDISPLAYABLEITEMS = 0;
    private int iSelectedHeadingWidth = 0;

    EconomicData() {
    }

    public void setData(String[][] strpData, int ipCurrentPage, int ipTotalPage, String strpFormName) {
        if (this.t == null) {
            AppConstants.bCommonCanvasThread = true;
            this.t = new Thread(this);
            this.t.start();
        }
        this.iSelectedHeadingWidth = 0;
        this.iHeadingX = 2;
        this.strData = strpData;
        this.iCurrentPage = ipCurrentPage;
        this.iTotalPage = ipTotalPage;
        this.setTitle(strpFormName);
        this.iTotalLines = (JPlatformCanvas.SCREEN_HEIGHT - (JPlatformCanvas.TITLE_BAR_HEIGHT + 1) - JPlatformCanvas.SOFT_KEYBAR_HEIGHT) / this.iFontHeight - 1;
        this.iStartIndex = 0;
        this.iEndIndex = this.strData.length < this.iTotalLines / 2 ? this.strData.length : this.iTotalLines / 2;
        this.iCurrentSelect = 0;
        this.MAXDISPLAYABLEITEMS = this.iTotalLines / 2;
        this.count = this.strData.length;
    }

    public String[][] getData() {
        return this.strData;
    }

    public int getCurrentPage() {
        return this.iCurrentPage;
    }

    public int getTotalPage() {
        return this.iTotalPage;
    }

    public void paint(Graphics g) {
        int x = 2;
        int y = JPlatformCanvas.TITLE_BAR_HEIGHT + 1;
        int iStartY = JPlatformCanvas.TITLE_BAR_HEIGHT + 1;
        boolean iCurrentPageNo = false;
        int iMaxWidth = JPlatformCanvas.SCREEN_WIDTH;
        int iMaxHeight = JPlatformCanvas.SCREEN_HEIGHT;
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, iMaxWidth, iMaxHeight);
        if (this.strData.length == 0 || this.strData == null) {
            g.setColor(0);
            g.setFont(AppConstants.FONT_HEADING);
            g.drawString("No Data", x, y, 20);
            return;
        }
        for (int i = this.iStartIndex; i < this.iEndIndex; ++i) {
            if (i == this.iCurrentSelect) {
                Image img = this.getTransparentBackground(iMaxWidth, this.iFontHeight, 0, 140);
                g.drawImage(img, 0, y, 0x10 | 4);
                g.setColor(0xFFFFFF);
                this.iSelectedHeadingWidth = AppConstants.FONT_CONTENT.stringWidth(this.strData[i][0] + " " + this.strData[i][1] + " " + this.strData[i][2]) > AppConstants.FONT_CONTENT.stringWidth("Actual:" + this.strData[i][3] + " Forecast:" + this.strData[i][4] + " Previous:" + this.strData[i][5]) ? AppConstants.FONT_CONTENT.stringWidth(this.strData[i][0] + " " + this.strData[i][1] + " " + this.strData[i][2]) : AppConstants.FONT_CONTENT.stringWidth("Actual:" + this.strData[i][3] + " Forecast:" + this.strData[i][4] + " Previous:" + this.strData[i][5]);
                g.setFont(AppConstants.FONT_HEADING);
                g.drawString(this.strData[i][0] + " " + this.strData[i][1] + " " + this.strData[i][2], this.iSelectedHeadingWidth > JPlatformCanvas.SCREEN_WIDTH - 4 ? this.iHeadingX : x, y, 20);
                g.drawImage(img, 0, y + this.iFontHeight, 0x10 | 4);
                g.setColor(0);
                g.setFont(AppConstants.FONT_CONTENT);
                g.drawString("Actual:" + this.strData[i][3] + " Forecast:" + this.strData[i][4] + " Previous:" + this.strData[i][5], AppConstants.FONT_CONTENT.stringWidth("Actual:" + this.strData[i][3] + " Forecast:" + this.strData[i][4] + " Previous:" + this.strData[i][5]) > iMaxWidth ? this.iHeadingX : x, y + this.iFontHeight, 20);
            } else if (i % 2 == 0) {
                g.setColor(9613776);
                g.fillRect(0, y, iMaxWidth, this.iFontHeight);
                g.setColor(0);
                g.setFont(AppConstants.FONT_HEADING);
                g.drawString(this.strData[i][0] + " " + this.strData[i][1] + " " + this.strData[i][2], x, y, 20);
                g.setColor(9613776);
                g.fillRect(0, y + this.iFontHeight, iMaxWidth, this.iFontHeight);
                g.setColor(0);
                g.setFont(AppConstants.FONT_CONTENT);
                g.drawString("Actual:" + this.strData[i][3] + " Forecast:" + this.strData[i][4] + " Previous:" + this.strData[i][5], x, y + this.iFontHeight, 20);
            } else {
                g.setColor(0);
                g.setFont(AppConstants.FONT_HEADING);
                g.drawString(this.strData[i][0] + " " + this.strData[i][1] + " " + this.strData[i][2], x, y, 20);
                g.setFont(AppConstants.FONT_CONTENT);
                g.drawString("Actual:" + this.strData[i][3] + " Forecast:" + this.strData[i][4] + " Previous:" + this.strData[i][5], x, y + this.iFontHeight, 20);
            }
            y += 2 * this.iFontHeight;
            if (!JPlatformCanvas.getInstance().hasPointerEvents()) continue;
            ScreenPointerDefinition.setPointer(this.getTitle(), this.strData[i][0] + this.strData[i][1] + this.strData[i][2], 0, y - 2 * this.iFontHeight, iMaxWidth, y);
            System.out.println("INSIDE PAINT, SECTION NAME : " + this.strData[i][0]);
        }
        this.iDataRowEndY = y;
        this.iRowHeight = (this.iDataRowEndY - this.iDataRowStartY) / this.iTotalLines;
        g.setColor(0);
        g.drawString("Page[" + this.iCurrentPage + "/" + this.iTotalPage + "]", iMaxWidth, iMaxHeight - JPlatformCanvas.SOFT_KEYBAR_HEIGHT - 1, 40);
        g.drawString("Event[" + (this.iCurrentSelect + 1) + "/" + this.count + "]", 1, iMaxHeight - JPlatformCanvas.SOFT_KEYBAR_HEIGHT - 1, 36);
    }

    private Image getTransparentBackground(int f_width, int f_height, int f_nRGB, int f_nTransparency) {
        int width = f_width;
        int height = f_height;
        Image im = Image.createImage((int)width, (int)height);
        int[] irgbData = new int[width * height];
        im.getRGB(irgbData, 0, width, 0, 0, width, height);
        int l_nTransparency = f_nTransparency << 24;
        int l_nRBG = f_nRGB;
        for (int i = 0; i < irgbData.length; ++i) {
            irgbData[i] = l_nTransparency + l_nRBG;
        }
        im = Image.createRGBImage((int[])irgbData, (int)width, (int)height, (boolean)true);
        return im;
    }

    public void run() {
        try {
            while (AppConstants.bCommonCanvasThread) {
                if (this.iSelectedHeadingWidth > JPlatformCanvas.SCREEN_WIDTH - 4) {
                    JPlatformCanvas.getInstance().refreshDisplay();
                    this.iHeadingX = this.iHeadingX + this.iSelectedHeadingWidth > 3 * (JPlatformCanvas.SCREEN_WIDTH >> 2) ? --this.iHeadingX : JPlatformCanvas.SCREEN_WIDTH >> 2;
                } else {
                    this.iHeadingX = 2;
                }
                Thread.sleep(30L);
            }
        }
        catch (Exception e) {
            Utilities.printLog("CommonCanvas-run " + e.toString());
        }
    }

    public boolean jcommandAction(SoftKey softkey, Displayable d) {
        if (softkey.getLabel().equals("Select")) {
            iWinRefresh.iPreviousForm = 5;
            String strCommandName = JPlatformCanvas.getInstance().getCommandName();
            if (strCommandName.equalsIgnoreCase("Filter")) {
                this.dispose();
                iWinRefresh.getInstance().showform.showSelectEconSymbol();
                return true;
            }
            if (strCommandName.equalsIgnoreCase("Next")) {
                if (this.iCurrentPage == 0) {
                    return false;
                }
                if (this.iCurrentPage >= this.iTotalPage) {
                    return false;
                }
                this.dispose();
                ++this.iCurrentPage;
                iWinRefresh.getInstance().showProgressBar();
                if (iWinRefresh.getInstance().showform.selectExchange != null && AppConstants.selectEvent) {
                    int l_countryIndex = iWinRefresh.getInstance().showform.selectExchange.getCountryIndex();
                    int l_frequencyIndex = iWinRefresh.getInstance().showform.selectExchange.getFrequencyIndex();
                    AppConstants.sendrequest.sendEconSymbolLookupRequest(iWinRefresh.getInstance().showform.selectExchange.getIndexAcctoCountry(l_countryIndex), iWinRefresh.getInstance().showform.selectExchange.getIndexAcctoFrequency(l_frequencyIndex), this.iCurrentPage);
                    return true;
                }
                if (AppConstants.bECOINDIA && AppConstants.bECOWORLD) {
                    AppConstants.sendrequest.sendEconSymbolLookupRequest("-1", "-1", this.iCurrentPage);
                } else if (AppConstants.bECOINDIA) {
                    AppConstants.sendrequest.sendEconSymbolLookupRequest("1", "-1", this.iCurrentPage);
                } else {
                    AppConstants.sendrequest.sendEconSymbolLookupRequest("-2", "-1", this.iCurrentPage);
                }
                return true;
            }
            if (strCommandName.equalsIgnoreCase("Prev")) {
                if (this.iCurrentPage <= 1) {
                    this.iCurrentPage = 1;
                    return false;
                }
                this.dispose();
                --this.iCurrentPage;
                iWinRefresh.getInstance().showProgressBar();
                if (iWinRefresh.getInstance().showform.selectExchange != null && AppConstants.selectEvent) {
                    int l_countryIndex = iWinRefresh.getInstance().showform.selectExchange.getCountryIndex();
                    int l_frequencyIndex = iWinRefresh.getInstance().showform.selectExchange.getFrequencyIndex();
                    AppConstants.sendrequest.sendEconSymbolLookupRequest(iWinRefresh.getInstance().showform.selectExchange.getIndexAcctoCountry(l_countryIndex), iWinRefresh.getInstance().showform.selectExchange.getIndexAcctoFrequency(l_frequencyIndex), this.iCurrentPage);
                    return true;
                }
                if (AppConstants.bECOINDIA && AppConstants.bECOWORLD) {
                    AppConstants.sendrequest.sendEconSymbolLookupRequest("-1", "-1", this.iCurrentPage);
                } else if (AppConstants.bECOINDIA) {
                    AppConstants.sendrequest.sendEconSymbolLookupRequest("1", "-1", this.iCurrentPage);
                } else {
                    AppConstants.sendrequest.sendEconSymbolLookupRequest("-2", "-1", this.iCurrentPage);
                }
                return true;
            }
            if (strCommandName.equalsIgnoreCase("Details")) {
                this.dispose();
                iWinRefresh.getInstance().showProgressBar();
                AppConstants.strCountryId = this.getCountryName().equalsIgnoreCase("India") ? "1" : "-1";
                AppConstants.sendrequest.sendEconomicDetailRequest(this.strData[this.iCurrentSelect][6]);
                return true;
            }
        } else if (softkey.getLabel().equals("Back")) {
            AppConstants.selectEvent = false;
            this.dispose();
            iWinRefresh.getInstance().showform.showMainMenu();
            return true;
        }
        return false;
    }

    private int getCondition(String strCondition) {
        if (strCondition.equals(">")) {
            return 10;
        }
        if (strCondition.equals("<")) {
            return 11;
        }
        return 12;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void keyPressed(int keycode) {
        switch (keycode) {
            case 56: 
            case 222: {
                if (this.iCurrentSelect != this.count - 1 && this.count > 0) {
                    this.iCurrentSelect = (this.iCurrentSelect + 1) % this.count;
                    this.adjustMenu();
                }
                this.iHeadingX = 2;
                break;
            }
            case 50: 
            case 221: {
                if (this.iCurrentSelect != 0 && this.count > 0) {
                    this.iCurrentSelect = ((this.iCurrentSelect - 1) % this.count + this.count) % this.count;
                    this.adjustMenu();
                }
                this.iHeadingX = 2;
                break;
            }
            default: {
                JPlatformCanvas.getInstance().processSoftKeys(keycode);
            }
        }
    }

    private void adjustMenu() {
        if (this.iCurrentSelect < this.iStartIndex) {
            this.iStartIndex = this.iCurrentSelect;
            this.iEndIndex = this.iStartIndex + this.MAXDISPLAYABLEITEMS;
        } else if (this.iCurrentSelect >= this.iEndIndex) {
            this.iEndIndex = this.iCurrentSelect + 1;
            this.iStartIndex = this.iEndIndex - this.MAXDISPLAYABLEITEMS;
        } else if (this.iEndIndex - this.iStartIndex < this.MAXDISPLAYABLEITEMS) {
            --this.iStartIndex;
        }
        if (this.iEndIndex >= this.count) {
            this.iEndIndex = this.count;
        }
        if (this.iStartIndex < 0) {
            this.iStartIndex = 0;
        }
    }

    public void paintScroller(Graphics g) {
        if (this.iCurrentSelect >= this.MAXDISPLAYABLEITEMS | this.iStartIndex > 0) {
            JPlatformCanvas.drawUpArrow(g);
        }
        if (this.size() > this.MAXDISPLAYABLEITEMS & this.iCurrentSelect < this.size() - 1) {
            JPlatformCanvas.drawDownArrow(g);
        }
    }

    public int size() {
        return this.count;
    }

    private void dispose() {
        AppConstants.bCommonCanvasThread = false;
        this.t = null;
    }

    public String getCurrentScripName() {
        return this.strData[this.iCurrentSelect][2];
    }

    public String getCountryName() {
        return this.strData[this.iCurrentSelect][1];
    }

    public boolean isPointerSelected(String lsSection) {
        for (int i = 0; i <= this.size(); ++i) {
            if (!lsSection.equals(this.strData[i][0])) continue;
            if (i == this.iCurrentSelect) {
                this.adjustMenu();
                return true;
            }
            this.iCurrentSelect = i;
            return false;
        }
        return false;
    }

    public void pointerPressed(String fsSection, int x, int y) {
        if (fsSection.equals("HEADER")) {
            if (this.iCurrentSelect != 0 && this.count > 0) {
                this.iCurrentSelect = ((this.iCurrentSelect - 1) % this.count + this.count) % this.count;
                this.adjustMenu();
            }
            this.iHeadingX = 2;
        } else if (fsSection.equals("FOOTER")) {
            if (this.iCurrentSelect != this.count - 1 && this.count > 0) {
                this.iCurrentSelect = (this.iCurrentSelect + 1) % this.count;
                this.adjustMenu();
            }
            this.iHeadingX = 2;
        } else if (this.strData != null && this.strData.length > 0) {
            for (int i = 0; i < this.strData.length; ++i) {
                if (!(this.strData[i][0] + this.strData[i][1] + this.strData[i][2]).equals(fsSection)) continue;
                this.iCurrentSelect = i;
                System.out.println("INSIDE POINTERPRESSED : " + this.strData[i][0] + "  " + this.iCurrentSelect);
                break;
            }
            this.iHeadingX = 2;
        }
    }
}

