/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.JPlatformCanvas;
import GeneralUI.ScreenPointerDefinition;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import market.iWinRefresh;

public class MarketInfo
implements JCommandListener {
    private String[][] strData;
    private int iCurrentIndex = 0;
    private int iMaxPages = 0;
    private int iNoOfRows = 1;
    private int iValueWidth;
    private int iHeadingWidth;
    private int iNoOfRecords = -1;
    private int iCurrentPageStartIndex = 0;
    private int iNoOfScripts = 0;
    private Image img;
    private int iPageNo = 0;
    private int iMaxPageNo = 0;

    public int getResponseDataLength() {
        return this.iNoOfRecords;
    }

    public void setData(String[][] strpData) {
        this.iMaxPages = 1;
        this.strData = strpData;
        this.iNoOfRecords = this.strData.length;
        this.iCurrentIndex = 0;
        this.iHeadingWidth = 0;
        this.iNoOfRows = 1;
        for (int i = 0; i < this.iNoOfRecords; ++i) {
            int iDataLength = AppConstants.FONT_HEADING.stringWidth(strpData[i][0]);
            if (iDataLength <= this.iHeadingWidth) continue;
            this.iHeadingWidth = iDataLength;
        }
        this.iValueWidth = AppConstants.FONT_CONTENT.stringWidth("00000.00");
        if (AppConstants.iListIndex == 5 || AppConstants.iListIndex == 8) {
            if (this.iHeadingWidth + this.iValueWidth > JPlatformCanvas.SCREEN_WIDTH - 2) {
                this.iHeadingWidth = JPlatformCanvas.SCREEN_WIDTH - this.iValueWidth - 2;
            }
        } else {
            this.iHeadingWidth += 10;
            if (this.iHeadingWidth + (this.iValueWidth << 1) > JPlatformCanvas.SCREEN_WIDTH - 2) {
                ++this.iNoOfRows;
            }
        }
    }

    public void setData(int ipCurrentPage, int ipTotalPage) {
        this.iPageNo = ipCurrentPage;
        this.iMaxPageNo = ipTotalPage;
    }

    public void setData(byte[] f_btImage) {
        this.img = f_btImage != null ? Image.createImage((byte[])f_btImage, (int)0, (int)f_btImage.length) : null;
        JPlatformCanvas.getInstance().refreshDisplay();
    }

    public void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, JPlatformCanvas.SCREEN_WIDTH, JPlatformCanvas.SCREEN_HEIGHT);
        switch (AppConstants.iListIndex) {
            case 0: 
            case 1: 
            case 6: 
            case 7: {
                this.showRecords(g, "LTP", "%Chg");
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.showRecords(g, "LTP", "Vol(Lks)");
                break;
            }
            case 5: 
            case 8: {
                this.showIndexInfo(g);
                break;
            }
            case 9: {
                this.showChart(g);
            }
        }
    }

    private void showChart(Graphics g) {
        int x = JPlatformCanvas.SCREEN_WIDTH / 2;
        int y = JPlatformCanvas.SCREEN_HEIGHT / 2;
        if (this.img != null) {
            g.drawImage(this.img, x, y, 1 | 2);
        } else {
            g.setFont(AppConstants.FONT_HEADING);
            g.setColor(0);
            g.drawString("Chart not available", x, y, 0x20 | 1);
        }
    }

    public boolean jcommandAction(SoftKey softkey, Displayable d) {
        if (softkey.getLabel().equals("Details")) {
            if (this.iNoOfRecords > 0) {
                int iTemp = this.strData[this.iCurrentIndex].length;
                String[] strDisplayData = new String[iTemp];
                for (int i = 0; i < iTemp; ++i) {
                    strDisplayData[i] = this.strData[this.iCurrentIndex][i];
                }
                iWinRefresh.iPreviousForm = 22;
                iWinRefresh.getInstance().showform.showViewDetails((byte)14);
                iWinRefresh.getInstance().showform.viewdetails.setMarketInfoData(strDisplayData);
            }
            return true;
        }
        if (softkey.getLabel().equals("Select")) {
            String strCommand = JPlatformCanvas.getInstance().getCommandName();
            if (strCommand.equals("Details")) {
                int iTemp = this.strData[this.iCurrentIndex].length;
                String[] strDisplayData = new String[iTemp];
                for (int i = 0; i < this.strData[0].length; ++i) {
                    strDisplayData[i] = this.strData[this.iCurrentIndex][i];
                }
                iWinRefresh.iPreviousForm = 22;
                iWinRefresh.getInstance().showform.showViewDetails((byte)31);
                iWinRefresh.getInstance().showform.viewdetails.setMarketInfoData(strDisplayData);
                return true;
            }
            if (strCommand.equals("Next")) {
                if (this.iMaxPageNo == 0) {
                    return false;
                }
                if (this.iPageNo >= this.iMaxPageNo) {
                    return false;
                }
                ++this.iPageNo;
                iWinRefresh.getInstance().showProgressBar();
                AppConstants.sendrequest.sendWorldIndicesRequest(AppConstants.iMarketSegmentId + 1, this.iPageNo);
                return true;
            }
            if (strCommand.equals("Prev")) {
                if (this.iMaxPageNo == 0) {
                    return false;
                }
                --this.iPageNo;
                if (this.iPageNo <= 0) {
                    this.iPageNo = 1;
                    return false;
                }
                iWinRefresh.getInstance().showProgressBar();
                AppConstants.sendrequest.sendWorldIndicesRequest(AppConstants.iMarketSegmentId + 1, this.iPageNo);
                return true;
            }
            if (strCommand.equals("Menu")) {
                iWinRefresh.getInstance().showform.showMainMenu();
                return true;
            }
        } else if (softkey.getLabel().equals("Back")) {
            if (AppConstants.iListIndex == 9) {
                iWinRefresh.getInstance().backForm(5);
            } else if (AppConstants.iListIndex == 8) {
                iWinRefresh.getInstance().showform.showWorldIndices();
            } else if (AppConstants.iListIndex == 6 || AppConstants.iListIndex == 7) {
                iWinRefresh.getInstance().showform.showMarketInfoHeading();
            } else if (AppConstants.iListIndex == 5) {
                iWinRefresh.getInstance().showform.showSelectExchangeList();
            } else {
                iWinRefresh.getInstance().showform.showSelectInstrument(1);
            }
            return true;
        }
        return false;
    }

    public void paintScroller(Graphics g) {
        if (this.iNoOfScripts > 0) {
            if (this.iMaxPages > 1 & this.iCurrentIndex / this.iNoOfScripts < this.iMaxPages - 1) {
                JPlatformCanvas.drawDownArrow(g);
            }
            if (this.iCurrentIndex / this.iNoOfScripts > 0) {
                JPlatformCanvas.drawUpArrow(g);
            }
        }
    }

    public void keyPressed(int keycode) {
        switch (keycode) {
            case 56: 
            case 222: {
                ++this.iCurrentIndex;
                if (this.iCurrentIndex < this.iNoOfRecords) break;
                this.iCurrentIndex = 0;
                break;
            }
            case 50: 
            case 221: {
                --this.iCurrentIndex;
                if (this.iCurrentIndex >= 0) break;
                this.iCurrentIndex = this.iNoOfRecords - 1;
                break;
            }
            default: {
                JPlatformCanvas.getInstance().processSoftKeys(keycode);
            }
        }
    }

    private void showRecords(Graphics g, String strHeading1, String strHeading2) {
        int x = 2;
        int y = JPlatformCanvas.TITLE_BAR_HEIGHT + 1;
        int iStartY = 2;
        int iCurrentPageNo = 0;
        int iTotalLines = 1;
        int iMaxWidth = JPlatformCanvas.SCREEN_WIDTH;
        int iMaxHeight = JPlatformCanvas.SCREEN_HEIGHT;
        int iFontHeight = AppConstants.FONT_HEADING.getHeight() + 1;
        g.setColor(0);
        g.setFont(AppConstants.FONT_HEADING);
        if (this.strData.length == 0) {
            g.drawString("No Data", x, y, 20);
            return;
        }
        g.drawString(strHeading1, x += this.iNoOfRows == 2 ? 0 : this.iHeadingWidth, y, 20);
        g.drawString(strHeading2, x += 2 * this.iValueWidth, y, 24);
        iTotalLines = (iMaxHeight - (y += iFontHeight)) / iFontHeight - 2;
        this.iNoOfScripts = iTotalLines / this.iNoOfRows;
        if (this.iNoOfScripts > this.strData.length) {
            this.iNoOfScripts = this.strData.length;
        }
        int iColorIndex = this.iCurrentIndex % this.iNoOfScripts;
        iCurrentPageNo = this.iCurrentIndex / this.iNoOfScripts;
        this.iMaxPages = this.strData.length / this.iNoOfScripts;
        if (this.iMaxPages * this.iNoOfScripts < this.strData.length) {
            ++this.iMaxPages;
        }
        this.iCurrentPageStartIndex = iCurrentPageNo * this.iNoOfScripts;
        x = 2;
        for (int i = 0; i < this.iNoOfScripts; ++i) {
            if (this.iCurrentPageStartIndex + i < this.strData.length) {
                if (i == iColorIndex) {
                    g.setColor(1132180);
                    g.fillRect(0, y, iMaxWidth, this.iNoOfRows * iFontHeight);
                    g.setColor(0xFFFFFF);
                } else if (i % 2 == 0) {
                    g.setColor(0xCCCC99);
                    g.fillRect(0, y, iMaxWidth, this.iNoOfRows * iFontHeight);
                    g.setColor(0);
                } else {
                    g.setColor(0);
                }
                g.setFont(AppConstants.FONT_HEADING);
                g.drawString(this.strData[i + this.iCurrentPageStartIndex][0], x, y + 1, 20);
                g.setFont(AppConstants.FONT_CONTENT);
                if (this.iNoOfRows == 2) {
                    g.drawString(this.strData[i + this.iCurrentPageStartIndex][1], x, (y += iFontHeight) + 1, 20);
                    g.drawString(this.strData[i + this.iCurrentPageStartIndex][2], x += 2 * this.iValueWidth, y + 1, 24);
                } else {
                    g.drawString(this.strData[i + this.iCurrentPageStartIndex][1], x += this.iHeadingWidth, y + 1, 20);
                    g.drawString(this.strData[i + this.iCurrentPageStartIndex][2], x += 2 * this.iValueWidth, y + 1, 24);
                }
                x = 2;
                y += iFontHeight;
                if (!JPlatformCanvas.getInstance().hasPointerEvents()) continue;
                ScreenPointerDefinition.setPointer(JPlatformCanvas.getInstance().getTitle(), this.strData[i + this.iCurrentPageStartIndex][0], x, y - iFontHeight, JPlatformCanvas.SCREEN_WIDTH, y);
                continue;
            }
            y += iFontHeight;
        }
        g.setFont(AppConstants.FONT_HEADING);
        g.setColor(0);
        g.drawString(iCurrentPageNo + 1 + "/" + this.iMaxPages, iMaxWidth - 2, iMaxHeight - 2 - JPlatformCanvas.SOFT_KEYBAR_HEIGHT, 40);
    }

    private void showIndexInfo(Graphics g) {
        int x = 2;
        int y = JPlatformCanvas.TITLE_BAR_HEIGHT + 1;
        int iStartY = 2;
        int iCurrentPageNo = 0;
        int iTotalLines = 1;
        int iMaxWidth = JPlatformCanvas.SCREEN_WIDTH;
        int iMaxHeight = JPlatformCanvas.SCREEN_HEIGHT;
        int iFontHeight = AppConstants.FONT_HEADING.getHeight() + 1;
        g.setColor(0);
        g.setFont(AppConstants.FONT_HEADING);
        if (this.strData.length == 0) {
            g.drawString("No Data", x, y, 20);
            return;
        }
        g.drawString("Index Name", this.iHeadingWidth >> 1, y, 17);
        g.drawString("Value", this.iHeadingWidth + (this.iValueWidth >> 1), y, 17);
        iTotalLines = (iMaxHeight - (y += iFontHeight)) / iFontHeight - 2;
        this.iNoOfScripts = iTotalLines / this.iNoOfRows;
        if (this.iNoOfScripts > this.strData.length) {
            this.iNoOfScripts = this.strData.length;
        }
        int iColorIndex = this.iCurrentIndex % this.iNoOfScripts;
        iCurrentPageNo = this.iCurrentIndex / this.iNoOfScripts;
        this.iMaxPages = this.strData.length / this.iNoOfScripts;
        if (this.iMaxPages * this.iNoOfScripts < this.strData.length) {
            ++this.iMaxPages;
        }
        this.iCurrentPageStartIndex = iCurrentPageNo * this.iNoOfScripts;
        x = 2;
        for (int i = 0; i < this.iNoOfScripts; ++i) {
            if (this.iCurrentPageStartIndex + i < this.strData.length) {
                if (i == iColorIndex) {
                    g.setColor(1132180);
                    g.fillRect(0, y, iMaxWidth, this.iNoOfRows * iFontHeight);
                    g.setColor(0xFFFFFF);
                } else if (i % 2 == 0) {
                    g.setColor(0xCCCC99);
                    g.fillRect(0, y, iMaxWidth, this.iNoOfRows * iFontHeight);
                    g.setColor(0);
                } else {
                    g.setColor(0);
                }
                g.setFont(AppConstants.FONT_CONTENT);
                g.setClip(x, y, this.iHeadingWidth - 10, iFontHeight);
                g.drawString(this.strData[i + this.iCurrentPageStartIndex][0], x, y + 1, 20);
                g.setClip(0, 0, iMaxWidth, iMaxHeight);
                g.drawString(this.strData[i + this.iCurrentPageStartIndex][1], this.iHeadingWidth + this.iValueWidth, y + 1, 24);
                x = 2;
                y += iFontHeight;
                if (JPlatformCanvas.getInstance().hasPointerEvents()) {
                    ScreenPointerDefinition.setPointer(JPlatformCanvas.getInstance().getTitle(), this.strData[i + this.iCurrentPageStartIndex][0], x, y - iFontHeight, JPlatformCanvas.SCREEN_WIDTH, y);
                }
            } else {
                y += iFontHeight;
            }
            g.setClip(0, 0, iMaxWidth, iMaxHeight);
        }
        g.setColor(0);
        g.setFont(AppConstants.FONT_HEADING);
        if (AppConstants.iListIndex == 8) {
            g.drawString("[Page " + this.iPageNo + "/" + this.iMaxPageNo + "]", 2, iMaxHeight - 2 - JPlatformCanvas.SOFT_KEYBAR_HEIGHT, 36);
        }
        g.drawString(iCurrentPageNo + 1 + "/" + this.iMaxPages, iMaxWidth - 2, iMaxHeight - 2 - JPlatformCanvas.SOFT_KEYBAR_HEIGHT, 40);
    }

    public void pointerPressed(String lsSection, int x, int y) {
        block3: {
            block4: {
                block2: {
                    if (!lsSection.equals("HEADER")) break block2;
                    --this.iCurrentIndex;
                    if (this.iCurrentIndex > 0) break block3;
                    this.iCurrentIndex = 0;
                    break block3;
                }
                if (!lsSection.equals("FOOTER")) break block4;
                ++this.iCurrentIndex;
                if (this.iCurrentIndex < this.iNoOfRecords) break block3;
                this.iCurrentIndex = this.iNoOfRecords - 1;
                break block3;
            }
            if (this.strData != null && this.strData.length > 0) {
                for (int i = 0; i < this.strData.length; ++i) {
                    if (!this.strData[i][0].equals(lsSection)) continue;
                    this.iCurrentIndex = i;
                    break;
                }
            }
        }
    }
}

