/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.JPlatformCanvas;
import GeneralUI.SoftKey;
import GeneralUI.Table;
import common.AppConstants;
import common.JCommandListener;
import common.Utilities;
import javax.microedition.lcdui.Displayable;
import market.iWinRefresh;

public final class PMSWatch
extends Table
implements JCommandListener {
    private String[][] strHeaderData;
    private String[][] strTransactionData;
    private String[][] strTempTransactionData;
    private String[][] strFinalTransactionData;
    private String[][] strPortfolioData;
    private String strPortfolioTotalValue = "";

    public PMSWatch(String[] Title, String[][] elements, int GridWidth, int GridHeight, int fonType) {
        super(Title, elements, GridWidth, GridHeight, fonType);
    }

    public void initialize(String[] Title, String[][] elements, int GridWidth, int GridHeight, int fonType) {
        super.initialize(Title, elements, GridWidth, GridHeight, fonType);
    }

    public PMSWatch() {
    }

    public void setHeaderData(String[][] newHeader) {
        this.strHeaderData = newHeader;
    }

    public void setTransactionData(String[][] newTransaction) {
        this.strTransactionData = newTransaction;
    }

    public void setPortfolioData(String[][] newPortfolio, String strTotal) {
        this.strPortfolioData = newPortfolio;
        this.strPortfolioTotalValue = strTotal;
    }

    public String[][] getPortfolioData() {
        return this.strPortfolioData;
    }

    public String getTotal() {
        return this.strPortfolioTotalValue;
    }

    public String getHeaderInfo(int rowIndex, int id) {
        return this.strHeaderData[rowIndex][id];
    }

    public String[][] setTransactionInfo(String[][] strTemp, String strSelected) {
        int i;
        String[][] strTempp = new String[strTemp.length][5];
        for (i = 0; i < strTemp.length; ++i) {
            for (int j = 0; j < 5; ++j) {
                strTempp[i][j] = strTemp[i][j];
            }
        }
        for (i = 0; i < strTemp.length; ++i) {
            if (strTemp[i][1].indexOf(strSelected) < 0) continue;
            strTempp[i][1] = strTempp[i][1].substring(1);
            String[] strData = Utilities.split(strTempp[i][1], "&");
            int length = strData.length;
            this.strFinalTransactionData = new String[length][3];
            for (int l = 0; l < length; ++l) {
                String[] strDataTemp = Utilities.split(strData[l], "$");
                int k = 0;
                for (int j = 0; j < strDataTemp.length; ++j) {
                    if (j <= 2) continue;
                    if (j == 3) {
                        this.strFinalTransactionData[l][k] = strDataTemp[j].startsWith("-") ? "Sell" : "Buy";
                        ++k;
                        continue;
                    }
                    if (j >= strDataTemp.length - 1) continue;
                    this.strFinalTransactionData[l][k] = strDataTemp[j];
                    ++k;
                }
            }
        }
        return this.strFinalTransactionData;
    }

    public boolean jcommandAction(SoftKey sk, Displayable d) {
        byte iScreenId = JPlatformCanvas.getInstance().getScreenID();
        if (iScreenId == 29) {
            if (sk.getLabel().equals("Select")) {
                String SelectedCommand = JPlatformCanvas.getInstance().getCommandName();
                if (SelectedCommand.equals("Details")) {
                    if (this.getNumberOfRows() <= 0) {
                        iWinRefresh.displayAlert("MVMG", "No Scrip Added", 5000);
                        return false;
                    }
                    AppConstants.IsScripByReq = true;
                    String[][] strData = this.setTransactionInfo(this.strTransactionData, this.strHeaderData[this.getSelectedRow()][2]);
                    iWinRefresh.getInstance().showform.createNEWPMSForm(strData, this.strTransactionData[this.getSelectedRow()][2]);
                    return true;
                }
                if (SelectedCommand.equals("AddScrip")) {
                    iWinRefresh.iPreviousForm = 29;
                    iWinRefresh.getInstance().showform.showSelectInstrument(0);
                    return true;
                }
                if (SelectedCommand.equals("Modify")) {
                    if (this.getNumberOfRows() <= 0) {
                        iWinRefresh.displayAlert("MVMG", "No Scrip Added", 5000);
                        return false;
                    }
                    iWinRefresh.iPreviousForm = 29;
                    iWinRefresh.getInstance().showform.showSettings(2);
                    return true;
                }
                if (SelectedCommand.equals("Remove")) {
                    if (this.getNumberOfRows() <= 0) {
                        iWinRefresh.displayAlert("MVMG", "No Scrip Added", 5000);
                        return false;
                    }
                    int Index = this.getSelectedRow();
                    iWinRefresh.getInstance().showform.showCommonForm("Remove from PMS", this.strHeaderData[Index][0], this.strHeaderData[Index][1], this.strHeaderData[Index][2], this.getCellData(Index, 1), this.getCellData(Index, 2), "2");
                    return true;
                }
                if (SelectedCommand.equals("Buy")) {
                    if (this.getNumberOfRows() <= 0) {
                        iWinRefresh.displayAlert("MVMG", "No Scrip Added", 5000);
                        return false;
                    }
                    String[][] strData = this.setTransactionInfo(this.strTransactionData, this.strHeaderData[this.getSelectedRow()][2]);
                    AppConstants.nTotalQty = 0;
                    for (int i = 0; i < strData.length; ++i) {
                        AppConstants.nTotalQty += Integer.parseInt(strData[i][1]);
                    }
                    AppConstants.IsSellOrBuy = "buy";
                    iWinRefresh.iPreviousForm = 29;
                    iWinRefresh.getInstance().showform.showSettings(2);
                    iWinRefresh.getInstance().showform.settings.setKeyInfo(this.strHeaderData[this.getSelectedRow()][0], this.strHeaderData[this.getSelectedRow()][1], this.strHeaderData[this.getSelectedRow()][2], this.strHeaderData[this.getSelectedRow()][3]);
                    return true;
                }
                if (SelectedCommand.equals("Sell")) {
                    if (this.getNumberOfRows() <= 0) {
                        iWinRefresh.displayAlert("MVMG", "No Scrip Added", 5000);
                        return false;
                    }
                    String[][] strData = this.setTransactionInfo(this.strTransactionData, this.strHeaderData[this.getSelectedRow()][2]);
                    AppConstants.nTotalQty = 0;
                    for (int i = 0; i < strData.length; ++i) {
                        AppConstants.nTotalQty += Integer.parseInt(strData[i][1]);
                    }
                    AppConstants.IsSellOrBuy = "sell";
                    iWinRefresh.iPreviousForm = 29;
                    iWinRefresh.getInstance().showform.showSettings(2);
                    iWinRefresh.getInstance().showform.settings.setKeyInfo(this.strHeaderData[this.getSelectedRow()][0], this.strHeaderData[this.getSelectedRow()][1], this.strHeaderData[this.getSelectedRow()][2], this.strHeaderData[this.getSelectedRow()][3]);
                    return true;
                }
            } else if (sk.getLabel().equals("Back")) {
                if (AppConstants.IsScripByReq) {
                    String[][] strData = this.getPortfolioData();
                    String strTotal = this.getTotal();
                    AppConstants.IsScripByReq = false;
                    iWinRefresh.getInstance().showform.createNEWPMSForm(strData, strTotal);
                } else {
                    AppConstants.IsAddOrRemove = "";
                    AppConstants.IsSellOrBuy = "";
                    AppConstants.IsScripByReq = false;
                    iWinRefresh.getInstance().showform.showTools();
                }
                return true;
            }
        } else if (iScreenId == 33) {
            if (sk.getLabel().equals("Story")) {
                int iNewsAvailable = Integer.parseInt(this.getHeaderInfo(this.getSelectedRow(), 0));
                if (iNewsAvailable == 0) {
                    iWinRefresh.getInstance();
                    iWinRefresh.displayAlert("MVMG", "Story not available", AppConstants.iAlertDisplayTime);
                    return false;
                }
                iWinRefresh.getInstance().showProgressBar();
                AppConstants.sendrequest.sendNewsStoryRequest(this.getHeaderInfo(this.getSelectedRow(), 1));
            } else if (sk.getLabel().equals("Back")) {
                iWinRefresh.getInstance().backForm(iWinRefresh.iPreviousForm);
                return true;
            }
        }
        return false;
    }
}

