/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.CanvasForm;
import GeneralUI.DropDownBox;
import GeneralUI.JTextField;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import common.Utilities;
import javax.microedition.lcdui.Displayable;
import market.iWinRefresh;

public class ParityCalculator
extends CanvasForm
implements JCommandListener {
    public DropDownBox Symbol = new DropDownBox("Symbol");
    public DropDownBox BaseContract = new DropDownBox("Base Contract");
    public DropDownBox FutureContract = new DropDownBox("Future Contract");
    public DropDownBox USDINR = new DropDownBox("USDINR(Rs.)");
    JTextField textField;
    String[][] strBaseContract;
    String[][] strFutureContract;
    final String[][] strUSDINR = new String[][]{{"USDINRCOMP", "17^1^4^6069:USDINRCOMP:0"}, {"Other", "USDINR"}};

    public ParityCalculator(String Title) {
        super(Title);
    }

    private void InitializeSymbol() {
        String[] strpSymbol = AppConstants.parityStore.getKeys();
        this.Symbol.init();
        if (this.Symbol.size() > 0) {
            this.Symbol.removeAllItems();
        }
        this.Symbol.addItem(strpSymbol);
        this.wrapItem(this.Symbol);
    }

    private void InitializeBaseContract() {
        String[] strpSymbol = AppConstants.parityStore.getKeys();
        this.UpdateBaseContract(AppConstants.parityStore.getBaseContract(strpSymbol[0]));
        this.wrapItem(this.BaseContract);
    }

    public void UpdateBaseContract(String[][] strTempBaseContract) {
        int iLength = strTempBaseContract.length;
        this.strBaseContract = strTempBaseContract;
        String[] strpBaseContract = new String[iLength];
        for (int i = 0; i < iLength; ++i) {
            strpBaseContract[i] = strTempBaseContract[i][0];
        }
        this.BaseContract.init();
        if (this.BaseContract.size() > 0) {
            this.BaseContract.removeAllItems();
        }
        this.BaseContract.addItem(strpBaseContract);
    }

    private void InitializeFutureContract() {
        String[] strpSymbol = AppConstants.parityStore.getKeys();
        this.UpdateFutureContract(AppConstants.parityStore.getFutureContract(strpSymbol[0]));
        this.wrapItem(this.FutureContract);
    }

    public void UpdateFutureContract(String[][] strTempFutureContract) {
        int iLength = strTempFutureContract.length;
        this.strFutureContract = strTempFutureContract;
        String[] strpFutureContract = new String[iLength];
        for (int i = 0; i < iLength; ++i) {
            strpFutureContract[i] = strTempFutureContract[i][0];
        }
        this.FutureContract.init();
        if (this.FutureContract.size() > 0) {
            this.FutureContract.removeAllItems();
        }
        this.FutureContract.addItem(strpFutureContract);
    }

    private void InitializeUSDINR() {
        this.UpDateUSDINR();
        this.wrapItem(this.USDINR);
    }

    public void UpDateUSDINR() {
        int iLength = this.strUSDINR.length;
        String[] strpUSDINR = new String[iLength];
        for (int i = 0; i < iLength; ++i) {
            strpUSDINR[i] = this.strUSDINR[i][0];
        }
        this.USDINR.init();
        if (this.USDINR.size() > 0) {
            this.USDINR.removeAllItems();
        }
        this.USDINR.addItem(strpUSDINR);
    }

    public void InitializeFormFields() {
        if (this.size() > 0) {
            for (int z = this.size() - 1; z >= 0; --z) {
                this.deleteItem(z);
            }
        }
        this.InitializeSymbol();
        this.InitializeBaseContract();
        this.InitializeFutureContract();
        this.InitializeUSDINR();
    }

    public void initializeTextField() {
        if (this.textField == null) {
            this.textField = new JTextField("Enter Value", "", 6, 0);
        }
        if (this.size() < 5) {
            this.wrapItem(this.textField);
            this.changeFocus(this.size() - 1);
        }
    }

    public boolean jcommandAction(SoftKey softkey, Displayable d) {
        if (softkey.getLabel().equals("Select")) {
            String strUSDINRValue;
            if (this.textField != null && ((strUSDINRValue = this.textField.getText()).equals("") || !Utilities.isAlphaNumeric(strUSDINRValue, 1))) {
                iWinRefresh.displayAlert("MVMG", "Price is not valid", AppConstants.iAlertDisplayTime);
                return false;
            }
            String choosenValue = iWinRefresh.getInstance().showform.parityCalc.Symbol.getListItem(iWinRefresh.getInstance().showform.parityCalc.Symbol.getSelectedIndex());
            if (!choosenValue.toUpperCase().equals("COPPER")) {
                iWinRefresh.getInstance().showform.showSettings(1);
            } else {
                iWinRefresh.getInstance().showform.showParityWatch("", "", "", "");
            }
            return true;
        }
        if (softkey.getLabel().equals("Back")) {
            this.restoreForm();
            for (int z = this.size() - 1; z >= 0; --z) {
                this.deleteItem(z);
            }
            iWinRefresh.getInstance().showform.showTools();
            return true;
        }
        return false;
    }

    public void calculateParity() {
        if (this.Symbol.isPopupDrawn()) {
            int SymbolIndex = this.Symbol.getSelectedIndex();
            String SelectedSymbol = this.Symbol.getListItem(SymbolIndex);
            this.UpdateBaseContract(AppConstants.parityStore.getBaseContract(SelectedSymbol));
            this.UpdateFutureContract(AppConstants.parityStore.getFutureContract(SelectedSymbol));
        }
        if (this.USDINR.getListItem(this.USDINR.getSelectedIndex()).equals("Other") & !this.USDINR.isPopupDrawn()) {
            this.initializeTextField();
        } else if (!this.USDINR.isPopupDrawn() & this.size() > 4) {
            this.deleteItem(iWinRefresh.getInstance().showform.parityCalc.size() - 1);
        }
    }
}

