/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.JPlatformCanvas;
import GeneralUI.ScreenPointerDefinition;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import common.TagData;
import common.Utilities;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import market.iWinRefresh;

public class ParityWatch
implements JCommandListener {
    private final int iMaxNoOfScript;
    private TagData m_tagUSDINR;
    private TagData[] m_tagBaseContract = new TagData[5];
    private TagData[] m_tagFutureContract = new TagData[5];
    private String[] m_strParity = new String[15];
    private Integer l_nInt = new Integer(0);
    private int[] iBaseLTP = new int[5];
    private long[] iBasePrice = new long[5];
    private long[] iFuturePrice = new long[5];
    private int[] iCIF = new int[5];
    private int[] iCustomDuty = new int[5];
    private int[] iCustomDutyIndex = new int[5];
    private int[] iBankDuty = new int[5];
    private int[] iBankDutyIndex = new int[5];
    private int iFineness = 9951;
    private int iUSDINR = 480000;
    private String[] strSymbol = new String[5];
    private byte iCounter = 0;
    private int iCurrentIndex = 0;
    private int xHeadingWidth = 0;
    private int iDataRowStartY = 0;
    private int iDataRowEndY = 0;
    private int iRowHeight = 0;
    private int iCurrentPageStartIndex = 0;

    public ParityWatch() {
        this.iMaxNoOfScript = 5;
        for (int i = 0; i < this.m_strParity.length; ++i) {
            this.m_strParity[i] = "";
        }
    }

    public void Initialize(String strpCIF, String strpCustomDuty, String strpBankCost, String strpFineness) {
        int iUSDINRIndex = iWinRefresh.getInstance().showform.parityCalc.USDINR.getSelectedIndex();
        String strUSDINRContract = iWinRefresh.getInstance().showform.parityCalc.USDINR.getListItem(iUSDINRIndex);
        String strUSDINRKey = iWinRefresh.getInstance().showform.parityCalc.strUSDINR[iUSDINRIndex][1];
        this.m_tagUSDINR = new TagData();
        if (iUSDINRIndex == 0) {
            String[] strTemp = Utilities.split(strUSDINRKey, "^");
            strUSDINRKey = strTemp[3] + "^" + strTemp[2] + "^" + strUSDINRContract;
            this.m_tagUSDINR.ExtractData(strTemp[0], strTemp[1], strUSDINRKey);
        } else {
            int iIndex;
            String strUSDINRValue = iWinRefresh.getInstance().showform.parityCalc.textField.getText();
            String strMentissa = strUSDINRValue.substring(0, iIndex = strUSDINRValue.indexOf("."));
            iIndex = strMentissa.length() == 1 ? 1 : 0;
            int iTemp = this.ConvertToWholeNumber(strUSDINRValue);
            iTemp = this.l_nInt;
            this.iUSDINR = iTemp = this.priceMultiplier(6 - (Integer.toString(iTemp).length() + iIndex), iTemp);
        }
        if (this.iCounter != 5) {
            String strTempVariable;
            int iTempIndex;
            int BaseIndex = iWinRefresh.getInstance().showform.parityCalc.BaseContract.getSelectedIndex();
            String strBaseContract = iWinRefresh.getInstance().showform.parityCalc.BaseContract.getListItem(BaseIndex);
            String strBaseKey = iWinRefresh.getInstance().showform.parityCalc.strBaseContract[BaseIndex][1];
            String[] strTemp = Utilities.split(strBaseKey, "^");
            strBaseKey = strTemp[3] + "^" + strTemp[2] + "^" + strBaseContract;
            this.m_tagBaseContract[this.iCounter] = new TagData();
            this.m_tagBaseContract[this.iCounter].ExtractData(strTemp[0], strTemp[1], strBaseKey);
            int FutureIndex = iWinRefresh.getInstance().showform.parityCalc.FutureContract.getSelectedIndex();
            String strFutureContract = iWinRefresh.getInstance().showform.parityCalc.FutureContract.getListItem(FutureIndex);
            String strFutureKey = iWinRefresh.getInstance().showform.parityCalc.strFutureContract[FutureIndex][1];
            strTemp = Utilities.split(strFutureKey, "^");
            strFutureKey = strTemp[3] + "^" + strTemp[2] + "^" + strFutureContract;
            this.m_tagFutureContract[this.iCounter] = new TagData();
            this.m_tagFutureContract[this.iCounter].ExtractData(strTemp[0], strTemp[1], strFutureKey);
            int iSymbolIndex = iWinRefresh.getInstance().showform.parityCalc.Symbol.getSelectedIndex();
            this.strSymbol[this.iCounter] = iWinRefresh.getInstance().showform.parityCalc.Symbol.getListItem(iSymbolIndex);
            if (this.strSymbol[this.iCounter].equals("GOLD")) {
                iTempIndex = this.ConvertToWholeNumber(strpCIF);
                this.iCIF[this.iCounter] = this.l_nInt;
                if (iTempIndex > this.m_tagBaseContract[this.iCounter].iDivisionFactor) {
                    strTempVariable = Integer.toString(this.iCIF[this.iCounter]);
                    this.iCIF[this.iCounter] = Integer.parseInt(strTempVariable.substring(0, strTempVariable.length() - 1));
                } else if (iTempIndex < this.m_tagBaseContract[this.iCounter].iDivisionFactor) {
                    this.iCIF[this.iCounter] = this.priceMultiplier(this.m_tagBaseContract[this.iCounter].iDivisionFactor - iTempIndex, this.iCIF[this.iCounter]);
                }
                iTempIndex = this.ConvertToWholeNumber(strpFineness);
                strTempVariable = Integer.toString(this.l_nInt) + "1";
                this.iFineness = Integer.parseInt(strTempVariable);
                this.iBankDutyIndex[this.iCounter] = this.ConvertToWholeNumber(strpBankCost);
                this.iBankDuty[this.iCounter] = this.l_nInt;
                this.iCustomDutyIndex[this.iCounter] = this.ConvertToWholeNumber(strpCustomDuty);
                this.iCustomDuty[this.iCounter] = this.l_nInt;
            } else if (this.strSymbol[this.iCounter].equals("SILVER")) {
                iTempIndex = this.ConvertToWholeNumber(strpCIF);
                this.iCIF[this.iCounter] = this.l_nInt;
                if (iTempIndex > this.m_tagBaseContract[this.iCounter].iDivisionFactor) {
                    strTempVariable = Integer.toString(this.iCIF[this.iCounter]);
                    this.iCIF[this.iCounter] = Integer.parseInt(strTempVariable.substring(0, strTempVariable.length() - 1));
                } else if (iTempIndex < this.m_tagBaseContract[this.iCounter].iDivisionFactor) {
                    this.iCIF[this.iCounter] = this.priceMultiplier(this.m_tagBaseContract[this.iCounter].iDivisionFactor - iTempIndex, this.iCIF[this.iCounter]);
                }
                this.iBankDutyIndex[this.iCounter] = this.ConvertToWholeNumber(strpBankCost);
                this.iBankDuty[this.iCounter] = this.l_nInt;
                this.iCustomDutyIndex[this.iCounter] = this.ConvertToWholeNumber(strpCustomDuty);
                this.iCustomDuty[this.iCounter] = this.l_nInt;
            } else if (this.strSymbol[this.iCounter].equals("COPPER")) {
                // empty if block
            }
            this.iCounter = (byte)(this.iCounter + 1);
        } else {
            iWinRefresh.displayAlert("MVMG", "Max. 5 records allowed.", AppConstants.iAlertDisplayTime);
        }
        for (int z = 0; z < this.iCounter; ++z) {
            if (AppConstants.FONT_HEADING.stringWidth(this.m_tagFutureContract[z].strScripDesc) <= this.xHeadingWidth) continue;
            this.xHeadingWidth = AppConstants.FONT_HEADING.stringWidth(this.m_tagFutureContract[z].strScripDesc);
        }
        AppConstants.sendrequest.startStopParityRequest(this.m_tagBaseContract, this.m_tagFutureContract, this.m_tagUSDINR, 0, this.iCounter);
    }

    public void setData(String strKeyofData, int iLTP, int iLUT) {
        for (int i = 0; i < this.iCounter; ++i) {
            if (this.m_tagBaseContract[i].strKeyOfData.startsWith(strKeyofData)) {
                this.m_strParity[i * 3 + 0] = Utilities.ConvertToDecimal(iLTP, this.m_tagBaseContract[i].iDivisionFactor, this.m_tagBaseContract[i].iSegmentId);
                this.iBaseLTP[i] = iLTP;
                this.DoCalculation(i);
            } else if (this.m_tagFutureContract[i].strKeyOfData.startsWith(strKeyofData)) {
                this.m_strParity[i * 3 + 1] = Utilities.ConvertToDecimal(iLTP, this.m_tagFutureContract[i].iDivisionFactor, this.m_tagBaseContract[i].iSegmentId);
                this.iFuturePrice[i] = iLTP;
            } else if (this.m_tagUSDINR.strKeyOfData.startsWith(strKeyofData)) {
                this.iUSDINR = iLTP;
                if (this.iBaseLTP[i] != 0) {
                    this.DoCalculation(i);
                }
            }
            if (this.iBasePrice[i] > this.iFuturePrice[i]) {
                this.m_strParity[i * 3 + 2] = "+" + Utilities.ConvertToDecimal(this.iBasePrice[i] - this.iFuturePrice[i], 2, this.m_tagBaseContract[i].iSegmentId);
                continue;
            }
            if (this.iBasePrice[i] >= this.iFuturePrice[i]) continue;
            this.m_strParity[i * 3 + 2] = "-" + Utilities.ConvertToDecimal(this.iFuturePrice[i] - this.iBasePrice[i], 2, this.m_tagBaseContract[i].iSegmentId);
        }
        JPlatformCanvas.getInstance().refreshDisplay();
        AppConstants.profilelist.checkAlerts(strKeyofData, iLTP, iLUT);
    }

    private void DoCalculation(int iTempCounter) {
        try {
            if (this.strSymbol[iTempCounter].equals("GOLD")) {
                long iAfterCIF = this.iCIF[iTempCounter] + this.iBaseLTP[iTempCounter];
                long iResult = 3215075L * iAfterCIF;
                String strResult = Utilities.ConvertToDecimal(iResult, 4, this.m_tagBaseContract[iTempCounter].iSegmentId);
                iResult = Long.parseLong(strResult.substring(0, strResult.indexOf(".")));
                strResult = Utilities.ConvertToDecimal(iResult *= (long)this.iFineness, 4, this.m_tagBaseContract[iTempCounter].iSegmentId);
                iResult = Long.parseLong(strResult.substring(0, strResult.indexOf(".")));
                strResult = Utilities.ConvertToDecimal(iResult *= (long)this.iUSDINR, 5, this.m_tagBaseContract[iTempCounter].iSegmentId);
                iResult = Long.parseLong(strResult.substring(0, strResult.indexOf(".")));
                strResult = Utilities.ConvertToDecimal(iResult, this.m_tagBaseContract[iTempCounter].iDivisionFactor, this.m_tagBaseContract[iTempCounter].iSegmentId);
                this.iBasePrice[iTempCounter] = Long.parseLong(strResult.substring(0, strResult.indexOf(".")));
                String strCustDuty = Utilities.ConvertToDecimal(this.iBasePrice[iTempCounter] * (long)this.iCustomDuty[iTempCounter], this.iCustomDutyIndex[iTempCounter] + 2, this.m_tagBaseContract[iTempCounter].iSegmentId);
                int n = iTempCounter;
                this.iBasePrice[n] = this.iBasePrice[n] + (long)Integer.parseInt(strCustDuty.substring(0, strCustDuty.indexOf(".")));
                String strBankCost = Utilities.ConvertToDecimal(this.iBasePrice[iTempCounter] * (long)this.iBankDuty[iTempCounter], this.iBankDutyIndex[iTempCounter] + 2, this.m_tagBaseContract[iTempCounter].iSegmentId);
                int iBankCost = Integer.parseInt(strBankCost.substring(0, strBankCost.indexOf(".")));
                int n2 = iTempCounter;
                this.iBasePrice[n2] = this.iBasePrice[n2] + (long)iBankCost;
            } else if (this.strSymbol[iTempCounter].equals("SILVER")) {
                int iIndex;
                long iAfterCIF = this.iCIF[iTempCounter] + this.iBaseLTP[iTempCounter];
                long iResult = 3215075L * iAfterCIF;
                String strResult = Utilities.ConvertToDecimal(iResult, 4, this.m_tagBaseContract[iTempCounter].iSegmentId);
                iResult = Long.parseLong(strResult.substring(0, strResult.indexOf(".")));
                strResult = Utilities.ConvertToDecimal(iResult *= (long)this.iUSDINR, 3, this.m_tagBaseContract[iTempCounter].iSegmentId);
                this.iBasePrice[iTempCounter] = Long.parseLong(strResult.substring(0, strResult.indexOf(".")));
                int iBaseLength = Long.toString(this.iBasePrice[iTempCounter]).length();
                int iFutureLength = Long.toString(this.iFuturePrice[iTempCounter]).length();
                strResult = Utilities.ConvertToDecimal(this.iBasePrice[iTempCounter], iBaseLength - iFutureLength, this.m_tagBaseContract[iTempCounter].iSegmentId);
                this.iBasePrice[iTempCounter] = Long.parseLong(strResult.substring(0, strResult.indexOf(".")));
                String strCustDuty = Utilities.ConvertToDecimal(this.iBasePrice[iTempCounter] * (long)this.iCustomDuty[iTempCounter], this.iCustomDutyIndex[iTempCounter] + 2, this.m_tagBaseContract[iTempCounter].iSegmentId);
                int n = iTempCounter;
                this.iBasePrice[n] = this.iBasePrice[n] + (long)Integer.parseInt(strCustDuty.substring(0, strCustDuty.indexOf(".")));
                String strBankCost = Utilities.ConvertToDecimal(this.iBasePrice[iTempCounter] * (long)this.iBankDuty[iTempCounter], this.iBankDutyIndex[iTempCounter] + 2, this.m_tagBaseContract[iTempCounter].iSegmentId);
                int iBankCost = Integer.parseInt(strBankCost.substring(0, strBankCost.indexOf(".")));
                int n3 = iTempCounter;
                this.iBasePrice[n3] = this.iBasePrice[n3] + (long)iBankCost;
                String strUSDINRValue = iWinRefresh.getInstance().showform.parityCalc.textField.getText();
                String strMentissa = strUSDINRValue.substring(0, iIndex = strUSDINRValue.indexOf("."));
                if (strMentissa.length() == 1) {
                    String strBasePrice = Utilities.ConvertToDecimal(this.iBasePrice[iTempCounter], 1, this.m_tagBaseContract[iTempCounter].iSegmentId);
                    this.iBasePrice[iTempCounter] = Long.parseLong(strBasePrice.substring(0, strBasePrice.indexOf(".")));
                }
            } else if (this.strSymbol[iTempCounter].equals("COPPER")) {
                int iIndex;
                long iResult = 22046 * this.iBaseLTP[iTempCounter];
                String strResult = Utilities.ConvertToDecimal(iResult, 3, this.m_tagBaseContract[iTempCounter].iSegmentId);
                iResult = Long.parseLong(strResult.substring(0, strResult.indexOf(".")));
                strResult = Utilities.ConvertToDecimal(iResult *= (long)this.iUSDINR, 4, this.m_tagBaseContract[iTempCounter].iSegmentId);
                this.iBasePrice[iTempCounter] = Long.parseLong(strResult.substring(0, strResult.indexOf(".")));
                int iBaseLength = Long.toString(this.iBasePrice[iTempCounter]).length();
                int iFutureLength = Long.toString(this.iFuturePrice[iTempCounter]).length();
                strResult = Utilities.ConvertToDecimal(this.iBasePrice[iTempCounter], iBaseLength - iFutureLength, this.m_tagBaseContract[iTempCounter].iSegmentId);
                this.iBasePrice[iTempCounter] = Long.parseLong(strResult.substring(0, strResult.indexOf(".")));
                String strUSDINRValue = iWinRefresh.getInstance().showform.parityCalc.textField.getText();
                String strMentissa = strUSDINRValue.substring(0, iIndex = strUSDINRValue.indexOf("."));
                if (strMentissa.length() == 1) {
                    String strBasePrice = Utilities.ConvertToDecimal(this.iBasePrice[iTempCounter], 1, this.m_tagBaseContract[iTempCounter].iSegmentId);
                    this.iBasePrice[iTempCounter] = Long.parseLong(strBasePrice.substring(0, strBasePrice.indexOf(".")));
                }
            }
        }
        catch (Exception e) {
            Utilities.printLog("ParityWatch-SetData " + e.toString());
        }
    }

    public void paint(Graphics g) {
        int iStartX = 2;
        int TL = 20;
        int TR = 24;
        int iFontHeight = AppConstants.FONT_HEADING.getHeight();
        int xTempWidth = 2 + this.xHeadingWidth + AppConstants.FONT_CONTENT.stringWidth("00000.00");
        boolean bNewLineFlag = xTempWidth > JPlatformCanvas.SCREEN_WIDTH;
        int iHeightCounter = bNewLineFlag ? 7 : 4;
        int iLinesDisplayblePerRow = (iFontHeight + 1) * iHeightCounter;
        int y = JPlatformCanvas.TITLE_BAR_HEIGHT + 6;
        int iMaxRowsPerScreen = (JPlatformCanvas.SCREEN_HEIGHT - y - JPlatformCanvas.SOFT_KEYBAR_HEIGHT) / iLinesDisplayblePerRow;
        int iMaxNoOfPages = this.iCounter / iMaxRowsPerScreen;
        int iCurrentPageIndex = this.iCurrentIndex / iMaxRowsPerScreen;
        this.iCurrentPageStartIndex = iCurrentPageIndex * iMaxRowsPerScreen;
        iMaxNoOfPages = this.iCounter != iMaxNoOfPages * iMaxRowsPerScreen ? iMaxNoOfPages + 1 : (iMaxNoOfPages == 0 ? 1 : iMaxNoOfPages);
        iMaxRowsPerScreen = this.iCounter - iCurrentPageIndex * iMaxRowsPerScreen < iMaxRowsPerScreen ? this.iCounter - iCurrentPageIndex * iMaxRowsPerScreen : iMaxRowsPerScreen;
        this.iDataRowStartY = y;
        g.setColor(0);
        g.fillRect(0, 0, JPlatformCanvas.SCREEN_WIDTH, JPlatformCanvas.SCREEN_HEIGHT);
        for (int i = 0; i < iMaxRowsPerScreen; ++i) {
            int x = 2;
            if (i + this.iCurrentPageStartIndex == this.iCurrentIndex) {
                g.setColor(1132180);
                g.fillRect(0, y, JPlatformCanvas.SCREEN_WIDTH, (iFontHeight + 1) * iHeightCounter);
            }
            g.setFont(AppConstants.FONT_HEADING);
            g.setColor(0xFFFFFF);
            g.drawString(this.strSymbol[i + this.iCurrentPageStartIndex], x, y, 20);
            if (JPlatformCanvas.getInstance().hasPointerEvents()) {
                ScreenPointerDefinition.setPointer(JPlatformCanvas.getInstance().getTitle(), this.strSymbol[i + this.iCurrentPageStartIndex], 0, y, JPlatformCanvas.SCREEN_WIDTH, y + (iFontHeight + 1) * iHeightCounter);
            }
            g.setFont(AppConstants.FONT_CONTENT);
            g.drawString(this.m_tagBaseContract[i + this.iCurrentPageStartIndex].strScripDesc, x, y += iFontHeight + 1, 20);
            g.drawString(this.m_strParity[(i + this.iCurrentPageStartIndex) * 3 + 0], !bNewLineFlag ? (x = x + xTempWidth) : x, bNewLineFlag ? (y = y + (iFontHeight + 1)) : y, !bNewLineFlag ? 24 : 20);
            x = 2;
            g.drawString(this.m_tagFutureContract[i + this.iCurrentPageStartIndex].strScripDesc, x, y += iFontHeight + 1, 20);
            g.drawString(this.m_strParity[(i + this.iCurrentPageStartIndex) * 3 + 1], !bNewLineFlag ? (x = x + xTempWidth) : x, bNewLineFlag ? (y = y + (iFontHeight + 1)) : y, !bNewLineFlag ? 24 : 20);
            x = 2;
            g.drawString("Parity/Disparity", x, y += iFontHeight + 1, 20);
            g.drawString(this.m_strParity[(i + this.iCurrentPageStartIndex) * 3 + 2], !bNewLineFlag ? (x = x + xTempWidth) : x, bNewLineFlag ? (y = y + (iFontHeight + 1)) : y, !bNewLineFlag ? 24 : 20);
            y += iFontHeight + 1;
        }
        this.iDataRowEndY = y;
        this.iRowHeight = (this.iDataRowEndY - this.iDataRowStartY) / iMaxRowsPerScreen;
        g.drawString(iCurrentPageIndex + 1 + "/" + iMaxNoOfPages, JPlatformCanvas.SCREEN_WIDTH, JPlatformCanvas.SCREEN_HEIGHT - JPlatformCanvas.SOFT_KEYBAR_HEIGHT, 40);
    }

    public boolean jcommandAction(SoftKey softkey, Displayable d) {
        if (softkey.getLabel().equals("Back")) {
            AppConstants.sendrequest.startStopParityRequest(this.m_tagBaseContract, this.m_tagFutureContract, this.m_tagUSDINR, 1, this.iCounter);
            iWinRefresh.getInstance().showform.showParityCalc();
            return true;
        }
        return false;
    }

    public void keyPressed(int keyCode) {
        switch (keyCode) {
            case -1: 
            case 50: 
            case 221: {
                this.iCurrentIndex = ((this.iCurrentIndex - 1) % this.iCounter + this.iCounter) % this.iCounter;
                break;
            }
            case -2: 
            case 56: 
            case 222: {
                this.iCurrentIndex = (this.iCurrentIndex + 1) % this.iCounter;
                break;
            }
            default: {
                JPlatformCanvas.getInstance().processSoftKeys(keyCode);
            }
        }
    }

    public void pointerPressed(String lsSection, int x, int y) {
        this.iCurrentIndex = lsSection.equals("HEADER") ? ((this.iCurrentIndex - 1) % this.iCounter + this.iCounter) % this.iCounter : (lsSection.equals("FOOTER") ? (this.iCurrentIndex + 1) % this.iCounter : (y > this.iDataRowStartY && y < this.iDataRowEndY ? this.iCurrentPageStartIndex + (this.iRowHeight > 0 ? (y - this.iDataRowStartY) / this.iRowHeight : 0) : this.iCurrentIndex));
    }

    private int priceMultiplier(int iDivisionFactor, int iValue) {
        switch (iDivisionFactor) {
            case 0: {
                return iValue * 0;
            }
            case 1: {
                return iValue * 10;
            }
            case 2: {
                return iValue * 100;
            }
            case 3: {
                return iValue * 1000;
            }
            case 4: {
                return iValue * 10000;
            }
        }
        return 10;
    }

    private int ConvertToWholeNumber(String strValue) {
        try {
            int iIndex = strValue.indexOf(".");
            if (iIndex > 0) {
                String strHead = strValue.substring(0, iIndex);
                String strTail = strValue.substring(iIndex + 1);
                String strResult = strHead + strTail;
                this.l_nInt = new Integer(Integer.parseInt(strResult));
                return strTail.length();
            }
            this.l_nInt = new Integer(Integer.parseInt(strValue));
            return 0;
        }
        catch (Exception e) {
            return 1;
        }
    }
}

