/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.CanvasForm;
import GeneralUI.DropDownBox;
import GeneralUI.JTextField;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import common.Utilities;
import javax.microedition.lcdui.Displayable;
import market.iWinRefresh;

public class SecurityInfo
extends CanvasForm
implements JCommandListener {
    private JTextField txtName = new JTextField("Symbol", "", 12, 0);
    private JTextField txtCode = new JTextField("Code", "", 20, 2);
    private JTextField txtExpiry = new JTextField("Exp Dt(ddmmmyyyy)", "", 9, 0);
    private JTextField txtStrikePrice = new JTextField("Strike Price", "", 10, 2);
    private JTextField txtOptionType = new JTextField("Option Type", "", 2, 0);
    private DropDownBox dpdContractType = new DropDownBox("Contract Type");
    private DropDownBox dpdInstType = new DropDownBox("Inst Type");
    private DropDownBox dpdTradingType = new DropDownBox("Trading Type");
    private String strSegmentName = "";
    private String strName = "";
    private String strExpiryDate = "";
    private String strStrikePrice = "";
    private String strOptionType = "";
    private String strInstType = "";
    private int iContractType = 0;
    private int iMarketSegmentId;
    private int iInstrumentId;
    private final String[] ContractTypeItem = new String[]{"ALL", "NEAR", "NEXT", "FAR"};
    private final String[] InstTypeItem = new String[]{"OFFICIAL", "UNOFFICIAL", "OUTRIGHT", "WAREHOUSE"};
    private final String[] TradingTypeItem = new String[]{"RING KERB", "SELECT", "INTER OFFICE", "REPORT", "RING", "KERB"};

    public SecurityInfo(String strSecurity) {
        super(strSecurity);
        this.initializeForm();
    }

    private void initializeForm() {
        if (this.getTitle().equals("Mutual Fund")) {
            if (AppConstants.iListIndex == 0) {
                this.txtName.setLabel("Fund Name");
                this.txtCode.setLabel("Scheme Name");
                this.txtCode.setContentType(0);
                this.wrapItem(this.txtName);
                this.wrapItem(this.txtCode);
            } else {
                this.txtCode.setLabel("AUM-Month(mmm-yyyy)");
                this.txtCode.setContentType(0);
                this.txtName.setLabel("Fund Name");
                this.wrapItem(this.txtCode);
                this.wrapItem(this.txtName);
            }
        } else if (this.getTitle().equals("New Profile")) {
            this.txtName.setLabel("Profile Name");
            this.txtName.toUpperCase();
            this.wrapItem(this.txtName);
        } else if (this.getTitle().equals("Insurance")) {
            this.txtName.setLabel("Policy Name");
            this.txtCode.setLabel("Plan Name");
            this.txtCode.setContentType(0);
            this.wrapItem(this.txtName);
            this.wrapItem(this.txtCode);
        } else {
            this.txtName.toUpperCase();
            this.wrapItem(this.txtName);
            this.wrapItem(this.txtCode);
            this.txtExpiry.toUpperCase();
            this.wrapItem(this.txtExpiry);
            this.dpdContractType.addItem(this.ContractTypeItem);
            this.wrapItem(this.dpdContractType);
            this.wrapItem(this.txtStrikePrice);
            this.txtOptionType.toUpperCase();
            this.wrapItem(this.txtOptionType);
            this.dpdInstType.addItem(this.InstTypeItem);
            this.wrapItem(this.dpdInstType);
            this.dpdTradingType.addItem(this.TradingTypeItem);
            this.wrapItem(this.dpdTradingType);
        }
    }

    public void setData(int ipIndex, int ipMarketSegId, int ipInstrumentId, String strpSegmentName, String strpInstName) {
        this.iMarketSegmentId = ipMarketSegId;
        this.iInstrumentId = ipInstrumentId;
        AppConstants.iMarketSegmentId = ipMarketSegId;
        AppConstants.iInstrumentId = ipInstrumentId;
        this.strSegmentName = strpSegmentName;
        AppConstants.strInstrumentName = strpInstName;
        if (strpInstName.equals("EQUITY") || strpInstName.equals("COM") || strpInstName.equals("COMDTY") || strpInstName.equals("SPOT") || strpInstName.equals("SPOT CROSS") || strpInstName.equals("WDM") || strpInstName.equals("INDEX") || strpInstName.equals("FORWARD")) {
            this.deleteItem(7);
            this.deleteItem(6);
            this.deleteItem(5);
            this.deleteItem(4);
            this.deleteItem(3);
            this.deleteItem(2);
            if (!strpInstName.equals("EQUITY")) {
                this.deleteItem(1);
            }
        } else if (strpInstName.equals("METAL") || strpInstName.equals("PLASTIC") || strpInstName.equals("STEEL")) {
            this.deleteItem(5);
            this.deleteItem(4);
            this.deleteItem(3);
            this.deleteItem(1);
        } else if (strpInstName.equals("OPTIDX") || strpInstName.equals("OPTSTK") || strpInstName.equals("OPTION") || strpInstName.equals("OPTCUR") || strpInstName.equals("OPTCOM")) {
            this.deleteItem(7);
            this.deleteItem(6);
            this.deleteItem(3);
            this.deleteItem(1);
        } else if (strpInstName.equals("FUTCOM") && (strpSegmentName.equals("MCX") || strpSegmentName.equals("NCDEX"))) {
            this.deleteItem(7);
            this.deleteItem(6);
            this.deleteItem(5);
            this.deleteItem(4);
            this.deleteItem(3);
            this.deleteItem(2);
            this.deleteItem(1);
        } else {
            this.deleteItem(7);
            this.deleteItem(6);
            this.deleteItem(5);
            this.deleteItem(4);
            this.deleteItem(1);
        }
    }

    public boolean jcommandAction(SoftKey c, Displayable d) {
        String strCommandName = c.getLabel();
        if (this.getTitle().equals("Mutual Fund")) {
            if (strCommandName.equals("Select")) {
                if (this.validateInput()) {
                    iWinRefresh.iPreviousForm = 16;
                    iWinRefresh.getInstance().showProgressBar();
                    AppConstants.sendrequest.sendIPOMutualFundRequest(AppConstants.iListIndex, 1, AppConstants.strFundName, AppConstants.strSchemeName);
                }
                return true;
            }
            if (strCommandName.equals("Back")) {
                iWinRefresh.getInstance().showform.showMutualFund();
                return true;
            }
        } else if (this.getTitle().equals("Insurance")) {
            if (strCommandName.equals("Select")) {
                if (this.validateInput()) {
                    iWinRefresh.iPreviousForm = 30;
                    iWinRefresh.getInstance().showProgressBar();
                    AppConstants.sendrequest.sendIPOMutualFundRequest(AppConstants.iListIndex, 1, AppConstants.strFundName, AppConstants.strSchemeName);
                }
                return true;
            }
            if (strCommandName.equals("Back")) {
                iWinRefresh.getInstance().showform.showMainMenu();
                return true;
            }
        } else if (this.getTitle().equals("New Profile")) {
            if (strCommandName.equals("Select")) {
                if (this.Validate()) {
                    String strProfileName = this.txtName.getText().toUpperCase().trim();
                    String[] strProfileNameArray = AppConstants.profilelist.getProfileNames();
                    boolean bMatchFlag = false;
                    int length = strProfileNameArray.length;
                    for (int i = 0; i < length; ++i) {
                        if (!strProfileName.equals(strProfileNameArray[i])) continue;
                        bMatchFlag = true;
                        break;
                    }
                    if (bMatchFlag) {
                        iWinRefresh.displayAlert("MVMG", "Profile Name already exists", AppConstants.iAlertDisplayTime);
                        return false;
                    }
                    AppConstants.STR_PROFILE_NAME = strProfileName;
                    iWinRefresh.getInstance().showform.showSelectInstrument(0);
                }
                return true;
            }
            if (strCommandName.equals("Back")) {
                iWinRefresh.getInstance().showform.showProfile();
                return true;
            }
        } else if (strCommandName.endsWith("Select")) {
            if (this.ValidateInput()) {
                iWinRefresh.getInstance().showform.showSymbolLookUpRequest(AppConstants.iMarketSegmentId, AppConstants.iInstrumentId, this.strSegmentName, AppConstants.strInstrumentName, 1, this.strName, this.strExpiryDate, this.strStrikePrice, this.strOptionType, this.strInstType, this.iContractType);
                return true;
            }
        } else if (strCommandName.equals("Back")) {
            iWinRefresh.getInstance().showform.showSelectInstrument(0);
            return true;
        }
        return true;
    }

    private boolean ValidateInput() {
        if (this.iMarketSegmentId == 3 && this.iInstrumentId == 1 || this.iMarketSegmentId == 4 && this.iInstrumentId == 1) {
            this.strName = this.txtName.getText().toUpperCase();
            if (this.strName.length() == 0) {
                this.strInstType = this.txtCode.getText();
                if (this.strInstType.length() == 0) {
                    iWinRefresh.displayAlert("MVMG", "Enter Symbol or Code", AppConstants.iAlertDisplayTime);
                    return false;
                }
            } else if (this.strName.length() < 2) {
                iWinRefresh.displayAlert("MVMG", "Enter Min 2 Characters", AppConstants.iAlertDisplayTime);
                return false;
            }
        } else if (this.iMarketSegmentId == 2 && this.iInstrumentId == 2 || this.iMarketSegmentId == 9 && this.iInstrumentId == 2 || this.iMarketSegmentId == 17 && this.iInstrumentId == 1 || this.iMarketSegmentId == 17 && this.iInstrumentId == 3 || this.iMarketSegmentId == 13 && this.iInstrumentId == 1 || this.iMarketSegmentId == 12 && this.iInstrumentId == 2) {
            this.strName = this.txtName.getText().toUpperCase();
            if (this.strName.length() == 0) {
                iWinRefresh.displayAlert("MVMG", "Enter Symbol", AppConstants.iAlertDisplayTime);
                return false;
            }
            if (this.strName.length() < 2) {
                iWinRefresh.displayAlert("MVMG", "Enter Min 2 Characters", AppConstants.iAlertDisplayTime);
                return false;
            }
        } else if (this.iMarketSegmentId == 7 && (this.iInstrumentId == 1 || this.iInstrumentId == 2 || this.iInstrumentId == 3)) {
            this.strName = this.txtName.getText().toUpperCase();
            this.strExpiryDate = this.txtExpiry.getText().toUpperCase();
            this.strInstType = this.dpdInstType.getText();
            this.strOptionType = this.dpdTradingType.getText();
            if (this.strName.length() == 0) {
                iWinRefresh.displayAlert("MVMG", "Enter Symbol", AppConstants.iAlertDisplayTime);
                return false;
            }
            if (this.strName.length() < 2) {
                iWinRefresh.displayAlert("MVMG", "Enter Min 2 Characters", AppConstants.iAlertDisplayTime);
                return false;
            }
            if (this.strExpiryDate.length() != 0 && !this.validDate(this.strExpiryDate)) {
                iWinRefresh.displayAlert("MVMG", "Date should be in ddmmmyyyy format", AppConstants.iAlertDisplayTime);
                return false;
            }
            if (this.strExpiryDate.startsWith("0")) {
                this.strExpiryDate = this.strExpiryDate.substring(1);
            }
        } else {
            int iStrikePrice;
            this.strName = this.txtName.getText().toUpperCase();
            this.strExpiryDate = this.txtExpiry.getText().toUpperCase();
            this.iContractType = this.dpdContractType.getSelectedIndex();
            if (this.strName.length() == 0) {
                iWinRefresh.displayAlert("MVMG", "Enter Symbol", AppConstants.iAlertDisplayTime);
                return false;
            }
            if (this.strName.length() < 2) {
                iWinRefresh.displayAlert("MVMG", "Enter Min 2 Characters", AppConstants.iAlertDisplayTime);
                return false;
            }
            if (this.strExpiryDate.length() != 0 && !this.validDate(this.strExpiryDate)) {
                iWinRefresh.displayAlert("MVMG", "Date should be in ddmmmyyyy format", AppConstants.iAlertDisplayTime);
                return false;
            }
            if (this.strExpiryDate.startsWith("0")) {
                this.strExpiryDate = this.strExpiryDate.substring(1);
            }
            this.strStrikePrice = this.txtStrikePrice.getText();
            this.strOptionType = this.txtOptionType.getText().toUpperCase();
            if (this.strStrikePrice.length() != 0 && (iStrikePrice = Integer.parseInt(this.strStrikePrice)) <= 0) {
                iWinRefresh.displayAlert("MVMG", "Strike Price should be > 0", AppConstants.iAlertDisplayTime);
                return false;
            }
            if (!(this.strOptionType.length() == 0 || this.strOptionType.equals("CA") || this.strOptionType.equals("PA") || this.strOptionType.equals("CE") || this.strOptionType.equals("PE"))) {
                iWinRefresh.displayAlert("MVMG", "Invalid Option type", AppConstants.iAlertDisplayTime);
            }
        }
        return true;
    }

    private boolean validateInput() {
        String strFundName = this.txtName.getText();
        String strSchemeName = this.txtCode.getText();
        AppConstants.strFundName = strFundName;
        AppConstants.strSchemeName = strSchemeName;
        if (this.getTitle().equals("Mutual Fund")) {
            if (AppConstants.iListIndex == 0) {
                if (strFundName.length() == 0) {
                    iWinRefresh.displayAlert("MVMG", "Enter Fund Name", AppConstants.iAlertDisplayTime);
                    return false;
                }
            } else if (!this.checkDate(strSchemeName)) {
                iWinRefresh.displayAlert("MVMG", "Enter valid date in mmm-yyyy format", AppConstants.iAlertDisplayTime);
                return false;
            }
        } else if (this.getTitle().equals("Insurance") && strFundName.length() == 0) {
            iWinRefresh.displayAlert("MVMG", "Enter policy name", AppConstants.iAlertDisplayTime);
            return false;
        }
        return true;
    }

    private boolean Validate() {
        String strName = this.txtName.getText().toUpperCase();
        if (strName.length() == 0) {
            iWinRefresh.displayAlert("MVMG", "Enter Name", AppConstants.iAlertDisplayTime);
            return false;
        }
        if (!Utilities.isAlphaNumeric(strName, 0)) {
            iWinRefresh.displayAlert("MVMG", "Only Alphabets and Numbers are allowed", AppConstants.iAlertDisplayTime);
            return false;
        }
        return true;
    }

    private boolean validDate(String strSource) {
        String strTemp = "";
        int iDay = 0;
        int iYear = 0;
        try {
            int iMaxNoOfDays;
            int i = strSource.length() - 4;
            strTemp = strSource.substring(i, i + 4);
            iYear = Integer.parseInt(strTemp);
            i = strSource.length() - 4 - 3;
            strTemp = strSource.substring(i, i + 3);
            int iMonth = this.GetMonthIndex(strTemp);
            if (iMonth <= -1) {
                return false;
            }
            strTemp = strSource.substring(0, i);
            iDay = Integer.parseInt(strTemp);
            return iDay <= (iMaxNoOfDays = this.GetDays(iMonth, iYear)) && iDay > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int GetDays(int ipMonth, int ipYear) {
        return ipMonth == 2 ? (ipYear % 4 == 0 && (ipYear % 100 != 0 || ipYear % 400 == 0) ? 29 : 28) : (ipMonth == 4 || ipMonth == 6 || ipMonth == 9 || ipMonth == 11 ? 30 : 31);
    }

    private int GetMonthIndex(String strSourceName) {
        int monthindex = -1;
        String[] months = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
        for (int i = 0; i < 12; ++i) {
            if (!strSourceName.toUpperCase().equals(months[i].toUpperCase())) continue;
            monthindex = i + 1;
            break;
        }
        return monthindex;
    }

    private boolean checkDate(String strSource) {
        try {
            if (strSource.length() == 0) {
                return false;
            }
            String strMonthName = strSource.substring(0, 3);
            int iMonth = this.GetMonthIndex(strMonthName);
            if (iMonth <= -1) {
                return false;
            }
            String strYear = strSource.substring(4);
            return strYear.length() == 4;
        }
        catch (Exception e) {
            return false;
        }
    }
}

