/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.CanvasForm;
import GeneralUI.DropDownBox;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.DynamicExchange;
import common.JCommandListener;
import javax.microedition.lcdui.Displayable;
import market.iWinRefresh;

public class SelectExchange
extends CanvasForm
implements JCommandListener {
    private DropDownBox dpdExchange = new DropDownBox("Exchange");
    private DropDownBox dpdInstrument = new DropDownBox("Instrument");
    private DropDownBox dpdProfile = new DropDownBox("Profile");
    private DropDownBox dpdCountry = new DropDownBox("Country");
    private DropDownBox dpdFrequency = new DropDownBox("Frequency");
    private String strExchangeName = "";
    private int iPage = -1;

    public SelectExchange() {
        super("Select Exchange");
        this.initializeForm();
    }

    public SelectExchange(String strpProfileName) {
        super(strpProfileName);
        AppConstants.selectProfile = true;
        this.initializeProfileForm();
    }

    public SelectExchange(String strpEconSearch, int iTemp) {
        super(strpEconSearch);
        AppConstants.selectProfile = true;
        this.initializeEconomicForm();
    }

    private void initializeForm() {
        this.wrapItem(this.dpdExchange);
        this.wrapItem(this.dpdInstrument);
    }

    private void initializeProfileForm() {
        this.wrapItem(this.dpdProfile);
    }

    private void initializeEconomicForm() {
        this.wrapItem(this.dpdCountry);
        this.wrapItem(this.dpdFrequency);
    }

    public void setPage(int ipPage) {
        this.iPage = ipPage;
    }

    public void setData(String[] strpExchangeNames, String[] strpInstrumentsName) {
        this.strExchangeName = strpExchangeNames[0];
        this.dpdExchange.addItem(strpExchangeNames);
        this.dpdInstrument.addItem(strpInstrumentsName);
    }

    public void setProfilename(String[] strpProfilename) {
        String[] tempStr = new String[strpProfilename.length];
        tempStr[0] = AppConstants.STR_PROFILE_NAME;
        int j = 1;
        for (int i = 0; i < strpProfilename.length; ++i) {
            if (strpProfilename[i].equals(AppConstants.STR_PROFILE_NAME)) continue;
            tempStr[j] = strpProfilename[i];
            ++j;
        }
        this.dpdProfile.addItem(tempStr);
    }

    public void setCountryData(String[] strpCountryName) {
        this.dpdCountry.addItem(strpCountryName);
    }

    public void setFrequencyData(String[] strpFrequency) {
        this.dpdFrequency.addItem(strpFrequency);
    }

    public void setInstrument() {
        String strTempExchangeName = this.dpdExchange.getListItem(this.dpdExchange.getSelectedIndex());
        if (!strTempExchangeName.equals(this.strExchangeName)) {
            if (this.dpdInstrument.size() > 0) {
                this.dpdInstrument.removeAllItems();
            }
            this.strExchangeName = strTempExchangeName;
            String[] temp = iWinRefresh.getInstance().showform.sortArray(AppConstants.dynamicList.getInstruments(this.strExchangeName));
            int l_nIndex = 0;
            for (int counter = 0; counter < temp.length; ++counter) {
                if (!temp[counter].equals("FUTCOM")) continue;
                l_nIndex = counter;
            }
            this.dpdInstrument.addItem(iWinRefresh.getInstance().showform.sortArray(AppConstants.dynamicList.getInstruments(this.strExchangeName)));
            this.dpdInstrument.setSelectedIndex(l_nIndex);
        }
    }

    public boolean jcommandAction(SoftKey softKey, Displayable d) {
        if (softKey.getLabel().equals("Select")) {
            if (this.getTitle().equals("Select Profile")) {
                AppConstants.selectProfile = false;
                AppConstants.SELECT_PROFILE_INDEX = (byte)AppConstants.profilelist.getIdFromName(this.dpdProfile.getText());
                AppConstants.sendrequest.sendMarketWatchRequestRealtime();
            } else if (this.getTitle().equals("Economic Calendar")) {
                AppConstants.selectEvent = true;
                iWinRefresh.getInstance().showProgressBar();
                AppConstants.sendrequest.sendEconSymbolLookupRequest(this.getIndexAcctoCountry(this.getCountryIndex()), this.getIndexAcctoFrequency(this.getFrequencyIndex()), 1);
            } else {
                String strExchange = this.dpdExchange.getListItem(this.dpdExchange.getSelectedIndex());
                String strInstrument = this.dpdInstrument.getListItem(this.dpdInstrument.getSelectedIndex());
                String strSecurity = strExchange + " " + strInstrument;
                int itempMarketSegmentId = -1;
                int itempInstrumentId = -1;
                DynamicExchange dynamicExchange = AppConstants.dynamicList.getExchange(strExchange, "0", "0", "0", "0");
                itempMarketSegmentId = dynamicExchange.iSegmentId;
                String strInstrumentId = (String)dynamicExchange.htInstruments.get(strInstrument);
                itempInstrumentId = Integer.parseInt(strInstrumentId);
                if (this.iPage == 0) {
                    iWinRefresh.getInstance().showform.showSecurityInfo(strSecurity, this.iPage, itempMarketSegmentId, itempInstrumentId, strExchange, strInstrument);
                } else if (this.iPage == 1) {
                    AppConstants.strSearchString = strSecurity;
                    AppConstants.iMarketSegmentId = itempMarketSegmentId;
                    AppConstants.iInstrumentId = itempInstrumentId;
                    iWinRefresh.getInstance().showProgressBar();
                    AppConstants.sendrequest.sendGainersLosersRequest(itempMarketSegmentId, itempInstrumentId, strInstrument, AppConstants.iListIndex);
                }
            }
            return true;
        }
        if (softKey.getLabel().equals("Back")) {
            if (iWinRefresh.iPreviousForm == 5) {
                AppConstants.BackFromExchange = true;
                AppConstants.selectProfile = false;
                iWinRefresh.getInstance().backForm(iWinRefresh.iPreviousForm);
            } else if (iWinRefresh.iPreviousForm == 39) {
                AppConstants.selectProfile = false;
                String[][] strTemp = iWinRefresh.getInstance().showform.econData.getData();
                int itempCurrentPg = iWinRefresh.getInstance().showform.econData.getCurrentPage();
                int itempTotalPg = iWinRefresh.getInstance().showform.econData.getTotalPage();
                iWinRefresh.getInstance().showform.econData.setData(strTemp, itempCurrentPg, itempTotalPg, "Economic Calendar");
                iWinRefresh.getInstance().showform.showEconData();
            } else {
                iWinRefresh.getInstance().backForm(iWinRefresh.iPreviousForm);
            }
        }
        return true;
    }

    public int getCountryIndex() {
        int itemp = this.dpdCountry.getSelectedIndex();
        if (itemp == 0 && this.dpdCountry.size() == 14) {
            return -1;
        }
        if (itemp == 0 && this.dpdCountry.size() == 13) {
            return 100;
        }
        if (this.dpdCountry.size() == 1) {
            return 7;
        }
        if (this.dpdCountry.size() == 13) {
            return this.getAdjustedCountryIndex(itemp);
        }
        return itemp;
    }

    public int getAdjustedCountryIndex(int itemp) {
        if (itemp <= 6) {
            System.out.println("itemppppppppppppppppppppp" + itemp);
            return itemp;
        }
        System.out.println("itemppppppppppppppppppppp" + itemp);
        return itemp + 1;
    }

    public int getFrequencyIndex() {
        int itemp = this.dpdFrequency.getSelectedIndex();
        if (itemp == 0) {
            return -1;
        }
        return itemp;
    }

    public String getIndexAcctoFrequency(int temp) {
        String strIndex = "";
        switch (temp) {
            case -1: {
                strIndex = "-1";
                break;
            }
            case 1: {
                strIndex = "6";
                break;
            }
            case 2: {
                strIndex = "1";
                break;
            }
            case 3: {
                strIndex = "7";
                break;
            }
            case 4: {
                strIndex = "2";
                break;
            }
            case 5: {
                strIndex = "3";
                break;
            }
            case 6: {
                strIndex = "4";
                break;
            }
            case 7: {
                strIndex = "5";
            }
        }
        return strIndex;
    }

    public String getIndexAcctoCountry(int temp) {
        String strIndex = "";
        switch (temp) {
            case -1: {
                strIndex = "-1";
                break;
            }
            case 1: {
                strIndex = "9";
                break;
            }
            case 2: {
                strIndex = "2";
                break;
            }
            case 3: {
                strIndex = "13";
                break;
            }
            case 4: {
                strIndex = "10";
                break;
            }
            case 5: {
                strIndex = "3";
                break;
            }
            case 6: {
                strIndex = "4";
                break;
            }
            case 7: {
                strIndex = "1";
                break;
            }
            case 8: {
                strIndex = "5";
                break;
            }
            case 9: {
                strIndex = "6";
                break;
            }
            case 10: {
                strIndex = "11";
                break;
            }
            case 11: {
                strIndex = "12";
                break;
            }
            case 12: {
                strIndex = "7";
                break;
            }
            case 13: {
                strIndex = "8";
                break;
            }
            default: {
                strIndex = "-2";
            }
        }
        return strIndex;
    }
}

