/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.JPlatformCanvas;
import GeneralUI.Table;
import chart.ChartCanvas;
import common.AppConstants;
import common.CommonList;
import common.Profile;
import common.TagData;
import common.Utilities;
import login.Login;
import login.Settings;
import market.Alerts;
import market.BestFive;
import market.CommonCanvas;
import market.CommonForm;
import market.CustomOrientation;
import market.EconomicData;
import market.MainMenu;
import market.MarketInfo;
import market.MarketWatch;
import market.MyWatchListResult;
import market.PMSWatch;
import market.ParityCalculator;
import market.ParityWatch;
import market.SecurityInfo;
import market.SelectExchange;
import market.SelectionWindow;
import market.ViewDetails;
import market.iWinRefresh;

public class ShowForm {
    public iWinRefresh iwinapp;
    public Login login;
    public MainMenu mainmenu;
    public MarketWatch marketwatch = new MarketWatch();
    public MyWatchListResult mywatchListresult;
    public CustomOrientation myCustomList;
    public MarketInfo marketinfo;
    public CommonCanvas commoncanvas;
    public EconomicData econData;
    public JPlatformCanvas mainCanvas;
    public CommonList commonList;
    public Settings settings;
    public ViewDetails viewdetails;
    public BestFive bestfive;
    public CommonForm commonform;
    public SecurityInfo securityinfo;
    public SelectExchange selectExchange;
    public ParityCalculator parityCalc;
    public ParityWatch parityWatch;
    public PMSWatch PortfolioWatch;
    public ChartCanvas chartCanvas;
    public SelectionWindow selectionWindow;
    public Alerts alerts;
    private int iMarketSegmentId;
    private int iInstrumentId;
    private String strSegmentName;
    private String strSymbol;
    private String strExpiryDate;
    private String strStrikePrice;
    private String strOptionType;
    private String strInstType;
    private int iPage;
    private String strDownLoadPath = "http://www.marketviewmobile.com/mvm/mvmrealtime.jad";

    public ShowForm() {
        this.iwinapp = iWinRefresh.getInstance();
        this.mainCanvas = JPlatformCanvas.getInstance();
    }

    public void showLogin() {
        if (this.login == null) {
            this.login = new Login();
        }
        this.mainCanvas.setScreenID((byte)1);
    }

    public void showMainMenu() {
        this.parityCalc = null;
        this.parityWatch = null;
        this.securityinfo = null;
        this.alerts = null;
        this.myCustomList = null;
        AppConstants.iCurrentPage = (byte)19;
        if (this.mainmenu == null) {
            this.mainmenu = new MainMenu("Main Menu");
            String[] strHeadings = new String[]{"MarketWatch", "Profile", "Mutual Fund", "IPO", "Insurance", "Economic Calendar", "TickerNews", "Market Info", "Tools", "About", "LogOff"};
            for (int itr = 0; itr < strHeadings.length; ++itr) {
                this.mainmenu.append(strHeadings[itr]);
            }
        }
        this.mainCanvas.setScreenID((byte)4);
    }

    public void showTools() {
        this.parityCalc = null;
        this.parityWatch = null;
        this.securityinfo = null;
        String[] strHeading = new String[]{"Alerts", "Parity Calc", "PMS", "Preferences"};
        this.iwinapp.showform.showCommonList("Tools", strHeading);
    }

    public void createPMSForm(String[][] strData, String strpTotalValue) {
        this.PortfolioWatch = null;
        if (this.PortfolioWatch == null) {
            String[] headerValue = this.getHeaderValue(AppConstants.IsScripByReq);
            this.PortfolioWatch = new PMSWatch(headerValue, strData, JPlatformCanvas.SCREEN_WIDTH, JPlatformCanvas.SCREEN_HEIGHT - JPlatformCanvas.SOFT_KEYBAR_HEIGHT * 4, 1);
            for (int z = 1; z < 4; ++z) {
                this.PortfolioWatch.setColumnOrientation(z, 1);
            }
            this.PortfolioWatch.setMainValues(strpTotalValue);
        }
        this.showPMS();
    }

    public String[] getHeaderValue(boolean isMainOrDetail) {
        if (!isMainOrDetail) {
            String[] headerValue = new String[]{"Scrip Name", "LTP", "P/L"};
            return headerValue;
        }
        String[] headerValue = new String[]{"BUY/SELL", "Qty", "Price"};
        return headerValue;
    }

    public void createNEWPMSForm(String[][] strData, String strpDescValue) {
        int i = 1;
        String[] headerValue = this.getHeaderValue(AppConstants.IsScripByReq);
        this.iwinapp.showform.PortfolioWatch.initialize(headerValue, strData, JPlatformCanvas.SCREEN_WIDTH, JPlatformCanvas.SCREEN_HEIGHT - JPlatformCanvas.SOFT_KEYBAR_HEIGHT * 4, 1);
        if (AppConstants.IsScripByReq) {
            i = 0;
        }
        for (int z = i; z < 4; ++z) {
            this.PortfolioWatch.setColumnOrientation(z, 1);
        }
        this.PortfolioWatch.setMainValues(strpDescValue);
        this.showPMS();
    }

    public void showNews(String strNews, boolean bReloadFlag) {
        if (bReloadFlag) {
            this.PortfolioWatch = null;
            String[] tmpArr = Table.formatTextInCells(strNews, '~', 0, JPlatformCanvas.SCREEN_WIDTH - 5);
            int len = tmpArr.length;
            String[][] tableData = new String[len][1];
            for (int i = 0; i < len; ++i) {
                tableData[i][0] = tmpArr[i];
            }
            String[] headerValue = new String[]{"Headlines"};
            this.PortfolioWatch = new PMSWatch(headerValue, tableData, JPlatformCanvas.SCREEN_WIDTH, JPlatformCanvas.SCREEN_HEIGHT - JPlatformCanvas.SOFT_KEYBAR_HEIGHT * 2, 0);
            this.PortfolioWatch.setFitPolicy((byte)1);
        }
        this.mainCanvas.setScreenID((byte)33);
    }

    public void showPMS() {
        this.mainCanvas.setScreenID((byte)29);
    }

    public void showParityCalc() {
        if (this.parityCalc == null) {
            this.parityCalc = new ParityCalculator("Parity Calculator");
        }
        this.mainCanvas.setScreenID((byte)26);
    }

    public void showParityWatch(String strCIF, String strCustomDuty, String strBankCost, String strFineness) {
        if (this.parityWatch == null) {
            this.parityWatch = new ParityWatch();
        }
        AppConstants.iCurrentPage = (byte)27;
        this.parityWatch.Initialize(strCIF, strCustomDuty, strBankCost, strFineness);
        this.mainCanvas.setScreenID((byte)27);
    }

    public void showMarketWatch() {
        this.alerts = null;
        this.chartCanvas = null;
        if (this.marketwatch == null) {
            this.marketwatch = new MarketWatch();
        }
        this.mainCanvas.setScreenID((byte)5);
    }

    public MarketWatch getMarketWatch() {
        return this.marketwatch;
    }

    public void showAddProfile() {
        this.securityinfo = null;
        if (this.securityinfo == null) {
            this.securityinfo = new SecurityInfo("New Profile");
        }
        this.mainCanvas.setScreenID((byte)25);
    }

    public void showSelectInstrument(int ipPage) {
        String[] strExchanges;
        this.selectExchange = null;
        if (this.selectExchange == null) {
            this.selectExchange = new SelectExchange();
        }
        if ((strExchanges = this.sortArray(AppConstants.dynamicList.getExcangeNameList())) != null && strExchanges.length > 0) {
            String[] strInstruments = this.sortArray(AppConstants.dynamicList.getInstruments(strExchanges[0]));
            this.selectExchange.setData(strExchanges, strInstruments);
        }
        this.selectExchange.setPage(ipPage);
        this.iPage = ipPage;
        this.mywatchListresult = null;
        this.mainCanvas.setScreenID((byte)12);
    }

    public void showSelectEconSymbol() {
        this.selectExchange = null;
        if (this.selectExchange == null) {
            this.selectExchange = new SelectExchange("Economic Calendar", 1);
        }
        iWinRefresh.iPreviousForm = 39;
        if (AppConstants.bECOWORLD && AppConstants.bECOINDIA) {
            this.selectExchange.setCountryData(new String[]{"All", "Australia", "Canada", "China", "EuropeanMonetaryUnion", "France", "Germany", "India", "Italy", "Japan", "New Zealand", "Switzerland", "UK", "US"});
        } else if (AppConstants.bECOWORLD) {
            this.selectExchange.setCountryData(new String[]{"ALL", "Australia", "Canada", "China", "EuropeanMonetaryUnion", "France", "Germany", "Italy", "Japan", "New Zealand", "Switzerland", "UK", "US"});
        } else {
            this.selectExchange.setCountryData(new String[]{"India"});
        }
        this.selectExchange.setFrequencyData(new String[]{"All", "Daily", "Weekly", "Fortnightly", "Monthly", "Quarterly", "Half Yearly", "Yearly"});
        this.mainCanvas.setScreenID((byte)12);
    }

    public void showSelectProfile() {
        this.selectExchange = null;
        if (this.selectExchange == null) {
            this.selectExchange = new SelectExchange("Select Profile");
        }
        String[] strProfileNames = AppConstants.profilelist.getProfileNames();
        this.selectExchange.setProfilename(strProfileNames);
        this.mainCanvas.setScreenID((byte)12);
    }

    public void showSelectExchangeList() {
        iWinRefresh.iPreviousForm = iWinRefresh.iFirstForm;
        String[] strData = AppConstants.dynamicList.getExcangeNameList();
        strData = this.sortArray(strData);
        this.showCommonList("Select Exchange", strData);
    }

    public void showSecurityInfo(String strSecurity, int iIndex, int iMarketSgId, int iInstrumentId, String strpSegmentName, String strpInstrument) {
        this.securityinfo = null;
        if (this.securityinfo == null) {
            this.securityinfo = new SecurityInfo(strSecurity);
        }
        this.securityinfo.setData(iIndex, iMarketSgId, iInstrumentId, strpSegmentName, strpInstrument);
        this.mainCanvas.setScreenID((byte)11);
    }

    public void showSymbolLookUpRequest(int ipMarketSegId, int ipInstrumentId, String strpSegmentName, String strpInstrumentName, int ipPageNo, String strpSymbol, String strpExpiryDate, String strpStrikePrice, String strpOptionType, String strpInstType, int f_nContractType) {
        this.iMarketSegmentId = ipMarketSegId;
        this.iInstrumentId = ipInstrumentId;
        this.strSymbol = strpSymbol;
        this.strExpiryDate = strpExpiryDate;
        this.strStrikePrice = strpStrikePrice;
        this.strOptionType = strpOptionType;
        this.strInstType = strpInstType;
        this.strSegmentName = strpSegmentName;
        AppConstants.strSearchString = this.strSymbol + " " + this.strExpiryDate + " " + this.strStrikePrice + " " + this.strOptionType;
        String strInstrumentDesc = strpSegmentName + " " + strpInstrumentName;
        this.iwinapp.showProgressBar();
        AppConstants.sendrequest.sendSymbolLookupRequest(this.iMarketSegmentId, this.iInstrumentId, strpInstrumentName, ipPageNo, this.strSymbol, this.strExpiryDate, this.strStrikePrice, this.strOptionType, this.strInstType, f_nContractType);
        this.iwinapp.progress.setProgress(strInstrumentDesc + " " + AppConstants.strSearchString, 2);
    }

    public MyWatchListResult getWatchListResult(boolean bReload) {
        if (bReload && this.mywatchListresult == null) {
            this.mywatchListresult = new MyWatchListResult();
        }
        return this.mywatchListresult;
    }

    public void showMyWatchListResults(boolean bReload) {
        if (bReload) {
            this.mywatchListresult = this.getWatchListResult(true);
            this.mywatchListresult.SetValues(this.strSegmentName, this.strSymbol, this.strExpiryDate, this.strStrikePrice, this.strOptionType, this.strInstType);
        }
        if (this.mywatchListresult != null) {
            this.mainCanvas.setScreenID((byte)13);
        }
    }

    public void showMyCustomListResults() {
        AppConstants.iCurrentPage = (byte)36;
        if (this.myCustomList == null) {
            this.myCustomList = new CustomOrientation("Custom Orientation");
            String[] strOptions = new String[]{"BidPrice", "BidQty", "AskPrice", "AskQty", "LTP", "LUT", "Open", "High", "Low", "NetChg"};
            this.iwinapp.showform.myCustomList.SetOrientationList(strOptions);
        }
        this.mainCanvas.setScreenID((byte)36);
    }

    public void showCommonList(String strFormName, String[] strpHeading) {
        if (this.commonList == null) {
            this.commonList = new CommonList(strFormName);
        }
        this.commonList.setTitle(strFormName);
        this.commonList.setData(this.iPage);
        this.commonList.deleteAll();
        for (int i = 0; i < strpHeading.length; ++i) {
            this.commonList.append(strpHeading[i]);
        }
        this.mainCanvas.setScreenID((byte)23);
    }

    public void showProfile() {
        iWinRefresh.iPreviousForm = 4;
        String[] strHeading = this.sortArray(AppConstants.profilelist.getProfileNames());
        this.iwinapp.showform.showCommonList("Profile", strHeading);
    }

    public void showModifyProfile() {
        AppConstants.bCommonCanvasThread = true;
        this.createCommonCanvas();
        Profile profile = AppConstants.profilelist.getData(Integer.toString(AppConstants.SELECT_PROFILE_INDEX));
        TagData[] tag = profile.getTagData();
        String[][] strProfileData = new String[tag.length][4];
        for (int i = 0; i < tag.length; ++i) {
            strProfileData[i][0] = tag[i].strScripDesc;
            strProfileData[i][1] = Integer.toString(tag[i].iSegmentId);
            strProfileData[i][2] = Integer.toString(tag[i].iInstrumentId);
            strProfileData[i][3] = tag[i].strKeyOfData;
        }
        this.commoncanvas.setData(strProfileData, 0, 0, "Profile Scrips");
        this.showCommonCanvas();
    }

    public void showMutualFund() {
        String[] strHeading = new String[]{"NAV Report", "New Fund", "AUM Report "};
        this.iwinapp.showform.showCommonList("Mutual Fund", strHeading);
    }

    public void showMutualFundDetails() {
        this.securityinfo = null;
        if (this.securityinfo == null) {
            this.securityinfo = new SecurityInfo("Mutual Fund");
        }
        this.mainCanvas.setScreenID((byte)16);
    }

    public void showInsurance() {
        this.securityinfo = null;
        if (this.securityinfo == null) {
            this.securityinfo = new SecurityInfo("Insurance");
        }
        this.mainCanvas.setScreenID((byte)30);
    }

    public void showIPO() {
        String[] strHeading = new String[]{"Open Issues", "Upcoming Issues", "Closed Issues"};
        this.iwinapp.showform.showCommonList("IPO", strHeading);
    }

    public void showSettings(int pageID) {
        this.settings = null;
        if (this.settings == null) {
            this.settings = new Settings();
        }
        this.settings.init(pageID);
        this.mainCanvas.setScreenID((byte)2);
    }

    public void showViewDetails(byte bytePage) {
        if (this.viewdetails == null) {
            this.viewdetails = new ViewDetails();
        }
        this.viewdetails.setData(bytePage);
        this.mainCanvas.setScreenID((byte)10);
    }

    public void showBestFive(String[] strDisplayData, int[] iValue) {
        if (this.bestfive == null) {
            this.bestfive = new BestFive();
        }
        this.bestfive.setData(strDisplayData, iValue);
        this.mainCanvas.setScreenID((byte)24);
    }

    public void showAbout() {
        this.showCommonForm("About", "", "", "", "", "", "");
    }

    public void showPMSDetail(String strProfitLoss) {
        this.showCommonForm("PMS", "", "", this.PortfolioWatch.getRowData(strProfitLoss), "", "", "");
    }

    public void showScripByPMSDetail(String Scripname) {
        this.mainCanvas.setScreenID((byte)29);
    }

    public void showUpdate() {
        try {
            this.iwinapp.platformRequest(this.strDownLoadPath);
            this.iwinapp.quit();
        }
        catch (Exception e) {
            Utilities.printLog("ShowUpdate " + e.toString());
        }
    }

    public void showCommonForm(String strFormName, String strpMarketSegmentId, String strpInstrumentId, String strpProfileData, String strpPMS1, String strpPMS2, String strpPMS3) {
        if (this.commonform == null) {
            this.commonform = new CommonForm(strFormName);
        }
        this.commonform.setTitle(strFormName);
        this.commonform.initializeForm();
        if (strpInstrumentId.length() > 0 || strpProfileData.length() > 0) {
            this.commonform.setData(strpMarketSegmentId, strpInstrumentId, strpProfileData);
        }
        if (strpPMS1.length() > 0 && strpPMS2.length() > 0 && strpPMS3.length() > 0) {
            this.commonform.setPMSData(strpMarketSegmentId, strpInstrumentId, strpProfileData, strpPMS1, strpPMS2, strpPMS3);
        }
        this.mainCanvas.setScreenID((byte)8);
    }

    public CommonCanvas createCommonCanvas() {
        if (this.commoncanvas == null) {
            this.commoncanvas = new CommonCanvas();
        }
        return this.commoncanvas;
    }

    public void showCommonCanvas() {
        this.mainCanvas.setScreenID((byte)6);
    }

    public void createEconData() {
        this.econData = null;
        if (this.econData == null) {
            this.econData = new EconomicData();
        }
    }

    public void showEconData() {
        this.mainCanvas.setScreenID((byte)39);
    }

    public MarketInfo createMarketInfoForm() {
        if (this.marketinfo == null) {
            this.marketinfo = new MarketInfo();
        }
        return this.marketinfo;
    }

    public void showMarketInfo() {
        this.createMarketInfoForm();
        this.mainCanvas.setScreenID((byte)22);
    }

    public void showChart(byte[] f_btImage) {
        AppConstants.iListIndex = 9;
        this.createMarketInfoForm();
        this.marketinfo.setData(f_btImage);
        JPlatformCanvas.getInstance().setScreenID((byte)22);
    }

    public void showInteractiveChart(String f_strSegId, String f_strInstId, String f_strKey, String f_strTickData, int f_nChartType) {
        if (this.chartCanvas == null) {
            this.chartCanvas = new ChartCanvas();
        }
        this.chartCanvas.LoadChart(f_strSegId, f_strInstId, f_strKey, f_nChartType, f_strTickData);
        JPlatformCanvas.getInstance().setScreenID((byte)34);
    }

    public ChartCanvas getChartObj() {
        return this.chartCanvas;
    }

    public void reloadInteractiveChart(boolean bIndicatorFlag, int f_nPeriod, int f_nIndicatorType, int f_nFormulaIndex, String f_strMultiplier) {
        this.chartCanvas.setIndicatorValues(bIndicatorFlag, f_nPeriod, f_nIndicatorType, f_nFormulaIndex, f_strMultiplier);
        JPlatformCanvas.getInstance().setScreenID((byte)34);
    }

    public void reloadInteractiveChart(boolean bStudyFlag, int f_nMACDSignalPeriod, int f_nShortPeriod, int f_nLongPeriod, int f_nStudyType) {
        this.chartCanvas.setStudiesValues(bStudyFlag, f_nMACDSignalPeriod, f_nShortPeriod, f_nLongPeriod, f_nStudyType);
        JPlatformCanvas.getInstance().setScreenID((byte)34);
    }

    public void showSelectionWindow(String strpFormName) {
        this.selectionWindow = null;
        if (this.selectionWindow == null) {
            this.selectionWindow = new SelectionWindow(strpFormName);
        }
        this.selectionWindow.setFormula();
        JPlatformCanvas.getInstance().setScreenID((byte)35);
    }

    public void showMarketInfoHeading() {
        String[] strHeading = new String[]{"Gainers", "Losers", "Vol Toppers", "Vol Shockers", "Vol Crashers", "Index Info", "BSE 30", "NIFTY 50", "World Indices"};
        this.iwinapp.showform.showCommonList("Market Info", strHeading);
    }

    public void showWorldIndices() {
        String[] strHeading = new String[]{"US", "Europe", "Asia Pacific", "Africa", "Middle East"};
        this.iwinapp.showform.showCommonList("World Indices", strHeading);
    }

    public void showAlerts() {
        String[] strHeading = new String[]{"Modify Alerts", "Alerts History"};
        this.iwinapp.showform.showCommonList("Alerts", strHeading);
    }

    public void showNewAlerts(TagData tag, int ipOperator, String strpPrice) {
        this.alerts = null;
        if (null == this.alerts) {
            this.alerts = new Alerts("Alerts");
        }
        this.alerts.setData(tag, ipOperator, strpPrice);
        this.mainCanvas.setScreenID((byte)19);
    }

    public void showAlertsHistory() {
        this.createCommonCanvas();
        String[][] strAlerts = AppConstants.profilelist.getAlertHistory();
        this.commoncanvas.setData(strAlerts, 0, 1, "Alert History");
        this.showCommonCanvas();
    }

    public void showModifyAlerts() {
        this.createCommonCanvas();
        String[][] strAlerts = AppConstants.profilelist.getAlerts();
        this.commoncanvas.setData(strAlerts, 0, 1, "Modify Alerts");
        this.showCommonCanvas();
    }

    public String[] sortArray(String[] aSource) {
        String sTempName = "";
        int iArrayLength = aSource.length;
        for (int a = 1; a < iArrayLength; ++a) {
            for (int b = iArrayLength - 1; b >= a; --b) {
                if (aSource[b - 1].compareTo(aSource[b]) <= 0) continue;
                sTempName = aSource[b - 1];
                aSource[b - 1] = aSource[b];
                aSource[b] = sTempName;
            }
        }
        return aSource;
    }
}

