/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import common.Utilities;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;
import structures.InfoFeedBestBuySell;

public class InfoFeedBSEEQTouchline {
    private int m_nFTCode = 0;
    private byte[] m_btScripId = new byte[13];
    private byte[] m_btGroupName = new byte[3];
    private int m_nScripCode = 0;
    private int m_nOpenRate = 0;
    private int m_nHighRate = 0;
    private int m_nLowRate = 0;
    private int m_nCloseRate = 0;
    private int m_nNoOfTrades = 0;
    private int m_nTradedVolume = 0;
    private int m_nTradedValue = 0;
    private int m_nLastTradeQty = 0;
    private int m_nLastTradeRate = 0;
    private int m_nTotalBuyQty = 0;
    private int m_nTotalSellQty = 0;
    private byte[] m_btTradeValueFlag = new byte[1];
    private byte[] m_btTrend = new byte[1];
    private int m_nLowerCircuitLimit = 0;
    private int m_nUpperCircuitLimit = 0;
    private int m_nWeightedAverage = 0;
    private InfoFeedBestBuySell[] m_objBestBuySell;
    private int m_nPreviousCloseRate;
    private String m_strKeyOfData;
    private int m_nDivisionFactor;
    private static int l_PrevTimestamp = 0;

    public InfoFeedBSEEQTouchline(int iNoOfBestBuySell) {
        this.m_objBestBuySell = new InfoFeedBestBuySell[iNoOfBestBuySell];
        for (int i = 0; i < iNoOfBestBuySell; ++i) {
            this.m_objBestBuySell[i] = new InfoFeedBestBuySell();
        }
        this.m_nPreviousCloseRate = 0;
        this.m_strKeyOfData = "";
        this.m_nDivisionFactor = 2;
    }

    public short UpdateLLFBestFive(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[5], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[6] != 0) {
                f_objDataInputStream.read(this.m_btScripId, 0, 12);
            }
            if (f_objMsgHeader.m_nFieldDescription[7] != 0) {
                f_objDataInputStream.read(this.m_btGroupName, 0, 2);
            }
            this.m_nScripCode = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[8], f_objMsgHeader.m_nBaseValue);
            this.m_nOpenRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[9], f_objMsgHeader.m_nBaseValue);
            this.m_nHighRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[10], f_objMsgHeader.m_nBaseValue);
            this.m_nLowRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[11], f_objMsgHeader.m_nBaseValue);
            this.m_nCloseRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[12], f_objMsgHeader.m_nBaseValue);
            this.m_nNoOfTrades = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[13], f_objMsgHeader.m_nBaseValue);
            this.m_nTradedVolume = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[14], f_objMsgHeader.m_nBaseValue);
            this.m_nTradedValue = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[15], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradeQty = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[16], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradeRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[17], f_objMsgHeader.m_nBaseValue);
            this.m_nTotalBuyQty = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[18], f_objMsgHeader.m_nBaseValue);
            this.m_nTotalSellQty = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[19], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[20] != 0) {
                f_objDataInputStream.read(this.m_btTradeValueFlag, 0, 1);
            }
            if (f_objMsgHeader.m_nFieldDescription[21] != 0) {
                f_objDataInputStream.read(this.m_btTrend, 0, 1);
            }
            this.m_nLowerCircuitLimit = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[22], f_objMsgHeader.m_nBaseValue);
            this.m_nUpperCircuitLimit = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[23], f_objMsgHeader.m_nBaseValue);
            this.m_nWeightedAverage = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[24], f_objMsgHeader.m_nBaseValue);
            for (int l_nBestBuySellIndex = 0; l_nBestBuySellIndex < 5; ++l_nBestBuySellIndex) {
                if (-1 != this.m_objBestBuySell[l_nBestBuySellIndex].UpdateRate(f_objDataInputStream, f_objMsgHeader, l_nBestBuySellIndex, 25)) continue;
                return -1;
            }
            this.m_nPreviousCloseRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[45], f_objMsgHeader.m_nBaseValue);
            this.m_strKeyOfData = this.createKey(this.m_nFTCode).toString();
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateLLFTouchline(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[5], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[6] != 0) {
                f_objDataInputStream.read(this.m_btScripId, 0, 12);
            }
            if (f_objMsgHeader.m_nFieldDescription[7] != 0) {
                f_objDataInputStream.read(this.m_btGroupName, 0, 2);
            }
            this.m_nScripCode = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[8], f_objMsgHeader.m_nBaseValue);
            this.m_nOpenRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[9], f_objMsgHeader.m_nBaseValue);
            this.m_nHighRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[10], f_objMsgHeader.m_nBaseValue);
            this.m_nLowRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[11], f_objMsgHeader.m_nBaseValue);
            this.m_nCloseRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[12], f_objMsgHeader.m_nBaseValue);
            this.m_nNoOfTrades = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[13], f_objMsgHeader.m_nBaseValue);
            this.m_nTradedVolume = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[14], f_objMsgHeader.m_nBaseValue);
            this.m_nTradedValue = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[15], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradeQty = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[16], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradeRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[17], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[18] != 0) {
                f_objDataInputStream.read(this.m_btTradeValueFlag, 0, 1);
            }
            if (f_objMsgHeader.m_nFieldDescription[19] != 0) {
                f_objDataInputStream.read(this.m_btTrend, 0, 1);
            }
            this.m_nWeightedAverage = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[20], f_objMsgHeader.m_nBaseValue);
            for (int l_nBestBuySellIndex = 0; l_nBestBuySellIndex < 1; ++l_nBestBuySellIndex) {
                if (-1 != this.m_objBestBuySell[l_nBestBuySellIndex].UpdateRate(f_objDataInputStream, f_objMsgHeader, l_nBestBuySellIndex, 21)) continue;
                return -1;
            }
            this.m_nPreviousCloseRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[25], f_objMsgHeader.m_nBaseValue);
            this.m_strKeyOfData = this.createKey(this.m_nFTCode).toString();
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private StringBuffer createKey(int iFTCode) {
        StringBuffer strTemp = new StringBuffer();
        return strTemp.append(iFTCode).append(":");
    }

    private void setData(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_objBestBuySell[0].m_nBuyQty, this.m_objBestBuySell[0].m_nBuyRate, this.m_objBestBuySell[0].m_nSellQty, this.m_objBestBuySell[0].m_nSellRate, this.m_nCloseRate, this.m_nPreviousCloseRate, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, this.m_nOpenRate, this.m_nHighRate, this.m_nLowRate);
                break;
            }
            case 24: {
                String[] strData = new String[20];
                for (int i = 0; i < this.m_objBestBuySell.length; ++i) {
                    strData[i * 4] = Utilities.ToString(this.m_objBestBuySell[i].m_nBuyQty);
                    strData[i * 4 + 1] = Utilities.ConvertToDecimal(this.m_objBestBuySell[i].m_nBuyRate, this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                    strData[i * 4 + 2] = Utilities.ToString(this.m_objBestBuySell[i].m_nSellQty);
                    strData[i * 4 + 3] = Utilities.ConvertToDecimal(this.m_objBestBuySell[i].m_nSellRate, this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                }
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nCloseRate, this.m_nTradedVolume, this.m_nOpenRate, this.m_nHighRate, this.m_nLowRate, this.m_nPreviousCloseRate, this.m_nTotalBuyQty, this.m_nTotalSellQty, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, this.m_nWeightedAverage, 0L);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nCloseRate, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }
}

