/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import common.Utilities;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;

public class InfoFeedINTLSPOT_FOREXTouchline {
    private int m_nFTCode = 0;
    private byte[] m_btSymbol = new byte[21];
    private byte[] m_btExchangeSymbol = new byte[21];
    private int m_nContributorCode = 0;
    private int m_nRegionCode = 0;
    private int m_nCityCode = 0;
    private long m_nPriceMultiplier = 0L;
    private int m_nBidRate = 0;
    private int m_nAskRate = 0;
    private int m_nLastTradedRate = 0;
    private int m_nNetChange = 0;
    private int m_nPercentNetChange = 0;
    private int m_nLastTradedTime = 0;
    private byte[] m_btTickIndicator = new byte[1];
    private int m_nPreviousCloseRate = 0;
    private int m_nOpen = 0;
    private int m_nHigh = 0;
    private int m_nLow = 0;
    private int m_nClose = 0;
    private String m_strKeyOfData = "";

    public short Update(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream, int f_nSegmentId) {
        try {
            this.m_nFTCode = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btSymbol, 0, 21);
            f_objDataInputStream.read(this.m_btExchangeSymbol, 0, 21);
            this.m_nContributorCode = f_objDataInputStream.readInt();
            this.m_nRegionCode = f_objDataInputStream.readInt();
            this.m_nCityCode = f_objDataInputStream.readInt();
            this.m_nPriceMultiplier = f_objDataInputStream.readLong();
            this.m_nBidRate = f_objDataInputStream.readInt();
            this.m_nAskRate = f_objDataInputStream.readInt();
            if (f_nSegmentId == 13) {
                this.m_nLastTradedRate = f_objDataInputStream.readInt();
                this.m_nNetChange = f_objDataInputStream.readInt();
                this.m_nPercentNetChange = f_objDataInputStream.readInt();
                this.m_nLastTradedTime = f_objDataInputStream.readInt();
                f_objDataInputStream.read(this.m_btTickIndicator, 0, 1);
            } else if (f_nSegmentId == 12) {
                this.m_nPercentNetChange = f_objDataInputStream.readInt();
                this.m_nNetChange = f_objDataInputStream.readInt();
                this.m_nLastTradedRate = f_objDataInputStream.readInt();
                this.m_nLastTradedTime = f_objDataInputStream.readInt();
            }
            this.m_nPreviousCloseRate = f_objDataInputStream.readInt();
            this.m_nOpen = f_objDataInputStream.readInt();
            this.m_nHigh = f_objDataInputStream.readInt();
            this.m_nLow = f_objDataInputStream.readInt();
            this.m_nClose = f_objDataInputStream.readInt();
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btExchangeSymbol)).toString();
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateLLFTouchline(CMsgHeader f_objInfoFeedMsgHeader, DataInputStream f_objDataInputStream, int f_nSegmentId) {
        try {
            int l_nIndex = 5;
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 20);
            }
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++] != 0) {
                f_objDataInputStream.read(this.m_btExchangeSymbol, 0, 20);
            }
            this.m_nContributorCode = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nRegionCode = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nCityCode = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nPriceMultiplier = Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nBidRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nAskRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_nSegmentId == 13) {
                this.m_nNetChange = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nPercentNetChange = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nLastTradedRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nLastTradedTime = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
                if (f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++] != 0) {
                    f_objDataInputStream.read(this.m_btTickIndicator, 0, 1);
                }
            } else if (f_nSegmentId == 12) {
                this.m_nPercentNetChange = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nNetChange = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nLastTradedRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nLastTradedTime = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            this.m_nPreviousCloseRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nOpen = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nHigh = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLow = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nClose = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[l_nIndex++], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btExchangeSymbol)).toString();
            this.setData(f_objInfoFeedMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private StringBuffer createKey(int iFTCode, String strExchangeSymbol) {
        StringBuffer strTemp = new StringBuffer();
        strExchangeSymbol = strExchangeSymbol.replace(':', '#');
        strExchangeSymbol = strExchangeSymbol.replace('\\', '*');
        return strTemp.append(iFTCode).append(":").append(strExchangeSymbol).append(":");
    }

    private void setData(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, 0, this.m_nBidRate, 0, this.m_nAskRate, this.m_nClose, this.m_nPreviousCloseRate, f_objMsgHeader.m_nMsgTimeStamp, 0, this.m_nOpen, this.m_nHigh, this.m_nLow);
                break;
            }
            case 24: {
                int m_nDivisionFactor = iWinRefresh.getInstance().showform.bestfive.getPriceMultiplier(this.m_strKeyOfData);
                String[] strData = new String[20];
                strData[0] = Utilities.ToString(0);
                strData[1] = Utilities.ConvertToDecimal(this.m_nBidRate, m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                strData[2] = Utilities.ToString(0);
                strData[3] = Utilities.ConvertToDecimal(this.m_nAskRate, m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nClose, 0, this.m_nOpen, this.m_nHigh, this.m_nLow, this.m_nPreviousCloseRate, 0, 0, f_objMsgHeader.m_nMsgTimeStamp, m_nDivisionFactor, 0, 0L);
                break;
            }
            case 27: {
                iWinRefresh.getInstance().showform.parityWatch.setData(this.m_strKeyOfData, this.m_nClose, f_objMsgHeader.m_nMsgTimeStamp);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nClose, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }
}

