/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import common.Utilities;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;

public class InfoFeedMCXTouchline {
    private int m_nFTCode = 0;
    private int m_nInstrumentIdentifier = 0;
    private int m_nIdentifierOfTheUnderlying = 0;
    private byte[] m_btSymbol = new byte[21];
    private int m_nContractExpiry = 0;
    private int m_nStrikePrice = 0;
    private byte[] m_btOptionType = new byte[3];
    private int m_nLastTradedRate = 0;
    private int m_nLastTradedVolume = 0;
    private byte[] m_btLastTradedTime = new byte[26];
    private int m_nAverageTradedRate = 0;
    private int m_nTotalVolumeTraded = 0;
    private int m_nOpenInterest = 0;
    private int m_nOpenRate = 0;
    private int m_nHighRate = 0;
    private int m_nLowRate = 0;
    private int m_nCloseRate = 0;
    private long m_nValue = 0L;
    private byte[] m_btRateUnit = new byte[21];
    private int m_nQuotationSize = 0;
    private int m_nPreviousCloseRate = 0;
    private int m_nNumberOfTrades = 0;
    private int[] m_nBuyQty;
    private int[] m_nBuyPrice;
    private int[] m_nSellQty;
    private int[] m_nSellPrice;
    private int m_nTotalBuyQty;
    private int m_nTotalSellQty;
    private String m_strKeyOfData;
    private int m_nDivisionFactor;

    public InfoFeedMCXTouchline(int iNoOfBestBuySell) {
        this.m_nBuyQty = new int[iNoOfBestBuySell];
        this.m_nBuyPrice = new int[iNoOfBestBuySell];
        this.m_nSellQty = new int[iNoOfBestBuySell];
        this.m_nSellPrice = new int[iNoOfBestBuySell];
        this.m_nTotalBuyQty = 0;
        this.m_nTotalSellQty = 0;
        this.m_strKeyOfData = "";
        this.m_nDivisionFactor = 2;
    }

    public short UpdateTouchline(CMsgHeader f_objInfoFeedMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int i;
            this.m_nFTCode = f_objDataInputStream.readInt();
            this.m_nInstrumentIdentifier = f_objDataInputStream.readInt();
            this.m_nIdentifierOfTheUnderlying = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btSymbol, 0, 21);
            this.m_nContractExpiry = f_objDataInputStream.readInt();
            this.m_nStrikePrice = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btOptionType, 0, 3);
            this.m_nLastTradedRate = f_objDataInputStream.readInt();
            this.m_nLastTradedVolume = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btLastTradedTime, 0, 26);
            this.m_nAverageTradedRate = f_objDataInputStream.readInt();
            this.m_nTotalVolumeTraded = f_objDataInputStream.readInt();
            this.m_nOpenInterest = f_objDataInputStream.readInt();
            this.m_nOpenRate = f_objDataInputStream.readInt();
            this.m_nHighRate = f_objDataInputStream.readInt();
            this.m_nLowRate = f_objDataInputStream.readInt();
            this.m_nCloseRate = f_objDataInputStream.readInt();
            this.m_nValue = f_objDataInputStream.readLong();
            f_objDataInputStream.read(this.m_btRateUnit, 0, 21);
            this.m_nQuotationSize = f_objDataInputStream.readInt();
            this.m_nPreviousCloseRate = f_objDataInputStream.readInt();
            for (i = 0; i < 1; ++i) {
                this.m_nBuyQty[i] = f_objDataInputStream.readInt();
                this.m_nBuyPrice[i] = f_objDataInputStream.readInt();
            }
            for (i = 0; i < 1; ++i) {
                this.m_nSellQty[i] = f_objDataInputStream.readInt();
                this.m_nSellPrice[i] = f_objDataInputStream.readInt();
            }
            this.m_strKeyOfData = this.createkey(this.m_nFTCode, this.m_nIdentifierOfTheUnderlying, this.m_nContractExpiry, this.m_nStrikePrice, Utilities.RemoveNull(this.m_btOptionType), f_objInfoFeedMsgHeader.m_nSegmentId).toString();
            this.setData(f_objInfoFeedMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateLLFTouchline(CMsgHeader f_objInfoFeedMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int i;
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[5], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nInstrumentIdentifier = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[6], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nIdentifierOfTheUnderlying = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[7], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[8] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 20);
            }
            this.m_nContractExpiry = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[9], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nStrikePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[10], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[11] != 0) {
                f_objDataInputStream.read(this.m_btOptionType, 0, 2);
            }
            this.m_nLastTradedRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[12], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLastTradedVolume = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[13], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[14] != 0) {
                f_objDataInputStream.read(this.m_btLastTradedTime, 0, 25);
            }
            this.m_nAverageTradedRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[15], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nTotalVolumeTraded = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[16], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nOpenInterest = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[17], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nOpenRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[18], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nHighRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[19], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLowRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[20], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nCloseRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[21], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nValue = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[22], f_objInfoFeedMsgHeader.m_nBaseValue) / 100000;
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[23] != 0) {
                f_objDataInputStream.read(this.m_btRateUnit, 0, 20);
            }
            this.m_nQuotationSize = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[24], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nPreviousCloseRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[25], f_objInfoFeedMsgHeader.m_nBaseValue);
            for (i = 0; i < 1; ++i) {
                this.m_nBuyQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[26], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nBuyPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[27], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            for (i = 0; i < 1; ++i) {
                this.m_nSellQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[28], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nSellPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[29], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            this.m_strKeyOfData = this.createkey(this.m_nFTCode, this.m_nIdentifierOfTheUnderlying, this.m_nContractExpiry, this.m_nStrikePrice, Utilities.RemoveNull(this.m_btOptionType), f_objInfoFeedMsgHeader.m_nSegmentId).toString();
            this.setData(f_objInfoFeedMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateBestFive(CMsgHeader f_objInfoFeedMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int i;
            this.m_nFTCode = f_objDataInputStream.readInt();
            this.m_nInstrumentIdentifier = f_objDataInputStream.readInt();
            this.m_nIdentifierOfTheUnderlying = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btSymbol, 0, 21);
            this.m_nContractExpiry = f_objDataInputStream.readInt();
            this.m_nStrikePrice = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btOptionType, 0, 3);
            this.m_nLastTradedRate = f_objDataInputStream.readInt();
            this.m_nTotalBuyQty = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btLastTradedTime, 0, 26);
            this.m_nAverageTradedRate = f_objDataInputStream.readInt();
            this.m_nTotalVolumeTraded = f_objDataInputStream.readInt();
            this.m_nOpenInterest = f_objDataInputStream.readInt();
            this.m_nOpenRate = f_objDataInputStream.readInt();
            this.m_nHighRate = f_objDataInputStream.readInt();
            this.m_nLowRate = f_objDataInputStream.readInt();
            this.m_nCloseRate = f_objDataInputStream.readInt();
            this.m_nValue = f_objDataInputStream.readLong();
            f_objDataInputStream.read(this.m_btRateUnit, 0, 21);
            this.m_nTotalSellQty = f_objDataInputStream.readInt();
            this.m_nPreviousCloseRate = f_objDataInputStream.readInt();
            f_objDataInputStream.skipBytes(16);
            this.m_nNumberOfTrades = f_objDataInputStream.readInt();
            for (i = 0; i < 5; ++i) {
                this.m_nBuyQty[i] = f_objDataInputStream.readInt();
                this.m_nBuyPrice[i] = f_objDataInputStream.readInt();
            }
            for (i = 0; i < 5; ++i) {
                this.m_nSellQty[i] = f_objDataInputStream.readInt();
                this.m_nSellPrice[i] = f_objDataInputStream.readInt();
            }
            this.m_strKeyOfData = this.createkey(this.m_nFTCode, this.m_nIdentifierOfTheUnderlying, this.m_nContractExpiry, this.m_nStrikePrice, Utilities.RemoveNull(this.m_btOptionType), f_objInfoFeedMsgHeader.m_nSegmentId).toString();
            this.setData(f_objInfoFeedMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateLLFBestFive(CMsgHeader f_objInfoFeedMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int i;
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[5], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nInstrumentIdentifier = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[6], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nIdentifierOfTheUnderlying = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[7], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[8] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 20);
            }
            this.m_nContractExpiry = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[9], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nStrikePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[10], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[11] != 0) {
                f_objDataInputStream.read(this.m_btOptionType, 0, 2);
            }
            this.m_nLastTradedRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[12], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLastTradedVolume = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[13], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[14] != 0) {
                f_objDataInputStream.read(this.m_btLastTradedTime, 0, 25);
            }
            this.m_nAverageTradedRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[15], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nTotalVolumeTraded = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[16], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nOpenInterest = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[17], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nOpenRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[18], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nHighRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[19], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLowRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[20], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nCloseRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[21], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nValue = Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[22], f_objInfoFeedMsgHeader.m_nBaseValue) / 100000L;
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[23] != 0) {
                f_objDataInputStream.read(this.m_btRateUnit, 0, 20);
            }
            this.m_nQuotationSize = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[24], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nPreviousCloseRate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[25], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nTotalBuyQty = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[26], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nTotalSellQty = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[27], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nNumberOfTrades = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[28], f_objInfoFeedMsgHeader.m_nBaseValue);
            for (i = 0; i < 5; ++i) {
                this.m_nBuyQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[29 + i * 2], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nBuyPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[30 + i * 2], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            for (i = 0; i < 5; ++i) {
                this.m_nSellQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[39 + i * 2], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nSellPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[40 + i * 2], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            this.m_strKeyOfData = this.createkey(this.m_nFTCode, this.m_nIdentifierOfTheUnderlying, this.m_nContractExpiry, this.m_nStrikePrice, Utilities.RemoveNull(this.m_btOptionType), f_objInfoFeedMsgHeader.m_nSegmentId).toString();
            this.setData(f_objInfoFeedMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StringBuffer createkey(int iFTCode, int iIdentifierOfTheUnderlying, int iExpiryDate, int iStrikePrice, String strOptionType, int f_nSegmentId) {
        StringBuffer strTemp = new StringBuffer();
        if (f_nSegmentId == 2) {
            if (iExpiryDate <= 0) return strTemp.append(iFTCode).append(":").append(iIdentifierOfTheUnderlying).append(":");
            if (iStrikePrice != 0) return strTemp;
            return strTemp.append(iFTCode).append(":").append(iIdentifierOfTheUnderlying).append(":").append(iExpiryDate).append(":").append("FUTCOM").append(":").append(iStrikePrice).append(":").append(strOptionType).append(":");
        }
        if (f_nSegmentId != 34) return strTemp;
        if (iStrikePrice != 0) return strTemp.append(iFTCode).append(":").append(iIdentifierOfTheUnderlying).append(":").append(iExpiryDate).append(":").append("OPTCUR").append(":").append(iStrikePrice).append(":").append(strOptionType).append(":");
        return strTemp.append(iFTCode).append(":").append(iIdentifierOfTheUnderlying).append(":").append(iExpiryDate).append(":").append("FUTCUR").append(":").append(iStrikePrice).append(":").append(strOptionType).append(":");
    }

    private void setData(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_nBuyQty[0], this.m_nBuyPrice[0], this.m_nSellQty[0], this.m_nSellPrice[0], this.m_nCloseRate, this.m_nPreviousCloseRate, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, this.m_nOpenRate, this.m_nHighRate, this.m_nLowRate);
                break;
            }
            case 24: {
                this.m_nDivisionFactor = iWinRefresh.getInstance().showform.bestfive.getPriceMultiplier(this.m_strKeyOfData);
                String[] strData = new String[20];
                for (int i = 0; i < this.m_nBuyPrice.length; ++i) {
                    strData[i * 4] = Utilities.ToString(this.m_nBuyQty[i]);
                    strData[i * 4 + 1] = Utilities.ConvertToDecimal(this.m_nBuyPrice[i], this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                    strData[i * 4 + 2] = Utilities.ToString(this.m_nSellQty[i]);
                    strData[i * 4 + 3] = Utilities.ConvertToDecimal(this.m_nSellPrice[i], this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                }
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nCloseRate, this.m_nTotalVolumeTraded, this.m_nOpenRate, this.m_nHighRate, this.m_nLowRate, this.m_nPreviousCloseRate, this.m_nTotalBuyQty, this.m_nTotalSellQty, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, this.m_nAverageTradedRate, 0L);
                iWinRefresh.getInstance().showform.bestfive.setOpenInt(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_nOpenInterest);
                break;
            }
            case 27: {
                iWinRefresh.getInstance().showform.parityWatch.setData(this.m_strKeyOfData, this.m_nCloseRate, f_objMsgHeader.m_nMsgTimeStamp);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nCloseRate, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }
}

