/*
 * Decompiled with CFR 0.152.
 */
package GeneralUI;

import GeneralUI.CanvasForm;
import GeneralUI.Component;
import GeneralUI.DrawText;
import GeneralUI.JPlatformCanvas;
import GeneralUI.ScreenPointerDefinition;
import common.Utilities;
import javax.microedition.lcdui.Graphics;

public class DropDownBox
extends Component {
    private String[] ListItem;
    private int selectedIndex = 0;
    private int currentStart;
    private int currentEnd;
    private byte MAXDISPLAYABLEITEMS;
    private byte V_OFFSET = (byte)6;
    private int yOffset = 0;
    private int DDBOX_LEN = 0;
    private int count;

    public DropDownBox(String Label) {
        this.setLabel(Label);
        this.focusable = true;
        int iDefaultCapacity = 5;
        this.ListItem = new String[5];
        this.init();
    }

    public void init() {
        this.selectedIndex = 0;
        this.currentEnd = 0;
        this.drawPopUp = false;
    }

    public void drawComponent(Graphics g) {
        int textlength;
        this.screenY += this.getLabelHeight();
        this.paintBackground(g, this.screenX, this.getWidth(), this.getHeight());
        g.setColor(0);
        g.drawRect(this.screenX, this.screenY, this.getWidth(), this.getHeight());
        int n = textlength = this.getLabel() != null ? this.getLabel().length() : 0;
        if (textlength > 0) {
            DrawText.setCurrentStrip(0);
            DrawText.drawText(this.getLabel(), g, this.screenX, this.screenY - this.getLabelHeight() - 2);
        }
        int n2 = textlength = this.getText() != null ? this.getText().length() : 0;
        if (textlength > 0) {
            DrawText.setCurrentStrip(1);
            if (DrawText.getWidth(this.getText()) > this.getWidth() - this.screenX) {
                int width = 0;
                for (int j = 0; j < textlength; ++j) {
                    if ((width += DrawText.getcharWidth(this.getText().charAt(j))) <= this.getWidth() - this.screenX) continue;
                    textlength = j;
                    break;
                }
            }
            DrawText.drawText(this.getText().substring(0, textlength), g, this.screenX + 3, this.screenY + this.getHeight() / 2 - DrawText.getHeight() / 2);
        }
        CanvasForm.drawTriangle(g, this.screenX + this.getWidth() - 10, this.screenY + this.getHeight() / 2 + 3, 5, 2, 0);
    }

    public void drawListWindow(Graphics g) {
        this.DDBOX_LEN = (DrawText.getHeight() + this.V_OFFSET) * this.getDisplayableItem() + 4;
        this.yOffset = this.screenY + this.HEIGHT - 1 + this.DDBOX_LEN + 1 <= JPlatformCanvas.SCREEN_HEIGHT - JPlatformCanvas.SOFT_KEYBAR_HEIGHT ? this.screenY + this.HEIGHT + 2 : this.screenY - (this.DDBOX_LEN + 1) - 1;
        g.setColor(0xFFFFFF);
        g.fillRect(this.screenX, this.yOffset, this.WIDTH + 2, this.DDBOX_LEN);
        g.setColor(0);
        g.drawRect(this.screenX - 1, this.yOffset - 1, this.WIDTH + 2, this.DDBOX_LEN + 1);
        this.drawListItems(g, this.screenX, this.yOffset + this.V_OFFSET);
        DrawText.drawText((this.size() > 0 ? this.getSelectedIndex() + 1 : 0) + "/" + this.size(), g, this.screenX + this.getWidth() - DrawText.getWidth((this.size() > 0 ? this.getSelectedIndex() + 1 : 0) + "/" + this.size()), this.yOffset + this.DDBOX_LEN - DrawText.getHeight() - 4);
        if (JPlatformCanvas.getInstance().hasPointerEvents()) {
            ScreenPointerDefinition.setPointer(JPlatformCanvas.getInstance().getTitle(), "PopUpList", this.screenX - 1, this.yOffset - 1, this.screenX + this.WIDTH + 2, this.yOffset + this.DDBOX_LEN + 1);
        }
    }

    private void drawListItems(Graphics g, int xOffset, int yOffset) {
        int j = 0;
        this.currentEnd = this.currentStart + this.getDisplayableItem();
        DrawText.setCurrentStrip(1);
        for (int index = this.currentStart; index < this.currentEnd; ++index) {
            if (index == this.getSelectedIndex()) {
                g.setColor(9613776);
                g.fillRect(xOffset + 1, yOffset + (DrawText.getHeight() + this.V_OFFSET) * j - 3, this.getWidth() - 2, DrawText.getHeight() + 4);
                g.setColor(0);
                g.drawRect(xOffset + 1, yOffset + (DrawText.getHeight() + this.V_OFFSET) * j - 3, this.getWidth() - 2, DrawText.getHeight() + 4);
            }
            if (this.getListItem(index) != null) {
                DrawText.drawText(this.getListItem(index), g, xOffset + 10, yOffset + (DrawText.getHeight() + this.V_OFFSET) * j);
            }
            ++j;
        }
    }

    private void adjustListItems() {
        if (this.selectedIndex < this.currentStart) {
            this.currentStart = this.selectedIndex;
            this.currentEnd = this.currentStart + this.MAXDISPLAYABLEITEMS - 1;
        } else if (this.selectedIndex >= this.currentEnd) {
            this.currentEnd = this.selectedIndex;
            this.currentStart = this.currentEnd - this.MAXDISPLAYABLEITEMS + 1;
        } else if (this.currentEnd - this.currentStart < this.MAXDISPLAYABLEITEMS - 1) {
            --this.currentStart;
        }
        if (this.currentEnd >= this.count) {
            this.currentEnd = this.count - 1;
        }
        if (this.currentStart < 0) {
            this.currentStart = 0;
        }
    }

    public void reAdjustList() {
        this.setDisplayableItem(this.count >= 0 && this.count < 2 ? 1 : (this.count == 2 ? 2 : 3));
        if (this.currentEnd - this.currentStart < this.MAXDISPLAYABLEITEMS - 1 && this.currentEnd < this.count - 1) {
            ++this.currentEnd;
        }
        this.adjustListItems();
    }

    public void scrolDn() {
        if (this.count > 0) {
            this.selectedIndex = (this.selectedIndex + 1) % this.count;
            this.adjustListItems();
        }
    }

    public void scrolUp() {
        if (this.count > 0) {
            this.selectedIndex = ((this.selectedIndex - 1) % this.count + this.count) % this.count;
            this.adjustListItems();
        }
    }

    public boolean keyPressed(int keyCode) {
        if (keyCode == 225) {
            this.drawPopUp = !this.drawPopUp;
            this.reAdjustList();
            return true;
        }
        return false;
    }

    public boolean pointerPressed(int x, int y) {
        if (x >= this.screenX && x <= this.screenX + this.getWidth() && y >= this.screenY && y <= this.screenY + this.getHeight()) {
            this.drawPopUp = !this.drawPopUp;
            this.reAdjustList();
            return true;
        }
        if (this.drawPopUp && x >= this.screenX && x <= this.screenX + this.WIDTH) {
            if (y >= this.yOffset && y <= this.yOffset + this.DDBOX_LEN / 2) {
                this.scrolUp();
            } else if (y >= this.yOffset + this.DDBOX_LEN / 2 && y <= this.yOffset + this.DDBOX_LEN) {
                this.scrolDn();
            }
        }
        return false;
    }

    public void addItem(String[] item) {
        int size = item.length;
        for (int index = 0; index < size; ++index) {
            if (null == item[index]) continue;
            this.append(item[index]);
        }
    }

    public void append(String newItem) {
        try {
            this.checkCapacity();
            this.ListItem[this.count] = newItem;
            ++this.count;
        }
        catch (Exception ex) {
            Utilities.printLog("JList-append " + ex);
        }
    }

    private void checkCapacity() {
        int increaseCapacity = 5;
        int length = this.ListItem.length;
        if (this.count >= length) {
            String[] tmp = new String[length + 5];
            System.arraycopy(this.ListItem, 0, tmp, 0, length);
            this.ListItem = tmp;
            Object var3_3 = null;
        }
    }

    public void removeItemAt(int i) {
        if (i < this.count && this.count > 0) {
            for (int j = i; j < this.count - 1; ++j) {
                this.ListItem[j] = this.ListItem[j + 1];
            }
            this.ListItem[this.count - 1] = null;
            --this.count;
            if (this.selectedIndex >= this.count && this.selectedIndex != 0 && this.currentEnd == this.selectedIndex) {
                --this.selectedIndex;
            }
            this.adjustListItems();
        }
    }

    public void removeAllItems() {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            this.removeItemAt(i);
        }
    }

    public String getListItem(int index) {
        return this.size() > 0 ? this.ListItem[index] : null;
    }

    public int size() {
        return this.count;
    }

    public void setDisplayableItem(int numberOfItems) {
        this.MAXDISPLAYABLEITEMS = (byte)numberOfItems;
        this.adjustListItems();
    }

    public int getDisplayableItem() {
        return this.MAXDISPLAYABLEITEMS;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public String getText() {
        return this.getListItem(this.getSelectedIndex()) != null ? this.getListItem(this.getSelectedIndex()) : "";
    }

    public String getTextforinstrument() {
        return this.getListItem(this.getSelectedIndex()) != null ? this.getListItem(this.getSelectedIndex()) : "";
    }

    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
        this.adjustListItems();
    }

    public boolean isPopupDrawn() {
        return this.drawPopUp;
    }

    public void hidePopup() {
        this.drawPopUp = false;
    }
}

