/*
 * Decompiled with CFR 0.152.
 */
package GeneralUI;

import GeneralUI.CanvasForm;
import GeneralUI.DrawText;
import GeneralUI.JPlatformCanvas;
import GeneralUI.ScreenPointerDefinition;
import GeneralUI.SoftKey;
import common.JCommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class JAlert
implements JCommandListener {
    private int startLine = -1;
    private int lineEnd = -1;
    private int lineCount;
    private String[] lineStr = new String[]{null, null, null, null, null};
    private static boolean showAlert = false;
    public static byte CurrentScreenID = (byte)-1;
    private String title;
    private Image headerImg = null;
    private int alertButtonWidth = 0;
    private int alertButtonHeight = 0;
    private int startX = 3;
    private int startY = 0;
    private int iAlertWindowWidth;
    private int iAlertWindowHeight;

    public JAlert(String Title) {
        this.title = Title;
        DrawText.setCurrentStrip(0);
        this.alertButtonWidth = DrawText.getWidth("OK") * 2;
        this.alertButtonHeight = 3 * DrawText.getHeight() / 2;
        this.startY = JPlatformCanvas.SCREEN_HEIGHT / 7;
        this.iAlertWindowWidth = JPlatformCanvas.SCREEN_WIDTH - (this.startX << 1);
        this.iAlertWindowHeight = JPlatformCanvas.SCREEN_HEIGHT - (this.startY << 1);
        try {
            if (this.headerImg == null) {
                Image.createImage((String)"/bar.gif");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        int strHeight = DrawText.getHeight();
        int currentY = 3 * (strHeight >> 1);
        DrawText.setCurrentStrip(0);
        this.drawBackGround(g, this.startX, this.startY, this.iAlertWindowWidth, this.iAlertWindowHeight);
        this.drawHeader(g, this.startX, this.startY + 1, this.iAlertWindowWidth, currentY);
        int startXOffSet = this.startX + 3;
        currentY += this.startY + (strHeight >> 1);
        if (this.getTitle() != null) {
            DrawText.drawText(this.getTitle(), g, startXOffSet, this.startY + (strHeight >> 1) - 1, JPlatformCanvas.SCREEN_WIDTH, 0);
        }
        if (this.lineStr == null) {
            DrawText.drawText("No Data ", g, startXOffSet, currentY, JPlatformCanvas.SCREEN_WIDTH, 0);
            return;
        }
        int i = 0;
        for (i = this.startLine; i < this.lineCount && currentY < this.startY + (JPlatformCanvas.SCREEN_HEIGHT >> 1) - this.alertButtonHeight; currentY += strHeight, ++i) {
            DrawText.drawText(this.lineStr[i], g, startXOffSet, currentY, JPlatformCanvas.SCREEN_WIDTH, 0);
        }
        this.lineEnd = i;
        if (this.startLine > 0) {
            CanvasForm.drawTriangle(g, startXOffSet + (JPlatformCanvas.SCREEN_WIDTH - (startXOffSet << 1)) - 10, this.startY + (JPlatformCanvas.SCREEN_HEIGHT >> 1) - this.alertButtonHeight - 2, this.alertButtonHeight / 3, 1, 0);
        }
        if (this.lineCount > this.lineEnd) {
            CanvasForm.drawTriangle(g, startXOffSet + (JPlatformCanvas.SCREEN_WIDTH - (startXOffSet << 1)) - 10, this.startY + (JPlatformCanvas.SCREEN_HEIGHT >> 1) - (this.alertButtonHeight >> 1) + 2, this.alertButtonHeight / 3, 2, 0);
        }
    }

    private void drawBackGround(Graphics g, int xpos, int ypos, int width, int height) {
        g.setColor(15331320);
        g.fillRect(xpos, ypos, width, height);
        g.setColor(0);
        g.drawRect(xpos, ypos, width, height);
        g.setColor(9613776);
        g.fillRect(xpos + (width >> 1) - this.alertButtonWidth, ypos + height - this.alertButtonHeight - 10, this.alertButtonWidth << 1, this.alertButtonHeight);
        g.setColor(0);
        g.drawRect(xpos + (width >> 1) - this.alertButtonWidth, ypos + height - this.alertButtonHeight - 10, this.alertButtonWidth << 1, this.alertButtonHeight);
        if (JPlatformCanvas.getInstance().hasPointerEvents()) {
            ScreenPointerDefinition.setPointer(this.getTitle(), "AlertOK", xpos + (width >> 1) - this.alertButtonWidth, ypos + height - this.alertButtonHeight - 10, xpos + (width >> 1) + this.alertButtonWidth, ypos + height - 10);
        }
        DrawText.drawText("OK", g, xpos + (width >> 1) - this.alertButtonWidth, ypos + height - (this.alertButtonHeight >> 1) - 10 - (DrawText.getHeight() >> 1), xpos + (width >> 1) + this.alertButtonWidth);
    }

    private void drawHeader(Graphics g, int xpos, int ypos, int width, int height) {
        g.setColor(9613776);
        g.fillRect(xpos, ypos, width, height);
        g.setColor(0);
        g.drawRect(xpos, ypos, width, height);
        g.drawImage(JPlatformCanvas.getInstance().getSelecteorLogoImg(), xpos + width, ypos + (height >> 1), 10);
    }

    public void setString(String msg) {
        DrawText.setCurrentStrip(0);
        int counter = 0;
        int tempWidth = 0;
        int curWidth = 0;
        int stdWidth = JPlatformCanvas.SCREEN_WIDTH - 30;
        this.startLine = 0;
        this.lineCount = 0;
        this.lineStr[this.lineCount] = "";
        msg = msg + " ";
        char[] strData = msg.toCharArray();
        int length = strData.length;
        for (int i = 0; i < length; ++i) {
            tempWidth += DrawText.getcharWidth(strData[i]);
            if (strData[i] == '\n' || strData[i] == '\r') {
                this.lineStr[this.lineCount] = this.lineStr[this.lineCount] + new String(strData, counter, i - counter);
                ++this.lineCount;
                this.checkLength(this.lineCount);
                this.lineStr[this.lineCount] = "";
                curWidth = 0;
                tempWidth = 0;
                counter = i + 1;
                continue;
            }
            if (strData[i] == ' ') {
                this.lineStr[this.lineCount] = this.lineStr[this.lineCount] + new String(strData, counter, i - counter) + " ";
                tempWidth = 0;
                curWidth = DrawText.getWidth(this.lineStr[this.lineCount]);
                counter = i + 1;
                continue;
            }
            if (tempWidth + curWidth < stdWidth) continue;
            ++this.lineCount;
            this.checkLength(this.lineCount);
            this.lineStr[this.lineCount] = new String(strData, counter, i - counter);
            tempWidth = DrawText.getcharWidth(strData[i]);
            curWidth = DrawText.getWidth(this.lineStr[this.lineCount]);
            counter = i;
        }
        ++this.lineCount;
        this.checkLength(this.lineCount);
    }

    public void setTimeout(final int newTimeOut) {
        final long setTimeOut = System.currentTimeMillis();
        new Thread(new Runnable(){

            public void run() {
                while (JAlert.isAlertShown()) {
                    try {
                        if (System.currentTimeMillis() - setTimeOut < (long)newTimeOut) continue;
                        JAlert.this.hideAlert();
                        break;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }).start();
    }

    private void checkLength(int lineCount) {
        int length = this.lineStr.length;
        if (lineCount == length) {
            String[] temp = new String[length + 5];
            System.arraycopy(this.lineStr, 0, temp, 0, length);
            this.lineStr = null;
            this.lineStr = temp;
        }
    }

    public void scrollDn() {
        if (this.lineCount > this.lineEnd) {
            ++this.startLine;
        }
    }

    public void scrollUp() {
        if (this.startLine > 0) {
            --this.startLine;
        }
    }

    public boolean keyPressed(int keyCode) {
        if (JAlert.isAlertShown()) {
            switch (keyCode) {
                case -2: 
                case 56: 
                case 222: {
                    this.scrollDn();
                    return true;
                }
                case -1: 
                case 50: 
                case 221: {
                    this.scrollUp();
                    return true;
                }
                case -201: 
                case -6: 
                case -5: 
                case 225: {
                    this.hideAlert();
                    return true;
                }
            }
        }
        return false;
    }

    private void hideAlert() {
        if (showAlert) {
            showAlert = false;
            JPlatformCanvas.getInstance().setScreenID(CurrentScreenID);
        }
    }

    public void pointerAction(int x, int y) {
        int xpos = 10;
        int ypos = JPlatformCanvas.SCREEN_HEIGHT / 6 + 10;
        int width = JPlatformCanvas.SCREEN_WIDTH - 20;
        int height = JPlatformCanvas.SCREEN_HEIGHT - 2 * ypos;
        if (y >= ypos + height - 10 - (DrawText.getHeight() >> 1) && y <= ypos + height + this.alertButtonHeight - 10 - (DrawText.getHeight() >> 1) && x >= 10 + width / 2 - this.alertButtonWidth && x <= 10 + width / 2 + this.alertButtonWidth) {
            this.hideAlert();
        }
    }

    public boolean jcommandAction(SoftKey softkey, Displayable d) {
        if (softkey.getLabel().equals("Ok")) {
            this.hideAlert();
        }
        return false;
    }

    public static void showAlert() {
        showAlert = true;
    }

    public static boolean isAlertShown() {
        return showAlert;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public String getTitle() {
        return this.title;
    }
}

