/*
 * Decompiled with CFR 0.152.
 */
package GeneralUI;

import GeneralUI.CanvasForm;
import GeneralUI.DrawText;
import GeneralUI.JAlert;
import GeneralUI.KeyCode;
import GeneralUI.ScreenPointerDefinition;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import common.Utilities;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import login.SplashScreen;
import market.iWinRefresh;

public final class JPlatformCanvas
extends Canvas {
    public static byte SCREEN_ID = 0;
    public static int SCREEN_WIDTH;
    public static int SCREEN_HEIGHT;
    public static byte TITLE_BAR_HEIGHT;
    public static byte SOFT_KEYBAR_HEIGHT;
    private JCommandListener jCommandListner = null;
    public SoftKey leftSoftKey;
    public SoftKey rightSoftKey;
    private SoftKey previousLSK;
    private SoftKey previousRSK;
    private String previousLSKSoftKeyLabel;
    private String previousRSKSoftKeyLabel;
    private SplashScreen frmSplashScreen;
    private static JPlatformCanvas instance;
    private String[] commands;
    private Image moOffScreenImage = null;
    private Image softKeyBarImg = null;
    private Image titleBar = null;
    public Image smallLogo = null;
    private String title;
    private String pageInfo = "";
    private String strValue;
    private boolean isDrawList = false;
    private byte MAXDISPLAYABLEITEMS = 0;
    private int iCurrentSelect = 0;
    private int iCurrentStart = 0;
    private int iCurrentEnd = 0;
    protected String[] CommandList = null;
    private int iListCount = 0;
    private int iFontHeight = 0;
    private final byte iPopUpXPos = (byte)5;
    private int iPopUpListYPos = 0;
    private int iPopUpListWidth = 0;
    private int iPopUpListHeight = 0;
    private int iVerticleDisplacing = 5;
    private int iSelectorImgHeight = 0;
    public SoftKey Options = new SoftKey("Options"){

        public synchronized void performAction() {
            if (!JPlatformCanvas.this.isDrawList()) {
                JPlatformCanvas.this.previousLSK = JPlatformCanvas.this.leftSoftKey;
                if (JPlatformCanvas.this.leftSoftKey != null) {
                    JPlatformCanvas.this.previousLSKSoftKeyLabel = JPlatformCanvas.this.leftSoftKey.getLabel();
                }
                JPlatformCanvas.this.previousRSK = JPlatformCanvas.this.rightSoftKey;
                if (JPlatformCanvas.this.rightSoftKey != null) {
                    JPlatformCanvas.this.previousRSKSoftKeyLabel = JPlatformCanvas.this.rightSoftKey.getLabel();
                }
                JPlatformCanvas.this.removeSoftKey(-201);
                JPlatformCanvas.this.removeSoftKey(224);
                JPlatformCanvas.this.setSoftKey(JPlatformCanvas.this.Select, "Select", -201);
                JPlatformCanvas.this.setSoftKey(JPlatformCanvas.this.Cancel, "Cancel", 224);
                JPlatformCanvas.this.setDrawList(true);
            }
        }
    };
    public SoftKey Cancel = new SoftKey("Cancel"){

        public synchronized void performAction() {
            if (JPlatformCanvas.this.isDrawList()) {
                JPlatformCanvas.this.removeSoftKey(-201);
                JPlatformCanvas.this.removeSoftKey(224);
                JPlatformCanvas.this.setSoftKey(JPlatformCanvas.this.previousLSK, JPlatformCanvas.this.previousLSKSoftKeyLabel, -201);
                JPlatformCanvas.this.setSoftKey(JPlatformCanvas.this.previousRSK, JPlatformCanvas.this.previousRSKSoftKeyLabel, 224);
                JPlatformCanvas.this.setDrawList(false);
            }
            if (JPlatformCanvas.this.jCommandListner != null && !JPlatformCanvas.this.jCommandListner.jcommandAction(this, (Displayable)JPlatformCanvas.getInstance())) {
                return;
            }
        }
    };
    public SoftKey Select = new SoftKey("Select"){

        public synchronized void performAction() {
            if (JPlatformCanvas.this.isDrawList()) {
                JPlatformCanvas.this.removeSoftKey(-201);
                JPlatformCanvas.this.removeSoftKey(224);
                JPlatformCanvas.this.setSoftKey(JPlatformCanvas.this.previousLSK, JPlatformCanvas.this.previousLSKSoftKeyLabel, -201);
                JPlatformCanvas.this.setSoftKey(JPlatformCanvas.this.previousRSK, JPlatformCanvas.this.previousRSKSoftKeyLabel, 224);
                JPlatformCanvas.this.setDrawList(false);
            }
            if (JPlatformCanvas.this.jCommandListner != null && !JPlatformCanvas.this.jCommandListner.jcommandAction(this, (Displayable)JPlatformCanvas.getInstance())) {
                return;
            }
        }
    };
    public SoftKey Back = new SoftKey("Back"){

        public synchronized void performAction() {
            if (JPlatformCanvas.this.jCommandListner != null) {
                if (JPlatformCanvas.this.isDrawList()) {
                    JPlatformCanvas.this.setDrawList(false);
                }
                if (!JPlatformCanvas.this.jCommandListner.jcommandAction(this, (Displayable)JPlatformCanvas.getInstance())) {
                    return;
                }
            }
        }
    };

    private JPlatformCanvas() {
        instance = this;
        this.setFullScreenMode(true);
        SCREEN_WIDTH = this.getWidth();
        SCREEN_HEIGHT = this.getHeight();
        this.iPopUpListWidth = SCREEN_WIDTH - 10;
        this.moOffScreenImage = this.isDoubleBuffered() ? null : Image.createImage((int)this.getWidth(), (int)this.getHeight());
        this.initialize();
    }

    public void initialize() {
        try {
            this.softKeyBarImg = null;
            this.titleBar = null;
            this.softKeyBarImg = this.loadImage("softkey" + AppConstants.iFont + ".png");
            SOFT_KEYBAR_HEIGHT = (byte)this.softKeyBarImg.getHeight();
            this.titleBar = this.loadImage("title" + AppConstants.iFont + ".png");
            TITLE_BAR_HEIGHT = (byte)this.titleBar.getHeight();
            DrawText.setCurrentStrip(0);
            this.iFontHeight = DrawText.getHeight();
        }
        catch (Exception e) {
            Utilities.printLog("Init Canvas " + e);
        }
    }

    private Image loadImage(String name) {
        Image appImg = null;
        try {
            appImg = Image.createImage((String)("/" + name));
        }
        catch (Exception e) {
            Utilities.printLog("Image " + name + " not found: " + e);
        }
        return appImg;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public String getTitle() {
        return this.title != null ? this.title : "";
    }

    public void setScreenID(byte id) {
        SCREEN_ID = id;
        this.commands = null;
        try {
            this.removeSoftKey(-201);
            this.removeSoftKey(224);
            if (this.isDrawList()) {
                this.setDrawList(false);
            }
            switch (SCREEN_ID) {
                case 0: {
                    this.setTitle("");
                    if (this.frmSplashScreen == null) {
                        this.frmSplashScreen = new SplashScreen();
                    }
                    this.runThread();
                    break;
                }
                case 1: {
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setSoftKey(this.Back, "Exit", 224);
                    this.commands = this.getCommands((byte)1);
                    this.setTitle(iWinRefresh.getInstance().showform.login.getTitle());
                    this.setListener(iWinRefresh.getInstance().showform.login);
                    this.frmSplashScreen = null;
                    break;
                }
                case 9: {
                    this.setSoftKey(this.Back, "Back", -201);
                    this.setSoftKey(this.Select, "Close", 224);
                    this.setTitle(iWinRefresh.getInstance().progress.getTitle());
                    this.setListener(iWinRefresh.getInstance().progress);
                    break;
                }
                case 4: {
                    iWinRefresh.getInstance().progress.stopProgress();
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setTitle(iWinRefresh.getInstance().showform.mainmenu.getTitle());
                    this.setListener(iWinRefresh.getInstance().showform.mainmenu);
                    break;
                }
                case 2: {
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setTitle(iWinRefresh.getInstance().showform.settings.getTitle());
                    switch (iWinRefresh.getInstance().showform.settings.getSettingPageID()) {
                        case 0: {
                            if (AppConstants.bLoggedIn) {
                                this.setSoftKey(this.Select, "Apply", -201);
                                break;
                            }
                            this.setSoftKey(this.Select, "Select", -201);
                            this.commands = this.getCommands((byte)2);
                            break;
                        }
                        case 1: {
                            this.setSoftKey(this.Select, "Apply", -201);
                            break;
                        }
                        case 2: {
                            this.setSoftKey(this.Select, iWinRefresh.iPreviousForm == 13 || iWinRefresh.iPreviousForm == 6 ? "Add" : "Save", -201);
                        }
                    }
                    this.setListener(iWinRefresh.getInstance().showform.settings);
                    break;
                }
                case 5: {
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setTitle("Profile: " + AppConstants.STR_PROFILE_NAME);
                    this.commands = this.getCommands((byte)5);
                    this.setListener(iWinRefresh.getInstance().showform.marketwatch);
                    break;
                }
                case 23: {
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setTitle(iWinRefresh.getInstance().showform.commonList.getTitle());
                    if (iWinRefresh.getInstance().showform.commonList.getTitle().equals("Profile")) {
                        this.commands = this.getCommands((byte)25);
                    }
                    this.setListener(iWinRefresh.getInstance().showform.commonList);
                    break;
                }
                case 8: {
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    String strTempForm = iWinRefresh.getInstance().showform.commonform.getTitle();
                    if (strTempForm.equals("About") || strTempForm.equals("News Story") || strTempForm.equals("IPO") || strTempForm.equals("Mutual Fund") || strTempForm.equals("PMS") || strTempForm.equals("Insurance") || strTempForm.equals("Economic Event Details")) {
                        this.removeSoftKey(-201);
                    } else if (strTempForm.equals("Custom Orientation")) {
                        this.setSoftKey(this.Select, "Save", -201);
                        this.setSoftKey(this.Back, "Modify", 224);
                    } else {
                        this.setSoftKey(this.Select, "Yes", -201);
                        this.setSoftKey(this.Back, "No", 224);
                    }
                    this.setTitle(iWinRefresh.getInstance().showform.commonform.getTitle());
                    this.setListener(iWinRefresh.getInstance().showform.commonform);
                    break;
                }
                case 24: {
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    if (iWinRefresh.getInstance().showform.bestfive.iMaxNoOfColumns >= 4) {
                        this.removeSoftKey(-201);
                        this.commands = null;
                    } else {
                        this.commands = this.getCommands((byte)24);
                    }
                    this.setTitle("Market Depth");
                    this.setListener(iWinRefresh.getInstance().showform.bestfive);
                    break;
                }
                case 10: {
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setTitle("Details");
                    this.setListener(iWinRefresh.getInstance().showform.viewdetails);
                    break;
                }
                case 6: {
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    String strFormName = iWinRefresh.getInstance().showform.commoncanvas.getTitle();
                    this.commands = strFormName.equals("Profile Scrips") ? this.getCommands((byte)7) : (strFormName.equals("Modify Alerts") ? this.getCommands((byte)19) : (strFormName.equals("Alert History") ? null : (strFormName.equals("Mutual Fund") && AppConstants.iListIndex == 0 || strFormName.equals("Insurance") ? this.getCommands((byte)16) : this.getCommands((byte)6))));
                    if (iWinRefresh.getInstance().showform.commoncanvas.isBlankForm() || strFormName.equals("Alert History")) {
                        this.commands = null;
                        this.removeSoftKey(-201);
                    }
                    this.setTitle(strFormName);
                    this.setListener(iWinRefresh.getInstance().showform.commoncanvas);
                    break;
                }
                case 39: {
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setTitle("Economic Calendar");
                    this.commands = this.getCommands((byte)39);
                    this.setListener(iWinRefresh.getInstance().showform.econData);
                    break;
                }
                case 12: {
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setListener(iWinRefresh.getInstance().showform.selectExchange);
                    this.setTitle(iWinRefresh.getInstance().showform.selectExchange.getTitle());
                    break;
                }
                case 11: {
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setListener(iWinRefresh.getInstance().showform.securityinfo);
                    this.setTitle(iWinRefresh.getInstance().showform.securityinfo.getTitle());
                    break;
                }
                case 25: {
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setListener(iWinRefresh.getInstance().showform.securityinfo);
                    this.setTitle(iWinRefresh.getInstance().showform.securityinfo.getTitle());
                    break;
                }
                case 22: {
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setTitle(AppConstants.strSearchString + "-" + AppConstants.strScrollCanvasHeading);
                    if (AppConstants.iListIndex == 5) {
                        if (iWinRefresh.getInstance().showform.createMarketInfoForm().getResponseDataLength() > 0) {
                            this.setSoftKey(this.Select, "Details", -201);
                        }
                    } else if (AppConstants.iListIndex == 8) {
                        this.setSoftKey(this.Select, "Select", -201);
                        this.commands = this.getCommands((byte)6);
                    }
                    this.setListener(iWinRefresh.getInstance().showform.marketinfo);
                    break;
                }
                case 16: {
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setTitle(iWinRefresh.getInstance().showform.securityinfo.getTitle());
                    this.setListener(iWinRefresh.getInstance().showform.securityinfo);
                    break;
                }
                case 30: {
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setTitle(iWinRefresh.getInstance().showform.securityinfo.getTitle());
                    this.setListener(iWinRefresh.getInstance().showform.securityinfo);
                    break;
                }
                case 13: {
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    this.commands = iWinRefresh.iPreviousForm == 29 ? this.getCommands((byte)37) : this.getCommands((byte)13);
                    this.setListener(iWinRefresh.getInstance().showform.mywatchListresult);
                    this.setTitle(iWinRefresh.getInstance().showform.mywatchListresult.getTitle());
                    break;
                }
                case 36: {
                    this.setSoftKey(this.Select, "Save", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setListener(iWinRefresh.getInstance().showform.myCustomList);
                    this.setTitle(iWinRefresh.getInstance().showform.myCustomList.getTitle());
                    break;
                }
                case 26: {
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setListener(iWinRefresh.getInstance().showform.parityCalc);
                    this.setTitle(iWinRefresh.getInstance().showform.parityCalc.getTitle());
                    if (iWinRefresh.getInstance().showform.parityCalc.size() >= 4) break;
                    iWinRefresh.getInstance().showform.parityCalc.InitializeFormFields();
                    break;
                }
                case 27: {
                    this.setTitle("Parity Watch");
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setListener(iWinRefresh.getInstance().showform.parityWatch);
                    break;
                }
                case 19: {
                    this.setTitle("Alerts");
                    this.setSoftKey(this.Select, "Ok", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setListener(iWinRefresh.getInstance().showform.alerts);
                    break;
                }
                case 29: {
                    this.setTitle("Portfolio");
                    this.setSoftKey(this.Select, "Option", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    if (AppConstants.IsScripByReq) {
                        this.setTitle("Portfolio Details");
                        this.removeSoftKey(-201);
                        this.commands = null;
                    } else {
                        this.setTitle("Portfolio");
                        this.commands = this.getCommands((byte)29);
                    }
                    if (iWinRefresh.getInstance().showform.PortfolioWatch.getNumberOfRows() <= 0) {
                        this.removeSoftKey(-201);
                        this.commands = null;
                    }
                    this.setListener(iWinRefresh.getInstance().showform.PortfolioWatch);
                    break;
                }
                case 33: {
                    this.setTitle("News");
                    if (iWinRefresh.getInstance().showform.PortfolioWatch.getNumberOfRows() > 0) {
                        this.setSoftKey(this.Select, "Story", -201);
                    }
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setListener(iWinRefresh.getInstance().showform.PortfolioWatch);
                    break;
                }
                case 34: {
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setTitle(AppConstants.strSearchString + " - " + AppConstants.strScrollCanvasHeading);
                    this.commands = this.getCommands((byte)34);
                    this.setListener(iWinRefresh.getInstance().showform.chartCanvas);
                    break;
                }
                case 35: {
                    this.setTitle(iWinRefresh.getInstance().showform.selectionWindow.getTitle());
                    this.setSoftKey(this.Select, "Select", -201);
                    this.setSoftKey(this.Back, "Back", 224);
                    this.setListener(iWinRefresh.getInstance().showform.selectionWindow);
                }
            }
            if (this.commands != null) {
                this.setCommands(this.commands);
            }
            if (JAlert.isAlertShown()) {
                JAlert.CurrentScreenID = this.getScreenID();
            }
            if (SCREEN_ID != 9 && iWinRefresh.getInstance().progress != null && iWinRefresh.getInstance().progress.getProgressStatus()) {
                iWinRefresh.getInstance().progress.stopProgress();
            }
            if (iWinRefresh.display.getCurrent() != this) {
                iWinRefresh.display.setCurrent((Displayable)this);
            }
        }
        catch (Exception e) {
            Utilities.printLog("ScreenID " + id + " Error " + e.toString());
        }
        this.refreshDisplay();
    }

    private String[] getCommands(byte iScreenNo) {
        String[] tmpCommands = null;
        try {
            switch (iScreenNo) {
                case 1: {
                    tmpCommands = new String[]{"Login", "Change Password", "Preferences", "About", "Update"};
                    break;
                }
                case 2: {
                    tmpCommands = new String[]{"Save", "Delete"};
                    break;
                }
                case 5: {
                    tmpCommands = new String[]{"Market Depth", "Chart", "Add To PMS", "News", "Set Alert", "Add Scrip", "Remove Scrip", "Profile", "Set Default"};
                    break;
                }
                case 6: {
                    tmpCommands = new String[]{"Details", "Next", "Prev", "Menu"};
                    break;
                }
                case 16: {
                    tmpCommands = new String[]{"AddToPMS", "Details", "Next", "Prev", "Menu"};
                    break;
                }
                case 13: {
                    tmpCommands = new String[]{"Add", "AddToPMS", "Next", "Prev", "Menu"};
                    break;
                }
                case 39: {
                    tmpCommands = new String[]{"Details", "Filter", "Next", "Prev"};
                    break;
                }
                case 37: {
                    tmpCommands = new String[]{"AddToPMS", "Next", "Prev", "Menu"};
                    break;
                }
                case 36: {
                    tmpCommands = new String[]{"Save", "Modify"};
                    break;
                }
                case 24: {
                    tmpCommands = new String[]{"Buy Depth", "Sell Depth", "Refresh"};
                    break;
                }
                case 19: {
                    tmpCommands = new String[]{"Modify", "Remove"};
                    break;
                }
                case 25: {
                    tmpCommands = new String[]{"MarketWatch", "New Profile", "Modify Profile", "Remove Profile", "Set Default"};
                    break;
                }
                case 7: {
                    tmpCommands = new String[]{"MoveUp", "MoveDown", "Set Alert", "Add", "Remove", "Save"};
                    break;
                }
                case 26: {
                    tmpCommands = new String[]{"Apply", "Edit"};
                    break;
                }
                case 29: {
                    tmpCommands = new String[]{"Buy", "Sell", "Details", "Remove"};
                    break;
                }
                case 38: {
                    tmpCommands = new String[]{"Modify", "Remove"};
                    break;
                }
                case 34: {
                    tmpCommands = new String[]{"Volume Chart", "OHLC", "Studies", "Indicators", "Candle Stick", "Bar Chart", "Mountain Chart"};
                }
            }
        }
        catch (Exception e) {
            Utilities.printLog("getCommands " + e.toString());
        }
        return tmpCommands;
    }

    public byte getScreenID() {
        return SCREEN_ID;
    }

    public String getCommandName() {
        return this.commands[this.getSelectedIndex()];
    }

    public static JPlatformCanvas getInstance() {
        instance = instance == null ? new JPlatformCanvas() : instance;
        return instance;
    }

    public void paint(Graphics foGraphics) {
        try {
            Graphics g = this.moOffScreenImage == null ? foGraphics : this.moOffScreenImage.getGraphics();
            SCREEN_WIDTH = this.getWidth();
            SCREEN_HEIGHT = this.getHeight();
            g.setColor(0xFFFFFF);
            g.fillRect(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
            if (this.hasPointerEvents()) {
                ScreenPointerDefinition.clearScreenPointer();
            }
            switch (SCREEN_ID) {
                case 0: {
                    this.frmSplashScreen.paint(g);
                    break;
                }
                case 1: {
                    if (iWinRefresh.getInstance().showform.login == null) break;
                    iWinRefresh.getInstance().showform.login.paint(g);
                    break;
                }
                case 9: {
                    if (iWinRefresh.getInstance().progress == null) break;
                    iWinRefresh.getInstance().progress.paint(g);
                    break;
                }
                case 4: {
                    if (iWinRefresh.getInstance().showform.mainmenu == null) break;
                    iWinRefresh.getInstance().showform.mainmenu.paint(g);
                    break;
                }
                case 5: {
                    if (iWinRefresh.getInstance().showform.marketwatch == null) break;
                    iWinRefresh.getInstance().showform.marketwatch.paint(g);
                    break;
                }
                case 2: {
                    if (iWinRefresh.getInstance().showform.settings == null) break;
                    iWinRefresh.getInstance().showform.settings.paint(g);
                    break;
                }
                case 23: {
                    if (iWinRefresh.getInstance().showform.commonList == null) break;
                    iWinRefresh.getInstance().showform.commonList.paint(g);
                    break;
                }
                case 8: {
                    if (iWinRefresh.getInstance().showform.commonform == null) break;
                    iWinRefresh.getInstance().showform.commonform.paint(g);
                    break;
                }
                case 24: {
                    if (iWinRefresh.getInstance().showform.bestfive == null) break;
                    iWinRefresh.getInstance().showform.bestfive.paint(g);
                    break;
                }
                case 10: {
                    if (iWinRefresh.getInstance().showform.viewdetails == null) break;
                    iWinRefresh.getInstance().showform.viewdetails.paint(g);
                    break;
                }
                case 6: {
                    if (iWinRefresh.getInstance().showform.commoncanvas == null) break;
                    iWinRefresh.getInstance().showform.commoncanvas.paint(g);
                    break;
                }
                case 11: {
                    if (iWinRefresh.getInstance().showform.securityinfo == null) break;
                    iWinRefresh.getInstance().showform.securityinfo.paint(g);
                    break;
                }
                case 12: {
                    if (iWinRefresh.getInstance().showform.selectExchange == null) break;
                    iWinRefresh.getInstance().showform.selectExchange.paint(g);
                    break;
                }
                case 25: {
                    if (iWinRefresh.getInstance().showform.securityinfo == null) break;
                    iWinRefresh.getInstance().showform.securityinfo.paint(g);
                    break;
                }
                case 22: {
                    if (iWinRefresh.getInstance().showform.marketinfo == null) break;
                    iWinRefresh.getInstance().showform.marketinfo.paint(g);
                    break;
                }
                case 16: {
                    if (iWinRefresh.getInstance().showform.securityinfo == null) break;
                    iWinRefresh.getInstance().showform.securityinfo.paint(g);
                    break;
                }
                case 30: {
                    if (iWinRefresh.getInstance().showform.securityinfo == null) break;
                    iWinRefresh.getInstance().showform.securityinfo.paint(g);
                    break;
                }
                case 13: {
                    if (iWinRefresh.getInstance().showform.mywatchListresult == null) break;
                    iWinRefresh.getInstance().showform.mywatchListresult.paint(g);
                    break;
                }
                case 39: {
                    if (iWinRefresh.getInstance().showform.econData == null) break;
                    iWinRefresh.getInstance().showform.econData.paint(g);
                    break;
                }
                case 36: {
                    if (iWinRefresh.getInstance().showform.myCustomList == null) break;
                    iWinRefresh.getInstance().showform.myCustomList.paint(g);
                    break;
                }
                case 26: {
                    if (iWinRefresh.getInstance().showform.parityCalc == null) break;
                    iWinRefresh.getInstance().showform.parityCalc.paint(g);
                    break;
                }
                case 27: {
                    if (iWinRefresh.getInstance().showform.parityWatch == null) break;
                    iWinRefresh.getInstance().showform.parityWatch.paint(g);
                    break;
                }
                case 19: {
                    if (iWinRefresh.getInstance().showform.alerts == null) break;
                    iWinRefresh.getInstance().showform.alerts.paint(g);
                    break;
                }
                case 29: {
                    if (iWinRefresh.getInstance().showform.PortfolioWatch == null) break;
                    iWinRefresh.getInstance().showform.PortfolioWatch.draw(g, SCREEN_WIDTH, SCREEN_HEIGHT);
                    iWinRefresh.getInstance().showform.PortfolioWatch.drawOtherInfo(g, iWinRefresh.getInstance().showform.PortfolioWatch.strMainHeading, 2, TITLE_BAR_HEIGHT + 2, -1, 0, 0);
                    iWinRefresh.getInstance().showform.PortfolioWatch.drawOtherInfo(g, iWinRefresh.getInstance().showform.PortfolioWatch.strTotalValue, 2, TITLE_BAR_HEIGHT + 2, SCREEN_WIDTH, 2, 1);
                    break;
                }
                case 33: {
                    if (iWinRefresh.getInstance().showform.PortfolioWatch == null) break;
                    iWinRefresh.getInstance().showform.PortfolioWatch.draw(g, SCREEN_WIDTH, SCREEN_HEIGHT);
                    break;
                }
                case 34: {
                    if (iWinRefresh.getInstance().showform.chartCanvas == null) break;
                    iWinRefresh.getInstance().showform.chartCanvas.draw(g);
                    break;
                }
                case 35: {
                    if (iWinRefresh.getInstance().showform.selectionWindow == null) break;
                    iWinRefresh.getInstance().showform.selectionWindow.paint(g);
                }
            }
            if (JAlert.isAlertShown()) {
                iWinRefresh.currentAlert.paint(g);
            }
            this.drawHeader(g);
            this.drawTitle(g);
            this.drawFooter(g);
            this.drawSoftKeys(g, 0);
        }
        catch (Exception e) {
            Utilities.printLog("Paint " + e + " Screen " + SCREEN_ID);
        }
    }

    private void drawFooter(Graphics g) {
        this.drawCommandList(g);
        if (this.softKeyBarImg != null) {
            for (int i = SCREEN_WIDTH; i >= 0; --i) {
                g.drawImage(this.softKeyBarImg, i, this.getHeight() - SOFT_KEYBAR_HEIGHT, 20);
            }
            if (this.hasPointerEvents()) {
                int x = DrawText.getWidth(this.leftSoftKey != null ? this.leftSoftKey.getLabel() + 10 : "");
                int width = SCREEN_WIDTH - DrawText.getWidth(this.rightSoftKey != null ? this.rightSoftKey.getLabel() : "") - 10;
                ScreenPointerDefinition.setPointer(this.getTitle(), "FOOTER", x, SCREEN_HEIGHT - SOFT_KEYBAR_HEIGHT, width, SCREEN_HEIGHT);
            }
        }
        switch (SCREEN_ID) {
            case 1: {
                if (iWinRefresh.getInstance().showform.login == null) break;
                iWinRefresh.getInstance().showform.login.paintScroller(g);
                break;
            }
            case 10: {
                if (iWinRefresh.getInstance().showform.viewdetails == null) break;
                iWinRefresh.getInstance().showform.viewdetails.paintScroller(g);
                break;
            }
            case 6: {
                if (iWinRefresh.getInstance().showform.commoncanvas == null) break;
                iWinRefresh.getInstance().showform.commoncanvas.paintScroller(g);
                break;
            }
            case 39: {
                if (iWinRefresh.getInstance().showform.econData == null) break;
                iWinRefresh.getInstance().showform.econData.paintScroller(g);
                break;
            }
            case 8: {
                if (iWinRefresh.getInstance().showform.commonform == null) break;
                iWinRefresh.getInstance().showform.commonform.paintScroller(g);
                break;
            }
            case 24: {
                if (iWinRefresh.getInstance().showform.bestfive == null) break;
                iWinRefresh.getInstance().showform.bestfive.paintScroller(g);
                break;
            }
            case 23: {
                if (iWinRefresh.getInstance().showform.commonList == null) break;
                iWinRefresh.getInstance().showform.commonList.paintScroller(g);
                break;
            }
            case 4: {
                if (iWinRefresh.getInstance().showform.mainmenu == null) break;
                iWinRefresh.getInstance().showform.mainmenu.paintScroller(g);
                break;
            }
            case 13: {
                if (iWinRefresh.getInstance().showform.mywatchListresult == null) break;
                iWinRefresh.getInstance().showform.mywatchListresult.paintScroller(g);
                break;
            }
            case 36: {
                if (iWinRefresh.getInstance().showform.myCustomList == null) break;
                iWinRefresh.getInstance().showform.myCustomList.paintScroller(g);
                break;
            }
            case 22: {
                if (iWinRefresh.getInstance().showform.marketinfo == null) break;
                iWinRefresh.getInstance().showform.marketinfo.paintScroller(g);
                break;
            }
            case 26: {
                if (iWinRefresh.getInstance().showform.parityCalc == null) break;
                iWinRefresh.getInstance().showform.parityCalc.paintScroller(g);
                break;
            }
            case 35: {
                if (iWinRefresh.getInstance().showform.selectionWindow == null) break;
                iWinRefresh.getInstance().showform.selectionWindow.paintScroller(g);
            }
        }
    }

    private void drawHeader(Graphics g) {
        if (this.titleBar != null) {
            for (int i = SCREEN_WIDTH; i >= 0; --i) {
                g.drawImage(this.titleBar, i, 0, 20);
            }
            if (this.hasPointerEvents()) {
                ScreenPointerDefinition.setPointer(this.getTitle(), "HEADER", 0, 0, SCREEN_WIDTH, TITLE_BAR_HEIGHT);
            }
        }
    }

    public Image getSelecteorLogoImg() {
        return this.smallLogo == null ? (this.smallLogo = this.loadImage("mvm_small.png")) : this.smallLogo;
    }

    public int getSmallLogoHeight() {
        return this.iSelectorImgHeight <= 0 ? (this.iSelectorImgHeight = this.getSelecteorLogoImg().getHeight()) : this.iSelectorImgHeight;
    }

    private void drawTitle(Graphics g) {
        DrawText.setCurrentStrip(0);
        switch (this.getScreenID()) {
            case 5: 
            case 10: 
            case 24: {
                if (this.getPageInfo() != null) {
                    DrawText.drawText(this.getPageInfo(), g, SCREEN_WIDTH - DrawText.getWidth(this.getPageInfo()) - 2, 1);
                }
                DrawText.drawText(this.getTitle(), g, 1, 1);
                break;
            }
            default: {
                DrawText.drawText(this.getTitle(), g, SCREEN_WIDTH - DrawText.getWidth(this.getTitle()) >> 1, 1);
            }
        }
    }

    public void setPageInfo(String info) {
        this.pageInfo = info;
    }

    private String getPageInfo() {
        return this.pageInfo;
    }

    public static void drawDownArrow(Graphics g) {
        CanvasForm.drawTriangle(g, SCREEN_WIDTH >> 1, SCREEN_HEIGHT - 1, (SOFT_KEYBAR_HEIGHT >> 1) - 1, 2, 0);
    }

    public static void drawUpArrow(Graphics g) {
        CanvasForm.drawTriangle(g, SCREEN_WIDTH >> 1, SCREEN_HEIGHT - SOFT_KEYBAR_HEIGHT + 1, (SOFT_KEYBAR_HEIGHT >> 1) - 1, 1, 0);
    }

    public void refreshDisplay() {
        this.repaint();
    }

    public void refreshArea(int startx, int startY, int width, int height) {
        this.repaint(startx, startY, width, height);
    }

    public void runThread() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    while (!JPlatformCanvas.this.frmSplashScreen.animate()) {
                        JPlatformCanvas.this.refreshDisplay();
                        Thread.sleep(20L);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }).start();
    }

    public void keyRepeated(int DevicekeyCode) {
        switch (SCREEN_ID) {
            default: 
        }
    }

    public void keyPressed(int DeviceKeyCode) {
        DeviceKeyCode = KeyCode.getInstance(this).adoptKeyCode(DeviceKeyCode);
        if (JAlert.isAlertShown()) {
            iWinRefresh.currentAlert.keyPressed(DeviceKeyCode);
            this.refreshDisplay();
            return;
        }
        if (this.isDrawList()) {
            this.processCommandAction(DeviceKeyCode);
            this.refreshDisplay();
            return;
        }
        switch (SCREEN_ID) {
            case 1: {
                iWinRefresh.getInstance().showform.login.keyPressed(DeviceKeyCode);
                this.refreshDisplay();
                break;
            }
            case 4: {
                iWinRefresh.getInstance().showform.mainmenu.keyPressed(DeviceKeyCode);
                this.refreshDisplay();
                break;
            }
            case 9: {
                iWinRefresh.getInstance().progress.keyPressed(DeviceKeyCode);
                break;
            }
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.keyPressed(DeviceKeyCode);
                this.refreshDisplay();
                break;
            }
            case 2: {
                iWinRefresh.getInstance().showform.settings.keyPressed(DeviceKeyCode);
                iWinRefresh.getInstance().showform.settings.setOrientationString();
                this.refreshDisplay();
                break;
            }
            case 23: {
                iWinRefresh.getInstance().showform.commonList.keyPressed(DeviceKeyCode);
                this.refreshDisplay();
                break;
            }
            case 8: {
                iWinRefresh.getInstance().showform.commonform.keyPressed(DeviceKeyCode);
                this.refreshDisplay();
                break;
            }
            case 24: {
                iWinRefresh.getInstance().showform.bestfive.keyPressed(DeviceKeyCode);
                this.refreshDisplay();
                break;
            }
            case 10: {
                iWinRefresh.getInstance().showform.viewdetails.keyPressed(DeviceKeyCode);
                this.refreshDisplay();
                break;
            }
            case 6: {
                iWinRefresh.getInstance().showform.commoncanvas.keyPressed(DeviceKeyCode);
                this.refreshDisplay();
                break;
            }
            case 39: {
                iWinRefresh.getInstance().showform.econData.keyPressed(DeviceKeyCode);
                this.refreshDisplay();
                break;
            }
            case 11: {
                if (iWinRefresh.getInstance().showform.securityinfo != null) {
                    iWinRefresh.getInstance().showform.securityinfo.keyPressed(DeviceKeyCode);
                }
                this.refreshDisplay();
                break;
            }
            case 12: {
                if (iWinRefresh.getInstance().showform.selectExchange != null) {
                    iWinRefresh.getInstance().showform.selectExchange.keyPressed(DeviceKeyCode);
                    if (!AppConstants.selectProfile) {
                        iWinRefresh.getInstance().showform.selectExchange.setInstrument();
                    }
                }
                this.refreshDisplay();
                break;
            }
            case 25: {
                if (iWinRefresh.getInstance().showform.securityinfo != null) {
                    iWinRefresh.getInstance().showform.securityinfo.keyPressed(DeviceKeyCode);
                }
                this.refreshDisplay();
                break;
            }
            case 22: {
                iWinRefresh.getInstance().showform.marketinfo.keyPressed(DeviceKeyCode);
                this.refreshDisplay();
                break;
            }
            case 16: {
                if (iWinRefresh.getInstance().showform.securityinfo != null) {
                    iWinRefresh.getInstance().showform.securityinfo.keyPressed(DeviceKeyCode);
                }
                this.refreshDisplay();
                break;
            }
            case 30: {
                if (iWinRefresh.getInstance().showform.securityinfo != null) {
                    iWinRefresh.getInstance().showform.securityinfo.keyPressed(DeviceKeyCode);
                }
                this.refreshDisplay();
                break;
            }
            case 13: {
                iWinRefresh.getInstance().showform.mywatchListresult.keyPressed(DeviceKeyCode);
                if (DeviceKeyCode == 225 && iWinRefresh.getInstance().showform.mywatchListresult.isSelected(iWinRefresh.getInstance().showform.mywatchListresult.getSelectedIndex())) {
                    String strValue = iWinRefresh.getInstance().showform.mywatchListresult.getString(iWinRefresh.getInstance().showform.mywatchListresult.getSelectedIndex());
                    iWinRefresh.displayAlert("MVMG", strValue, AppConstants.iAlertDisplayTime);
                }
                this.refreshDisplay();
                break;
            }
            case 26: {
                iWinRefresh.getInstance().showform.parityCalc.keyPressed(DeviceKeyCode);
                if (iWinRefresh.getInstance().showform.parityCalc != null) {
                    iWinRefresh.getInstance().showform.parityCalc.calculateParity();
                }
                this.refreshDisplay();
                break;
            }
            case 27: {
                if (iWinRefresh.getInstance().showform.parityWatch != null) {
                    iWinRefresh.getInstance().showform.parityWatch.keyPressed(DeviceKeyCode);
                }
                this.refreshDisplay();
                break;
            }
            case 19: {
                if (iWinRefresh.getInstance().showform.alerts != null) {
                    iWinRefresh.getInstance().showform.alerts.keyPressed(DeviceKeyCode);
                }
                this.refreshDisplay();
                break;
            }
            case 29: 
            case 33: {
                if (iWinRefresh.getInstance().showform.PortfolioWatch != null) {
                    iWinRefresh.getInstance().showform.PortfolioWatch.keyEvent(DeviceKeyCode);
                }
                this.refreshDisplay();
                break;
            }
            case 34: {
                if (iWinRefresh.getInstance().showform.chartCanvas != null) {
                    iWinRefresh.getInstance().showform.chartCanvas.keyPressed(DeviceKeyCode);
                }
                this.refreshDisplay();
                break;
            }
            case 35: {
                if (iWinRefresh.getInstance().showform.selectionWindow != null) {
                    iWinRefresh.getInstance().showform.selectionWindow.keyPressed(DeviceKeyCode);
                    iWinRefresh.getInstance().showform.selectionWindow.setFormula();
                }
                this.refreshDisplay();
                break;
            }
            case 36: {
                if (iWinRefresh.getInstance().showform.myCustomList != null) {
                    iWinRefresh.getInstance().showform.myCustomList.keyPressed(DeviceKeyCode);
                }
                this.refreshDisplay();
            }
        }
    }

    protected void pointerPressed(int fiXCordinate, int fiYCordinate) {
        if (this.hasPointerEvents()) {
            String lsSection = ScreenPointerDefinition.getClickedSection(this.getTitle(), fiXCordinate, fiYCordinate);
            if (JAlert.isAlertShown()) {
                if (lsSection != null && lsSection.equals("FOOTER")) {
                    iWinRefresh.currentAlert.scrollDn();
                    this.refreshDisplay();
                } else if (lsSection != null && lsSection.equals("HEADER")) {
                    iWinRefresh.currentAlert.scrollUp();
                    this.refreshDisplay();
                } else {
                    iWinRefresh.currentAlert.pointerAction(fiXCordinate, fiYCordinate);
                    this.refreshDisplay();
                }
                return;
            }
            if (this.isDrawList()) {
                if (!this.processPointerSoftKeys(fiXCordinate, fiYCordinate)) {
                    if (lsSection != null && lsSection.equals("FOOTER")) {
                        this.scrollDN();
                    } else if (lsSection != null && lsSection.equals("HEADER")) {
                        this.scrollUP();
                    } else if (this.processPointerEvent(fiXCordinate, fiYCordinate) && this.leftSoftKey != null && this.leftSoftKey.getLabel().equals("Select")) {
                        this.leftSoftKey.performAction();
                    }
                    this.refreshDisplay();
                }
                return;
            }
            if (this.processPointerSoftKeys(fiXCordinate, fiYCordinate)) {
                return;
            }
            if (lsSection == null) {
                return;
            }
            switch (SCREEN_ID) {
                case 1: {
                    iWinRefresh.getInstance().showform.login.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    this.refreshDisplay();
                    break;
                }
                case 4: {
                    iWinRefresh.getInstance().showform.mainmenu.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    this.refreshDisplay();
                    break;
                }
                case 2: {
                    iWinRefresh.getInstance().showform.settings.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    iWinRefresh.getInstance().showform.settings.setOrientationString();
                    this.refreshDisplay();
                    break;
                }
                case 23: {
                    iWinRefresh.getInstance().showform.commonList.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    this.refreshDisplay();
                    break;
                }
                case 8: {
                    iWinRefresh.getInstance().showform.commonform.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    this.refreshDisplay();
                    break;
                }
                case 11: {
                    if (iWinRefresh.getInstance().showform.securityinfo != null) {
                        iWinRefresh.getInstance().showform.securityinfo.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    }
                    this.refreshDisplay();
                    break;
                }
                case 12: {
                    if (iWinRefresh.getInstance().showform.selectExchange != null) {
                        iWinRefresh.getInstance().showform.selectExchange.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                        if (!AppConstants.selectProfile) {
                            iWinRefresh.getInstance().showform.selectExchange.setInstrument();
                        }
                    }
                    this.refreshDisplay();
                    break;
                }
                case 25: {
                    if (iWinRefresh.getInstance().showform.securityinfo != null) {
                        iWinRefresh.getInstance().showform.securityinfo.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    }
                    this.refreshDisplay();
                    break;
                }
                case 16: {
                    if (iWinRefresh.getInstance().showform.securityinfo != null) {
                        iWinRefresh.getInstance().showform.securityinfo.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    }
                    this.refreshDisplay();
                    break;
                }
                case 30: {
                    if (iWinRefresh.getInstance().showform.securityinfo != null) {
                        iWinRefresh.getInstance().showform.securityinfo.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    }
                    this.refreshDisplay();
                    break;
                }
                case 13: {
                    iWinRefresh.getInstance().showform.mywatchListresult.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    if (iWinRefresh.getInstance().showform.mywatchListresult.isSelected(iWinRefresh.getInstance().showform.mywatchListresult.getSelectedIndex())) {
                        String strValue = iWinRefresh.getInstance().showform.mywatchListresult.getString(iWinRefresh.getInstance().showform.mywatchListresult.getSelectedIndex());
                        iWinRefresh.displayAlert("MVMG", strValue, AppConstants.iAlertDisplayTime);
                    }
                    this.refreshDisplay();
                    break;
                }
                case 36: {
                    iWinRefresh.getInstance().showform.myCustomList.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    if (iWinRefresh.getInstance().showform.myCustomList.isSelected(iWinRefresh.getInstance().showform.myCustomList.getSelectedIndex())) {
                        this.strValue = iWinRefresh.getInstance().showform.myCustomList.getString(iWinRefresh.getInstance().showform.myCustomList.getSelectedIndex());
                    }
                    this.refreshDisplay();
                    break;
                }
                case 5: {
                    iWinRefresh.getInstance().showform.marketwatch.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    this.refreshDisplay();
                    break;
                }
                case 24: {
                    iWinRefresh.getInstance().showform.bestfive.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    this.refreshDisplay();
                    break;
                }
                case 10: {
                    iWinRefresh.getInstance().showform.viewdetails.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    this.refreshDisplay();
                    break;
                }
                case 6: {
                    iWinRefresh.getInstance().showform.commoncanvas.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    this.refreshDisplay();
                    break;
                }
                case 39: {
                    iWinRefresh.getInstance().showform.econData.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    this.refreshDisplay();
                    break;
                }
                case 22: {
                    iWinRefresh.getInstance().showform.marketinfo.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    this.refreshDisplay();
                    break;
                }
                case 26: {
                    iWinRefresh.getInstance().showform.parityCalc.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    if (iWinRefresh.getInstance().showform.parityCalc != null) {
                        iWinRefresh.getInstance().showform.parityCalc.calculateParity();
                    }
                    this.refreshDisplay();
                    break;
                }
                case 27: {
                    iWinRefresh.getInstance().showform.parityWatch.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    this.refreshDisplay();
                    break;
                }
                case 19: {
                    iWinRefresh.getInstance().showform.alerts.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    this.refreshDisplay();
                    break;
                }
                case 29: 
                case 33: {
                    iWinRefresh.getInstance().showform.PortfolioWatch.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    this.refreshDisplay();
                    break;
                }
                case 34: {
                    iWinRefresh.getInstance().showform.chartCanvas.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    this.refreshDisplay();
                    break;
                }
                case 35: {
                    iWinRefresh.getInstance().showform.selectionWindow.pointerPressed(lsSection, fiXCordinate, fiYCordinate);
                    iWinRefresh.getInstance().showform.selectionWindow.setFormula();
                    this.refreshDisplay();
                }
            }
        }
    }

    private void drawSoftKeys(Graphics g, int stripIndex) {
        DrawText.setCurrentStrip(stripIndex);
        if (this.leftSoftKey != null) {
            DrawText.drawText(this.leftSoftKey.getLabel(), g, 3, this.getHeight() - SOFT_KEYBAR_HEIGHT + 2);
            if (this.hasPointerEvents() && this.getScreenID() != 0) {
                ScreenPointerDefinition.setPointer(this.getTitle(), this.leftSoftKey.getLabel(), 1, this.getHeight() - SOFT_KEYBAR_HEIGHT - 2, DrawText.getWidth(this.leftSoftKey.getLabel()) + 5, SOFT_KEYBAR_HEIGHT);
            }
        }
        if (this.rightSoftKey != null) {
            DrawText.drawText(this.rightSoftKey.getLabel(), g, this.getWidth() - DrawText.getWidth(this.rightSoftKey.getLabel()), this.getHeight() - SOFT_KEYBAR_HEIGHT + 2);
            if (this.hasPointerEvents() && this.getScreenID() != 0) {
                ScreenPointerDefinition.setPointer(this.getTitle(), this.rightSoftKey.getLabel(), this.getWidth() - DrawText.getWidth(this.rightSoftKey.getLabel()) - 10, this.getHeight() - SOFT_KEYBAR_HEIGHT - 2, DrawText.getWidth(this.rightSoftKey.getLabel()) + 10, SOFT_KEYBAR_HEIGHT);
            }
        }
    }

    public void setSoftKey(SoftKey softKey, String label, int position) {
        if (position == -201) {
            this.leftSoftKey = softKey;
            if (this.leftSoftKey != null) {
                this.leftSoftKey.setLabel(label);
            }
        } else if (position == 224) {
            this.rightSoftKey = softKey;
            if (this.rightSoftKey != null) {
                this.rightSoftKey.setLabel(label);
            }
        }
    }

    public void removeSoftKey(int position) {
        if (position == -201) {
            this.leftSoftKey = null;
        } else if (position == 224) {
            this.rightSoftKey = null;
        }
    }

    public boolean processPointerSoftKeys(int x, int y) {
        if (y >= SCREEN_HEIGHT - SOFT_KEYBAR_HEIGHT - 2 && y <= SCREEN_HEIGHT) {
            if (this.leftSoftKey != null && x >= 3 && x <= DrawText.getWidth(this.leftSoftKey.getLabel()) + 5) {
                this.leftSoftKey.performAction();
                this.refreshDisplay();
                return true;
            }
            if (this.rightSoftKey != null && x <= SCREEN_WIDTH && x >= SCREEN_WIDTH - DrawText.getWidth(this.rightSoftKey.getLabel()) - 5) {
                this.rightSoftKey.performAction();
                this.refreshDisplay();
                return true;
            }
        }
        return false;
    }

    public void processSoftKeys(int keycode) {
        switch (keycode) {
            case -201: 
            case -6: 
            case -5: 
            case 225: {
                if (this.leftSoftKey == null) break;
                this.leftSoftKey.performAction();
                break;
            }
            case -202: 
            case -7: {
                if (this.rightSoftKey == null) break;
                this.rightSoftKey.performAction();
            }
        }
    }

    public void setListener(JCommandListener jCommandListner) {
        this.jCommandListner = jCommandListner;
    }

    public void initSoftKeys() {
        if (this.CommandList != null) {
            this.removeSoftKey(-201);
            this.setSoftKey(this.Options, "Options", -201);
        }
    }

    public void setAlertCommand() {
        this.removeSoftKey(-201);
        this.removeSoftKey(224);
    }

    public void drawCommandList(Graphics g) {
        if (this.isDrawList() && this.CommandList != null) {
            int iSelectorX = 7;
            int iSelectorY = this.iPopUpListYPos + this.iVerticleDisplacing;
            int iSelectorHeight = this.iFontHeight + this.iVerticleDisplacing;
            g.setColor(0xFFFFFF);
            g.fillRect(5, this.iPopUpListYPos, this.iPopUpListWidth - 1, this.iPopUpListHeight);
            g.setColor(0);
            g.drawRect(5, this.iPopUpListYPos - 1, this.iPopUpListWidth, this.iPopUpListHeight);
            DrawText.setCurrentStrip(0);
            int j = 0;
            for (int loopCount = this.iCurrentStart; loopCount <= this.iCurrentEnd; ++loopCount) {
                if (loopCount == this.iCurrentSelect) {
                    g.setColor(9613776);
                    g.fillRect(7, iSelectorY + (loopCount - this.iCurrentStart) * (this.iFontHeight + this.iVerticleDisplacing), this.iPopUpListWidth - 5, iSelectorHeight);
                    g.setColor(0);
                    g.drawRect(7, iSelectorY + (loopCount - this.iCurrentStart) * (this.iFontHeight + this.iVerticleDisplacing), this.iPopUpListWidth - 5, iSelectorHeight);
                    g.drawImage(this.getSelecteorLogoImg(), this.iPopUpListWidth - 2, iSelectorY + (loopCount - this.iCurrentStart) * (this.iFontHeight + this.iVerticleDisplacing) + (iSelectorHeight >> 1) - (this.getSmallLogoHeight() >> 1), 24);
                }
                DrawText.drawText(this.CommandList[loopCount], g, 10, iSelectorY + (iSelectorHeight >> 1) - (this.iFontHeight >> 1) + (loopCount - this.iCurrentStart) * (this.iFontHeight + this.iVerticleDisplacing) + 1);
                ++j;
            }
        }
    }

    public void setDrawList(boolean bIsShown) {
        this.isDrawList = bIsShown;
        if (this.isDrawList) {
            this.initializePopList();
        }
    }

    public boolean isDrawList() {
        return this.isDrawList;
    }

    public int getSelectedIndex() {
        return this.iCurrentSelect;
    }

    public void scrollUP() {
        this.iCurrentSelect = ((this.iCurrentSelect - 1) % this.iListCount + this.iListCount) % this.iListCount;
        this.reAdjustPopUpList();
    }

    public void scrollDN() {
        this.iCurrentSelect = (this.iCurrentSelect + 1) % this.iListCount;
        this.reAdjustPopUpList();
    }

    public void reAdjustPopUpList() {
        if (this.iCurrentSelect < this.iCurrentStart) {
            this.iCurrentStart = this.iCurrentSelect;
            this.iCurrentEnd = this.iCurrentStart + this.MAXDISPLAYABLEITEMS - 1;
        } else if (this.iCurrentSelect > this.iCurrentEnd) {
            this.iCurrentEnd = this.iCurrentSelect;
            this.iCurrentStart = this.iCurrentEnd - this.MAXDISPLAYABLEITEMS + 1;
        } else if (this.iCurrentEnd - this.iCurrentStart < this.MAXDISPLAYABLEITEMS - 1) {
            --this.iCurrentStart;
        }
        if (this.iCurrentEnd >= this.iListCount) {
            this.iCurrentEnd = this.iListCount - 1;
        }
        if (this.iCurrentStart < 0) {
            this.iCurrentStart = 0;
        }
    }

    public void setCommands(String[] command) {
        this.CommandList = command;
        this.iListCount = command.length;
        this.initSoftKeys();
    }

    public void initializePopList() {
        this.iFontHeight = DrawText.getHeight();
        this.iVerticleDisplacing = this.iFontHeight / 4;
        this.iPopUpListHeight = SCREEN_HEIGHT - (SOFT_KEYBAR_HEIGHT << 1) - SCREEN_HEIGHT / 3;
        this.iPopUpListYPos = SCREEN_HEIGHT - SOFT_KEYBAR_HEIGHT - this.iPopUpListHeight - 1;
        this.MAXDISPLAYABLEITEMS = (byte)((this.iPopUpListHeight - (this.iVerticleDisplacing << 1)) / (this.iFontHeight + this.iVerticleDisplacing));
        if (this.MAXDISPLAYABLEITEMS >= this.iListCount) {
            this.MAXDISPLAYABLEITEMS = (byte)this.iListCount;
            this.iPopUpListHeight = this.MAXDISPLAYABLEITEMS * (this.iFontHeight + this.iVerticleDisplacing) + (this.iVerticleDisplacing << 1);
            this.iPopUpListYPos = SCREEN_HEIGHT - SOFT_KEYBAR_HEIGHT - this.iPopUpListHeight - 1;
        }
        this.iCurrentSelect = 0;
        this.iCurrentStart = 0;
        this.iCurrentEnd = this.MAXDISPLAYABLEITEMS - 1;
    }

    public void processCommandAction(int keyCode) {
        if (this.CommandList == null) {
            return;
        }
        switch (keyCode) {
            case 221: {
                this.scrollUP();
                break;
            }
            case 222: {
                this.scrollDN();
                break;
            }
            default: {
                JPlatformCanvas.getInstance().processSoftKeys(keyCode);
            }
        }
    }

    public boolean processPointerEvent(int x, int y) {
        int iItemY = this.iPopUpListYPos + this.iVerticleDisplacing;
        int j = 0;
        for (int itr = this.iCurrentStart; itr <= this.iCurrentEnd; ++itr) {
            int itemTempY = iItemY - (this.iVerticleDisplacing >> 1) + j * (this.iFontHeight + this.iVerticleDisplacing) - 1;
            if (y >= itemTempY && y <= itemTempY + this.iFontHeight + this.iVerticleDisplacing && x >= 8 && x <= this.iPopUpListWidth - 5) {
                if (j + this.iCurrentStart == this.iCurrentSelect) {
                    this.reAdjustPopUpList();
                    return true;
                }
                this.iCurrentSelect = j + this.iCurrentStart;
                return false;
            }
            ++j;
        }
        return false;
    }

    public Image scaleImage(Image src, int width, int height) {
        int scanline = src.getWidth();
        int srcw = src.getWidth();
        int srch = src.getHeight();
        int[] buf = new int[srcw * srch];
        src.getRGB(buf, 0, scanline, 0, 0, srcw, srch);
        int[] buf2 = new int[width * height];
        for (int y = 0; y < height; ++y) {
            int c1 = y * width;
            int c2 = y * srch / height * scanline;
            for (int x = 0; x < width; ++x) {
                buf2[c1 + x] = buf[c2 + x * srcw / width];
            }
        }
        return Image.createRGBImage((int[])buf2, (int)width, (int)height, (boolean)true);
    }

    static {
        instance = null;
    }
}

