/*
 * Decompiled with CFR 0.152.
 */
package chart;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CXAxis {
    private String m_strStartDate;
    private String m_strEndDate;
    private int m_nNoOfUnits;
    private int m_nStartX;
    private int m_nStartY;
    private int m_nWidth;
    private int m_nHeight;
    private boolean m_bDisplayFlag = true;
    private Font f = Font.getFont((int)0, (int)0, (int)8);

    public void setInitialValue(int f_nStartX, int f_nStartY, int f_nWidth, int f_nHeight) {
        this.m_nStartX = f_nStartX;
        this.m_nStartY = f_nStartY;
        this.m_nWidth = f_nWidth;
        this.m_nHeight = f_nHeight;
    }

    public void AssignValues(String f_strStartDate, String f_strEndDate, int f_nNoOfUnits) {
        this.m_strStartDate = f_strStartDate;
        this.m_strEndDate = f_strEndDate;
        this.m_nNoOfUnits = f_nNoOfUnits;
    }

    public void setIntradayFlag(boolean f_bDisplayFlag) {
        this.m_bDisplayFlag = f_bDisplayFlag;
    }

    public void paintXAxis(Graphics g) {
        if (this.m_bDisplayFlag) {
            g.setColor(0, 0, 0);
            g.drawLine(this.m_nWidth + this.m_nStartX, this.m_nStartY, this.m_nWidth + this.m_nStartX, this.m_nHeight + this.m_nStartY);
            g.setFont(this.f);
            int spaceindex = this.m_strStartDate.indexOf(" ");
            this.m_strStartDate = spaceindex > 0 ? this.m_strStartDate.substring(0, spaceindex) : this.m_strStartDate;
            spaceindex = this.m_strEndDate.indexOf(" ");
            this.m_strEndDate = spaceindex > 0 ? this.m_strEndDate.substring(0, spaceindex) : this.m_strEndDate;
            g.drawString(this.m_strStartDate, 2 + this.m_nStartX, this.m_nHeight + this.m_nStartY, 0x10 | 4);
            g.drawString(this.m_strEndDate, this.m_nWidth + this.m_nStartX, this.m_nHeight + this.m_nStartY, 0x10 | 8);
            int m_nRatio = this.m_nWidth / this.m_nNoOfUnits;
            for (int i = 0; i < this.m_nNoOfUnits; ++i) {
                g.setColor(212, 208, 200);
                g.drawLine(m_nRatio * i + this.m_nStartX, this.m_nStartY, m_nRatio * i + this.m_nStartX, this.m_nHeight - 1 + this.m_nStartY);
            }
        }
    }
}

