/*
 * Decompiled with CFR 0.152.
 */
package chart;

import chart.CXAxis;
import chart.CYAxis;
import chart.ChartGenerator;
import chart.DataToPlotted;
import chart.Tick;
import common.Utilities;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class Studies {
    private ChartGenerator m_objChartGenerator = new ChartGenerator();
    private CYAxis m_objYAxis = new CYAxis();
    private CXAxis m_objXAxis = new CXAxis();
    private Vector m_objPaintingMACDTicks;
    private Vector m_objMACDSignalTicks;
    private Vector m_objMACDHistogramTicks;
    private int m_nPx = 0;
    private int m_nStartIndex = 0;
    private int m_nEndIndex = 0;
    private int m_nYAxisData;
    private int m_nXCordinate;
    private int m_nYcordinate;
    private int m_nUnitsForX;
    private int m_nUnitsForY;
    private int m_nShortPeriod = 12;
    private int m_nLongPeriod = 26;
    private int m_nPeriod = 1;
    private int m_nStudiesType = 10;
    private int m_nMax = 0;
    private int m_nMin = 0;
    private int m_nHeight = 0;
    private int m_nWidth = 0;
    private int m_nDivisionFactor = 0;
    private int m_nZeroPoint = 0;
    private int[] m_nTotalTicks = null;
    private int[] m_nSignalTicks = null;
    private int[] m_nHistogramTicks = null;
    private int[] m_nColorTicks = null;

    public void setInitialValues(int f_nYAxisData, int f_nXCordinate, int f_nYCordinate, int f_nWidth, int f_nHeight, int f_nNoOfUnitsForX, int f_nNoOfUnitsForY) {
        this.m_objYAxis.setInitialvalue(f_nXCordinate, f_nYCordinate, f_nWidth, f_nHeight);
        this.m_objXAxis.setInitialValue(f_nXCordinate, f_nYCordinate, f_nWidth, f_nHeight);
        this.m_nYAxisData = f_nYAxisData;
        this.m_nXCordinate = f_nXCordinate;
        this.m_nYcordinate = f_nYCordinate;
        this.m_nWidth = f_nWidth;
        this.m_nHeight = f_nHeight;
        this.m_nUnitsForX = f_nNoOfUnitsForX;
        this.m_nUnitsForY = f_nNoOfUnitsForY;
    }

    public void setShortPeriod(int f_nShortPeriod) {
        this.m_nShortPeriod = f_nShortPeriod;
    }

    public int getShortPeriod() {
        return this.m_nShortPeriod;
    }

    public void setLongPeriod(int f_nLongPeriod) {
        this.m_nLongPeriod = f_nLongPeriod;
    }

    public int getLongPeriod() {
        return this.m_nLongPeriod;
    }

    public void setPeriod(int f_nPeriod) {
        this.m_nPeriod = f_nPeriod;
    }

    public int getPeriod() {
        return this.m_nPeriod;
    }

    public void setStudiesType(int f_nStudiesType) {
        this.m_nStudiesType = f_nStudiesType;
    }

    public int getStudiesType() {
        return this.m_nStudiesType;
    }

    public void prepareStudiesData(Vector f_objData) {
        switch (this.m_nStudiesType) {
            case 0: {
                this.prepareMACDLTPData(f_objData);
                break;
            }
            case 1: {
                this.prepareElliotOscillatorData(f_objData);
                break;
            }
            case 2: 
            case 4: {
                this.prepareDeviationData(f_objData);
                break;
            }
            case 3: {
                this.prepareRSIData(f_objData);
                break;
            }
            case 10: {
                this.prepareVolumeData(f_objData);
            }
        }
    }

    private void prepareVolumeData(Vector f_objData) {
        this.ClearPaintingTicks();
        this.m_nTotalTicks = null;
        this.m_nSignalTicks = null;
        this.m_nHistogramTicks = null;
        this.m_nColorTicks = null;
        if (f_objData == null || f_objData.size() == 0) {
            return;
        }
        this.m_nTotalTicks = new int[f_objData.size()];
        this.m_nColorTicks = new int[f_objData.size()];
        int l_nPrevVolume = 0;
        this.m_nDivisionFactor = ((Tick)f_objData.elementAt((int)0)).m_nDivisionFactor;
        for (int i = 0; i < f_objData.size(); ++i) {
            int l_nVolume;
            this.m_nTotalTicks[i] = l_nVolume = ((Tick)f_objData.elementAt((int)i)).m_nVolume;
            this.m_nColorTicks[i] = l_nVolume > l_nPrevVolume ? 3448628 : 15141900;
            l_nPrevVolume = l_nVolume;
        }
    }

    private void prepareMACDLTPData(Vector f_objData) {
        this.ClearPaintingTicks();
        this.m_nTotalTicks = null;
        this.m_nSignalTicks = null;
        this.m_nHistogramTicks = null;
        this.m_nColorTicks = null;
        if (Math.max(this.m_nShortPeriod, this.m_nLongPeriod) >= f_objData.size()) {
            return;
        }
        if (this.m_objPaintingMACDTicks.size() == 0) {
            int i;
            int l_nMACD = 0;
            int l_nDiffFirstMV = 0;
            int l_nDiffSecondMV = 0;
            int l_nFirstMV = 0;
            int l_nSecondMV = 0;
            this.m_nMax = 0;
            this.m_nMin = 0;
            this.m_nDivisionFactor = ((Tick)f_objData.elementAt((int)0)).m_nDivisionFactor;
            this.m_nTotalTicks = new int[f_objData.size()];
            for (int j = 0; j <= this.m_nShortPeriod - 1; ++j) {
                if (j >= f_objData.size() || j < 0) continue;
                l_nFirstMV += ((Tick)f_objData.elementAt((int)j)).m_nLTP;
            }
            l_nFirstMV = this.m_nShortPeriod > 1 ? (l_nFirstMV /= this.m_nShortPeriod) : 0;
            int l_nShortValue = (((Tick)f_objData.elementAt((int)(this.m_nShortPeriod - 1))).m_nLTP * 2 + l_nFirstMV * (this.m_nShortPeriod + 1 - 2)) / (this.m_nShortPeriod + 1);
            for (int j = 0; j <= this.m_nLongPeriod - 1; ++j) {
                if (j >= f_objData.size() || j < 0) continue;
                l_nSecondMV += ((Tick)f_objData.elementAt((int)j)).m_nLTP;
            }
            l_nSecondMV = this.m_nLongPeriod > 1 ? (l_nSecondMV /= this.m_nLongPeriod) : 0;
            int l_nLongValue = (((Tick)f_objData.elementAt((int)(this.m_nLongPeriod - 1))).m_nLTP * 2 + l_nSecondMV * (this.m_nLongPeriod + 1 - 2)) / (this.m_nLongPeriod + 1);
            for (i = this.m_nShortPeriod; i <= this.m_nLongPeriod - 1; ++i) {
                l_nFirstMV = l_nShortValue = (((Tick)f_objData.elementAt((int)i)).m_nLTP * 2 + l_nFirstMV * (this.m_nShortPeriod + 1 - 2)) / (this.m_nShortPeriod + 1);
            }
            for (i = 0; i < f_objData.size(); ++i) {
                if (i < this.m_nLongPeriod - 1) {
                    this.m_nTotalTicks[i] = 0;
                    continue;
                }
                l_nDiffFirstMV = l_nShortValue;
                l_nShortValue = (((Tick)f_objData.elementAt((int)i)).m_nLTP * 2 + l_nFirstMV * (this.m_nShortPeriod + 1 - 2)) / (this.m_nShortPeriod + 1);
                l_nDiffFirstMV = l_nShortValue - l_nDiffFirstMV;
                l_nFirstMV = l_nShortValue;
                l_nDiffSecondMV = l_nSecondMV;
                l_nSecondMV = l_nLongValue = (((Tick)f_objData.elementAt((int)i)).m_nLTP * 2 + l_nSecondMV * (this.m_nLongPeriod + 1 - 2)) / (this.m_nLongPeriod + 1);
                l_nDiffSecondMV = l_nSecondMV - l_nDiffSecondMV;
                l_nMACD = l_nShortValue - l_nLongValue;
                if (this.m_nMax < l_nMACD) {
                    this.m_nMax = l_nMACD;
                }
                if (this.m_nMin > l_nMACD) {
                    this.m_nMin = l_nMACD;
                }
                this.m_nTotalTicks[i] = l_nMACD;
            }
            this.prepareMACDSignalAndHistogramData(this.m_nTotalTicks);
            int l_nDivisionValue = Utilities.convertToWholeNumber(Integer.toString(1), this.m_nDivisionFactor);
            this.m_nMax += l_nDivisionValue;
            this.m_nMin -= l_nDivisionValue;
        }
    }

    private void prepareMACDSignalAndHistogramData(int[] f_nTotalTicks) {
        this.m_nSignalTicks = new int[f_nTotalTicks.length];
        this.m_nHistogramTicks = new int[f_nTotalTicks.length];
        this.m_nColorTicks = new int[f_nTotalTicks.length];
        int l_nMACDSignalFirstMV = 0;
        for (int j = 0; j <= this.m_nPeriod - 1; ++j) {
            if (j >= f_nTotalTicks.length || j < 0) continue;
            l_nMACDSignalFirstMV += f_nTotalTicks[j];
        }
        l_nMACDSignalFirstMV = this.m_nPeriod > 1 ? (l_nMACDSignalFirstMV /= this.m_nPeriod) : 0;
        int l_nMACDSignalLTP = (f_nTotalTicks[this.m_nPeriod - 1] * 2 + l_nMACDSignalFirstMV * (this.m_nPeriod + 1 - 2)) / (this.m_nPeriod + 1);
        int l_nPreviousSignalValue = 0;
        for (int i = 0; i < f_nTotalTicks.length; ++i) {
            Object l_objTick = null;
            if (i < this.m_nPeriod + Math.max(this.m_nLongPeriod, this.m_nShortPeriod) - 2) {
                this.m_nSignalTicks[i] = 0;
                this.m_nHistogramTicks[i] = 0;
                this.m_nColorTicks[i] = 0x50FF50;
                continue;
            }
            l_nMACDSignalLTP = (f_nTotalTicks[i] * 2 + l_nMACDSignalFirstMV * (this.m_nPeriod + 1 - 2)) / (this.m_nPeriod + 1);
            int l_nHistogramValue = f_nTotalTicks[i] - l_nMACDSignalLTP;
            this.m_nSignalTicks[i] = l_nMACDSignalLTP;
            this.m_nHistogramTicks[i] = l_nHistogramValue;
            l_nMACDSignalFirstMV = l_nMACDSignalLTP;
            this.m_nColorTicks[i] = l_nPreviousSignalValue < l_nMACDSignalLTP ? 3448628 : 15141900;
            l_nPreviousSignalValue = l_nMACDSignalLTP;
            if (this.m_nMax < l_nMACDSignalLTP) {
                this.m_nMax = l_nMACDSignalLTP;
            }
            if (this.m_nMin > l_nMACDSignalLTP) {
                this.m_nMin = l_nMACDSignalLTP;
            }
            if (this.m_nMax < l_nHistogramValue) {
                this.m_nMax = l_nHistogramValue;
            }
            if (this.m_nMin <= l_nHistogramValue) continue;
            this.m_nMin = l_nHistogramValue;
        }
    }

    private void prepareElliotOscillatorData(Vector f_objData) {
        this.ClearPaintingTicks();
        this.m_nTotalTicks = null;
        this.m_nSignalTicks = null;
        this.m_nHistogramTicks = null;
        this.m_nColorTicks = null;
        if (f_objData == null || f_objData.size() == 0) {
            return;
        }
        this.m_nMax = 0;
        this.m_nMin = 0;
        this.m_nSignalTicks = this.getMovingAverageData(f_objData, this.m_nShortPeriod);
        this.m_nHistogramTicks = this.getMovingAverageData(f_objData, this.m_nLongPeriod);
        this.m_nTotalTicks = new int[this.m_nSignalTicks.length];
        this.m_nColorTicks = new int[this.m_nSignalTicks.length];
        this.m_nDivisionFactor = ((Tick)f_objData.elementAt((int)0)).m_nDivisionFactor;
        for (int i = 0; i < this.m_nSignalTicks.length; ++i) {
            int l_nMovingAverage1Price = this.m_nSignalTicks[i];
            int l_nMovingAverage2Price = this.m_nHistogramTicks[i];
            int l_nDiffMA = l_nMovingAverage1Price - l_nMovingAverage2Price;
            if (l_nMovingAverage1Price == 0 || l_nMovingAverage2Price == 0) {
                this.m_nTotalTicks[i] = 0;
                this.m_nColorTicks[i] = 3448628;
                continue;
            }
            this.m_nTotalTicks[i] = l_nDiffMA;
            this.m_nColorTicks[i] = l_nDiffMA > 0 ? 3448628 : 15141900;
        }
    }

    private int[] getMovingAverageData(Vector f_objData, int f_nPeriod) {
        int l_nCounter = f_objData.size();
        int[] l_nTotalTicks = new int[l_nCounter];
        if (l_nCounter <= f_nPeriod) {
            return null;
        }
        int l_nLastLTPSum = 0;
        for (int i = 0; i < l_nCounter; ++i) {
            l_nLastLTPSum += ((Tick)f_objData.elementAt((int)i)).m_nLTP;
            if (i > f_nPeriod - 1) {
                int l_nPreLTP = ((Tick)f_objData.elementAt((int)(i - f_nPeriod))).m_nLTP;
                l_nLastLTPSum -= l_nPreLTP;
            }
            int iLTP = l_nLastLTPSum / f_nPeriod;
            if (i < f_nPeriod - 1) {
                iLTP = 0;
            }
            l_nTotalTicks[i] = iLTP;
        }
        return l_nTotalTicks;
    }

    private void prepareDeviationData(Vector f_objData) {
        this.ClearPaintingTicks();
        this.m_nTotalTicks = null;
        this.m_nSignalTicks = null;
        this.m_nHistogramTicks = null;
        this.m_nColorTicks = null;
        if (this.m_nPeriod >= f_objData.size()) {
            return;
        }
        if (this.m_objPaintingMACDTicks.size() == 0 || this.m_objPaintingMACDTicks == null) {
            int i;
            this.m_nMax = 0;
            this.m_nMin = 0;
            int l_nLastLTPSum = 0;
            this.m_nTotalTicks = new int[f_objData.size()];
            this.m_nDivisionFactor = ((Tick)f_objData.elementAt((int)0)).m_nDivisionFactor;
            for (i = 0; i < this.m_nPeriod - 1; ++i) {
                l_nLastLTPSum += ((Tick)f_objData.elementAt((int)i)).m_nLTP;
                this.m_nTotalTicks[i] = 0;
            }
            i = this.m_nPeriod - 1;
            int l_nMeanLTP = (l_nLastLTPSum += ((Tick)f_objData.elementAt((int)i)).m_nLTP) / this.m_nPeriod;
            int l_nLTP = 0;
            int j = this.m_nPeriod;
            int k = i;
            while (j > 0) {
                int l_nTempLTP = ((Tick)f_objData.elementAt((int)k)).m_nLTP - l_nMeanLTP;
                l_nLTP = this.m_nStudiesType == 4 ? (l_nLTP += l_nTempLTP * l_nTempLTP) : (l_nLTP += Math.abs(l_nTempLTP));
                --j;
                --k;
            }
            l_nLTP /= this.m_nPeriod;
            if (this.m_nStudiesType == 4) {
                l_nLTP = this.mathSqrt(l_nLTP);
            }
            this.m_nTotalTicks[i] = l_nLTP;
            int l_nDiffLastSum = 0;
            for (i = this.m_nPeriod; i < f_objData.size(); ++i) {
                l_nDiffLastSum = l_nLastLTPSum;
                l_nLastLTPSum = l_nLastLTPSum - ((Tick)f_objData.elementAt((int)(i - this.m_nPeriod))).m_nLTP + ((Tick)f_objData.elementAt((int)i)).m_nLTP;
                l_nDiffLastSum = l_nLastLTPSum - l_nDiffLastSum;
                l_nMeanLTP = l_nLastLTPSum;
                l_nMeanLTP /= this.m_nPeriod;
                l_nLTP = 0;
                int j2 = this.m_nPeriod;
                int k2 = i;
                while (j2 > 0) {
                    int l_nTempLTP = ((Tick)f_objData.elementAt((int)k2)).m_nLTP - l_nMeanLTP;
                    l_nLTP = this.m_nStudiesType == 4 ? (l_nLTP += l_nTempLTP * l_nTempLTP) : (l_nLTP += Math.abs(l_nTempLTP));
                    --j2;
                    --k2;
                }
                l_nLTP /= this.m_nPeriod;
                if (this.m_nStudiesType == 4) {
                    l_nLTP = this.mathSqrt(l_nLTP);
                }
                this.m_nTotalTicks[i] = l_nLTP;
            }
        }
    }

    private int mathSqrt(int f_nNumber) {
        if (f_nNumber <= 1) {
            return f_nNumber;
        }
        int x = f_nNumber >> 1;
        while ((x = (x + f_nNumber / x) / 2) > (x + f_nNumber / x) / 2) {
        }
        return x;
    }

    private void prepareRSIData(Vector f_objData) {
        int l_nCounter = f_objData.size();
        this.ClearPaintingTicks();
        this.m_nTotalTicks = null;
        this.m_nSignalTicks = null;
        this.m_nHistogramTicks = null;
        this.m_nColorTicks = null;
        if (this.m_nPeriod >= l_nCounter) {
            return;
        }
        if (this.m_objPaintingMACDTicks.size() == 0) {
            boolean l_bAlreadyComputed = false;
            int l_nRelativeStrengthIndex = 0;
            int l_nGain = 0;
            int l_nLoss = 0;
            int l_nAverageGain = 0;
            int l_nAverageLoss = 0;
            int l_nTotalGain = 0;
            int l_nTotalLoss = 0;
            int l_nTodayClose = 0;
            int l_nPreviousClose = 0;
            int l_nNewAverageGain = 0;
            int l_nNewAverageLoss = 0;
            int l_nIncrementor = 0;
            this.m_nMax = 0;
            this.m_nMin = 0;
            this.m_nDivisionFactor = ((Tick)f_objData.elementAt((int)0)).m_nDivisionFactor;
            this.m_nTotalTicks = new int[l_nCounter];
            for (int i = 0; i < l_nCounter; ++i) {
                if (i < this.m_nPeriod) {
                    this.m_nTotalTicks[i] = 0;
                    continue;
                }
                if (!l_bAlreadyComputed) {
                    for (int j = 0; j < this.m_nPeriod; ++j) {
                        l_nTodayClose = ((Tick)f_objData.elementAt((int)(j + 1))).m_nLTP;
                        l_nPreviousClose = ((Tick)f_objData.elementAt((int)j)).m_nLTP;
                        if (l_nTodayClose > l_nPreviousClose) {
                            l_nGain = l_nTodayClose - l_nPreviousClose;
                            l_nTotalGain += l_nGain;
                        }
                        if (l_nTodayClose < l_nPreviousClose) {
                            l_nLoss = l_nPreviousClose - l_nTodayClose;
                            l_nTotalLoss += l_nLoss;
                        }
                        ++l_nIncrementor;
                    }
                    l_nAverageGain = l_nTotalGain / this.m_nPeriod;
                    l_nAverageLoss = l_nTotalLoss / this.m_nPeriod;
                    this.m_nTotalTicks[i] = l_nRelativeStrengthIndex = 10000 - 10000 * l_nTotalLoss / (l_nTotalLoss + l_nTotalGain);
                    l_bAlreadyComputed = true;
                    continue;
                }
                l_nGain = 0;
                l_nLoss = 0;
                l_nTodayClose = ((Tick)f_objData.elementAt((int)(l_nIncrementor + 1))).m_nLTP;
                l_nPreviousClose = ((Tick)f_objData.elementAt((int)l_nIncrementor)).m_nLTP;
                if (l_nTodayClose > l_nPreviousClose) {
                    l_nGain = l_nTodayClose - l_nPreviousClose;
                }
                if (l_nTodayClose < l_nPreviousClose) {
                    l_nLoss = l_nPreviousClose - l_nTodayClose;
                }
                l_nAverageGain = l_nNewAverageGain = (l_nAverageGain * (this.m_nPeriod - 1) + l_nGain) / this.m_nPeriod;
                l_nAverageLoss = l_nNewAverageLoss = (l_nAverageLoss * (this.m_nPeriod - 1) + l_nLoss) / this.m_nPeriod;
                this.m_nTotalTicks[i] = l_nRelativeStrengthIndex = 10000 - 10000 * l_nNewAverageLoss / (l_nNewAverageLoss + l_nNewAverageGain);
                ++l_nIncrementor;
            }
        }
    }

    public synchronized void getDataToPlot(Vector f_objData, int f_nStartIndex, int f_nEndIndex, int f_nPx) {
        try {
            this.ClearPaintingTicks();
            if (this.m_nTotalTicks == null || this.m_nTotalTicks.length == 0) {
                return;
            }
            this.m_nPx = f_nPx;
            this.m_nMax = this.m_nTotalTicks[this.m_nPeriod];
            this.m_nMin = this.m_nTotalTicks[this.m_nPeriod];
            for (int i = f_nStartIndex; i < f_nEndIndex; ++i) {
                int l_nVolume = this.m_nTotalTicks[i];
                if (l_nVolume > this.m_nMax) {
                    this.m_nMax = l_nVolume;
                }
                if (l_nVolume >= this.m_nMin) continue;
                this.m_nMin = l_nVolume;
            }
            if (this.m_nStudiesType == 10) {
                int l_nDiffential = (this.m_nMax - this.m_nMin) / 100;
                this.m_nMax += l_nDiffential;
                this.m_nMin -= l_nDiffential;
                if (this.m_nMin <= 0) {
                    this.m_nMin = 0;
                }
                if (this.m_nMax <= 0) {
                    return;
                }
            } else {
                int l_nDivisionValue = Utilities.convertToWholeNumber(Integer.toString(1), this.m_nDivisionFactor);
                this.m_nMax += l_nDivisionValue;
                this.m_nMin -= l_nDivisionValue;
            }
            int l_nXPoint = 0;
            int l_nYPoint = 0;
            for (int i = f_nStartIndex; i <= f_nEndIndex; ++i) {
                int iLTP = this.m_nTotalTicks[i];
                l_nYPoint = iLTP == 0 ? -1 : this.m_nHeight * (iLTP - this.m_nMin) / (this.m_nMax - this.m_nMin);
                Tick tick = new Tick(0L, 0, 0, 0, 0, 0, this.m_nTotalTicks[i], 0, "", this.m_nDivisionFactor);
                DataToPlotted l_objDataToPlotted = new DataToPlotted(tick, l_nXPoint += this.m_nPx, l_nYPoint);
                this.m_objPaintingMACDTicks.addElement(l_objDataToPlotted);
            }
            this.m_nZeroPoint = this.m_nYAxisData == 2 ? 0 : Math.abs(this.m_nHeight * this.m_nMin / (this.m_nMax - this.m_nMin));
            this.m_nStartIndex = 0;
            this.m_nEndIndex = this.m_objPaintingMACDTicks.size();
            String l_strStartDate = ((Tick)f_objData.elementAt((int)this.m_nStartIndex)).m_strDate;
            String l_strEndDate = ((Tick)f_objData.elementAt((int)(this.m_nEndIndex - 1))).m_strDate;
            this.m_objYAxis.AssignValues(this.m_nMin, this.m_nMax, this.m_nUnitsForY, this.m_nDivisionFactor);
            this.m_objXAxis.AssignValues(l_strStartDate, l_strEndDate, this.m_nUnitsForX);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void getDataToPlotMACD(Vector f_objData, int f_nStartIndex, int f_nEndIndex, int f_nPx) {
        this.ClearPaintingTicks();
        if (this.m_nTotalTicks == null || this.m_nTotalTicks.length == 0) {
            return;
        }
        this.m_nPx = f_nPx;
        int l_nXPoint = 0;
        for (int i = f_nStartIndex; i <= f_nEndIndex; ++i) {
            int l_nYPoint = 0;
            int iMACDLTP = this.m_nTotalTicks[i];
            l_nYPoint = iMACDLTP == 0 ? -1 : this.m_nHeight * (iMACDLTP - this.m_nMin) / (this.m_nMax - this.m_nMin);
            Tick l_objMACDTick = new Tick(0L, iMACDLTP, 0, 0, 0, 0, 0, 0, "", 2);
            DataToPlotted l_objMACDPlot = new DataToPlotted(l_objMACDTick, l_nXPoint += this.m_nPx, l_nYPoint);
            this.m_objPaintingMACDTicks.addElement(l_objMACDPlot);
            int iSignalLTP = this.m_nSignalTicks[i];
            l_nYPoint = iSignalLTP == 0 ? -1 : this.m_nHeight * (iSignalLTP - this.m_nMin) / (this.m_nMax - this.m_nMin);
            Tick l_objSignalTick = new Tick(0L, iSignalLTP, 0, 0, 0, 0, 0, 0, "", 2);
            DataToPlotted l_objSignalPlot = new DataToPlotted(l_objSignalTick, l_nXPoint, l_nYPoint);
            this.m_objMACDSignalTicks.addElement(l_objSignalPlot);
            int iHistogramLTP = this.m_nHistogramTicks[i];
            l_nYPoint = iHistogramLTP == 0 ? -1 : this.m_nHeight * (iHistogramLTP - this.m_nMin) / (this.m_nMax - this.m_nMin);
            Tick l_objHistogramTick = new Tick(0L, iHistogramLTP, 0, 0, 0, 0, 0, 0, "", 2);
            DataToPlotted l_objHistogramPlot = new DataToPlotted(l_objHistogramTick, l_nXPoint, l_nYPoint);
            this.m_objMACDHistogramTicks.addElement(l_objHistogramPlot);
        }
        this.m_nZeroPoint = Math.abs(this.m_nHeight * this.m_nMin / (this.m_nMax - this.m_nMin));
        this.m_nStartIndex = 0;
        this.m_nEndIndex = this.m_objPaintingMACDTicks.size();
        String l_strStartDate = ((Tick)f_objData.elementAt((int)this.m_nStartIndex)).m_strDate;
        String l_strEndDate = ((Tick)f_objData.elementAt((int)(this.m_nEndIndex - 1))).m_strDate;
        this.m_objYAxis.AssignValues(this.m_nMin, this.m_nMax, this.m_nUnitsForY, this.m_nDivisionFactor);
        this.m_objXAxis.AssignValues(l_strStartDate, l_strEndDate, this.m_nUnitsForX);
    }

    private void ClearPaintingTicks() {
        if (this.m_objPaintingMACDTicks != null) {
            this.m_objPaintingMACDTicks.removeAllElements();
            this.m_objPaintingMACDTicks = null;
        }
        if (this.m_objMACDSignalTicks != null) {
            this.m_objMACDSignalTicks.removeAllElements();
            this.m_objMACDSignalTicks = null;
        }
        if (this.m_objMACDHistogramTicks != null) {
            this.m_objMACDHistogramTicks.removeAllElements();
            this.m_objMACDHistogramTicks = null;
        }
        this.m_objPaintingMACDTicks = new Vector();
        this.m_objMACDSignalTicks = new Vector();
        this.m_objMACDHistogramTicks = new Vector();
    }

    public void paintStudies(Graphics g, int f_nStartIndex, int f_nIndex) {
        if (this.m_objPaintingMACDTicks == null || this.m_objPaintingMACDTicks.size() == 0) {
            g.setColor(0);
            g.drawString("Data not available", this.m_nWidth / 2, this.m_nYcordinate + this.m_nHeight / 2, 0x10 | 1);
            return;
        }
        this.m_objXAxis.paintXAxis(g);
        this.m_objYAxis.paintYAxis(g, this.m_nYAxisData);
        switch (this.m_nStudiesType) {
            case 0: {
                this.m_objChartGenerator.HistogramChartGenerator(g, this.m_objMACDHistogramTicks, this.m_nWidth + this.m_nXCordinate, this.m_nHeight + this.m_nYcordinate, this.m_nStartIndex, this.m_nEndIndex, this.m_nPx, this.m_nColorTicks, this.m_nZeroPoint, f_nStartIndex);
                this.m_objChartGenerator.LineChartGenerator(g, this.m_objPaintingMACDTicks, this.m_nWidth + this.m_nXCordinate, this.m_nHeight + this.m_nYcordinate, this.m_nStartIndex, this.m_nEndIndex);
                this.m_objChartGenerator.LineChartGeneratorForSuperTrend(g, this.m_objMACDSignalTicks, this.m_nWidth + this.m_nXCordinate, this.m_nHeight + this.m_nYcordinate, this.m_nStartIndex, this.m_nEndIndex, this.m_nColorTicks, f_nStartIndex);
                break;
            }
            case 1: 
            case 10: {
                this.m_objChartGenerator.HistogramChartGenerator(g, this.m_objPaintingMACDTicks, this.m_nWidth + this.m_nXCordinate, this.m_nHeight + this.m_nYcordinate, this.m_nStartIndex, this.m_nEndIndex, this.m_nPx, this.m_nColorTicks, this.m_nZeroPoint, f_nStartIndex);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.m_objChartGenerator.LineChartGenerator(g, this.m_objPaintingMACDTicks, this.m_nWidth + this.m_nXCordinate, this.m_nHeight + this.m_nYcordinate, this.m_nStartIndex, this.m_nEndIndex);
                if (this.m_nStudiesType != 3) break;
                if (this.m_nShortPeriod * 100 > this.m_nMin && this.m_nShortPeriod * 100 < this.m_nMax) {
                    this.m_nZeroPoint = Math.abs(this.m_nHeight * (this.m_nShortPeriod * 100 - this.m_nMin) / (this.m_nMax - this.m_nMin));
                    g.drawLine(0, this.m_nHeight + this.m_nYcordinate - this.m_nZeroPoint, this.m_nWidth + this.m_nXCordinate, this.m_nHeight + this.m_nYcordinate - this.m_nZeroPoint);
                }
                if (this.m_nLongPeriod * 100 <= this.m_nMin || this.m_nLongPeriod * 100 >= this.m_nMax) break;
                this.m_nZeroPoint = Math.abs(this.m_nHeight * (this.m_nLongPeriod * 100 - this.m_nMin) / (this.m_nMax - this.m_nMin));
                g.drawLine(0, this.m_nHeight + this.m_nYcordinate - this.m_nZeroPoint, this.m_nWidth + this.m_nXCordinate, this.m_nHeight + this.m_nYcordinate - this.m_nZeroPoint);
            }
        }
    }

    public String getStudyValue(int f_nIndex, int f_nDivisionFactor) {
        String l_strMACDValue = Utilities.ConvertToDecimal(this.m_nTotalTicks[f_nIndex], f_nDivisionFactor, 1);
        return l_strMACDValue;
    }

    public String getSignalValue(int f_nIndex, int f_nDivisionFactor) {
        String l_strSignalValue = Utilities.ConvertToDecimal(this.m_nSignalTicks[f_nIndex], f_nDivisionFactor, 1);
        return l_strSignalValue;
    }

    public String getHistogramValue(int f_nIndex, int f_nDivisionFactor) {
        String l_strHistogramValue = Utilities.ConvertToDecimal(this.m_nHistogramTicks[f_nIndex], f_nDivisionFactor, 1);
        return l_strHistogramValue;
    }
}

