/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.AppConstants;
import common.Profile;
import common.TagData;
import common.Utilities;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.AlertType;
import market.iWinRefresh;

public class ProfileList {
    private Hashtable profileTable = new Hashtable();
    private Hashtable alertsProfile = new Hashtable();
    private Vector vectAlertHistory = new Vector();
    private int iTimeStamp;

    public void putData(String strProfileId, Profile profile) {
        this.profileTable.put(strProfileId, profile);
    }

    public Profile getData(String strpProfileId) {
        Profile profile = null;
        if (this.profileTable.size() > 0) {
            Enumeration e = this.profileTable.keys();
            while (e.hasMoreElements()) {
                String strProfileId = (String)e.nextElement();
                if (!strProfileId.equals(strpProfileId)) continue;
                profile = (Profile)this.profileTable.get(strProfileId);
                break;
            }
            return profile;
        }
        return null;
    }

    public int getIdFromName(String strProfileName) {
        Profile profile = null;
        int f_nProfileId = 0;
        Enumeration e = this.profileTable.elements();
        while (e.hasMoreElements()) {
            profile = (Profile)e.nextElement();
            if (!profile.getProfileName().equals(strProfileName)) continue;
            f_nProfileId = profile.getProfileId();
            break;
        }
        return f_nProfileId;
    }

    public String[] getProfileNames() {
        String[] strHeading = new String[this.profileTable.size()];
        Enumeration ep = this.profileTable.elements();
        int i = 0;
        while (ep.hasMoreElements()) {
            Profile profile = (Profile)ep.nextElement();
            if (profile.getProfileId() == -1) continue;
            strHeading[i] = profile.getProfileName();
            ++i;
        }
        return strHeading;
    }

    public void removeProfile(int iProfileid) {
        this.profileTable.remove(Integer.toString(iProfileid));
    }

    public void printData() {
        Enumeration e = this.profileTable.keys();
        while (e.hasMoreElements()) {
            String strProfileid = (String)e.nextElement();
            Profile profile = (Profile)this.profileTable.get(strProfileid);
        }
    }

    public void setTimeStamp(int ipTimeStamp) {
        this.iTimeStamp = ipTimeStamp;
    }

    public void addAlert(TagData objTag, boolean bFlag) {
        String l_strTempKey = objTag.strKeyOfData;
        if (!l_strTempKey.endsWith(":")) {
            l_strTempKey = l_strTempKey.substring(0, l_strTempKey.length() - 1);
        }
        if (!this.ifAlertExists(l_strTempKey)) {
            objTag.setAlerts(objTag.iReserved, objTag.iPrice);
            this.alertsProfile.put(l_strTempKey, objTag);
            AppConstants.sendrequest.sendRealtimeRequest(objTag, 0, 0);
        } else {
            TagData tag = this.getAlert(l_strTempKey);
            tag.setAlerts(objTag.iReserved, objTag.iPrice);
            tag.iReserved = objTag.iReserved;
            this.alertsProfile.put(l_strTempKey, tag);
        }
    }

    public int getNoOfAlerts() {
        return this.alertsProfile.size();
    }

    public void removeAlert(String strKey) {
        String l_strTempKey = strKey;
        if (!l_strTempKey.endsWith(":")) {
            l_strTempKey = l_strTempKey.substring(0, l_strTempKey.length() - 1);
        }
        if (this.ifAlertExists(l_strTempKey)) {
            TagData tag = this.getAlert(l_strTempKey);
            if (tag.htAlerts.size() == 1) {
                AppConstants.sendrequest.sendRealtimeRequest(tag, 1, 0);
                this.alertsProfile.remove(l_strTempKey);
            } else {
                tag.htAlerts.remove(AppConstants.strRequestString);
            }
        }
    }

    public String[][] getAlerts() {
        String[][] strHeading = new String[15][2];
        Enumeration ep = this.alertsProfile.elements();
        int i = 0;
        while (ep.hasMoreElements()) {
            TagData tag = (TagData)ep.nextElement();
            Enumeration e = tag.htAlerts.keys();
            while (e.hasMoreElements()) {
                String strCondition = (String)e.nextElement();
                int iPrice = Integer.parseInt((String)tag.htAlerts.get(strCondition));
                strHeading[i][0] = tag.strScripDesc + " LTP " + this.getOperator(strCondition) + Utilities.ConvertToDecimal(iPrice, tag.iDivisionFactor, tag.iSegmentId);
                strHeading[i][1] = tag.strKeyOfData;
                ++i;
            }
        }
        String[][] strNewHeading = new String[i][2];
        for (int j = 0; j < i; ++j) {
            strNewHeading[j][0] = strHeading[j][0];
            strNewHeading[j][1] = strHeading[j][1];
        }
        return strNewHeading;
    }

    private String getOperator(String strpCondition) {
        switch (Integer.parseInt(strpCondition)) {
            case 10: {
                return "> ";
            }
            case 11: {
                return "< ";
            }
        }
        return "= ";
    }

    public TagData getAlert(String strKey) {
        if (!strKey.endsWith(":")) {
            strKey = strKey.substring(0, strKey.length() - 1);
        }
        TagData tag = (TagData)this.alertsProfile.get(strKey);
        return tag;
    }

    public TagData[] getAlertsProfile() {
        TagData[] tag = new TagData[this.alertsProfile.size()];
        Enumeration ep = this.alertsProfile.elements();
        int i = 0;
        while (ep.hasMoreElements()) {
            tag[i] = (TagData)ep.nextElement();
            ++i;
        }
        return tag;
    }

    public String[][] getAlertHistory() {
        int iCounter = this.vectAlertHistory.size();
        String[][] strHeading = new String[iCounter][1];
        for (int i = 0; i < iCounter; ++i) {
            strHeading[i][0] = (String)this.vectAlertHistory.elementAt(i);
        }
        return strHeading;
    }

    public boolean ifAlertExists(String strKey) {
        if (!strKey.endsWith(":")) {
            strKey = strKey.substring(0, strKey.length() - 1);
        }
        return this.alertsProfile.containsKey(strKey);
    }

    public void checkAlerts(String strKey, int ipLTP, int iCurrentTime) {
        if (!strKey.endsWith(":")) {
            strKey = strKey.substring(0, strKey.length() - 1);
        }
        if (this.ifAlertExists(strKey)) {
            TagData tag = this.getAlert(strKey);
            if (tag.iReserved > 0) {
                int iGreaterFlag = 10;
                for (int i = 0; i < 3; ++i) {
                    String strAlertKey = Integer.toString(iGreaterFlag);
                    if (tag.htAlerts.containsKey(strAlertKey)) {
                        int iPrice = Integer.parseInt((String)tag.htAlerts.get(strAlertKey));
                        if (this.checkCriteria(Integer.parseInt(strAlertKey), iPrice, ipLTP, iCurrentTime)) {
                            tag.iReserved = 0;
                            String strAlertString = "[" + Utilities.GetFormattedTime(iCurrentTime) + "] Alert generated, " + tag.strScripDesc + " LTP " + this.getOperator(strAlertKey) + Utilities.ConvertToDecimal(iPrice, tag.iDivisionFactor, tag.iSegmentId);
                            this.generateAlert(strAlertString);
                            return;
                        }
                    }
                    ++iGreaterFlag;
                }
            }
        }
    }

    private boolean checkCriteria(int iCondition, int ipSetPrice, int ipLTP, int iCurrentTime) {
        switch (iCondition) {
            case 10: {
                return ipLTP > ipSetPrice && iCurrentTime > this.iTimeStamp;
            }
            case 11: {
                return ipLTP < ipSetPrice && iCurrentTime > this.iTimeStamp;
            }
            case 12: {
                return ipLTP == ipSetPrice && iCurrentTime > this.iTimeStamp;
            }
        }
        return false;
    }

    private void generateAlert(String f_strAlertString) {
        this.vectAlertHistory.addElement(f_strAlertString);
        if (this.vectAlertHistory.size() > 10) {
            this.vectAlertHistory.removeElementAt(this.vectAlertHistory.size());
        }
        iWinRefresh.displayAlert("MVMG", f_strAlertString, 6000);
        for (int i = 0; i < 3; ++i) {
            try {
                iWinRefresh.display.vibrate(600);
                AlertType.INFO.playSound(iWinRefresh.display);
                Thread.sleep(700L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

