/*
 * Decompiled with CFR 0.152.
 */
package common;

import GeneralUI.DrawText;
import GeneralUI.JPlatformCanvas;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import common.Utilities;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import market.iWinRefresh;

public class ProgressBarScreen
implements JCommandListener {
    private boolean bcontinue = false;
    private String title = null;
    private String[] sProgress = new String[]{"Connecting.", "Connecting..", "Connecting...", "Connecting...."};
    private int count = 0;
    private int isteps = 1;

    public ProgressBarScreen() {
        this.setTitle("");
    }

    public void paint(Graphics g) {
        int barHeight = 12;
        int startx = JPlatformCanvas.SCREEN_WIDTH / 4;
        int starty = JPlatformCanvas.SCREEN_HEIGHT / 4;
        int endx = JPlatformCanvas.SCREEN_WIDTH / 2;
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, JPlatformCanvas.SCREEN_WIDTH, JPlatformCanvas.SCREEN_HEIGHT);
        this.count = this.count < 3 ? (this.count = this.count + 1) : 0;
        DrawText.drawText(this.sProgress[this.count], g, (JPlatformCanvas.SCREEN_WIDTH - DrawText.getWidth(this.sProgress[3])) / 2, starty + barHeight + 4);
        g.setColor(0);
        g.drawRect(startx, starty, endx, barHeight + 1);
        for (int j = 0; j < barHeight; ++j) {
            g.setColor(59 + j * 8, 115 + j * 8, 172 + j * 6);
            g.fillRect(startx + 1, starty + barHeight - j, endx / 4 * this.isteps - 1, 1);
        }
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean jcommandAction(SoftKey c, Displayable d) {
        if (c.getLabel().equals("Close")) {
            AppConstants.bMarketWatchRequest = false;
            AppConstants.bHTTPRequestSent = false;
            iWinRefresh.getInstance().assignNull();
            iWinRefresh.getInstance().quit();
        }
        if (c.getLabel().equals("Back") && AppConstants.bLoggedIn) {
            AppConstants.bMarketWatchRequest = false;
            AppConstants.bHTTPRequestSent = false;
            this.stopProgress();
            iWinRefresh.getInstance().backForm(iWinRefresh.iPreviousForm);
        }
        return false;
    }

    public void setProgress(String strMsg, int ipos) {
        JPlatformCanvas.getInstance().setTitle(strMsg);
        this.isteps = ipos;
        JPlatformCanvas.getInstance().refreshDisplay();
    }

    public void continuousProgress() {
        this.bcontinue = true;
        this.count = 0;
        this.isteps = 1;
        JPlatformCanvas.getInstance().setScreenID((byte)9);
        new Thread(new Runnable(){

            public void run() {
                try {
                    while (ProgressBarScreen.this.bcontinue) {
                        JPlatformCanvas.getInstance().refreshDisplay();
                        Thread.sleep(300L);
                    }
                }
                catch (Exception e) {
                    Utilities.printLog("ContinuousProgress");
                }
            }
        }).start();
    }

    public void stopProgress() {
        this.bcontinue = false;
    }

    public boolean getProgressStatus() {
        return this.bcontinue;
    }

    public void keyPressed(int keyCode) {
        JPlatformCanvas.getInstance().processSoftKeys(keyCode);
    }
}

