/*
 * Decompiled with CFR 0.152.
 */
package connection;

import common.AppConstants;
import common.Utilities;
import common.iWinDB;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import market.iWinRefresh;

public class HTTPThread
implements Runnable {
    private String strURLName = "";
    private StringBuffer sbuffData = new StringBuffer();
    private StringBuffer sbuffResult;
    private int iRequestType = 1;

    public HTTPThread(String strURLName, StringBuffer sbuffData) {
        this.strURLName = strURLName;
        this.sbuffData = sbuffData;
    }

    public HTTPThread(String strURLName, StringBuffer sbuffData, int iRequestType) {
        this.strURLName = strURLName;
        this.sbuffData = sbuffData;
        this.iRequestType = iRequestType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer getViaStreamConnection() {
        this.sbuffResult = new StringBuffer();
        HttpConnection conn = null;
        OutputStream os = null;
        InputStream is = null;
        try {
            int len = -1;
            int ch = 0;
            conn = (HttpConnection)Connector.open((String)this.strURLName);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Length", Integer.toString(this.sbuffData.length()));
            conn.setRequestProperty("Content-Type", "application/octet-stream");
            if (!AppConstants.strUserId.equals("")) {
                conn.setRequestProperty("cookie", "ASP.NET_SessionId=" + AppConstants.strUserId);
            }
            os = conn.openOutputStream();
            int requestLength = this.sbuffData.length();
            for (int i = 0; i < requestLength; ++i) {
                os.write(this.sbuffData.charAt(i));
            }
            int rc = conn.getResponseCode();
            if (rc != 200) {
                this.sbuffResult = new StringBuffer();
                this.sbuffResult.append("HTTP Error:").append(conn.getResponseCode()).append(" ").append(conn.getResponseMessage());
                StringBuffer i = this.sbuffResult;
                return i;
            }
            is = conn.openInputStream();
            if (conn instanceof HttpConnection) {
                len = (int)conn.getLength();
            }
            if (len > 0) {
                int actual = 0;
                byte[] data = new byte[len];
                for (int bytesread = 0; bytesread != len && actual != -1; bytesread += actual) {
                    actual = is.read(data, bytesread, len - bytesread);
                }
                this.sbuffResult = new StringBuffer(new String(data));
            } else {
                byte[] data = new byte[874];
                int n = is.read(data, 0, data.length);
                for (int i = 0; i < n; ++i) {
                    ch = data[i] & 0xFF;
                    this.sbuffResult.append((char)ch);
                }
            }
        }
        catch (ConnectionNotFoundException e) {
            this.sbuffResult = new StringBuffer("Gateway not found");
        }
        catch (SecurityException e) {
            this.sbuffResult = new StringBuffer("Permission not granted. Select 'Yes' to download");
        }
        catch (IOException e) {
            this.sbuffResult = new StringBuffer("Kindly check your network connection");
        }
        catch (Exception e) {
            this.sbuffResult = new StringBuffer("Error in downloading ");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                Utilities.printLog("Error closing connection");
            }
            is = null;
            os = null;
            conn = null;
        }
        return this.sbuffResult;
    }

    public void run() {
        if (this.iRequestType == 1 || this.iRequestType == 4) {
            StringBuffer strOutput = this.getViaStreamConnection();
            AppConstants.process.ProcessHTTPResponse(strOutput);
        } else if (this.iRequestType == 2) {
            byte[] baImageData = null;
            baImageData = this.DownloadImage(this.strURLName);
            if (baImageData != null) {
                this.SaveBrokerImage(baImageData);
            }
        } else if (this.iRequestType == 3) {
            byte[] baImageData = null;
            baImageData = this.DownloadImage(this.strURLName);
            iWinRefresh.getInstance().progress.stopProgress();
            iWinRefresh.getInstance().showform.showChart(baImageData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] DownloadImage(String strURLName) {
        HttpConnection c = null;
        FilterInputStream is = null;
        DataOutputStream os = null;
        int rc = 0;
        try {
            c = (HttpConnection)Connector.open((String)strURLName, (int)3, (boolean)true);
            if (this.iRequestType == 3) {
                c.setRequestMethod("POST");
                c.setRequestProperty("Content-Length", Integer.toString(this.sbuffData.length()));
                c.setRequestProperty("Content-Type", "application/octet-stream");
                os = c.openDataOutputStream();
                os.write(this.sbuffData.toString().getBytes());
            }
            if ((rc = c.getResponseCode()) != 200) {
                byte[] byArray = null;
                return byArray;
            }
            int len = (int)c.getLength();
            if (len > 0) {
                is = c.openDataInputStream();
                byte[] data = new byte[len];
                ((DataInputStream)is).readFully(data);
                byte[] byArray = data;
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception ex) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
                if (c != null) {
                    c.close();
                }
            }
            catch (Exception e) {}
            is = null;
            c = null;
        }
        return null;
    }

    private void SaveBrokerImage(byte[] baImage) {
        try {
            iWinDB dbBrokerLogo = new iWinDB("MVMBrokerLogo");
            if (!dbBrokerLogo.isEmpty()) {
                String strName = dbBrokerLogo.deleteRecordStore();
                dbBrokerLogo = new iWinDB(strName);
            }
            dbBrokerLogo.addRecordData(baImage);
            dbBrokerLogo.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

