/*
 * Decompiled with CFR 0.152.
 */
package login;

import GeneralUI.CanvasForm;
import GeneralUI.JPlatformCanvas;
import GeneralUI.JTextField;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import common.Utilities;
import javax.microedition.lcdui.Displayable;
import market.iWinRefresh;

public class Login
extends CanvasForm
implements JCommandListener {
    private JTextField txtLogin = null;
    private JTextField txtPassword = null;
    private JTextField txtSavePassword = null;
    private JTextField txtNewPassword = null;
    private JTextField txtConfirmPassword = null;
    private String strNewPassword = "";

    public Login() {
        super("Login");
        this.initializeForm();
        if (AppConstants.bRememberPassword) {
            this.setValues(AppConstants.strUserId, AppConstants.strPassword, "Y");
        }
    }

    private void initializeForm() {
        if (this.txtLogin == null) {
            this.txtLogin = new JTextField("Login ID :", "", 15, 0);
            this.txtLogin.toUpperCase();
        }
        if (this.txtPassword == null) {
            this.txtPassword = new JTextField("Password :", "", 8, 65536);
        }
        if (this.txtSavePassword == null) {
            this.txtSavePassword = new JTextField("Save Password(Y/N) :", "Y", 1, 0);
            this.txtSavePassword.toUpperCase();
        }
        this.wrapItem(this.txtLogin);
        this.wrapItem(this.txtPassword);
        this.wrapItem(this.txtSavePassword);
    }

    public boolean jcommandAction(SoftKey softKey, Displayable d) {
        iWinRefresh iwinapp = iWinRefresh.getInstance();
        if (softKey.getLabel().equals("Select")) {
            String strCommandName = JPlatformCanvas.getInstance().getCommandName();
            if (strCommandName.equals("Login")) {
                if (this.validate()) {
                    iwinapp.showProgressBar();
                    AppConstants.strUserId = this.txtLogin.getText().toUpperCase().trim();
                    AppConstants.strPassword = this.txtPassword.getText().trim();
                    AppConstants.cInfofeedmain.init(AppConstants.strUserId, AppConstants.strPassword, this.strNewPassword);
                    return true;
                }
            } else {
                if (strCommandName.equals("Preferences")) {
                    iwinapp.showform.showSettings(0);
                    return true;
                }
                if (strCommandName.equals("Change Password")) {
                    if (this.size() < 5) {
                        if (this.txtNewPassword == null) {
                            this.txtNewPassword = new JTextField("New Password :", "", 8, 65536);
                        }
                        if (this.txtConfirmPassword == null) {
                            this.txtConfirmPassword = new JTextField("Confirm Password :", "", 8, 65536);
                        }
                        this.wrapItem(this.txtNewPassword);
                        this.wrapItem(this.txtConfirmPassword);
                    }
                    iwinapp.showform.showLogin();
                    return true;
                }
                if (strCommandName.equals("About")) {
                    iwinapp.showform.showAbout();
                    return true;
                }
                if (strCommandName.equals("Update")) {
                    iwinapp.showform.showUpdate();
                    return true;
                }
            }
        } else if (softKey.getLabel().equals("Exit")) {
            iwinapp.quit();
            return true;
        }
        return false;
    }

    private boolean validate() {
        String strTempLoginId = this.txtLogin.getText().trim();
        String strTempPassword = this.txtPassword.getText().trim();
        String strTempSavePassword = this.txtSavePassword.getText();
        if (strTempLoginId.length() == 0) {
            iWinRefresh.displayAlert("MVMG", "Type Login ID", AppConstants.iAlertDisplayTime);
            return false;
        }
        if (!Utilities.isAlphaNumeric(strTempLoginId, 0)) {
            iWinRefresh.displayAlert("MVMG", "Login ID has invalid chars", AppConstants.iAlertDisplayTime);
            return false;
        }
        if (strTempPassword.length() == 0) {
            iWinRefresh.displayAlert("MVMG", "Type Password", AppConstants.iAlertDisplayTime);
            return false;
        }
        if (!Utilities.isAlphaNumeric(strTempPassword, 0)) {
            iWinRefresh.displayAlert("MVMG", "Password has invalid chars", AppConstants.iAlertDisplayTime);
            return false;
        }
        if (!strTempSavePassword.toUpperCase().equals("Y") && !strTempSavePassword.toUpperCase().equals("N")) {
            iWinRefresh.displayAlert("MVMG", "Type Y or N for Save Password", AppConstants.iAlertDisplayTime);
            return false;
        }
        AppConstants.bRememberPassword = strTempSavePassword.toUpperCase().equals("Y");
        if (this.size() > 3) {
            this.strNewPassword = this.txtNewPassword.getText().trim();
            String strTempConfirmNewPassword = this.txtConfirmPassword.getText().trim();
            if (this.strNewPassword.length() > 0) {
                if (this.strNewPassword.length() < 6) {
                    iWinRefresh.displayAlert("MVMG", "New Password must be >=6 chars.", AppConstants.iAlertDisplayTime);
                    return false;
                }
                if (!Utilities.isAlphaNumeric(this.strNewPassword, 0)) {
                    iWinRefresh.displayAlert("MVMG", "New Password has invalid chars", AppConstants.iAlertDisplayTime);
                    return false;
                }
                if (strTempPassword.equals(this.strNewPassword)) {
                    iWinRefresh.displayAlert("MVMG", "Type different New Password", AppConstants.iAlertDisplayTime);
                    return false;
                }
                if (strTempConfirmNewPassword.length() == 0) {
                    iWinRefresh.displayAlert("MVMG", "Type Confirm Password", AppConstants.iAlertDisplayTime);
                    return false;
                }
                if (!this.strNewPassword.equals(strTempConfirmNewPassword)) {
                    iWinRefresh.displayAlert("MVMG", "Password confirmation failed", AppConstants.iAlertDisplayTime);
                    return false;
                }
                if (strTempLoginId.toUpperCase().equals(this.strNewPassword.toUpperCase())) {
                    iWinRefresh.displayAlert("MVMG", "New Password cannot be same as Login ID", AppConstants.iAlertDisplayTime);
                    return false;
                }
            }
        }
        return true;
    }

    private void setValues(String strUserId, String strPassword, String strSavePassword) {
        Utilities.printLog("UserID " + strUserId + " PWD " + strPassword + " SAVE " + strSavePassword);
        this.txtLogin.setText(strUserId);
        this.txtPassword.setText(strPassword);
        this.txtSavePassword.setText(strSavePassword);
    }
}

