/*
 * Decompiled with CFR 0.152.
 */
package login;

import GeneralUI.CanvasForm;
import GeneralUI.DrawText;
import GeneralUI.DropDownBox;
import GeneralUI.JPlatformCanvas;
import GeneralUI.JStringItem;
import GeneralUI.JTextField;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import common.iWinDB;
import javax.microedition.lcdui.Displayable;
import market.PMSWatch;
import market.iWinRefresh;

public class Settings
extends CanvasForm
implements JCommandListener {
    private JTextField txtWebServer = null;
    private DropDownBox dpOrientation = null;
    private DropDownBox dpBuyorSell = null;
    private DropDownBox dpFont = null;
    private JTextField EditCIFValue = null;
    private JTextField EditCustomDuty = null;
    private JTextField EditBankCost = null;
    private DropDownBox EditFineness = null;
    private JTextField PMSStockQty = null;
    private JTextField PMSStockPrice = null;
    private DropDownBox PMSdpBuyorSell = null;
    private int SettingPageID = 0;
    private String strSegmentId = "";
    private String strInstrumentId = "";
    private String strKey = "";
    private JStringItem strSymbol = new JStringItem("", "");
    private boolean bLoggedUserSettings = false;
    iWinDB db = new iWinDB("MVMOrientation");

    public Settings() {
        super("Preferences");
    }

    public void init(int pageID) {
        this.SettingPageID = pageID;
        this.dellocateComponents(pageID);
        switch (this.SettingPageID) {
            case 0: {
                this.setTitle("Preferences");
                this.setLoggedUserSettingsState(AppConstants.bLoggedIn);
                if (!this.bLoggedUserSettings) {
                    if (this.txtWebServer == null) {
                        this.txtWebServer = new JTextField("Web Server", AppConstants.strWebServer, 50, 0);
                    }
                    if (this.dpFont == null) {
                        this.dpFont = new DropDownBox("Font");
                        String[] FontItem = new String[]{"SMALL", "MEDIUM", "LARGE"};
                        this.dpFont.addItem(FontItem);
                    }
                    if (this.dpFont.isPopupDrawn()) {
                        this.dpFont.hidePopup();
                    }
                    this.dpFont.setSelectedIndex(AppConstants.iFont);
                    this.wrapItem(this.dpFont);
                    this.wrapItem(this.txtWebServer);
                }
                if (this.dpOrientation != null) break;
                this.dpOrientation = new DropDownBox("Market Orientation");
                String[] OrientationItem = new String[]{"STANDARD", "CUSTOM 1", "CUSTOM 2", "CUSTOM 3"};
                this.dpOrientation.addItem(OrientationItem);
                this.wrapItem(this.dpOrientation);
                if (this.dpOrientation.isPopupDrawn()) {
                    this.dpOrientation.hidePopup();
                }
                this.dpOrientation.setSelectedIndex(AppConstants.iOrientation);
                this.setOrientationString();
                this.wrapItem(this.strSymbol);
                break;
            }
            case 1: {
                int choosenIndex = iWinRefresh.getInstance().showform.parityCalc.Symbol.getSelectedIndex();
                String choosenValue = iWinRefresh.getInstance().showform.parityCalc.Symbol.getListItem(choosenIndex);
                this.setTitle(choosenValue);
                choosenIndex = choosenValue.equals("GOLD") ? 1 : 0;
                if (this.EditCIFValue == null) {
                    this.EditCIFValue = new JTextField("CIF($)", AppConstants.defaultValues[choosenIndex][0], 4, 0);
                }
                this.wrapItem(this.EditCIFValue);
                if (this.EditCustomDuty == null) {
                    this.EditCustomDuty = new JTextField("Custom Duty(%)", AppConstants.defaultValues[choosenIndex][1], 8, 0);
                }
                this.wrapItem(this.EditCustomDuty);
                if (this.EditBankCost == null) {
                    this.EditBankCost = new JTextField("Bank Cost(%)", AppConstants.defaultValues[choosenIndex][2], 4, 0);
                }
                this.wrapItem(this.EditBankCost);
                if (!choosenValue.toUpperCase().equals("GOLD")) break;
                if (this.EditFineness == null) {
                    String[] values = new String[]{"989", "990", "991", "992", "993", "994", "995", "996", "997", "998", "999"};
                    this.EditFineness = new DropDownBox("Fineness");
                    this.EditFineness.addItem(values);
                    this.EditFineness.setSelectedIndex(6);
                }
                this.wrapItem(this.EditFineness);
                break;
            }
            case 2: {
                this.setTitle("PMS");
                iWinRefresh iwinapp = iWinRefresh.getInstance();
                PMSWatch tmpObjectRef = iwinapp.showform.PortfolioWatch;
                if (this.strSymbol == null) {
                    this.strSymbol = new JStringItem("", "");
                }
                this.strSymbol.setText(iWinRefresh.iPreviousForm == 29 ? tmpObjectRef.getCellData(tmpObjectRef.getSelectedRow(), 0) : (iWinRefresh.iPreviousForm == 6 ? iwinapp.showform.commoncanvas.getCurrentScripName() : (iWinRefresh.iPreviousForm == 5 ? iwinapp.showform.marketwatch.getCurrentScripName() : iwinapp.showform.mywatchListresult.getString(iwinapp.showform.mywatchListresult.getSelectedIndex()))), 0);
                if (AppConstants.IsSellOrBuy.equals("buy") || AppConstants.IsSellOrBuy.equals("sell")) {
                    this.strSymbol.setText(tmpObjectRef.getCellData(tmpObjectRef.getSelectedRow(), 0), 0);
                }
                this.wrapItem(this.strSymbol);
                if (AppConstants.IsAddOrRemove.equals("Add")) {
                    if (this.dpBuyorSell == null) {
                        this.dpBuyorSell = new DropDownBox("Options:");
                    }
                    this.dpBuyorSell.addItem(new String[]{"Buy", "Sell"});
                    this.wrapItem(this.dpBuyorSell);
                }
                if (this.PMSStockQty == null) {
                    this.PMSStockQty = new JTextField("Qty:", "", 10, 5);
                }
                this.wrapItem(this.PMSStockQty);
                if (this.PMSStockPrice == null) {
                    this.PMSStockPrice = new JTextField("Price:", "", 10, 5);
                }
                this.wrapItem(this.PMSStockPrice);
            }
        }
    }

    private void dellocateComponents(int pageID) {
        if (this.size() > 0) {
            this.restoreForm();
            for (int z = this.size() - 1; z >= 0; --z) {
                this.deleteItem(z);
            }
            switch (pageID) {
                case 0: {
                    this.txtWebServer = null;
                    this.dpOrientation = null;
                    this.strSymbol = null;
                    this.dpFont = null;
                    break;
                }
                case 1: {
                    this.EditCIFValue = null;
                    this.EditCustomDuty = null;
                    this.EditBankCost = null;
                    this.EditFineness = null;
                    break;
                }
                case 2: {
                    this.focusedIndex = -1;
                    this.strSymbol = null;
                    this.PMSStockQty = null;
                    this.PMSStockPrice = null;
                }
            }
        }
    }

    public boolean jcommandAction(SoftKey c, Displayable d) {
        String softkey = c.getLabel();
        if (softkey.equals("Select")) {
            String strCommandName = JPlatformCanvas.getInstance().getCommandName();
            if (strCommandName.equals("Save")) {
                if (this.validate()) {
                    AppConstants.iOrientation = (byte)this.dpOrientation.getSelectedIndex();
                    AppConstants.iFont = (byte)this.dpFont.getSelectedIndex();
                    AppConstants.strWebServer = this.txtWebServer.getText().trim();
                    DrawText.resetFontStrip();
                    JPlatformCanvas.getInstance().initialize();
                    if (AppConstants.iOrientation == 3 && this.dpOrientation.isFocusOwner()) {
                        iWinRefresh.getInstance().showform.showMyCustomListResults();
                    } else {
                        AppConstants.cInfofeedmain.saveUserSettings(AppConstants.strUserId, AppConstants.strPassword, "Y", AppConstants.strWebServer, AppConstants.strBrokerId, AppConstants.iOrientation, AppConstants.iFont);
                        iWinRefresh.getInstance().showform.login = null;
                        iWinRefresh.getInstance().showform.showLogin();
                    }
                }
                return true;
            }
            if (strCommandName.equals("Delete")) {
                iWinRefresh.getInstance().showform.showCommonForm("Reset Preferences", " ", " ", " ", " ", " ", " ");
                return true;
            }
        } else {
            if (softkey.equals("Apply")) {
                if (this.bLoggedUserSettings) {
                    this.bLoggedUserSettings = false;
                    byte iOrientation = (byte)this.dpOrientation.getSelectedIndex();
                    if (iOrientation == 3) {
                        iWinRefresh.getInstance().showform.showMyCustomListResults();
                    } else {
                        AppConstants.iOrientation = iOrientation;
                        AppConstants.cInfofeedmain.saveUserSettings(AppConstants.bRememberPassword ? AppConstants.strUserId : "", AppConstants.bRememberPassword ? AppConstants.strPassword : "", "Y", AppConstants.strWebServer, AppConstants.strBrokerId, AppConstants.iOrientation, AppConstants.iFont);
                        iWinRefresh.getInstance().showform.mainmenu = null;
                        iWinRefresh.getInstance().showform.showMainMenu();
                    }
                } else {
                    String strCIF = this.EditCIFValue.getText();
                    String strCustomDuty = this.EditCustomDuty.getText();
                    String strBankCost = this.EditBankCost.getText();
                    String strFineness = "";
                    if (null != this.EditFineness) {
                        strFineness = this.EditFineness.getText();
                    }
                    iWinRefresh.getInstance().showform.showParityWatch(strCIF, strCustomDuty, strBankCost, strFineness);
                }
                return true;
            }
            if (softkey.equals("Save")) {
                if (this.validatePrice()) {
                    PMSWatch PMS = iWinRefresh.getInstance().showform.PortfolioWatch;
                    if (AppConstants.IsAddOrRemove.equals("Add")) {
                        AppConstants.sendrequest.sendNewAddRemovePMSRequest(this.strSegmentId, this.strInstrumentId, this.strKey, this.dpBuyorSell.getSelectedIndex() == 0 ? this.PMSStockQty.getText() : "-" + this.PMSStockQty.getText(), this.dpBuyorSell.getSelectedIndex() == 0 ? this.PMSStockPrice.getText() : "-" + this.PMSStockPrice.getText(), "1");
                    } else {
                        int Index = PMS.getSelectedRow();
                        AppConstants.sendrequest.sendNewAddRemovePMSRequest(PMS.getHeaderInfo(Index, 0), PMS.getHeaderInfo(Index, 1), PMS.getHeaderInfo(Index, 2), AppConstants.IsSellOrBuy.equals("sell") ? "-" + this.PMSStockQty.getText() : this.PMSStockQty.getText(), AppConstants.IsSellOrBuy.equals("sell") ? "-" + this.PMSStockPrice.getText() : this.PMSStockPrice.getText(), "1");
                    }
                }
                return true;
            }
            if (softkey.equals("Add")) {
                if (this.validatePrice()) {
                    AppConstants.sendrequest.sendNewAddRemovePMSRequest(this.strSegmentId, this.strInstrumentId, this.strKey, this.dpBuyorSell.getSelectedIndex() == 0 && iWinRefresh.iPreviousForm != 5 ? this.PMSStockQty.getText() : "-" + this.PMSStockQty.getText(), this.dpBuyorSell.getSelectedIndex() == 0 && iWinRefresh.iPreviousForm != 5 ? this.PMSStockPrice.getText() : "-" + this.PMSStockPrice.getText(), "1");
                }
                return true;
            }
            if (softkey.equals("Back")) {
                this.bLoggedUserSettings = false;
                switch (this.SettingPageID) {
                    case 0: {
                        if (AppConstants.bLoggedIn) {
                            iWinRefresh.getInstance().showform.showMainMenu();
                            break;
                        }
                        iWinRefresh.getInstance().showform.showLogin();
                        break;
                    }
                    case 1: {
                        iWinRefresh.getInstance().showform.showParityCalc();
                        break;
                    }
                    case 2: {
                        iWinRefresh.getInstance().backForm(iWinRefresh.iPreviousForm);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private boolean validate() {
        String strWebServer = this.txtWebServer.getText().trim();
        if (strWebServer.length() == 0) {
            iWinRefresh.displayAlert("MVMG", "Enter WebServer", AppConstants.iAlertDisplayTime);
            return false;
        }
        return true;
    }

    private boolean validatePrice() {
        String strQty = this.PMSStockQty.getText();
        if (strQty.length() == 0) {
            iWinRefresh.displayAlert("MVMG", "Enter quantity", AppConstants.iAlertDisplayTime);
            return false;
        }
        String strPrice = this.PMSStockPrice.getText();
        if (strPrice.length() == 0) {
            iWinRefresh.displayAlert("MVMG", "Enter price", AppConstants.iAlertDisplayTime);
            return false;
        }
        return true;
    }

    public void setKeyInfo(String strpScripDesc, String strpSegID, String strpInstrID, String strpKey) {
        this.strSegmentId = strpSegID;
        this.strInstrumentId = strpInstrID;
        this.strKey = strpKey;
    }

    public int getSettingPageID() {
        return this.SettingPageID;
    }

    public void setOrientationString() {
        if (this.SettingPageID == 0) {
            if (this.dpOrientation.getSelectedIndex() == 0) {
                this.strSymbol.setText("BidPrice  AskPrice  LTP\nBidQty     AskQty     LUT", 0);
            } else if (this.dpOrientation.getSelectedIndex() == 1) {
                this.strSymbol.setText("LTP  NetChg  LUT\nOpen  High     Low", 0);
            } else if (this.dpOrientation.getSelectedIndex() == 2) {
                this.strSymbol.setText("BidPrice  AskPrice  LTP\n   High          Low      NetChg", 0);
            } else if (this.dpOrientation.getSelectedIndex() == 3) {
                iWinDB db = new iWinDB("MVMOrientation");
                String[] strtemp = new String[6];
                if (db != null && !db.isEmpty()) {
                    String[][] strOrientationList = db.readRecordStore();
                    block12: for (int x = 0; x < 6; ++x) {
                        switch (Integer.parseInt(strOrientationList[x][1])) {
                            case 0: {
                                strtemp[x] = "BidPrice";
                                continue block12;
                            }
                            case 1: {
                                strtemp[x] = "BidQty";
                                continue block12;
                            }
                            case 2: {
                                strtemp[x] = "AskPrice";
                                continue block12;
                            }
                            case 3: {
                                strtemp[x] = "AskQty";
                                continue block12;
                            }
                            case 4: {
                                strtemp[x] = "LTP";
                                continue block12;
                            }
                            case 5: {
                                strtemp[x] = "LUT";
                                continue block12;
                            }
                            case 6: {
                                strtemp[x] = "Open";
                                continue block12;
                            }
                            case 7: {
                                strtemp[x] = "High";
                                continue block12;
                            }
                            case 8: {
                                strtemp[x] = "Low";
                                continue block12;
                            }
                            case 9: {
                                strtemp[x] = "Netchg";
                            }
                        }
                    }
                    this.setOrientationSetting(strtemp);
                } else {
                    this.strSymbol.setText(" ", 0);
                }
            }
        }
    }

    private void setOrientationSetting(String[] strOrientation) {
        if (this.SettingPageID == 0) {
            this.strSymbol.setText(strOrientation[0] + "   " + strOrientation[1] + "   " + strOrientation[2] + "\n" + strOrientation[3] + "   " + strOrientation[4] + "   " + strOrientation[5], 0);
        }
    }

    public void setLoggedUserSettingsState(boolean bNewState) {
        this.bLoggedUserSettings = bNewState;
    }

    public boolean isLoggedUserSettingsEnabled() {
        return this.bLoggedUserSettings;
    }
}

