/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.CanvasForm;
import GeneralUI.JPlatformCanvas;
import GeneralUI.JStringItem;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import javax.microedition.lcdui.Displayable;
import market.iWinRefresh;

public class CommonForm
extends CanvasForm
implements JCommandListener {
    private JStringItem strHeading = new JStringItem("", "");
    private String strMarketSegmentId = "";
    private String strInstrumentId = "";
    private String strProfileData = "";
    private String strPMSQty = "";
    private String strPMSPrice = "";
    private String strTagAddOrRemove = "";

    public CommonForm(String strFormName) {
        super(strFormName);
    }

    public void initializeForm() {
        if (this.size() > 0) {
            for (int z = this.size() - 1; z >= 0; --z) {
                this.deleteItem(z);
            }
        }
        if (this.getTitle().equals("Remove Scrip")) {
            this.strHeading.setText("Are you sure you want to remove this record?", 0);
            this.wrapItem(this.strHeading);
        } else if (this.getTitle().equals("Remove Profile")) {
            this.strHeading.setText("Are you sure you want to remove this Profile?", 0);
            this.wrapItem(this.strHeading);
        } else if (this.getTitle().equals("Log Off")) {
            this.strHeading.setText("Are you sure you want to exit the application?", 0);
            this.wrapItem(this.strHeading);
        } else if (this.getTitle().equals("Reset Preferences")) {
            this.strHeading.setText("Are you sure you want to reset preferences?", 0);
            this.wrapItem(this.strHeading);
        } else if (this.getTitle().equals("About")) {
            this.strHeading.setText("MVMG is a registered trademark of TickerPlant Limited.\nFor further information, browse www.tickerplantindia.com", 1);
            this.wrapItem(new JStringItem("Product Name", "MVMG"));
            this.wrapItem(new JStringItem("Vendor Name", "TickerPlant Limited"));
            this.wrapItem(new JStringItem("Product Version", "3.8"));
            this.wrapItem(this.strHeading);
        } else if (this.getTitle().equals("Custom Orientation")) {
            this.strHeading.setText("Are you sure you want to Apply preferences or Modify?", 0);
            this.wrapItem(this.strHeading);
        } else if (this.getTitle().equals("Remove from PMS")) {
            this.strHeading.setText("Are you sure you want to Remove Scrip from PMS?", 0);
            this.wrapItem(this.strHeading);
        }
        this.restoreForm();
    }

    public void setData(String strpMarketSegmentId, String strpInstrumentId, String strpProfileData) {
        this.strMarketSegmentId = strpMarketSegmentId;
        this.strInstrumentId = strpInstrumentId;
        this.strProfileData = strpProfileData;
        if (this.getTitle().equals("News Story") || this.getTitle().equals("IPO") || this.getTitle().equals("Mutual Fund") || this.getTitle().equals("PMS") || this.getTitle().equals("Insurance") || this.getTitle().equals("Economic Event Details")) {
            this.deleteItem(this.strHeading);
            this.strHeading.setText(this.strProfileData, 0);
            this.wrapItem(this.strHeading);
        }
    }

    public void setPMSData(String strpMarketSegmentId, String strpInstrumentId, String strpProfileData, String strpPMSQty, String strpPrice, String strpAddorRemoveTag) {
        this.strMarketSegmentId = strpMarketSegmentId;
        this.strInstrumentId = strpInstrumentId;
        this.strProfileData = strpProfileData;
        this.strPMSQty = strpPMSQty;
        this.strPMSPrice = strpPrice;
        this.strTagAddOrRemove = strpAddorRemoveTag;
    }

    public boolean jcommandAction(SoftKey softkey, Displayable d) {
        if (softkey.getLabel().equals("Yes")) {
            if (this.getTitle().equals("Remove Scrip")) {
                String strProfileName = AppConstants.STR_PROFILE_NAME;
                iWinRefresh.iPreviousForm = iWinRefresh.iPreviousForm == 5 ? 5 : 32;
                iWinRefresh.getInstance().showProgressBar();
                AppConstants.sendrequest.sendRemoveScripRequest(this.strMarketSegmentId, this.strInstrumentId, strProfileName, this.strProfileData);
            } else if (this.getTitle().equals("Remove Profile")) {
                iWinRefresh.getInstance().showProgressBar();
                AppConstants.sendrequest.sendDeleteProfileRequest(AppConstants.SELECT_PROFILE_INDEX, "MARKETWATCH");
            } else if (this.getTitle().equals("Log Off")) {
                AppConstants.bLoggedIn = false;
                AppConstants.sendrequest.startStopAlertRequest(1);
                iWinRefresh.getInstance().assignNull();
                iWinRefresh.getInstance().quit();
            } else if (this.getTitle().equals("Reset Preferences")) {
                if (iWinRefresh.getInstance().deleteSettings()) {
                    iWinRefresh.getInstance().quit();
                }
            } else if (this.getTitle().equals("Remove from PMS")) {
                AppConstants.IsAddOrRemove = "remove";
                AppConstants.sendrequest.sendNewAddRemovePMSRequest(this.strMarketSegmentId, this.strInstrumentId, this.strProfileData, this.strPMSQty, this.strPMSPrice, this.strTagAddOrRemove);
            }
            return true;
        }
        if (softkey.getLabel().equals("No")) {
            if (this.getTitle().equals("Remove Scrip")) {
                AppConstants.bMarketWatchRequest = false;
                iWinRefresh.getInstance().backForm(iWinRefresh.iPreviousForm);
            } else if (this.getTitle().equals("Remove Profile")) {
                iWinRefresh.getInstance().showform.showProfile();
            } else if (this.getTitle().equals("Log Off")) {
                iWinRefresh.getInstance().showform.showMainMenu();
            } else if (this.getTitle().equals("Reset Preferences")) {
                iWinRefresh.getInstance().showform.showSettings(0);
            } else if (this.getTitle().equals("Remove from PMS")) {
                AppConstants.IsAddOrRemove = "";
                iWinRefresh.getInstance().showform.showPMS();
            }
            return true;
        }
        if (softkey.getLabel().equals("Back")) {
            if (this.getTitle().equals("About")) {
                this.restoreForm();
                if (AppConstants.bLoggedIn) {
                    iWinRefresh.getInstance().showform.showMainMenu();
                } else {
                    iWinRefresh.getInstance().showform.showLogin();
                }
            } else if (this.getTitle().equals("News Story")) {
                iWinRefresh.getInstance().showform.showNews("", false);
            } else if (this.getTitle().equals("IPO") || this.getTitle().equals("Mutual Fund") || this.getTitle().equals("Insurance")) {
                iWinRefresh.getInstance().showform.showCommonCanvas();
            } else if (this.getTitle().equals("PMS")) {
                iWinRefresh.getInstance().showform.showPMS();
            } else if (this.getTitle().equals("Economic Event Details")) {
                String[][] strTemp = iWinRefresh.getInstance().showform.econData.getData();
                int itempCurrentPg = iWinRefresh.getInstance().showform.econData.getCurrentPage();
                int itempTotalPg = iWinRefresh.getInstance().showform.econData.getTotalPage();
                iWinRefresh.getInstance().showform.econData.setData(strTemp, itempCurrentPg, itempTotalPg, "Economic Calendar");
                iWinRefresh.getInstance().showform.showEconData();
            }
            return true;
        }
        if (softkey.getLabel().equals("Save")) {
            AppConstants.cInfofeedmain.saveUserSettings(AppConstants.bRememberPassword ? AppConstants.strUserId : "", AppConstants.bRememberPassword ? AppConstants.strPassword : "", "Y", AppConstants.strWebServer, AppConstants.strBrokerId, AppConstants.iOrientation, AppConstants.iFont);
            iWinRefresh.getInstance().showform.showMainMenu();
        } else if (softkey.getLabel().equals("Modify")) {
            iWinRefresh.getInstance().showform.showMyCustomListResults();
            JPlatformCanvas.getInstance().setListener(iWinRefresh.getInstance().showform.myCustomList);
        }
        return true;
    }
}

