/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.JList;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import common.Utilities;
import common.iWinDB;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import market.iWinRefresh;

public class CustomOrientation
extends JList
implements JCommandListener {
    private Vector OrientationlistVector;

    public CustomOrientation(String str) {
        super(str);
        this.setChoiceType((byte)2);
        this.OrientationlistVector = new Vector();
    }

    public void SetOrientationList(String[] strpWatchListData) {
        for (int itr = 0; itr < strpWatchListData.length; ++itr) {
            this.append(strpWatchListData[itr]);
        }
        iWinDB dbMarketwatch = new iWinDB("MVMOrientation");
        if (!dbMarketwatch.isEmpty()) {
            String[][] strOrientationList = dbMarketwatch.readRecordStore();
            int[] columnList = new int[]{Integer.parseInt(strOrientationList[0][1]), Integer.parseInt(strOrientationList[1][1]), Integer.parseInt(strOrientationList[2][1]), Integer.parseInt(strOrientationList[3][1]), Integer.parseInt(strOrientationList[4][1]), Integer.parseInt(strOrientationList[5][1])};
            for (int i = 0; i < columnList.length; ++i) {
                this.OrientationlistVector.addElement(Integer.toString(columnList[i]));
                this.setSelectedIndex(columnList[i]);
                this.unSelectIndex();
            }
        }
    }

    private void SaveIndex(String strValue) {
        if (this.OrientationlistVector.contains(strValue)) {
            return;
        }
        if (this.OrientationlistVector.contains(" ")) {
            int i = this.OrientationlistVector.indexOf(" ");
            this.OrientationlistVector.setElementAt(strValue, i);
        } else {
            this.OrientationlistVector.addElement(strValue);
        }
    }

    private void RemoveIndex(String strValue) {
        if (this.OrientationlistVector.contains(strValue)) {
            int i = this.OrientationlistVector.indexOf(strValue);
            this.OrientationlistVector.setElementAt(" ", i);
        }
    }

    public void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        if (keyCode == 225 && this.getSelectedCount() > 6 && this.isSelected(this.getSelectedIndex())) {
            this.unSelectIndex();
            iWinRefresh.displayAlert("MVMG", "You have already selected 6 columns", AppConstants.iAlertDisplayTime);
            return;
        }
        int selectedIndex = this.getSelectedIndex();
        if (this.isSelected(selectedIndex)) {
            this.SaveIndex(Integer.toString(selectedIndex));
        } else {
            this.RemoveIndex(Integer.toString(selectedIndex));
        }
    }

    public void pointerPressed(String fsSection, int x, int y) {
        super.pointerPressed(fsSection, x, y);
        if (this.isPointerSelected(fsSection) && this.getSelectedCount() > 6 && this.isSelected(this.getSelectedIndex())) {
            this.unSelectIndex();
            iWinRefresh.displayAlert("MVMG", "You have already selected 6 columns", AppConstants.iAlertDisplayTime);
            return;
        }
        int selectedIndex = this.getSelectedIndex();
        if (this.isSelected(selectedIndex)) {
            this.SaveIndex(Integer.toString(selectedIndex));
        } else {
            this.RemoveIndex(Integer.toString(selectedIndex));
        }
    }

    public boolean jcommandAction(SoftKey softkey, Displayable d) {
        if (softkey.getLabel().equals("Save")) {
            int iNoOfScrips = this.size();
            int iNoOfSelectedScrips = 0;
            for (int k = 0; k < iNoOfScrips; ++k) {
                if (!this.isSelected(k)) continue;
                ++iNoOfSelectedScrips;
            }
            if (iNoOfSelectedScrips <= 0) {
                iWinRefresh.displayAlert("MVMG", "You have not selected any record", AppConstants.iAlertDisplayTime);
                return false;
            }
            if (iNoOfSelectedScrips < 6) {
                iWinRefresh.displayAlert("MVMG", "You have selected less than 6 record", AppConstants.iAlertDisplayTime);
                return false;
            }
            if (iNoOfSelectedScrips == 6) {
                String[][] strList = new String[][]{{"0", this.OrientationlistVector.elementAt(0).toString()}, {"1", this.OrientationlistVector.elementAt(1).toString()}, {"2", this.OrientationlistVector.elementAt(2).toString()}, {"3", this.OrientationlistVector.elementAt(3).toString()}, {"4", this.OrientationlistVector.elementAt(4).toString()}, {"5", this.OrientationlistVector.elementAt(5).toString()}};
                try {
                    iWinDB dbOrientation = new iWinDB("MVMOrientation");
                    dbOrientation.saveRecordStore(strList);
                    dbOrientation.close();
                    dbOrientation = null;
                    iWinRefresh.displayAlert("MVMG", "Saved Successfully", AppConstants.iAlertDisplayTime);
                    AppConstants.iOrientation = (byte)3;
                    AppConstants.cInfofeedmain.saveUserSettings(AppConstants.bRememberPassword ? AppConstants.strUserId : "", AppConstants.bRememberPassword ? AppConstants.strPassword : "", "Y", AppConstants.strWebServer, AppConstants.strBrokerId, AppConstants.iOrientation, AppConstants.iFont);
                    if (AppConstants.bLoggedIn) {
                        iWinRefresh.getInstance().showform.mainmenu = null;
                        iWinRefresh.getInstance().showform.showMainMenu();
                    } else {
                        iWinRefresh.getInstance().showform.login = null;
                        iWinRefresh.getInstance().showform.showLogin();
                    }
                }
                catch (Exception e) {
                    Utilities.printLog("Saving Orientationlist" + e.toString());
                }
            }
            return true;
        }
        if (softkey.getLabel().equals("Back")) {
            iWinRefresh.getInstance().showform.showSettings(0);
            return true;
        }
        return false;
    }
}

