/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.JList;
import GeneralUI.JPlatformCanvas;
import GeneralUI.SoftKey;
import common.AppConstants;
import common.JCommandListener;
import common.Profile;
import common.TagData;
import javax.microedition.lcdui.Displayable;
import market.iWinRefresh;

public class MyWatchListResult
extends JList
implements JCommandListener {
    private String[][] strTempList;
    private int iPageNo = 0;
    private int iMaxPageNo = 0;
    private int iMarketSegmentId = 0;
    private int iInstrumentId = 0;
    private String strSegmentName = "";
    private String strSymbol = "";
    private String strExpiryDate = "";
    private String strStrikePrice = "";
    private String strOptionType = "";
    private String strInstType = "";
    private final int iMaxScripsPerProfile;

    public MyWatchListResult() {
        super("Search List");
        this.iMaxScripsPerProfile = 30;
        this.setChoiceType((byte)2);
    }

    public void SetScripList(String strpSearchText, String[][] strpWatchListData, int ipPageNo, int ipMaxPageNo, int ipMarketSegmentId, int ipInstrumentId) {
        this.iMaxPageNo = ipMaxPageNo;
        this.iPageNo = ipPageNo;
        this.iMarketSegmentId = ipMarketSegmentId;
        this.iInstrumentId = ipInstrumentId;
        this.strTempList = strpWatchListData;
        int length = this.strTempList.length;
        if (ipMarketSegmentId == 12 && ipInstrumentId == 1) {
            for (int i = 0; i < length; ++i) {
                this.append(this.strTempList[i][0].replace('*', ' '), null);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                this.append(this.strTempList[i][0], null);
            }
        }
        if (this.iMaxPageNo == 0) {
            iWinRefresh.displayAlert("MVMG", "No securities found", AppConstants.iAlertDisplayTime);
        } else {
            this.setLabel("Results-[Pg " + this.iPageNo + "/" + this.iMaxPageNo + "]");
        }
    }

    public boolean jcommandAction(SoftKey softkey, Displayable d) {
        if (softkey.getLabel().equals("Select")) {
            iWinRefresh iwinapp = iWinRefresh.getInstance();
            String strCommandName = JPlatformCanvas.getInstance().getCommandName();
            if (strCommandName.equals("Add")) {
                int i;
                int iNoOfScrips = this.size();
                String[][] strNewScrip = new String[iNoOfScrips][2];
                int iNoOfSelectedScrips = 0;
                for (int iTemp = 0; iTemp < iNoOfScrips; ++iTemp) {
                    if (!this.isSelected(iTemp)) continue;
                    int length = this.strTempList[iTemp].length;
                    for (i = 0; i < length; ++i) {
                        strNewScrip[iNoOfSelectedScrips][i] = this.strTempList[iTemp][i];
                    }
                    ++iNoOfSelectedScrips;
                }
                if (iNoOfSelectedScrips <= 0) {
                    iWinRefresh.displayAlert("MVMG", "You have not selected any record", AppConstants.iAlertDisplayTime);
                    return false;
                }
                iWinRefresh.iPreviousForm = 13;
                String strAddScrips = "";
                Profile profile = AppConstants.profilelist.getData(Integer.toString(AppConstants.SELECT_PROFILE_INDEX));
                if (null != profile) {
                    TagData[] tag = profile.getTagData();
                    int k = 0;
                    int length = tag.length;
                    for (int i2 = 0; i2 < iNoOfSelectedScrips; ++i2) {
                        String l_strTempKey = strNewScrip[i2][1];
                        if (this.iInstrumentId != -1) {
                            l_strTempKey = l_strTempKey.substring(0, l_strTempKey.length() - 1);
                        }
                        boolean bMatchFlag = false;
                        for (int j = 0; j < length; ++j) {
                            if (!tag[j].strKeyOfData.startsWith(l_strTempKey) || tag[j].iSegmentId != this.iMarketSegmentId) continue;
                            bMatchFlag = true;
                            break;
                        }
                        if (bMatchFlag) continue;
                        strAddScrips = strAddScrips + strNewScrip[i2][1] + "$";
                        ++k;
                    }
                    if (k == 0) {
                        iWinRefresh.displayAlert("MVMG", "Record already exists", AppConstants.iAlertDisplayTime);
                        return false;
                    }
                    if (30 - length < k) {
                        iWinRefresh.displayAlert("MVMG", "Max. 30 records allowed. you have added " + tag.length + " records", AppConstants.iAlertDisplayTime);
                        return false;
                    }
                } else {
                    for (i = 0; i < iNoOfSelectedScrips; ++i) {
                        strAddScrips = strAddScrips + strNewScrip[i][1] + "$";
                    }
                }
                if (strAddScrips.endsWith("$")) {
                    strAddScrips = strAddScrips.substring(0, strAddScrips.length() - 1);
                }
                this.iMarketSegmentId = AppConstants.iMarketSegmentId;
                this.iInstrumentId = AppConstants.iInstrumentId;
                iwinapp.showProgressBar();
                AppConstants.sendrequest.sendAddScripRequest(this.iMarketSegmentId, this.iInstrumentId, AppConstants.STR_PROFILE_NAME, strAddScrips);
                iwinapp.progress.setProgress("Adding scrips", 2);
                return true;
            }
            if (strCommandName.equals("AddToPMS")) {
                if (this.iInstrumentId == -1 || this.iInstrumentId == 2 && (this.iMarketSegmentId == 2 || this.iMarketSegmentId == 9) || (this.iInstrumentId == 2 || this.iInstrumentId == 1 || this.iInstrumentId == 3) && this.iMarketSegmentId == 17 || this.iMarketSegmentId == 12) {
                    iWinRefresh.displayAlert("MVMG", "Scrip cannot be added to Portfolio.", AppConstants.iAlertDisplayTime);
                    return false;
                }
                iWinRefresh.iPreviousForm = 13;
                int iNoOfScrips = this.size();
                String[][] strNewScrip = new String[iNoOfScrips][2];
                int iNoOfSelectedScrips = 0;
                for (int iTemp = 0; iTemp < iNoOfScrips; ++iTemp) {
                    if (!this.isSelected(iTemp)) continue;
                    int length = this.strTempList[iTemp].length;
                    for (int i = 0; i < length; ++i) {
                        strNewScrip[iNoOfSelectedScrips][i] = this.strTempList[iTemp][i];
                    }
                    ++iNoOfSelectedScrips;
                }
                if (iNoOfSelectedScrips == 1) {
                    AppConstants.IsAddOrRemove = "Add";
                    iWinRefresh.getInstance().showform.showSettings(2);
                    iWinRefresh.getInstance().showform.settings.setKeyInfo(strNewScrip[0][0], Integer.toString(this.iMarketSegmentId), Integer.toString(this.iInstrumentId), strNewScrip[0][1]);
                } else {
                    iWinRefresh.displayAlert("Alert", "Add one record at a time.", AppConstants.iAlertDisplayTime);
                }
                return true;
            }
            if (strCommandName.equals("Next")) {
                if (this.iMaxPageNo == 0) {
                    return false;
                }
                if (this.iPageNo >= this.iMaxPageNo) {
                    return false;
                }
                ++this.iPageNo;
                this.ClearSecurities();
                iwinapp.showform.showSymbolLookUpRequest(this.iMarketSegmentId, this.iInstrumentId, this.strSegmentName, AppConstants.strInstrumentName, this.iPageNo, this.strSymbol, this.strExpiryDate, this.strStrikePrice, this.strOptionType, this.strInstType, 0);
                return true;
            }
            if (strCommandName.equals("Prev")) {
                if (this.iMaxPageNo == 0) {
                    return false;
                }
                --this.iPageNo;
                if (this.iPageNo <= 0) {
                    this.iPageNo = 1;
                    return false;
                }
                this.ClearSecurities();
                iwinapp.showform.showSymbolLookUpRequest(this.iMarketSegmentId, this.iInstrumentId, this.strSegmentName, AppConstants.strInstrumentName, this.iPageNo, this.strSymbol, this.strExpiryDate, this.strStrikePrice, this.strOptionType, this.strInstType, 0);
                return true;
            }
            if (strCommandName.equals("Menu")) {
                iwinapp.showform.showMainMenu();
                return true;
            }
            if (strCommandName.equals("Back")) {
                iwinapp.showform.showSelectInstrument(0);
                return true;
            }
        } else if (softkey.getLabel().equals("Back")) {
            iWinRefresh.getInstance().showform.showSelectInstrument(0);
            return true;
        }
        return false;
    }

    public void ClearSecurities() {
        int iNoOfSecurities = this.size();
        for (int i = iNoOfSecurities - 1; i >= 0; --i) {
            this.delete(i);
        }
    }

    public void SetValues(String strpSegmentName, String strpSymbol, String strpExpiryDate, String strpStrikePrice, String strpOptionType, String strpInstType) {
        this.strSegmentName = strpSegmentName;
        this.strSymbol = strpSymbol;
        this.strExpiryDate = strpExpiryDate;
        this.strStrikePrice = strpStrikePrice;
        this.strOptionType = strpOptionType;
        this.strInstType = strpInstType;
    }
}

