/*
 * Decompiled with CFR 0.152.
 */
package market;

import GeneralUI.CanvasForm;
import GeneralUI.DropDownBox;
import GeneralUI.JTextField;
import GeneralUI.SoftKey;
import common.JCommandListener;
import javax.microedition.lcdui.Displayable;
import market.iWinRefresh;

public class SelectionWindow
extends CanvasForm
implements JCommandListener {
    DropDownBox dpIndicators = new DropDownBox("Select");
    JTextField txtPeriod = new JTextField("Period", "", 3, 2);
    JTextField txtMultiplier = new JTextField("Multiplier", "2", 3, 5);
    DropDownBox dpApply = new DropDownBox("Apply Formula");
    JTextField txtShortPeriod = new JTextField("Short Period", "12", 3, 2);
    JTextField txtLongPeriod = new JTextField("Long Period", "26", 3, 2);
    String strTitle = "";
    int iIndex = 3;
    String[] strMovingAvgApply = new String[]{"Close", "Open", "High", "Low"};
    String[] strPivotPointApply = new String[]{"(H+L+C)/3", "(H+L+C+TO)/4", "(H+L+TO)/3"};

    public SelectionWindow(String f_strFormName) {
        super(f_strFormName);
        this.strTitle = f_strFormName;
        this.initialize();
    }

    public void initialize() {
        if (this.strTitle.equals("Indicators")) {
            String[] strIndicatorList = new String[]{"Moving Avg.", "Pivot Point", "Super Trend"};
            this.dpIndicators.addItem(strIndicatorList);
            this.wrapItem(this.dpIndicators);
        } else if (this.strTitle.equals("Studies")) {
            String[] strStudiesList = new String[]{"MACD", "ELLIOT OSCIL.", "ABS. DEV", "RSI"};
            this.dpIndicators.addItem(strStudiesList);
            this.wrapItem(this.dpIndicators);
        }
    }

    public void setFormula() {
        int iIndicatorIndex = this.dpIndicators.getSelectedIndex();
        if (iIndicatorIndex != this.iIndex) {
            int l_nCounter;
            for (int i = l_nCounter = this.size(); i > 0; --i) {
                this.deleteItem(i);
            }
            if (this.dpApply.size() > 0) {
                this.dpApply.removeAllItems();
            }
            if (this.strTitle.equals("Indicators")) {
                int l_nPeriod;
                this.iIndex = iIndicatorIndex;
                if (this.iIndex == 0) {
                    l_nPeriod = iWinRefresh.getInstance().showform.chartCanvas.getIndicatorPeriod();
                    this.txtPeriod.setText("" + l_nPeriod);
                    this.wrapItem(this.txtPeriod);
                    this.dpApply.addItem(this.strMovingAvgApply);
                    this.wrapItem(this.dpApply);
                } else if (this.iIndex == 1) {
                    this.dpApply.addItem(this.strPivotPointApply);
                    this.wrapItem(this.dpApply);
                } else if (this.iIndex == 2) {
                    l_nPeriod = iWinRefresh.getInstance().showform.chartCanvas.getIndicatorPeriod();
                    this.txtPeriod.setText("" + l_nPeriod);
                    this.wrapItem(this.txtPeriod);
                    this.wrapItem(this.txtMultiplier);
                }
            } else if (this.strTitle.equals("Studies")) {
                int l_nMACDSignalPeriod;
                int l_nShortPeriod;
                this.iIndex = iIndicatorIndex;
                if (this.iIndex == 0) {
                    l_nShortPeriod = iWinRefresh.getInstance().showform.chartCanvas.getStudiesShortPeriod();
                    int l_nLongPeriod = iWinRefresh.getInstance().showform.chartCanvas.getStudiesLongPeriod();
                    int l_nMACDSignalPeriod2 = iWinRefresh.getInstance().showform.chartCanvas.getStudiesPeriod();
                    this.txtShortPeriod.setText("" + l_nShortPeriod);
                    this.txtLongPeriod.setText("" + l_nLongPeriod);
                    this.txtPeriod.setText("" + l_nMACDSignalPeriod2);
                    this.wrapItem(this.txtShortPeriod);
                    this.wrapItem(this.txtLongPeriod);
                    this.wrapItem(this.txtPeriod);
                } else if (this.iIndex == 1) {
                    l_nShortPeriod = iWinRefresh.getInstance().showform.chartCanvas.getStudiesShortPeriod();
                    int l_nLongPeriod = iWinRefresh.getInstance().showform.chartCanvas.getStudiesLongPeriod();
                    this.txtShortPeriod.setText("" + l_nShortPeriod);
                    this.txtLongPeriod.setText("" + l_nLongPeriod);
                    this.wrapItem(this.txtShortPeriod);
                    this.wrapItem(this.txtLongPeriod);
                } else if (this.iIndex == 4 || this.iIndex == 2) {
                    l_nMACDSignalPeriod = iWinRefresh.getInstance().showform.chartCanvas.getStudiesPeriod();
                    this.txtPeriod.setText("" + l_nMACDSignalPeriod);
                    this.wrapItem(this.txtPeriod);
                } else if (this.iIndex == 3) {
                    l_nMACDSignalPeriod = iWinRefresh.getInstance().showform.chartCanvas.getStudiesPeriod();
                    this.txtPeriod.setText("9");
                    this.txtShortPeriod.setLabel("PriceValue1");
                    this.txtShortPeriod.setText("70");
                    this.txtLongPeriod.setLabel("PriceValue2");
                    this.txtLongPeriod.setText("30");
                    this.wrapItem(this.txtPeriod);
                    this.wrapItem(this.txtShortPeriod);
                    this.wrapItem(this.txtLongPeriod);
                }
            }
        }
    }

    public boolean jcommandAction(SoftKey s, Displayable d) {
        String strCommand = s.getLabel();
        if (this.strTitle.equals("Indicators")) {
            int l_nIndicatorType = this.dpIndicators.getSelectedIndex();
            String strPeriod = this.txtPeriod.getText();
            String strMultiplier = this.txtMultiplier.getText();
            if (strPeriod.equals("")) {
                strPeriod = "1";
            }
            if (strMultiplier.equals("") || strMultiplier.equals("0")) {
                strMultiplier = "1";
            }
            int l_nPeriod = Integer.parseInt(strPeriod);
            int l_nFormulaIndex = this.dpApply.getSelectedIndex();
            if (strCommand.equals("Select")) {
                iWinRefresh.getInstance().showform.reloadInteractiveChart(true, l_nPeriod, l_nIndicatorType, l_nFormulaIndex, strMultiplier);
            } else if (strCommand.equals("Back")) {
                iWinRefresh.getInstance().showform.reloadInteractiveChart(false, l_nPeriod, l_nIndicatorType, l_nFormulaIndex, strMultiplier);
            }
        } else if (this.strTitle.equals("Studies")) {
            int l_nStudyType = this.dpIndicators.getSelectedIndex();
            String strShortPeriod = this.txtShortPeriod.getText();
            String strLongPeriod = this.txtLongPeriod.getText();
            String strMACDSignalPeriod = this.txtPeriod.getText();
            if (strShortPeriod.equals("")) {
                strShortPeriod = "1";
            }
            if (strLongPeriod.equals("1")) {
                strLongPeriod = "1";
            }
            if (strMACDSignalPeriod.equals("")) {
                strMACDSignalPeriod = "1";
            }
            int l_nShortPeriod = Integer.parseInt(strShortPeriod);
            int l_nLongPeriod = Integer.parseInt(strLongPeriod);
            int l_nMACDSignalPeriod = Integer.parseInt(strMACDSignalPeriod);
            if (strCommand.equals("Select")) {
                iWinRefresh.getInstance().showform.reloadInteractiveChart(true, l_nMACDSignalPeriod, l_nShortPeriod, l_nLongPeriod, l_nStudyType);
            } else if (strCommand.equals("Back")) {
                iWinRefresh.getInstance().showform.reloadInteractiveChart(false, l_nMACDSignalPeriod, l_nShortPeriod, l_nLongPeriod, l_nStudyType);
            }
        }
        return true;
    }
}

