/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import common.Utilities;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;
import structures.InfoFeedBestBuySell;

public class CInfofeedDGCXFNOTouchline {
    private int m_nFTCode = 0;
    private byte[] m_btUniqueSymbol;
    private int m_nOrderBookId = 0;
    private byte[] m_btUniqueIdentifier;
    private byte[] UnderlyingUniqueIdentifier;
    private byte[] m_btIdentifierOfTheUnderlying = new byte[65];
    private byte[] m_btSymbol;
    private int m_nExpiryDate = 0;
    private int m_nStrikePrice = 0;
    private byte[] m_btOptionType;
    private short m_nPriceMultiplier = 0;
    private short StrikePriceMultiplier = 0;
    private InfoFeedBestBuySell[] m_objBestBuySell;
    private long m_nTotalBidQty;
    private long m_nTotalAskQty;
    private int m_nNumberOfTrades;
    private int m_nLastTradePrice;
    private int m_nLastTradedQty;
    private byte[] m_btLastTradedTime;
    private int m_nAverageTradePrice;
    private int m_nTotalTradedQty;
    private int m_nOpenInterest;
    private int m_nOpen;
    private int m_nHigh;
    private int m_nLow;
    private int m_nClose;
    private long m_nValue;
    private int m_nPreviousClose;
    private String m_strKeyOfData;

    public CInfofeedDGCXFNOTouchline(int f_nBestBuySell) {
        this.m_btUniqueIdentifier = new byte[65];
        this.m_btUniqueSymbol = new byte[12];
        this.m_btSymbol = new byte[33];
        this.m_btOptionType = new byte[3];
        this.m_objBestBuySell = new InfoFeedBestBuySell[f_nBestBuySell];
        for (int i = 0; i < f_nBestBuySell; ++i) {
            this.m_objBestBuySell[i] = new InfoFeedBestBuySell();
        }
        this.m_nTotalBidQty = 0L;
        this.m_nTotalAskQty = 0L;
        this.m_nNumberOfTrades = 0;
        this.m_nLastTradePrice = 0;
        this.m_nLastTradedQty = 0;
        this.m_btLastTradedTime = new byte[21];
        this.m_nAverageTradePrice = 0;
        this.m_nTotalTradedQty = 0;
        this.m_nOpenInterest = 0;
        this.m_nOpen = 0;
        this.m_nHigh = 0;
        this.m_nLow = 0;
        this.m_nClose = 0;
        this.m_nValue = 0L;
        this.m_nPreviousClose = 0;
        this.m_strKeyOfData = "";
    }

    public short UpdateLLFTouchline(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[5], f_objMsgHeader.m_nBaseValue);
            this.m_nOrderBookId = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[6], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[7] != 0) {
                f_objDataInputStream.read(this.m_btUniqueIdentifier, 0, 64);
            }
            if (f_objMsgHeader.m_nFieldDescription[8] != 0) {
                f_objDataInputStream.read(this.m_btIdentifierOfTheUnderlying, 0, 64);
            }
            if (f_objMsgHeader.m_nFieldDescription[9] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 32);
            }
            this.m_nExpiryDate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[10], f_objMsgHeader.m_nBaseValue);
            this.m_nStrikePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[11], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[12] != 0) {
                f_objDataInputStream.read(this.m_btOptionType, 0, 2);
            }
            this.m_nPriceMultiplier = (short)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[13], f_objMsgHeader.m_nBaseValue);
            this.StrikePriceMultiplier = (short)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[14], f_objMsgHeader.m_nBaseValue);
            for (int l_nBestBuySellIndex = 0; l_nBestBuySellIndex < 1; ++l_nBestBuySellIndex) {
                if (-1 != this.m_objBestBuySell[l_nBestBuySellIndex].UpdateQtyDGCXFNO(f_objDataInputStream, f_objMsgHeader, l_nBestBuySellIndex, 15)) continue;
                return -1;
            }
            int iIndex = 20;
            this.m_nLastTradePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradedQty = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[++iIndex] != 0) {
                f_objDataInputStream.read(this.m_btLastTradedTime, 0, 20);
            }
            this.m_nAverageTradePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nTotalTradedQty = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nOpenInterest = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nOpen = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nHigh = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nLow = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nClose = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nValue = Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nPreviousClose = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btUniqueIdentifier), Utilities.RemoveNull(this.m_btSymbol));
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateLLFBestFive(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[5], f_objMsgHeader.m_nBaseValue);
            this.m_nOrderBookId = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[6], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[7] != 0) {
                f_objDataInputStream.read(this.m_btUniqueIdentifier, 0, 64);
            }
            if (f_objMsgHeader.m_nFieldDescription[8] != 0) {
                f_objDataInputStream.read(this.m_btIdentifierOfTheUnderlying, 0, 64);
            }
            if (f_objMsgHeader.m_nFieldDescription[9] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 32);
            }
            this.m_nExpiryDate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[10], f_objMsgHeader.m_nBaseValue);
            this.m_nStrikePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[11], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[12] != 0) {
                f_objDataInputStream.read(this.m_btOptionType, 0, 2);
            }
            this.m_nPriceMultiplier = (short)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[13], f_objMsgHeader.m_nBaseValue);
            this.StrikePriceMultiplier = (short)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[14], f_objMsgHeader.m_nBaseValue);
            int l_nBestBuySellIndex = 0;
            int i = 15;
            while (l_nBestBuySellIndex < 5) {
                this.m_objBestBuySell[l_nBestBuySellIndex] = new InfoFeedBestBuySell();
                if (-1 == this.m_objBestBuySell[l_nBestBuySellIndex].UpdateQtyDGCXFNOBUY(f_objDataInputStream, f_objMsgHeader, 0, i)) {
                    return -1;
                }
                ++l_nBestBuySellIndex;
                i += 3;
            }
            l_nBestBuySellIndex = 0;
            int j = 30;
            while (l_nBestBuySellIndex < 5) {
                if (-1 == this.m_objBestBuySell[l_nBestBuySellIndex].UpdateQtyDGCXFNOSELL(f_objDataInputStream, f_objMsgHeader, 0, j)) {
                    return -1;
                }
                ++l_nBestBuySellIndex;
                j += 3;
            }
            int iIndex = 44;
            this.m_nTotalBidQty = Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nTotalAskQty = Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nNumberOfTrades = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradedQty = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[++iIndex] != 0) {
                f_objDataInputStream.read(this.m_btLastTradedTime, 0, 20);
            }
            this.m_nAverageTradePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nTotalTradedQty = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nOpenInterest = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nOpen = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nHigh = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nLow = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nClose = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nValue = Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_nPreviousClose = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[++iIndex], f_objMsgHeader.m_nBaseValue);
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btUniqueIdentifier), Utilities.RemoveNull(this.m_btSymbol));
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private String createKey(int f_nFTCode, String f_strUniqueIdentifier, String f_nExpiryDate) {
        StringBuffer strKey = new StringBuffer();
        strKey.append(f_nFTCode).append(":").append(f_strUniqueIdentifier).append(":").append(f_nExpiryDate);
        return strKey.toString();
    }

    private void setData(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_objBestBuySell[0].m_nBuyQty, this.m_objBestBuySell[0].m_nBuyRate, this.m_objBestBuySell[0].m_nSellQty, this.m_objBestBuySell[0].m_nSellRate, this.m_nClose, this.m_nPreviousClose, f_objMsgHeader.m_nMsgTimeStamp, this.m_nPriceMultiplier, this.m_nOpen, this.m_nHigh, this.m_nLow);
                break;
            }
            case 24: {
                String[] strData = new String[20];
                for (int i = 0; i < this.m_objBestBuySell.length; ++i) {
                    strData[i * 4] = Utilities.ToString(this.m_objBestBuySell[i].m_nBuyQty);
                    strData[i * 4 + 1] = Utilities.ConvertToDecimal(this.m_objBestBuySell[i].m_nBuyRate, (int)this.m_nPriceMultiplier, f_objMsgHeader.m_nSegmentId);
                    strData[i * 4 + 2] = Utilities.ToString(this.m_objBestBuySell[i].m_nSellQty);
                    strData[i * 4 + 3] = Utilities.ConvertToDecimal(this.m_objBestBuySell[i].m_nSellRate, (int)this.m_nPriceMultiplier, f_objMsgHeader.m_nSegmentId);
                }
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nClose, this.m_nTotalTradedQty, this.m_nOpen, this.m_nHigh, this.m_nLow, this.m_nPreviousClose, (int)this.m_nTotalBidQty, (int)this.m_nTotalAskQty, f_objMsgHeader.m_nMsgTimeStamp, this.m_nPriceMultiplier, this.m_nAverageTradePrice, this.m_nValue);
                iWinRefresh.getInstance().showform.bestfive.setOpenInt(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_nOpenInterest);
                break;
            }
        }
    }
}

