/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import common.Utilities;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;

public class CInfofeedMCXSXEQTouchline {
    private int m_nFTCode = 0;
    private short m_nMarketType = 0;
    private int m_nUniqueIdentifier = 0;
    private byte[] m_btSymbol = new byte[13];
    private byte[] m_btSeries = new byte[3];
    private short m_nIndicativeFlag = 0;
    private int m_nReserved1 = 0;
    private int m_nReserved2 = 0;
    private byte[] m_btReserved3 = new byte[3];
    private long m_lDecimalLocator = 0L;
    private int[] m_nBuyQty;
    private int[] m_nBuyPrice;
    private int[] m_nSellQty;
    private int[] m_nSellPrice;
    private int m_nLTP;
    private int m_nLTQ;
    private byte[] m_btLTT;
    private int m_nATP;
    private int m_nTTQ;
    private int m_nReserved4;
    private int m_nOpenPrice;
    private int m_nHighPrice;
    private int m_nLowPrice;
    private int m_nClosePrice;
    private long m_lValue;
    private byte[] m_btPQU;
    private long m_lQL;
    private int m_nPCP;
    private long m_lTBQ;
    private long m_lTSQ;
    private int m_nNumberOfTrades;
    private int m_nReserved5;
    private byte[] m_btInstrumentName;
    private byte[] m_btReserved6;
    private String m_strKeyOfData;

    public CInfofeedMCXSXEQTouchline(int iNoOfBestBuySell) {
        this.m_nBuyQty = new int[iNoOfBestBuySell];
        this.m_nBuyPrice = new int[iNoOfBestBuySell];
        this.m_nSellQty = new int[iNoOfBestBuySell];
        this.m_nSellPrice = new int[iNoOfBestBuySell];
        this.m_nLTP = 0;
        this.m_nLTQ = 0;
        this.m_btLTT = new byte[31];
        this.m_nATP = 0;
        this.m_nTTQ = 0;
        this.m_nReserved4 = 0;
        this.m_nOpenPrice = 0;
        this.m_nHighPrice = 0;
        this.m_nLowPrice = 0;
        this.m_nClosePrice = 0;
        this.m_strKeyOfData = "";
        this.m_lValue = 0L;
        this.m_btPQU = new byte[21];
        this.m_lQL = 0L;
        this.m_nPCP = 0;
        this.m_lTBQ = 0L;
        this.m_lTSQ = 0L;
        this.m_nNumberOfTrades = 0;
        this.m_nReserved5 = 0;
        this.m_btInstrumentName = new byte[11];
        this.m_btReserved6 = new byte[10];
    }

    public short UpdateLLFTouchline(CMsgHeader f_objInfoFeedMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int j = 5;
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nMarketType = (short)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 1], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nUniqueIdentifier = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 2], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 3] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 12);
            }
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 4] != 0) {
                f_objDataInputStream.read(this.m_btSeries, 0, 2);
            }
            this.m_nIndicativeFlag = (short)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 5], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nReserved1 = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 6], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nReserved2 = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 7], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 8] != 0) {
                f_objDataInputStream.read(this.m_btReserved3, 0, 2);
            }
            this.m_lDecimalLocator = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 9], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_lDecimalLocator = this.GetPriceMultiplier(this.m_lDecimalLocator);
            for (int i = 0; i < 1; ++i) {
                this.m_nBuyQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 10], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nBuyPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 11], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nSellQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 12], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nSellPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 13], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            this.m_nLTP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 14], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLTQ = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 15], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 16] != 0) {
                f_objDataInputStream.read(this.m_btLTT, 0, 30);
            }
            this.m_nATP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 17], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nTTQ = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 18], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nReserved4 = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 19], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nOpenPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 20], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nHighPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 21], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLowPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 22], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nClosePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 23], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_lValue = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 24], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 25] != 0) {
                f_objDataInputStream.read(this.m_btPQU, 0, 20);
            }
            this.m_lQL = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 26], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nPCP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 27], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nReserved5 = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 28], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 29] != 0) {
                f_objDataInputStream.read(this.m_btInstrumentName, 0, 10);
            }
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 30] != 0) {
                f_objDataInputStream.read(this.m_btReserved6, 0, 10);
            }
            this.m_strKeyOfData = this.createkey(this.m_nFTCode, this.m_nMarketType, Utilities.RemoveNull(this.m_btSeries).toString(), f_objInfoFeedMsgHeader.m_nSegmentId).toString();
            this.setData(f_objInfoFeedMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateLLFBestFive(CMsgHeader f_objInfoFeedMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int i;
            int j = 5;
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nMarketType = (short)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 1], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nUniqueIdentifier = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 2], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 3] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 12);
            }
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 4] != 0) {
                f_objDataInputStream.read(this.m_btSeries, 0, 2);
            }
            this.m_nIndicativeFlag = (short)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 5], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nReserved1 = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 6], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nReserved2 = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 7], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 8] != 0) {
                f_objDataInputStream.read(this.m_btReserved3, 0, 2);
            }
            this.m_lDecimalLocator = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 9], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_lDecimalLocator = this.GetPriceMultiplier(this.m_lDecimalLocator);
            for (i = 0; i < 5; ++i) {
                this.m_nBuyQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[2 * i + j + 10], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nBuyPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[2 * i + j + 11], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            for (i = 0; i < 5; ++i) {
                this.m_nSellQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[2 * i + j + 20], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nSellPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[2 * i + j + 21], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            this.m_nLTP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 30], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLTQ = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[++j + 30], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 31] != 0) {
                f_objDataInputStream.read(this.m_btLTT, 0, 30);
            }
            this.m_nATP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 32], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nTTQ = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 33], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nReserved4 = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 34], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nOpenPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 35], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nHighPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 36], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLowPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 37], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nClosePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 38], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_lValue = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 39], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 40] != 0) {
                f_objDataInputStream.read(this.m_btPQU, 0, 20);
            }
            this.m_lQL = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 41], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nPCP = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 42], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_lTBQ = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 43], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_lTSQ = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 44], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nNumberOfTrades = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 45], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nReserved5 = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[j + 46], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 47] != 0) {
                f_objDataInputStream.read(this.m_btInstrumentName, 0, 10);
            }
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[j + 48] != 0) {
                f_objDataInputStream.read(this.m_btReserved6, 0, 10);
            }
            this.m_strKeyOfData = this.createkey(this.m_nFTCode, this.m_nMarketType, Utilities.RemoveNull(this.m_btSeries).toString(), f_objInfoFeedMsgHeader.m_nSegmentId).toString();
            this.setData(f_objInfoFeedMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private StringBuffer createkey(int iFTCode, int sMarketType, String sSeries, int f_nSegmentId) {
        StringBuffer strTemp = new StringBuffer();
        if (f_nSegmentId == 34) {
            return strTemp.append(iFTCode).append(":").append(sMarketType).append(":").append(sSeries).append(":");
        }
        return strTemp;
    }

    private void setData(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_nBuyQty[0], this.m_nBuyPrice[0], this.m_nSellQty[0], this.m_nSellPrice[0], this.m_nClosePrice, this.m_nPCP, f_objMsgHeader.m_nMsgTimeStamp, (int)this.m_lDecimalLocator, this.m_nOpenPrice, this.m_nHighPrice, this.m_nLowPrice);
                break;
            }
            case 24: {
                String[] strData = new String[20];
                for (int i = 0; i < this.m_nBuyPrice.length; ++i) {
                    strData[i * 4] = Utilities.ToString(this.m_nBuyQty[i]);
                    strData[i * 4 + 1] = Utilities.ConvertToDecimal(this.m_nBuyPrice[i], (int)this.m_lDecimalLocator, f_objMsgHeader.m_nSegmentId);
                    strData[i * 4 + 2] = Utilities.ToString(this.m_nSellQty[i]);
                    strData[i * 4 + 3] = Utilities.ConvertToDecimal(this.m_nSellPrice[i], (int)this.m_lDecimalLocator, f_objMsgHeader.m_nSegmentId);
                }
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nClosePrice, this.m_nTTQ, this.m_nOpenPrice, this.m_nHighPrice, this.m_nLowPrice, this.m_nPCP, (int)this.m_lTBQ, (int)this.m_lTSQ, f_objMsgHeader.m_nMsgTimeStamp, (int)this.m_lDecimalLocator, this.m_nATP, this.m_lValue);
                break;
            }
            case 27: {
                iWinRefresh.getInstance().showform.parityWatch.setData(this.m_strKeyOfData, this.m_nClosePrice, f_objMsgHeader.m_nMsgTimeStamp);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nClosePrice, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }

    private int GetPriceMultiplier(long f_nPriceMultiplier) {
        if (f_nPriceMultiplier < 10L) {
            return (int)f_nPriceMultiplier;
        }
        int lnCount = 0;
        do {
            ++lnCount;
        } while ((f_nPriceMultiplier /= 10L) != 1L);
        return lnCount;
    }
}

