/*
 * Decompiled with CFR 0.152.
 */
package structures;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class CMsgHeader {
    public int m_nSegmentId = 0;
    public short m_nMsgCategory = 0;
    public int m_nInstrumentType = 0;
    public int m_nMsgCode = 0;
    public int m_nMsgTimeStamp = 0;
    public byte[] m_btMsgVersion = new byte[12];
    public int m_nMsgLength;
    public byte m_nFieldDescriptionLength;
    public byte[] m_nFieldDescription;
    public int m_nBaseValue = 0;

    public short Update(DataInputStream f_objDataInputStream) {
        try {
            this.m_nSegmentId = f_objDataInputStream.readInt();
            this.m_nMsgCategory = f_objDataInputStream.readShort();
            this.m_nInstrumentType = f_objDataInputStream.readInt();
            this.m_nMsgCode = f_objDataInputStream.readInt();
            this.m_nMsgTimeStamp = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btMsgVersion, 0, 12);
            this.m_nMsgLength = f_objDataInputStream.readInt();
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short Update(DataInputStream f_objDataInputStream, int f_nValue) {
        try {
            f_objDataInputStream.skipBytes(1);
            int l_nMsgLength = (int)this.processDataType(f_objDataInputStream, f_nValue);
            this.m_nFieldDescriptionLength = f_objDataInputStream.readByte();
            this.m_nFieldDescription = new byte[this.m_nFieldDescriptionLength * 2];
            for (int j = 0; j < this.m_nFieldDescriptionLength * 2; j += 2) {
                byte l_btValue = f_objDataInputStream.readByte();
                long l_nMSB = l_btValue >> 4;
                long l_nLSB = (long)l_btValue - (l_nMSB << 4);
                this.m_nFieldDescription[j] = (byte)l_nMSB;
                this.m_nFieldDescription[j + 1] = (byte)l_nLSB;
            }
            this.m_nSegmentId = (int)this.processDataType(f_objDataInputStream, this.m_nFieldDescription[0]);
            this.m_nInstrumentType = (int)this.processDataType(f_objDataInputStream, this.m_nFieldDescription[1]);
            this.m_nMsgCode = (int)this.processDataType(f_objDataInputStream, this.m_nFieldDescription[2]);
            this.m_nMsgTimeStamp = (int)this.processDataType(f_objDataInputStream, this.m_nFieldDescription[3]);
            this.m_nBaseValue = (int)this.processDataType(f_objDataInputStream, this.m_nFieldDescription[4]);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public byte[] ToByteArray() {
        try {
            ByteArrayOutputStream l_objByteArrayInputStream = new ByteArrayOutputStream();
            DataOutputStream l_objDataInputStream = new DataOutputStream(l_objByteArrayInputStream);
            l_objDataInputStream.writeInt(this.m_nSegmentId);
            l_objDataInputStream.writeShort(this.m_nMsgCategory);
            l_objDataInputStream.writeInt(this.m_nInstrumentType);
            l_objDataInputStream.writeInt(this.m_nMsgCode);
            l_objDataInputStream.writeInt(this.m_nMsgTimeStamp);
            l_objDataInputStream.write(this.m_btMsgVersion);
            l_objDataInputStream.writeInt(this.m_nMsgLength);
            l_objDataInputStream.close();
            return l_objByteArrayInputStream.toByteArray();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public long processDataType(DataInputStream l_objDataInputStream, int f_nValue) {
        long msgDataLength = 0L;
        int l_tempValue = f_nValue >> 3;
        try {
            int l_nmsgDataType = f_nValue - (l_tempValue << 3);
            switch (l_nmsgDataType) {
                case 1: {
                    msgDataLength = l_objDataInputStream.readByte();
                    break;
                }
                case 2: {
                    msgDataLength = l_objDataInputStream.readShort();
                    break;
                }
                case 3: {
                    msgDataLength = l_objDataInputStream.readInt();
                    break;
                }
                case 5: {
                    msgDataLength = l_objDataInputStream.readLong();
                }
            }
        }
        catch (IOException ex) {
            msgDataLength = 0L;
            ex.printStackTrace();
        }
        return msgDataLength;
    }
}

