/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;

public class InfoFeedBSEEQMultipleIndex {
    private int m_nFTCode = 0;
    private short m_nIndexCode = 0;
    private int m_nIndexValue = 0;
    private int m_nPreviousCloseIndexValue = 0;
    private byte[] m_nIndexTime = new byte[9];
    private String m_strKeyOfData = "";
    private int m_nDivisionFactor = 2;

    public short Update(CMsgHeader f_ObjMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int l_nNumberOfRecords = f_objDataInputStream.readShort();
            int l_nTimeStamp = f_objDataInputStream.readInt();
            for (int l_nRecordCount = 0; l_nRecordCount < l_nNumberOfRecords; ++l_nRecordCount) {
                if (-1 != this.updateMultipleIndex(f_ObjMsgHeader, f_objDataInputStream)) continue;
                return -1;
            }
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private short updateMultipleIndex(CMsgHeader f_ObjMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.m_nFTCode = f_objDataInputStream.readInt();
            this.m_nIndexCode = f_objDataInputStream.readShort();
            this.m_nIndexValue = f_objDataInputStream.readInt();
            this.m_nPreviousCloseIndexValue = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_nIndexTime, 0, 9);
            this.m_strKeyOfData = this.createKey(this.m_nFTCode).toString();
            this.updateMarketWatchIndex(f_ObjMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private StringBuffer createKey(int ipFTCode) {
        StringBuffer strTemp = new StringBuffer();
        return strTemp.append(ipFTCode).append(":0");
    }

    private void updateMarketWatchIndex(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetIndex(this.m_strKeyOfData, this.m_nIndexValue, this.m_nPreviousCloseIndexValue, this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId, f_objMsgHeader.m_nMsgTimeStamp, 0, 0, 0);
                break;
            }
            case 24: {
                iWinRefresh.getInstance().showform.bestfive.SetIndexData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_nIndexValue, this.m_nPreviousCloseIndexValue, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nIndexValue, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }
}

