/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import common.Utilities;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;

public class InfoFeedCOMEXNYMEXTouchline {
    private int m_nFTCode = 0;
    private byte[] m_btSymbol = new byte[21];
    private byte[] m_btExchangeSymbol = new byte[21];
    private byte[] m_btOptionType = new byte[3];
    private long m_nPriceMultiplier = 0L;
    private long m_nStrikePriceMultiplier = 0L;
    private int m_nContractExpiry = 0;
    private int m_nStrikePrice = 0;
    private int m_nBidVolume = 0;
    private int m_nBidRate = 0;
    private int m_nAskVolume = 0;
    private int m_nAskRate = 0;
    private int m_nPercentNetChange = 0;
    private int m_nVWAP = 0;
    private int m_nNetChange = 0;
    private int m_nLastTradedRate = 0;
    private int m_nLastTradedVolume = 0;
    private int m_nLastTradedTime = 0;
    private int m_nTotalVolumeTraded = 0;
    private int m_nLimitHighPrice = 0;
    private int m_nLimitLowPrice = 0;
    private int m_nOpenInterest = 0;
    private int m_nPreviousCloseRate = 0;
    private int m_nOpen = 0;
    private int m_nHigh = 0;
    private int m_nLow = 0;
    private int m_nClose = 0;
    private short m_nSessionIndicator = (short)-1;
    private long m_nValue = 0L;
    private String m_strKeyOfData = "";
    private int m_nDivisionFactor = 1;
    private String m_strTempTick;

    public short UpdateSGX_ICE(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.m_nFTCode = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btSymbol, 0, 21);
            f_objDataInputStream.read(this.m_btExchangeSymbol, 0, 21);
            f_objDataInputStream.read(this.m_btOptionType, 0, 3);
            this.m_nPriceMultiplier = f_objDataInputStream.readShort();
            this.m_nStrikePriceMultiplier = f_objDataInputStream.readShort();
            this.m_nContractExpiry = f_objDataInputStream.readInt();
            this.m_nStrikePrice = f_objDataInputStream.readInt();
            this.m_nBidVolume = f_objDataInputStream.readInt();
            this.m_nBidRate = f_objDataInputStream.readInt();
            this.m_nAskVolume = f_objDataInputStream.readInt();
            this.m_nAskRate = f_objDataInputStream.readInt();
            this.m_nPercentNetChange = f_objDataInputStream.readInt();
            this.m_nVWAP = f_objDataInputStream.readInt();
            this.m_nNetChange = f_objDataInputStream.readInt();
            this.m_nLastTradedRate = f_objDataInputStream.readInt();
            this.m_nLastTradedVolume = f_objDataInputStream.readInt();
            this.m_nLastTradedTime = f_objDataInputStream.readInt();
            this.m_nTotalVolumeTraded = f_objDataInputStream.readInt();
            this.m_nLimitHighPrice = f_objDataInputStream.readInt();
            this.m_nLimitLowPrice = f_objDataInputStream.readInt();
            this.m_nOpenInterest = f_objDataInputStream.readInt();
            this.m_nPreviousCloseRate = f_objDataInputStream.readInt();
            if (f_objMsgHeader.m_nSegmentId == 57) {
                int l_nSettlementPrice = f_objDataInputStream.readInt();
                int l_nSettlementDate = f_objDataInputStream.readInt();
                this.m_nValue = f_objDataInputStream.readLong();
            }
            this.m_nOpen = f_objDataInputStream.readInt();
            this.m_nHigh = f_objDataInputStream.readInt();
            this.m_nLow = f_objDataInputStream.readInt();
            this.m_nClose = f_objDataInputStream.readInt();
            this.m_nSessionIndicator = f_objDataInputStream.readShort();
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btExchangeSymbol)).toString();
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateCOMEXLLF(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int l_nIndexNo = 5;
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[l_nIndexNo++] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 20);
            }
            if (f_objMsgHeader.m_nFieldDescription[l_nIndexNo++] != 0) {
                f_objDataInputStream.read(this.m_btExchangeSymbol, 0, 20);
            }
            if (f_objMsgHeader.m_nFieldDescription[l_nIndexNo++] != 0) {
                f_objDataInputStream.read(this.m_btOptionType, 0, 2);
            }
            this.m_nPriceMultiplier = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nStrikePriceMultiplier = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nContractExpiry = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nStrikePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nPercentNetChange = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nVWAP = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nNetChange = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradedRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradedVolume = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradedTime = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nTotalVolumeTraded = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nLimitHighPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nLimitLowPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nOpenInterest = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nPreviousCloseRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nOpen = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nHigh = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nLow = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nClose = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nSessionIndicator = (short)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nBidVolume = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nBidRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nAskVolume = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nAskRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            int l_nBidOrder = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            int l_nAskOrder = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            int l_nSettlementPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            int l_nSettlementDate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btExchangeSymbol)).toString();
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateLLF(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int l_nIndexNo = 5;
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[l_nIndexNo++] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 20);
            }
            if (f_objMsgHeader.m_nFieldDescription[l_nIndexNo++] != 0) {
                f_objDataInputStream.read(this.m_btExchangeSymbol, 0, 20);
            }
            if (f_objMsgHeader.m_nFieldDescription[l_nIndexNo++] != 0) {
                f_objDataInputStream.read(this.m_btOptionType, 0, 2);
            }
            this.m_nPriceMultiplier = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nStrikePriceMultiplier = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nContractExpiry = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nStrikePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nBidVolume = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nBidRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nAskVolume = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nAskRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nPercentNetChange = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nVWAP = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nNetChange = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradedVolume = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nLastTradedTime = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nTotalVolumeTraded = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nLimitHighPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nLimitLowPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nOpenInterest = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nPreviousCloseRate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nSegmentId == 57) {
                int l_nSettlementPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
                int l_nSettlementDate = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
                this.m_nValue = Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            }
            this.m_nOpen = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nHigh = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nLow = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nClose = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_nSessionIndicator = (short)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[l_nIndexNo++], f_objMsgHeader.m_nBaseValue);
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btExchangeSymbol)).toString();
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private StringBuffer createKey(int iFTCode, String strExchangeSymbol) {
        StringBuffer strTemp = new StringBuffer();
        strExchangeSymbol = strExchangeSymbol.replace(':', '#');
        strExchangeSymbol = strExchangeSymbol.replace('\\', '*');
        return strTemp.append(iFTCode).append(":").append(strExchangeSymbol).append(":");
    }

    private void setData(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_nBidVolume, this.m_nBidRate, this.m_nAskVolume, this.m_nAskRate, this.m_nClose, this.m_nPreviousCloseRate, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, this.m_nOpen, this.m_nHigh, this.m_nLow);
                break;
            }
            case 24: {
                this.m_nDivisionFactor = iWinRefresh.getInstance().showform.bestfive.getPriceMultiplier(this.m_strKeyOfData);
                String[] strData = new String[20];
                strData[0] = Utilities.ToString(this.m_nBidVolume);
                strData[1] = Utilities.ConvertToDecimal(this.m_nBidRate, this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                strData[2] = Utilities.ToString(this.m_nAskVolume);
                strData[3] = Utilities.ConvertToDecimal(this.m_nAskRate, this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nClose, this.m_nTotalVolumeTraded, this.m_nOpen, this.m_nHigh, this.m_nLow, this.m_nPreviousCloseRate, 0, 0, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, this.m_nVWAP, 0L);
                iWinRefresh.getInstance().showform.bestfive.setOpenInt(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_nOpenInterest);
                break;
            }
            case 27: {
                iWinRefresh.getInstance().showform.parityWatch.setData(this.m_strKeyOfData, this.m_nClose, f_objMsgHeader.m_nMsgTimeStamp);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nClose, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }
}

