/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;

public class InfoFeedMCXIndex {
    private int FTCode;
    private byte[] m_btIndexName = new byte[21];
    private int m_nLastTradedPrice;
    private int m_nOpenRate = 0;
    private int m_nHighRate = 0;
    private int m_nLowRate = 0;
    private int m_nCloseRate = 0;
    private int m_nPreviousClosingIndex;
    private String m_strKeyOfData = "";
    private int m_nDivisionFactor = 2;

    public short Update(CMsgHeader f_ObjMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.FTCode = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btIndexName, 0, 21);
            this.m_nLastTradedPrice = f_objDataInputStream.readInt();
            this.m_nOpenRate = f_objDataInputStream.readInt();
            this.m_nHighRate = f_objDataInputStream.readInt();
            this.m_nLowRate = f_objDataInputStream.readInt();
            this.m_nCloseRate = f_objDataInputStream.readInt();
            this.m_nPreviousClosingIndex = f_objDataInputStream.readInt();
            this.m_strKeyOfData = this.createKey(this.FTCode).toString();
            this.UpdateScrip(f_ObjMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private StringBuffer createKey(int iFTCode) {
        StringBuffer strTemp = new StringBuffer();
        return strTemp.append(iFTCode).append(":0");
    }

    private void UpdateScrip(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetIndex(this.m_strKeyOfData, this.m_nCloseRate, this.m_nPreviousClosingIndex, this.m_nDivisionFactor, 2, f_objMsgHeader.m_nMsgTimeStamp, this.m_nOpenRate, this.m_nHighRate, this.m_nLowRate);
                break;
            }
            case 24: {
                String[] strData = new String[20];
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nCloseRate, 0, this.m_nOpenRate, this.m_nHighRate, this.m_nLowRate, this.m_nPreviousClosingIndex, 0, 0, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, 0, 0L);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nCloseRate, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }
}

