/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import common.Utilities;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;

public class InfoFeedNSEEQIndex {
    private int m_nFTCode = 0;
    private byte[] m_btIndexName = new byte[18];
    private int m_nCurrentIndexValue = 0;
    private int m_nOpenIndexValue = 0;
    private int m_nCloseIndexValue = 0;
    private int m_nHighIndexValue = 0;
    private int m_nLowIndexValue = 0;
    private int m_nPercentChange = 0;
    private int m_nYearlyHighIndexValue = 0;
    private int m_nYearlyLowIndexValue = 0;
    private int m_nPreviousClosingIndex = 0;
    private String m_strKeyOfData = "";
    private int m_nDivisionFactor = 2;

    public short UpdateLLF(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[5], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[6] != 0) {
                f_objDataInputStream.read(this.m_btIndexName, 0, 17);
            }
            this.m_nOpenIndexValue = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[7], f_objMsgHeader.m_nBaseValue);
            this.m_nCloseIndexValue = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[8], f_objMsgHeader.m_nBaseValue);
            this.m_nHighIndexValue = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[9], f_objMsgHeader.m_nBaseValue);
            this.m_nLowIndexValue = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[10], f_objMsgHeader.m_nBaseValue);
            this.m_nCurrentIndexValue = this.m_nCloseIndexValue;
            this.m_nPreviousClosingIndex = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[11], f_objMsgHeader.m_nBaseValue);
            this.m_strKeyOfData = this.createKey(this.m_nFTCode).toString();
            this.UpdateScrip(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private StringBuffer createKey(int iFTCode) {
        StringBuffer strTemp = new StringBuffer();
        return strTemp.append(iFTCode).append(":0");
    }

    private void UpdateScrip(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetIndex(this.m_strKeyOfData, this.m_nCloseIndexValue, this.m_nPreviousClosingIndex, this.m_nDivisionFactor, 4, f_objMsgHeader.m_nMsgTimeStamp, this.m_nOpenIndexValue, this.m_nHighIndexValue, this.m_nLowIndexValue);
                break;
            }
            case 24: {
                String[] strData = new String[20];
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nCloseIndexValue, 0, this.m_nOpenIndexValue, this.m_nHighIndexValue, this.m_nLowIndexValue, this.m_nPreviousClosingIndex, 0, 0, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, 0, 0L);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nCloseIndexValue, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }
}

