/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import common.Utilities;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;
import structures.InfoFeedBestBuySell;

public class InfoFeedNSEEQTouchline {
    private int m_nFTCode;
    private byte[] m_btSymbol = new byte[11];
    private byte[] m_btSeries = new byte[3];
    private byte[] m_btMarketType = new byte[1];
    private InfoFeedBestBuySell m_objInfoFeedBestBuySell = new InfoFeedBestBuySell();
    private int m_nLastTradedPrice = 0;
    private int m_nTotalTradedQty = 0;
    private byte[] m_btSecurityStatus = new byte[1];
    private int m_nOpeningPrice = 0;
    private int m_nHighPrice = 0;
    private int m_nLowPrice = 0;
    private int m_nClosingPrice = 0;
    private int m_nOnlineIndex = 0;
    private int m_nPreviousClosePrice = 0;
    private int m_nAverageTradedPrice = 0;
    private int m_nTotalTurnover = 0;
    private String m_strKeyOfData = "";
    private int m_nDivisionFactor = 2;

    public short UpdateLLF(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[5], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[6] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 10);
            }
            if (f_objMsgHeader.m_nFieldDescription[7] != 0) {
                f_objDataInputStream.read(this.m_btSeries, 0, 2);
            }
            if (f_objMsgHeader.m_nFieldDescription[8] != 0) {
                f_objDataInputStream.read(this.m_btMarketType, 0, 1);
            }
            if (-1 == this.m_objInfoFeedBestBuySell.UpdateRate(f_objDataInputStream, f_objMsgHeader, 0, 9)) {
                return -1;
            }
            this.m_nLastTradedPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[13], f_objMsgHeader.m_nBaseValue);
            this.m_nTotalTradedQty = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[14], f_objMsgHeader.m_nBaseValue);
            if (f_objMsgHeader.m_nFieldDescription[15] != 0) {
                f_objDataInputStream.read(this.m_btSecurityStatus, 0, 1);
            }
            this.m_nOpeningPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[16], f_objMsgHeader.m_nBaseValue);
            this.m_nHighPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[17], f_objMsgHeader.m_nBaseValue);
            this.m_nLowPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[18], f_objMsgHeader.m_nBaseValue);
            this.m_nClosingPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[19], f_objMsgHeader.m_nBaseValue);
            this.m_nOnlineIndex = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[20], f_objMsgHeader.m_nBaseValue);
            this.m_nPreviousClosePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[21], f_objMsgHeader.m_nBaseValue);
            this.m_nAverageTradedPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[22], f_objMsgHeader.m_nBaseValue);
            this.m_nTotalTurnover = (int)Utilities.processDataType(f_objDataInputStream, f_objMsgHeader.m_nFieldDescription[23], f_objMsgHeader.m_nBaseValue);
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btSeries), Utilities.RemoveNull(this.m_btMarketType)).toString();
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private StringBuffer createKey(int iFTCode, String strSeries, String strMarketType) {
        StringBuffer strTemp = new StringBuffer();
        return strTemp.append(iFTCode).append(":").append(strSeries).append(":").append(strMarketType).append(":");
    }

    private void setData(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_objInfoFeedBestBuySell.m_nBuyQty, this.m_objInfoFeedBestBuySell.m_nBuyRate, this.m_objInfoFeedBestBuySell.m_nSellQty, this.m_objInfoFeedBestBuySell.m_nSellRate, this.m_nClosingPrice, this.m_nPreviousClosePrice, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, this.m_nOpeningPrice, this.m_nHighPrice, this.m_nLowPrice);
                break;
            }
            case 24: {
                this.m_nDivisionFactor = iWinRefresh.getInstance().showform.bestfive.getPriceMultiplier(this.m_strKeyOfData);
                String[] strData = new String[20];
                strData[0] = Utilities.ToString(this.m_objInfoFeedBestBuySell.m_nBuyQty);
                strData[1] = Utilities.ConvertToDecimal(this.m_objInfoFeedBestBuySell.m_nBuyRate, this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                strData[2] = Utilities.ToString(this.m_objInfoFeedBestBuySell.m_nSellQty);
                strData[3] = Utilities.ConvertToDecimal(this.m_objInfoFeedBestBuySell.m_nSellRate, this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nClosingPrice, this.m_nTotalTradedQty, this.m_nOpeningPrice, this.m_nHighPrice, this.m_nLowPrice, this.m_nPreviousClosePrice, 0, 0, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, this.m_nAverageTradedPrice, this.m_nTotalTurnover);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nClosingPrice, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }
}

