/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import common.Utilities;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;

public class InfoFeedTPContributorsSPOTTouchline {
    private int m_nFTCode = 0;
    private byte[] m_btSource = new byte[21];
    private byte[] m_btExchangeSymbol = new byte[21];
    private byte[] m_btCompositeSymbol = new byte[41];
    private long m_nPriceMultiplier = 0L;
    private int m_nBestBuyOrderPrice = 0;
    private int m_nBestBuyOrderQty = 0;
    private int m_nBestSellOrderPrice = 0;
    private int m_nBestSellOrderQty = 0;
    private int m_nOpeningPrice = 0;
    private int m_nHighPrice = 0;
    private int m_nLowPrice = 0;
    private int m_nClosingPrice = 0;
    private int m_nLastTradedPrice = 0;
    private int m_nLastTradedQty = 0;
    private int m_nTotalTradedQty = 0;
    private int m_nLastTradedTime = 0;
    private long m_nNetChange = 0L;
    private long m_nPercentNetChange = 0L;
    private int m_nPreviousClosePrice = 0;
    private int m_nLastUpdateTime = 0;
    private String m_strKeyOfData = "";
    private int m_nDivisionFactor = 4;

    public short Update(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            this.m_nFTCode = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btSource, 0, 21);
            f_objDataInputStream.read(this.m_btExchangeSymbol, 0, 21);
            f_objDataInputStream.read(this.m_btCompositeSymbol, 0, 41);
            this.m_nPriceMultiplier = f_objDataInputStream.readLong();
            this.m_nBestBuyOrderPrice = f_objDataInputStream.readInt();
            this.m_nBestBuyOrderQty = f_objDataInputStream.readInt();
            this.m_nBestSellOrderPrice = f_objDataInputStream.readInt();
            this.m_nBestSellOrderQty = f_objDataInputStream.readInt();
            this.m_nOpeningPrice = f_objDataInputStream.readInt();
            this.m_nHighPrice = f_objDataInputStream.readInt();
            this.m_nLowPrice = f_objDataInputStream.readInt();
            this.m_nClosingPrice = f_objDataInputStream.readInt();
            this.m_nLastTradedPrice = f_objDataInputStream.readInt();
            this.m_nLastTradedQty = f_objDataInputStream.readInt();
            this.m_nTotalTradedQty = f_objDataInputStream.readInt();
            this.m_nLastTradedTime = f_objDataInputStream.readInt();
            this.m_nNetChange = f_objDataInputStream.readLong();
            this.m_nPercentNetChange = f_objDataInputStream.readLong();
            this.m_nPreviousClosePrice = f_objDataInputStream.readInt();
            this.m_nLastUpdateTime = f_objDataInputStream.readInt();
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, Utilities.RemoveNull(this.m_btCompositeSymbol)).toString();
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private StringBuffer createKey(int iFTCode, String strCompositeSymbol) {
        StringBuffer strTemp = new StringBuffer();
        return strTemp.append(iFTCode).append(":").append(strCompositeSymbol).append(":");
    }

    private void setData(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_nBestBuyOrderQty, this.m_nBestBuyOrderPrice, this.m_nBestSellOrderQty, this.m_nBestSellOrderPrice, this.m_nClosingPrice, this.m_nPreviousClosePrice, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, this.m_nOpeningPrice, this.m_nHighPrice, this.m_nLowPrice);
                break;
            }
            case 24: {
                this.m_nDivisionFactor = iWinRefresh.getInstance().showform.bestfive.getPriceMultiplier(this.m_strKeyOfData);
                String[] strData = new String[20];
                strData[0] = Utilities.ToString(this.m_nBestBuyOrderQty);
                strData[1] = Utilities.ConvertToDecimal(this.m_nBestBuyOrderPrice, this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                strData[2] = Utilities.ToString(this.m_nBestSellOrderQty);
                strData[3] = Utilities.ConvertToDecimal(this.m_nBestSellOrderPrice, this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nClosingPrice, this.m_nTotalTradedQty, this.m_nOpeningPrice, this.m_nHighPrice, this.m_nLowPrice, this.m_nPreviousClosePrice, 0, 0, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, 0, 0L);
                break;
            }
            case 27: {
                iWinRefresh.getInstance().showform.parityWatch.setData(this.m_strKeyOfData, this.m_nClosingPrice, f_objMsgHeader.m_nMsgTimeStamp);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nClosingPrice, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }
}

