/*
 * Decompiled with CFR 0.152.
 */
package structures;

import common.AppConstants;
import common.Utilities;
import java.io.DataInputStream;
import market.iWinRefresh;
import structures.CMsgHeader;

public class InfofeedNCXFAOTouchline {
    private int m_nFTCode = 0;
    private byte[] m_btInstrument = new byte[7];
    private byte[] m_btSymbol = new byte[11];
    private int m_nExpiryDate = 0;
    private int m_nStrikePrice = 0;
    private byte[] m_btOptionType = new byte[3];
    private byte[] m_btMarketType = new byte[1];
    private int[] m_nBuyQty;
    private int[] m_nBuyPrice;
    private int[] m_nSellQty;
    private int[] m_nSellPrice;
    private int m_nLastTradedPrice;
    private int m_nTotalTradedQty;
    private byte[] m_btSecurityStatus;
    private int m_nOpeningPrice;
    private int m_nHighPrice;
    private int m_nLowPrice;
    private int m_nClosingPrice;
    private int m_nAverageTradedPrice;
    private int m_nTotalBuyQty;
    private int m_nTotalSellQty;
    private int m_nTotalTurnover;
    private int m_nPreviousClosePrice;
    private String m_strKeyOfData;
    private int m_nDivisionFactor;

    public InfofeedNCXFAOTouchline(int iNoOfBestBuySell) {
        this.m_nBuyPrice = new int[iNoOfBestBuySell];
        this.m_nBuyQty = new int[iNoOfBestBuySell];
        this.m_nSellPrice = new int[iNoOfBestBuySell];
        this.m_nSellQty = new int[iNoOfBestBuySell];
        this.m_nLastTradedPrice = 0;
        this.m_nTotalTradedQty = 0;
        this.m_btSecurityStatus = new byte[1];
        this.m_nOpeningPrice = 0;
        this.m_nHighPrice = 0;
        this.m_nLowPrice = 0;
        this.m_nClosingPrice = 0;
        this.m_nAverageTradedPrice = 0;
        this.m_nTotalBuyQty = 0;
        this.m_nTotalSellQty = 0;
        this.m_nTotalTurnover = 0;
        this.m_nPreviousClosePrice = 0;
        this.m_strKeyOfData = "";
        this.m_nDivisionFactor = 4;
    }

    public short UpdateTouchline(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int i;
            this.m_nFTCode = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btInstrument, 0, 7);
            f_objDataInputStream.read(this.m_btSymbol, 0, 11);
            this.m_nExpiryDate = f_objDataInputStream.readInt();
            this.m_nStrikePrice = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btOptionType, 0, 3);
            f_objDataInputStream.read(this.m_btMarketType, 0, 1);
            for (i = 0; i < 1; ++i) {
                this.m_nBuyPrice[i] = f_objDataInputStream.readInt();
                this.m_nBuyQty[i] = f_objDataInputStream.readInt();
            }
            for (i = 0; i < 1; ++i) {
                this.m_nSellPrice[i] = f_objDataInputStream.readInt();
                this.m_nSellQty[i] = f_objDataInputStream.readInt();
            }
            this.m_nLastTradedPrice = f_objDataInputStream.readInt();
            this.m_nTotalTradedQty = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btSecurityStatus, 0, 1);
            this.m_nOpeningPrice = f_objDataInputStream.readInt();
            this.m_nHighPrice = f_objDataInputStream.readInt();
            this.m_nLowPrice = f_objDataInputStream.readInt();
            this.m_nClosingPrice = f_objDataInputStream.readInt();
            this.m_nAverageTradedPrice = f_objDataInputStream.readInt();
            this.m_nTotalTurnover = f_objDataInputStream.readInt();
            this.m_nPreviousClosePrice = f_objDataInputStream.readInt();
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, this.m_nExpiryDate, Utilities.RemoveNull(this.m_btInstrument), this.m_nStrikePrice, Utilities.RemoveNull(this.m_btOptionType), Utilities.RemoveNull(this.m_btMarketType)).toString();
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateLLFTouchline(CMsgHeader f_objInfoFeedMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int i;
            this.m_nFTCode = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[5], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[6] != 0) {
                f_objDataInputStream.read(this.m_btInstrument, 0, 6);
            }
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[7] != 0) {
                f_objDataInputStream.read(this.m_btSymbol, 0, 10);
            }
            this.m_nExpiryDate = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[8], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nStrikePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[9], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[10] != 0) {
                f_objDataInputStream.read(this.m_btOptionType, 0, 2);
            }
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[11] != 0) {
                f_objDataInputStream.read(this.m_btMarketType, 0, 1);
            }
            for (i = 0; i < 1; ++i) {
                this.m_nBuyPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[12], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nBuyQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[13], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            for (i = 0; i < 1; ++i) {
                this.m_nSellPrice[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[14], f_objInfoFeedMsgHeader.m_nBaseValue);
                this.m_nSellQty[i] = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[15], f_objInfoFeedMsgHeader.m_nBaseValue);
            }
            this.m_nLastTradedPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[16], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nTotalTradedQty = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[17], f_objInfoFeedMsgHeader.m_nBaseValue);
            if (f_objInfoFeedMsgHeader.m_nFieldDescription[18] != 0) {
                f_objDataInputStream.read(this.m_btSecurityStatus, 0, 1);
            }
            this.m_nOpeningPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[19], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nHighPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[20], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nLowPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[21], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nClosingPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[22], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nAverageTradedPrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[23], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nTotalTurnover = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[24], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_nPreviousClosePrice = (int)Utilities.processDataType(f_objDataInputStream, f_objInfoFeedMsgHeader.m_nFieldDescription[25], f_objInfoFeedMsgHeader.m_nBaseValue);
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, this.m_nExpiryDate, Utilities.RemoveNull(this.m_btInstrument), this.m_nStrikePrice, Utilities.RemoveNull(this.m_btOptionType), Utilities.RemoveNull(this.m_btMarketType)).toString();
            this.setData(f_objInfoFeedMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public short UpdateBestFive(CMsgHeader f_objMsgHeader, DataInputStream f_objDataInputStream) {
        try {
            int i;
            this.m_nFTCode = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btInstrument, 0, 7);
            f_objDataInputStream.read(this.m_btSymbol, 0, 11);
            this.m_nExpiryDate = f_objDataInputStream.readInt();
            this.m_nStrikePrice = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btOptionType, 0, 3);
            f_objDataInputStream.read(this.m_btMarketType, 0, 1);
            for (i = 0; i < 5; ++i) {
                this.m_nBuyPrice[i] = f_objDataInputStream.readInt();
                this.m_nBuyQty[i] = f_objDataInputStream.readInt();
            }
            for (i = 0; i < 5; ++i) {
                this.m_nSellPrice[i] = f_objDataInputStream.readInt();
                this.m_nSellQty[i] = f_objDataInputStream.readInt();
            }
            this.m_nLastTradedPrice = f_objDataInputStream.readInt();
            this.m_nTotalTradedQty = f_objDataInputStream.readInt();
            f_objDataInputStream.read(this.m_btSecurityStatus, 0, 1);
            this.m_nOpeningPrice = f_objDataInputStream.readInt();
            this.m_nHighPrice = f_objDataInputStream.readInt();
            this.m_nLowPrice = f_objDataInputStream.readInt();
            this.m_nClosingPrice = f_objDataInputStream.readInt();
            this.m_nAverageTradedPrice = f_objDataInputStream.readInt();
            this.m_nTotalBuyQty = f_objDataInputStream.readInt();
            this.m_nTotalSellQty = f_objDataInputStream.readInt();
            this.m_nTotalTurnover = f_objDataInputStream.readInt();
            this.m_nPreviousClosePrice = f_objDataInputStream.readInt();
            this.m_strKeyOfData = this.createKey(this.m_nFTCode, this.m_nExpiryDate, Utilities.RemoveNull(this.m_btInstrument), this.m_nStrikePrice, Utilities.RemoveNull(this.m_btOptionType), Utilities.RemoveNull(this.m_btMarketType)).toString();
            this.setData(f_objMsgHeader);
            return 0;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private StringBuffer createKey(int iFTCode, int iExpiryDate, String strInstrumentName, int iStrikePrice, String strOptioType, String strMarketType) {
        StringBuffer strTemp = new StringBuffer();
        return strTemp.append(iFTCode).append(":").append(iExpiryDate).append(":").append(strInstrumentName).append(":").append(iStrikePrice).append(":").append(strOptioType).append(":").append(strMarketType).append(":");
    }

    private void setData(CMsgHeader f_objMsgHeader) {
        switch (AppConstants.iCurrentPage) {
            case 5: {
                iWinRefresh.getInstance().showform.marketwatch.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, this.m_nBuyQty[0], this.m_nBuyPrice[0], this.m_nSellQty[0], this.m_nSellPrice[0], this.m_nClosingPrice, this.m_nPreviousClosePrice, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, this.m_nOpeningPrice, this.m_nHighPrice, this.m_nLowPrice);
                break;
            }
            case 24: {
                this.m_nDivisionFactor = iWinRefresh.getInstance().showform.bestfive.getPriceMultiplier(this.m_strKeyOfData);
                String[] strData = new String[20];
                for (int i = 0; i < this.m_nBuyPrice.length; ++i) {
                    strData[i * 4] = Utilities.ToString(this.m_nBuyQty[i]);
                    strData[i * 4 + 1] = Utilities.ConvertToDecimal(this.m_nBuyPrice[i], this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                    strData[i * 4 + 2] = Utilities.ToString(this.m_nSellQty[i]);
                    strData[i * 4 + 3] = Utilities.ConvertToDecimal(this.m_nSellPrice[i], this.m_nDivisionFactor, f_objMsgHeader.m_nSegmentId);
                }
                iWinRefresh.getInstance().showform.bestfive.SetData(f_objMsgHeader.m_nSegmentId, this.m_strKeyOfData, strData, this.m_nClosingPrice, this.m_nTotalTradedQty, this.m_nOpeningPrice, this.m_nHighPrice, this.m_nLowPrice, this.m_nPreviousClosePrice, this.m_nTotalBuyQty, this.m_nTotalSellQty, f_objMsgHeader.m_nMsgTimeStamp, this.m_nDivisionFactor, this.m_nAverageTradedPrice, this.m_nTotalTurnover);
                break;
            }
            default: {
                AppConstants.profilelist.checkAlerts(this.m_strKeyOfData, this.m_nClosingPrice, f_objMsgHeader.m_nMsgTimeStamp);
            }
        }
    }
}

